<?php
/**
 * Handles Popup Post Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $wpdb;

// Taking some variables
$prefix				= PAOC_PRO_META_PREFIX; // Metabox prefix
$default_meta		= paoc_pro_popup_default_meta();
$popup_appear_data	= paoc_pro_when_appear_options();
$popup_goals		= paoc_pro_popup_goals();
$popup_types		= paoc_pro_popup_types();
$show_for_data		= paoc_pro_show_for_options();
$display_on_data	= paoc_pro_display_on_options();
$popup_time_data	= paoc_pro_time_options();
$enable				= paoc_pro_get_option( 'enable' );
$selected_tab		= get_post_meta( $post->ID, $prefix.'tab', true );
$popup_goal			= get_post_meta( $post->ID, $prefix.'popup_goal', true );
$display_type		= get_post_meta( $post->ID, $prefix.'display_type', true );
$popup_appear		= get_post_meta( $post->ID, $prefix.'popup_appear', true );
$content			= get_post_meta( $post->ID, $prefix.'content', true );
$advance			= get_post_meta( $post->ID, $prefix.'advance', true );
$campaign_id		= get_post_meta( $post->ID, $prefix.'campaign_id', true );
$analytics			= get_post_meta( $post->ID, $prefix.'analytics', true );
$integration		= get_post_meta( $post->ID, $prefix.'integration', true );
$popup_goal			= ! empty( $popup_goal )	? paoc_pro_clean( $popup_goal )		: 'announcement';
$display_type		= ! empty( $display_type )	? paoc_pro_clean( $display_type )	: 'modal';
$enable_link		= add_query_arg( array('post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-pro-settings', 'tab' => 'general'), admin_url('edit.php') );

// Get Campaign Data
if( ! empty( $campaign_id ) ) {
	$sql			= "SELECT * FROM ".PAOC_PRO_CAMPAIGN_TBL." WHERE 1=1 AND `id` = '{$campaign_id}'";
	$campaign_data	= $wpdb->get_row( $sql );
}

$campaign_enable = ! empty( $campaign_data->enable ) ? 1 : 0;

// Add general reminder when module is disabled from setting page
if( ! $enable ) { ?>
	<div class="paoc-error paoc-no-margin paoc-no-radius">
		<i class="dashicons dashicons-warning"></i> 
		<?php esc_html_e('Popup Anything Pro is disabled from plugin setting page.', 'popup-anything-on-click'); ?>
		<?php if ( current_user_can( 'manage_options' ) ) {
			echo sprintf( esc_html__('Kindly %senable%s it from plugin general settings to use it.', 'popup-anything-on-click'), '<a target="_blank" href="'.esc_url( $enable_link ).'">', '</a>' );
		} ?>
	</div>
<?php } ?>

<div class="paoc-vtab-wrap paoc-cnt-wrap paoc-clearfix">
	<ul class="paoc-vtab-nav-wrap">
		<li class="paoc-vtab-nav paoc-active-vtab">
			<a href="#paoc_behaviour_sett"><i class="dashicons dashicons-welcome-view-site" aria-hidden="true"></i> <?php esc_html_e('Behaviour', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_content_sett"><i class="dashicons dashicons-text-page" aria-hidden="true"></i> <?php esc_html_e('Content', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-show-hide-row-goal paoc-show-if-goal-email-lists paoc-vtab-nav" style="<?php if( $popup_goal != 'email-lists' ) { echo 'display: none;'; } ?>">
			<a href="#paoc_form_fields_sett"><i class="dashicons dashicons-id-alt" aria-hidden="true"></i> <?php esc_html_e('Form Fields', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_design_sett"><i class="dashicons dashicons-admin-customizer" aria-hidden="true"></i> <?php esc_html_e('Design', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_social_sett"><i class="dashicons dashicons-share" aria-hidden="true"></i> <?php esc_html_e('Social Profile', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_advance_sett"><i class="dashicons dashicons-admin-settings" aria-hidden="true"></i> <?php esc_html_e('Advance', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-show-hide-row-goal paoc-show-if-goal-email-lists paoc-vtab-nav" style="<?php if( $popup_goal != 'email-lists' ) { echo 'display: none;'; } ?>">
			<a href="#paoc_notification_sett"><i class="dashicons dashicons-email-alt" aria-hidden="true"></i> <?php esc_html_e('Notification', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-show-hide-row-goal paoc-show-if-goal-email-lists paoc-vtab-nav" style="<?php if( $popup_goal != 'email-lists' ) { echo 'display: none;'; } ?>">
			<a href="#paoc_integration_sett"><i class="dashicons dashicons-networking" aria-hidden="true"></i> <?php esc_html_e('Integration', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_referrer_sett"><i class="dashicons dashicons-megaphone" aria-hidden="true"></i> <?php esc_html_e('Referrer Popup', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_utm_sett"><i class="dashicons dashicons-admin-links" aria-hidden="true"></i> <?php esc_html_e('UTM Popup', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_cookie_sett"><i class="dashicons dashicons-art" aria-hidden="true"></i> <?php esc_html_e('Cookie Popup', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_geolocation_sett"><i class="dashicons dashicons-location-alt" aria-hidden="true"></i> <?php esc_html_e('Geolocation Popup', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_analytics_sett"><i class="dashicons dashicons-chart-bar" aria-hidden="true"></i> <?php esc_html_e('Google Analytics', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_campaign_sett"><i class="dashicons dashicons-randomize" aria-hidden="true"></i> <?php esc_html_e('A/B Testing', 'popup-anything-on-click'); ?></a>
		</li>

		<li class="paoc-vtab-nav">
			<a href="#paoc_css_sett"><i class="dashicons dashicons-editor-code" aria-hidden="true"></i> <?php esc_html_e('Custom CSS', 'popup-anything-on-click'); ?></a>
		</li>
	</ul>

	<div class="paoc-vtab-cnt-wrp">
		<?php
			// Behaviour Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/behaviour-metabox.php' );

			// Content Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/content-metabox.php' );

			// Form Fields Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/form-fields-metabox.php' );

			// Design Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/design-metabox.php' );

			// Social Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/social-metabox.php' );

			// Advance Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/advance-metabox.php' );

			// Notification Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/notification-metabox.php' );

			// Integration Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/integration-metabox.php' );

			// Referer Popup Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/referrer-metabox.php' );

			// UTM Popup Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/utm-metabox.php' );

			// Cookie Popup Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/cookie-metabox.php' );

			// Geo Location Popup Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/geolocation-metabox.php' );

			// Google Analytic Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/analytics-metabox.php' );

			// A/B Testing Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/campaign-metabox.php' );

			// Custom CSS Settings
			include_once( PAOC_PRO_DIR . '/includes/admin/metabox/css-metabox.php' );
		?>
	</div>
	<input type="hidden" value="<?php echo esc_attr( $selected_tab ); ?>" class="paoc-selected-tab" name="<?php echo esc_attr( $prefix ); ?>tab" />
</div>

<div class="paoc-notice-wrap paoc-meta-notify paoc-info paoc-hide"><?php esc_html_e('Changing the Popup Bahaviour or Popup Type will enable some settings in Content and Designs tab.', 'popup-anything-on-click'); ?></div>

<div class="paoc-notice-wrap paoc-js-notice-notify paoc-hide"></div>

<?php

// Popup Preview File
include( PAOC_PRO_DIR . '/includes/preview/preview-popup.php' );

// Popup General Tags File
paoc_pro_generate_modal_popup( 'general_tags' );

// Popup Form Fields Tags File
paoc_pro_generate_modal_popup( 'form_fields_tags' );