<?php
/**
 * Handles Referrer Popup Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$referrer_mode		= ! empty( $advance['referrer_mode'] )		? $advance['referrer_mode']	: '';
$referrer_url		= ! empty( $advance['referrer_url'] )		? $advance['referrer_url']	: '';
$referrer_enable	= ! empty( $advance['referrer_enable'] )	? 1							: 0;
?>

<div id="paoc_referrer_sett" class="paoc-vtab-cnt paoc-referrer-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Referrer Popup Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose referrer popup settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-referrer-enable"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>advance[referrer_enable]" value="1" <?php checked( $referrer_enable, 1 ); ?> class="paoc-checkbox paoc-referrer-enable" id="paoc-referrer-enable" /><br/>
					<span class="description"><?php esc_html_e('Check this box if you want to display referrer popup.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-referrer-mode"><?php esc_html_e('Referrer Mode', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[referrer_mode]" class="paoc-select paoc-referrer-mode" id="paoc-referrer-mode">
						<option value=""><?php esc_html_e('Direct Referrer', 'popup-anything-on-click'); ?></option>
						<option value="1" <?php selected( 1, $referrer_mode ); ?>><?php esc_html_e('Track Referrer', 'popup-anything-on-click'); ?></option>
					</select><br/>
					<span class="description"><?php esc_html_e('Choose referrer mode.', 'popup-anything-on-click'); ?></span><br/>
					<span class="description"><?php esc_html_e('Direct Referrer - Popup will only work if page is directly referred.', 'popup-anything-on-click') ?></span><br/>
					<span class="description"><?php esc_html_e('Track Referrer - Referrer will be tracked on whole site and Popup will work on relevant page even if page is not directly referred.', 'popup-anything-on-click') ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-referrer-url"><?php esc_html_e('Referrer URLs', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<textarea id="paoc-referrer-url" name="<?php echo esc_attr( $prefix ); ?>advance[referrer_url]" class="large-text paoc-textarea paoc-referrer-url"><?php echo esc_textarea( $referrer_url ); ?></textarea>
					<span class="description"><?php esc_html_e('Enter Referrer URLs for which you want to show popup.', 'popup-anything-on-click'); ?></span><br/>
					<span class="description"><?php esc_html_e('Note : Referrer is dependent on the server from which it originate. Some of the server does not send referrer URL to track. Sometimes they send full referrer url or only domain to track.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- End .paoc-referrer-sett -->