<?php
/**
 * Popup Report Metabox. Popup Click, Impression and Report Link
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post;

$prefix					= PAOC_PRO_META_PREFIX;
$stats_flush_date		= get_post_meta( $post->ID, $prefix.'stats_flush_date', true );
$popup_views			= get_post_meta( $post->ID, $prefix.'popup_views', true );
$popup_views_normal		= ! empty( $popup_views['normal'] ) ? number_format( $popup_views['normal'] ) : 0;
$popup_views_inline		= ! empty( $popup_views['inline'] ) ? number_format( $popup_views['inline'] ) : 0;

$popup_clicks			= get_post_meta( $post->ID, $prefix.'popup_clicks', true );
$popup_clicks_normal	= ! empty( $popup_clicks['normal'] ) ? number_format( $popup_clicks['normal'] ) : 0;
$popup_clicks_inline	= ! empty( $popup_clicks['inline'] ) ? number_format( $popup_clicks['inline'] ) : 0;
$report_link			= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-reports', 'popup_id' => $post->ID ), admin_url( 'edit.php' ) );
$entry_link				= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-form-entries', 'paoc_popup_id' => $post->ID ), admin_url( 'edit.php' ) );
$display_rule_link		= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-pro-settings', 'tab' => 'display_rule'), admin_url('edit.php') );
?>

<div class="paoc-popup-report-sett paoc-cnt-wrap">
	<div class="paoc-preview-btn-wrp">
		<button type="button" class="button button-large button-primary paoc-btn paoc-btn-large paoc-popup-preview-btn paoc-show-popup-modal" data-popup-id="<?php echo esc_attr( $post->ID ); ?>" data-preview="1"><?php esc_html_e('Preview Popup', 'popup-anything-on-click'); ?></button>
		<br><br>
		<a class="button button-large paoc-btn paoc-btn-half paoc-btn-black" href="<?php echo esc_url( $display_rule_link ); ?>" target="_blank"><?php esc_html_e('Set Display Rule', 'popup-anything-on-click'); ?></a>
		<button type="button" class="button button-large paoc-btn paoc-btn-half paoc-btn-black paoc-open-ajax-popup" title="<?php esc_attr_e('Popup Quick Overview', 'popup-anything-on-click'); ?>" data-popup-id="<?php echo esc_attr( $post->ID ); ?>" data-nonce="<?php echo wp_create_nonce( "paoc-quick-overview-{$post->ID}" ); ?>" data-id="quick_overview" data-cache="0" data-navigate="1">
			<span class="paoc-inline-loader"><i class="dashicons dashicons-update"></i> <?php esc_html_e('Loading...', 'popup-anything-on-click'); ?></span>
			<span class="paoc-btn-txt-icon"><?php esc_html_e('Quick Overview', 'popup-anything-on-click'); ?></span>
		</button>
	</div>

	<div class="paoc-clearfix paoc-center">
		<div class="paoc-stats-box-wrap">
			<div class="paoc-stats-box-title"><strong><?php esc_html_e('Impressions', 'popup-anything-on-click'); ?></strong></div>
			<div class="paoc-stats-box">
				<div class="paoc-report-title"><?php esc_html_e('Normal', 'popup-anything-on-click'); ?></div>
				<span class="paoc-report-no"><?php echo esc_html( $popup_views_normal ); ?></span>
			</div>
			<div class="paoc-stats-box">
				<div class="paoc-report-title"><?php esc_html_e('Inline', 'popup-anything-on-click'); ?></div>
				<span class="paoc-report-no"><?php echo esc_html( $popup_views_inline ); ?></span>
			</div>
		</div>

		<div class="paoc-stats-box-wrap">
			<div class="paoc-stats-box"><strong><?php esc_html_e('Clicks', 'popup-anything-on-click'); ?></strong></div>
			<div class="paoc-stats-box">
				<div class="paoc-report-title"><?php esc_html_e('Normal', 'popup-anything-on-click'); ?></div>
				<span class="paoc-report-no"><?php echo esc_html( $popup_clicks_normal ); ?></span>
			</div>
			<div class="paoc-stats-box">
				<div class="paoc-report-title"><?php esc_html_e('Inline', 'popup-anything-on-click'); ?></div>
				<span class="paoc-report-no"><?php echo esc_html( $popup_clicks_inline ); ?></span>
			</div>
		</div>
	</div>

	<?php if ( current_user_can( 'manage_options' ) ) { ?>
	<p class="paoc-popup-report-link paoc-center">
		<a href="<?php echo esc_url( $report_link ); ?>" target="_blank"><?php esc_html_e('View Report', 'popup-anything-on-click'); ?></a> | 
		<a href="<?php echo esc_url( $entry_link ); ?>" target="_blank"><?php esc_html_e('View Entries', 'popup-anything-on-click'); ?></a>
	</p>
	<hr/>

	<div class="paoc-flush-report-wrp">
		<button type="button" class="button button-secondary paoc-btn paoc-flush-stats-btn" data-nonce="<?php echo wp_create_nonce( 'paoc-flush-stats-'.$post->ID ); ?>"><?php esc_html_e('Flush Stats', 'popup-anything-on-click'); ?></button>
		<span class="spinner paoc-spinner"></span>
		<?php if( $stats_flush_date ) { ?>
			<p class="paoc-stats-flush-date"><strong><?php echo esc_html__('Last Flush', 'popup-anything-on-click') .' : '. esc_html( $stats_flush_date ); ?></strong></p>
		<?php } ?>
		<hr/>
		<span class="description"><?php esc_html_e('Note : Flush Stats button will only flush the `Impressions` and `Clicks` for this post. The popup report will not be affected by this.', 'popup-anything-on-click'); ?></span>
	</div>
	<?php } ?>
</div>