<?php
/**
 * Handles Social Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$social_data	= paoc_pro_social_options();
$social			= get_post_meta( $post->ID, $prefix.'social', true );
$social_type	= isset( $social['social_type'] )		? $social['social_type']	: '';
$social_arr		= ! empty( $social['social_traffic'] )	? $social['social_traffic']	: array( 0 => '' );
?>

<div id="paoc_social_sett" class="paoc-vtab-cnt paoc-social-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('Social Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Set popup social settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl paoc-clone-ele-wrap">
		<tbody>
			<tr>
				<th>
					<label for="paoc-social-type"><?php esc_html_e('Social Type', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>social[social_type]" class="paoc-select paoc-social-type" id="paoc-social-type" />
						<option value="icon" <?php selected( $social_type, 'icon' ); ?>><?php esc_html_e('Only Icon', 'popup-anything-on-click'); ?></option>
						<option value="text" <?php selected( $social_type, 'text' ); ?>><?php esc_html_e('Only Text', 'popup-anything-on-click'); ?></option>
						<option value="icon-text" <?php selected( $social_type, 'icon-text' ); ?>><?php esc_html_e('Icon With Text', 'popup-anything-on-click'); ?></option>
					</select><br/>
					<span class="description"><?php esc_html_e('Choose social icon type.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>
			<tr>
				<td colspan="3" class="paoc-no-padding">
					<hr/>
				</td>
			</tr>
			<?php foreach ( $social_arr as $social_key => $social_val ) {

				$social_name	= isset( $social_arr[$social_key]['name'] ) ? $social_arr[$social_key]['name'] : '';
				$social_link	= isset( $social_arr[$social_key]['link'] ) ? $social_arr[$social_key]['link'] : '';

				if( $social_name == 'whatsapp' || $social_name == 'mail' || $social_name == 'skype' ) {
					$social_link = esc_attr( $social_link );
				} else {
					$social_link = esc_url( $social_link );
				}
			?>
				<tr class="paoc-social-title-row paoc-clone-row" data-key="<?php echo esc_attr( $social_key ); ?>">
					<td class="paoc-no-padding">
						<select name="<?php echo esc_attr( $prefix ); ?>social[social_traffic][<?php echo esc_attr( $social_key ); ?>][name]" class="paoc-select paoc-social-name" id="paoc-social-name-<?php echo esc_attr( $social_key ); ?>">
							<?php
							if( ! empty( $social_data ) ) {
								foreach ( $social_data as $social_data_key => $social_data_val ) {

									$social_service_name = ! empty( $social_data_val['name'] ) ? $social_data_val['name'] : ucfirst( $social_data_key );
							?>
								<option value="<?php echo esc_attr( $social_data_key ); ?>" <?php selected( $social_name, $social_data_key ); ?>><?php echo esc_html( $social_service_name ); ?></option>
							<?php } } ?>
						</select>
					</td>
					<td>
						<input type="text" name="<?php echo esc_attr( $prefix ); ?>social[social_traffic][<?php echo esc_attr( $social_key ); ?>][link]" value="<?php echo esc_attr( $social_link ); ?>" class="paoc-text large-text paoc-social-link" />
					</td>
					<td>
						<span class="paoc-action-btn paoc-tooltip paoc-action-add-btn paoc-add-clone-btn" data-tooltip-text="<?php esc_html_e('Add', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-plus-alt"></i></span>
						<span class="paoc-action-btn paoc-tooltip paoc-action-del-btn paoc-del-clone-btn" data-tooltip-text="<?php esc_html_e('Delete', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-trash"></i></span>
					</td>
				</tr>
			<?php } ?>
		</tbody>
	</table>

	<hr/><br/>

	<div class="paoc-info">
		<p><?php esc_html_e('For WhatsApp, you need to add mobile number with country code. e.g. 919988776655 Where 91 (India) is country code and rest is the mobile number.', 'popup-anything-on-click'); ?></p>
		<p><?php esc_html_e('For pre-defined text in WhatsApp you can use like this.', 'popup-anything-on-click'); ?> <code>919988776655&text=Your Text</code></p>
	</div>
</div>