<?php
/**
 * Handles UTM Popup Setting metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$utm_mode	= ! empty( $advance['utm_mode'] )	? $advance['utm_mode']		: '';
$utm_params	= ! empty( $advance['utm_params'] ) ? $advance['utm_params']	: '';
$utm_enable	= ! empty( $advance['utm_enable'] )	? 1 : 0;
?>

<div id="paoc_utm_sett" class="paoc-vtab-cnt paoc-utm-sett paoc-clearfix">

	<div class="paoc-tab-info-wrap">
		<div class="paoc-tab-title"><?php esc_html_e('UTM Popup Settings', 'popup-anything-on-click'); ?></div>
		<span class="paoc-tab-desc"><?php esc_html_e('Choose UTM a URL parameter based popup settings.', 'popup-anything-on-click'); ?></span>
	</div>

	<table class="form-table paoc-tbl">
		<tbody>
			<tr>
				<th>
					<label for="paoc-utm-enable"><?php esc_html_e('Enable', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<input type="checkbox" name="<?php echo esc_attr( $prefix ); ?>advance[utm_enable]" value="1" <?php checked( $utm_enable, 1 ); ?> class="paoc-checkbox paoc-utm-enable" id="paoc-utm-enable" /><br/>
					<span class="description"><?php esc_html_e('Check this box if you want to enable UTM based popup.', 'popup-anything-on-click'); ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-utm-mode"><?php esc_html_e('UTM Mode', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<select name="<?php echo esc_attr( $prefix ); ?>advance[utm_mode]" class="paoc-select paoc-utm-mode" id="paoc-utm-mode">
						<option value=""><?php esc_html_e('Direct UTM', 'popup-anything-on-click'); ?></option>
						<option value="1" <?php selected( 1, $utm_mode ); ?>><?php esc_html_e('Track UTM', 'popup-anything-on-click'); ?></option>
					</select><br/>
					<span class="description"><?php esc_html_e('Choose UTM mode.', 'popup-anything-on-click'); ?></span><br/>
					<span class="description"><?php esc_html_e('Direct UTM - Popup will only work if UTM is present in web URL.', 'popup-anything-on-click') ?></span><br/>
					<span class="description"><?php esc_html_e('Track UTM - UTM will be tracked on whole site and Popup will work on relevant page even if UTM is not present in web URL.', 'popup-anything-on-click') ?></span>
				</td>
			</tr>

			<tr>
				<th>
					<label for="paoc-utm-params"><?php esc_html_e('UTM Params', 'popup-anything-on-click'); ?></label>
				</th>
				<td>
					<textarea id="paoc-utm-params" name="<?php echo esc_attr( $prefix ); ?>advance[utm_params]" class="large-text paoc-textarea paoc-utm-params"><?php echo esc_textarea( $utm_params ); ?></textarea>
					<span class="description"><?php esc_html_e('Enter one UTM params fragment per line. Example: utm_key | utm_value. Popup will be displayed by below URL. You can enter only utm key also.', 'popup-anything-on-click'); ?></span><br/>
					<code><?php echo add_query_arg( 'utm_key', 'utm_value', site_url() ); ?></code>
				</td>
			</tr>
		</tbody>
	</table>
</div><!-- End .paoc-utm-sett -->