<?php
/**
 * Popup Content Class
 *
 * Handles the Admin side functionality of plugin
 *
 * @package Popup Anything on Click Pro
 * @since 2.0.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Paoc_Pro_Popup_Content {

	function __construct() {

		// Action to load quick overview popup HTML
		add_action( 'admin_footer', array($this, 'paoc_pro_popup_quick_overview_html') );

		// Action to display popup tags
		add_action( 'paoc_pro_admin_popup_cnt_general_tags', array($this, 'paoc_pro_popup_general_tags_html') );

		// Action to display popup tags
		add_action( 'paoc_pro_admin_popup_cnt_form_fields_tags', array($this, 'paoc_pro_popup_form_fields_tags_html') );

		// Action to display popup quick overview
		add_action( 'wp_ajax_paoc_pro_popup_quick_overview', array($this, 'paoc_pro_popup_quick_overview') );
	}

	/**
	 * Function to load quick overview HTML
	 * 
	 * @since 2.0.7
	 */
	function paoc_pro_popup_quick_overview_html() {

		global $pagenow, $typenow;

		if( $typenow == PAOC_PRO_POST_TYPE && ( $pagenow == 'post.php' || $pagenow == 'post-new.php' || $pagenow == 'edit.php' ) ) {
			paoc_pro_generate_modal_popup( 'quick_overview' );
		}
	}

	/**
	 * Function to display popup general tags 
	 * 
	 * @since 2.0.7
	 */
	function paoc_pro_popup_general_tags_html() { ?>

		<div class="paoc-modal-sub-title"><strong># <?php esc_html_e('General Tags', 'popup-anything-on-click'); ?></strong></div>

		<table class="wp-list-table widefat fixed striped paoc-modal-tbl">
			<tbody>
				<tr>
					<td><strong><?php esc_html_e('Site Name', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="site_name"]' readonly></td>
					<td><?php esc_html_e('Display website name.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Site URL', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="site_url"]' readonly></td>
					<td><?php esc_html_e('Display website URL.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Referral URL', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="ref_url"]' readonly></td>
					<td><?php esc_html_e('Display referral page URL.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Site Logo', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="site_logo"]' readonly></td>
					<td><?php esc_html_e('Display website logo.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Admin Email', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="admin_email"]' readonly></td>
					<td><?php esc_html_e('Display admin email addresss.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('User Name', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="user_name"]' readonly></td>
					<td><?php esc_html_e('Display user name.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('User Email', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="user_email"]' readonly></td>
					<td><?php esc_html_e('Display user email addresss.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Page/Post Title', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="page_title"]' readonly></td>
					<td><?php esc_html_e('Display current page or post title.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Post Excerpt', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="post_excerpt"]' readonly></td>
					<td><?php esc_html_e('Display current post excerpt.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Date Time', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="date_time"]' readonly></td>
					<td><?php esc_html_e('Display current date & time.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Date', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="date"]' readonly></td>
					<td><?php esc_html_e('Display current date.', 'popup-anything-on-click'); ?></td>
				</tr>
				<tr>
					<td><strong><?php esc_html_e('Year', 'popup-anything-on-click'); ?></strong></td>
					<td><input type="text" class="large-text paoc-copy-clipboard" value='[paoc_details display="year"]' readonly></td>
					<td><?php esc_html_e('Display current year.', 'popup-anything-on-click'); ?></td>
				</tr>
			</tbody>
		</table>

	<?php }

	/**
	 * Function to display popup form fields tags 
	 * 
	 * @since 2.0.7
	 */
	function paoc_pro_popup_form_fields_tags_html() {

		// General tags HTML
		$this->paoc_pro_popup_general_tags_html(); ?>		

		<div class="paoc-modal-sub-title"><strong># <?php esc_html_e('Form Fields Tags', 'popup-anything-on-click'); ?></strong></div>

		<table class="wp-list-table widefat fixed striped paoc-modal-tbl">
			<tr>
				<td><strong><?php esc_html_e('Popup ID', 'popup-anything-on-click'); ?></strong></td>
				<td><input type="text" class="large-text paoc-copy-clipboard" value="{ID}" readonly></td>
				<td><?php esc_html_e('Display popup ID.', 'popup-anything-on-click'); ?></td>
			</tr>

			<tr>
				<td><strong><?php esc_html_e('Popup Name', 'popup-anything-on-click'); ?></strong></td>
				<td><input type="text" class="large-text paoc-copy-clipboard" value="{popup_name}" readonly></td>
				<td><?php esc_html_e('Display popup name.', 'popup-anything-on-click'); ?></td>
			</tr>

			<tr>
				<td><strong><?php esc_html_e('Entry ID', 'popup-anything-on-click'); ?></strong></td>
				<td><input type="text" class="large-text paoc-copy-clipboard" value="{entry_id}" readonly></td>
				<td><?php esc_html_e('Display entry ID.', 'popup-anything-on-click'); ?></td>
			</tr>

			<tr>
				<td><strong><?php esc_html_e('All Fields', 'popup-anything-on-click'); ?></strong></td>
				<td><input type="text" class="large-text paoc-copy-clipboard" value="{all_fields}" readonly></td>
				<td><?php esc_html_e('Display all form fields.', 'popup-anything-on-click'); ?></td>
			</tr>

			<tr>
				<td><strong><?php esc_html_e('Field 0', 'popup-anything-on-click'); ?></strong></td>
				<td><input type="text" class="large-text paoc-copy-clipboard" value="{field_0}" readonly></td>
				<td><?php esc_html_e('Display particular form field.', 'popup-anything-on-click'); ?></td>
			</tr>
		</table>

	<?php }

	/**
	 * Function to display popup quick overview 
	 * 
	 * @since 2.0.7
	 */
	function paoc_pro_popup_quick_overview() {

		global $wpdb, $paoc_preview;

		// Tweak : Enabled the preview so `paoc_pro_get_meta` function works correctly and take data on run time
		$paoc_preview = true;

		// Taking some variables
		$prefix		= PAOC_PRO_META_PREFIX; // Metabox prefix
		$result		= array( 'success' => 0, 'msg' => esc_js( __('Sorry, Something happened wrong.', 'popup-anything-on-click') ) );
		$nonce		= isset( $_POST['nonce'] )		? paoc_pro_clean( $_POST['nonce'] )				: '';
		$popup_id	= isset( $_POST['popup_id'] )	? paoc_pro_clean_number( $_POST['popup_id'] )	: 0;
		$navigate	= ! empty( $_POST['navigate'] )	? 1	: 0;

		if( $popup_id && wp_verify_nonce( $nonce, 'paoc-quick-overview-'.$popup_id ) ) {

			// Taking some variable
			$navigate_title		= '';
			$navigate_cls		= '';
			$popup_appear_data	= paoc_pro_when_appear_options();
			$popup_goals		= paoc_pro_popup_goals();
			$popup_types		= paoc_pro_popup_types();
			$show_for_data		= paoc_pro_show_for_options();
			$display_on_data	= paoc_pro_display_on_options();
			$popup_time_data	= paoc_pro_time_options();
			$popup_goal			= paoc_pro_get_meta( $popup_id, $prefix.'popup_goal', true );
			$display_type		= paoc_pro_get_meta( $popup_id, $prefix.'display_type', true );
			$popup_appear		= paoc_pro_get_meta( $popup_id, $prefix.'popup_appear', true );
			$advance			= paoc_pro_get_meta( $popup_id, $prefix.'advance', true );
			$integration		= paoc_pro_get_meta( $popup_id, $prefix.'integration', true );
			$analytics			= paoc_pro_get_meta( $popup_id, $prefix.'analytics', true );
			$campaign_id		= get_post_meta( $popup_id, $prefix.'campaign_id', true );
			$popup_goal			= ! empty( $popup_goal )	? paoc_pro_clean( $popup_goal )		: 'announcement';
			$display_type		= ! empty( $display_type )	? paoc_pro_clean( $display_type )	: 'modal';

			// Get Campaign Data
			if( ! empty( $campaign_id ) ) {

				$sql			= "SELECT * FROM ".PAOC_PRO_CAMPAIGN_TBL." WHERE 1=1 AND `id` = '{$campaign_id}'";
				$campaign_data	= $wpdb->get_row( $sql );
			}

			// Taking some variable
			$geo_enable			= paoc_pro_get_option( 'geo_enable' );
			$popup_appear		= ! empty( $popup_appear )						? $popup_appear							: 'page_load';
			$popup_appear_name	= isset( $popup_appear_data[ $popup_appear ] )	? $popup_appear_data[ $popup_appear ]	: $popup_appear;
			$display_on			= ! empty( $advance['display_on'] )				? $advance['display_on']				: 'every_device';
			$show_for			= ! empty( $advance['show_for'] )				? $advance['show_for']					: 'all';
			$start_time			= ! empty( $advance['start_time'] )				? $advance['start_time']				: '';
			$end_time			= ! empty( $advance['end_time'] )				? $advance['end_time']					: '';
			$cookie_unit		= ! empty( $advance['cookie_unit'] )			? $advance['cookie_unit']				: 'day';
			$geo_countries		= ! empty( $advance['geo_countries'] )			? $advance['geo_countries']				: array();
			$cookie_expire		= isset( $advance['cookie_expire'] )			? $advance['cookie_expire']				: '';
			$cookie_unit		= isset( $time_options[ $cookie_unit ] )		? $time_options[ $cookie_unit ]			: $cookie_unit;
			$campaign_title		= ! empty( $campaign_data->title )				? $campaign_data->title					: '';
			$campaign_enable	= ! empty( $campaign_data->enable )				? 1										: 0;
			$mc_enable			= ! empty( $integration['mc_enable'] )			? 1										: 0;
			$schedule_tooltip	= __('Start Time', 'popup-anything-on-click')." : ".$start_time."\n".__('End Time', 'popup-anything-on-click')." : ".$end_time."\n\n".__('Note : Time is displayed in 24 Hrs format.', 'popup-anything-on-click');
			$campaign_url		= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign', 'action' => 'edit', 'campaign_id' => $campaign_id ), admin_url('edit.php') );

			/* Add navigate class & title */
			if( $navigate ) {
				$navigate_title	= __('Navigate to this setting', 'popup-anything-on-click');
				$navigate_cls	= 'paoc-navigate-sett';
			}

			ob_start();

			// Popup Quick Overview HTML
			include( PAOC_PRO_DIR . '/includes/admin/popup/quick-overview.php' );

			$data = ob_get_clean();

			$result['success']	= 1;
			$result['msg']		= esc_js( __('Success', 'popup-anything-on-click') );
			$result['data']		= $data;
		}

		wp_send_json( $result );
	}
}

$paoc_pro_popup_content = new Paoc_Pro_Popup_Content();