<?php
/**
 * Handles Popup Outer HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<div id="paoc-modal-popup-<?php echo esc_attr( $identifier ); ?>" class="paoc-popup-modal paoc-modal-popup-<?php echo esc_attr( $identifier ); ?> paoc-cnt-wrap">
	<div class="paoc-popup-modal-act-btn-wrp">
		<span class="paoc-popup-modal-act-btn paoc-popup-modal-close paoc-popup-close" title="<?php esc_attr_e('Close', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-no-alt"></i></span>
	</div>

	<div class="paoc-popup-modal-title-wrp">
		<span class="paoc-popup-modal-title"><?php esc_html_e( 'Popup', 'popup-anything-on-click' ); ?></span>
	</div>

	<div class="paoc-no-padding paoc-popup-modal-cnt">
		<div class="paoc-popup-modal-cnt-inr">
			<?php do_action( "paoc_pro_admin_popup_cnt_{$identifier}" ); // Action to display popup content ?>
			<?php do_action( "paoc_pro_admin_popup_cnt", $identifier ); ?>
		</div>
	</div>
</div>
<div class="paoc-popup-modal-overlay paoc-popup-modal-overlay-<?php echo esc_attr( $identifier ); ?>"></div>