<?php
/**
 * Handles Popup Quick Overview metabox HTML
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<table class="wp-list-table widefat fixed striped paoc-modal-tbl">
	<tbody>
		<tr>
			<th><strong><?php esc_html_e('Popup Goal', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_behaviour_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo esc_html( $popup_goals[ $popup_goal ]['name'] ); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Popup Type', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_behaviour_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo esc_html( $popup_types[ $display_type ]['name'] ); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Popup Appear', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_behaviour_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo esc_html( $popup_appear_name ); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Display On', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_advance_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo esc_html( $display_on_data[ $display_on ] ); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Show For', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_advance_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo esc_html( $show_for_data[ $show_for ] ); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('A/B Testing', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<?php if( $campaign_id && $campaign_enable ) {
					if ( current_user_can( 'manage_options' ) ) { ?>
						<a href="<?php echo esc_url( $campaign_url ); ?>" target="_blank" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo esc_html( $campaign_title ); ?></a>
					<?php } else {
						echo esc_html( $campaign_title );
					}
				} else {
					echo '&mdash;';
				} ?>
			</td>
		</tr>
		<?php if( $popup_goal == 'email-lists' ) { ?>
		<tr>
			<th><strong><?php esc_html_e('MailChimp Integration', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_integration_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo ! empty( $mc_enable ) ? '<span class="paoc-success-text">'.esc_html__('Yes', 'popup-anything-on-click').'</span>' : esc_html__('No', 'popup-anything-on-click'); ?></a>
			</td>
		</tr>
		<?php } ?>
		<tr>
			<th><strong><?php esc_html_e('Adblocker', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_advance_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo ! empty( $advance['adblocker'] ) ? '<span class="paoc-success-text">'.esc_html__('Yes', 'popup-anything-on-click').'</span>' : esc_html__('No', 'popup-anything-on-click'); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Referrer Popup', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_referrer_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo ! empty( $advance['referrer_enable'] ) ? '<span class="paoc-success-text">'.esc_html__('Yes', 'popup-anything-on-click').'</span>' : esc_html__('No', 'popup-anything-on-click'); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('UTM Popup', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_utm_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo ! empty( $advance['utm_enable'] ) ? '<span class="paoc-success-text">'.esc_html__('Yes', 'popup-anything-on-click').'</span>' : esc_html__('No', 'popup-anything-on-click'); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Cookie Popup', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_cookie_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo ! empty( $advance['cookie_enable'] ) ? '<span class="paoc-success-text">'.esc_html__('Yes', 'popup-anything-on-click').'</span>' : esc_html__('No', 'popup-anything-on-click'); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Geolocation Popup', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_geolocation_sett" title="<?php echo esc_attr( $navigate_title ); ?>">
					<?php if( $geo_enable && $geo_countries ) {
						echo implode( ', ', $geo_countries );
					} else {
						esc_html_e('No', 'popup-anything-on-click');
					} ?>
				</a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Google Analytics', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_analytics_sett" title="<?php echo esc_attr( $navigate_title ); ?>"><?php echo ! empty( $analytics['enable'] ) ? '<span class="paoc-success-text">'.esc_html__('Yes', 'popup-anything-on-click').'</span>' : esc_html__('No', 'popup-anything-on-click'); ?></a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Schedule', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_advance_sett" title="<?php echo esc_attr( $navigate_title ); ?>">
					<?php if( ! empty( $start_time ) || ! empty( $end_time ) ) {
						'<span class="paoc-success-text">'.esc_html_e('Yes', 'popup-anything-on-click').'</span>'; ?>
						<i class="dashicons dashicons-info paoc-dashicons-icon" title="<?php echo esc_attr( $schedule_tooltip ); ?>"></i>
					<?php } else {
						esc_html_e('No', 'popup-anything-on-click');
					} ?>
				</a>
			</td>
		</tr>
		<tr>
			<th><strong><?php esc_html_e('Cookie Expiry', 'popup-anything-on-click'); ?></strong></th>
			<td>
				<a href="javascript:void(0);" class="<?php echo esc_attr( $navigate_cls ); ?>" data-href="#paoc_advance_sett" title="<?php echo esc_attr( $navigate_title ); ?>">
					<?php if( $cookie_expire ) {
						echo esc_html( $cookie_expire.' '.$cookie_unit );
					} else {
						esc_html_e('No', 'popup-anything-on-click');
					} ?>
				</a>
			</td>
		</tr>
	</tbody>
</table>