<?php
/**
 * Popup Report. Popup Click, Impression
 * 
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

global $post, $wpdb;

// Taking some data
$from_date				= '';
$to_date				= '';
$sum_column				= 'click_view';
$submitted_popup_type	= "AND `popup_type` != 'inline'";
$date_options			= paoc_pro_report_date_options();
$popup_post_data		= paoc_pro_get_posts( PAOC_PRO_POST_TYPE );
$current_date			= date( 'Y-m-d', current_time( 'timestamp' ) );

$popup_id		= ! empty( $_GET['popup_id'] )									? paoc_pro_clean_number( $_GET['popup_id'] )	: 0;
$popup_id		= ( empty( $popup_id ) && isset( $popup_post_data[0]->ID ) )	? $popup_post_data[0]->ID						: $popup_id;
$popup_type		= ! empty( $_GET['popup_type'] )								? paoc_pro_clean( $_GET['popup_type'] )			: '';
$date_selected	= ! empty( $_GET['date_range'] )								? paoc_pro_clean( $_GET['date_range'] )			: 'last_30_days';
$date_text		= isset( $date_options[ $date_selected ] )						? $date_options[ $date_selected ]				: '';

if( $date_selected == 'other' ) {
	$from_date	= ! empty( $_GET['from_date'] )	? date( 'Y-m-d', strtotime( $_GET['from_date'] ) )	: $current_date;
	$to_date	= ! empty( $_GET['to_date'] )	? date( 'Y-m-d', strtotime( $_GET['to_date'] ) )	: $current_date;
	$date_text	= $from_date .' '. __('to', 'popup-anything-on-click') .' '. $to_date;
}

$date_range	= paoc_pro_date_range_sql( $date_selected );

// Popup type filter
if( $popup_type == 'inline' ) {
	$sum_column				= 'inline_click_view';
	$submitted_popup_type	= "AND `popup_type` = 'inline'";
}

// Get popup total views
$total_views	= $wpdb->get_var( "SELECT SUM( $sum_column ) FROM `".PAOC_PRO_REPORT_TBL."` WHERE 1=1 AND `popup_id` = {$popup_id} AND `type` = '1'" );
$total_views	= ! empty( $total_views ) ? $total_views : 0;

// Get popup total clicks
$total_clicks	= $wpdb->get_var( "SELECT SUM( $sum_column ) FROM `".PAOC_PRO_REPORT_TBL."` WHERE 1=1 AND `popup_id` = {$popup_id} AND `type` = '2'" );
$total_clicks	= ! empty( $total_clicks ) ? $total_clicks : 0;

// Get date wise popup views
$filter_views	= $wpdb->get_var( "SELECT SUM( $sum_column ) FROM `".PAOC_PRO_REPORT_TBL."` WHERE 1=1 AND `popup_id` = {$popup_id} AND `type` = '1' {$date_range}" );
$filter_views	= ! empty( $filter_views ) ? $filter_views : 0;

// Get date wise popup clicks
$filter_clicks	= $wpdb->get_var( "SELECT SUM( $sum_column ) FROM `".PAOC_PRO_REPORT_TBL."` WHERE 1=1 AND `popup_id` = {$popup_id} AND `type` = '2' {$date_range}" );
$filter_clicks	= ! empty( $filter_clicks ) ? $filter_clicks : 0;

// Get Total popup clicks by top refferal URL
$total_submitted_data = $wpdb->get_results( "SELECT `referral_link`, COUNT(id) as page_clicks FROM `".PAOC_PRO_ENTRY_TBL."` WHERE 1=1 {$submitted_popup_type} AND `popup_id` = {$popup_id} GROUP BY `referral_link` ORDER BY `page_clicks` DESC LIMIT 30" );

// Get date wise popup clicks by top refferal URL
$filter_submitted_data = $wpdb->get_results( "SELECT `referral_link`, COUNT(id) as page_clicks FROM `".PAOC_PRO_ENTRY_TBL."` WHERE 1=1 {$submitted_popup_type} AND `popup_id` = {$popup_id} {$date_range} GROUP BY `referral_link` ORDER BY `page_clicks` DESC LIMIT 30" );
?>

<div class="wrap paoc-popup-report-wrp">

	<h2><?php esc_html_e( 'Popup Anything Pro - Reports', 'popup-anything-on-click' ); ?></h2>

	<div class="metabox-holder">
		<div class="post-box-container">
			<div class="meta-box-sortables ui-sortable">
				<div class="postbox paoc-no-toggle">

					<div class="postbox-header">
						<h3 class="hndle">
							<span><?php esc_html_e( 'Popup Anything Pro Report', 'popup-anything-on-click' ); ?></span>
						</h3>
					</div>

					<div class="inside paoc-report-wrp paoc-cnt-wrap">
						<div class="paoc-report-form-wrp">
							<form id="paoc-post-report" class="paoc-report-form" method="get" action="">

								<input type="hidden" name="post_type" value="<?php echo PAOC_PRO_POST_TYPE; ?>" />
								<input type="hidden" name="page" value="paoc-reports" />

								<select name="popup_id" class="paoc-select paoc-sett-post-type">
									<?php if( ! empty( $popup_post_data ) ) {
										foreach ( $popup_post_data as $popup_post_key => $popup_post_val ) { ?>
											<option value="<?php echo esc_attr( $popup_post_val->ID ); ?>" <?php selected( $popup_post_val->ID, $popup_id ); ?>><?php echo esc_html( $popup_post_val->post_title ); ?></option>
									<?php }
									} ?>
								</select>

								<select name="popup_type" class="paoc-select paoc-sett-popup-type">
									<option value=""><?php esc_html_e('Normal Popup', 'popup-anything-on-click'); ?></option>
									<option value="inline" <?php selected( $popup_type, 'inline' ); ?>><?php esc_html_e('Inline Popup', 'popup-anything-on-click'); ?></option>
								</select>

								<select name="date_range" class="paoc-select paoc-date-range-filter paoc-date-filter">
									<?php foreach ( $date_options as $date_key => $date_val ) { ?>
										<option value="<?php echo esc_attr( $date_key ) ?>" <?php selected( $date_selected, $date_key ); ?>><?php echo esc_html( $date_val ); ?></option>
									<?php } ?>
								</select>

								<div class="paoc-date-range-field paoc-search-date" style="<?php if( $date_selected != 'other' ) { echo "display: none;"; } ?>">
									<span><?php esc_html_e('From', 'popup-anything-on-click'); ?>: </span>
									<input type="text" name="from_date" value="<?php echo esc_attr( $from_date ); ?>" max="<?php echo esc_attr( $current_date ); ?>" id="paoc-from-date" class="paoc-text paoc-date paoc-start-date paoc-date-field paoc-from-date" />
									
									<span><?php esc_html_e('To', 'popup-anything-on-click'); ?>: </span>
									<input type="text" name="to_date" value="<?php echo esc_attr( $to_date ); ?>" max="<?php echo esc_attr( $current_date ); ?>" id="paoc-to-date" class="paoc-text paoc-date paoc-end-date paoc-date-field paoc-to-date" />
								</div>
								<button class="button button-secondary paoc-btn paoc-filter-btn" type="submit"><?php esc_html_e('Filter','popup-anything-on-click'); ?></button>
							</form>
						</div>

						<hr/>

						<div class="paoc-report-data-wrap paoc-row paoc-clearfix">

							<div class="paoc-stats-row paoc-medium-6 paoc-columns">
								<h4><?php echo esc_html__('Viewing Record of', 'popup-anything-on-click') . ' : ' . esc_html( $date_text ); ?></h4>
								<div class="paoc-row">
									<div class="paoc-medium-6 paoc-columns">
										<div class="paoc-report-box">
											<div class="paoc-report-box-title"><?php esc_html_e('Clicks', 'popup-anything-on-click'); ?></div>
											<div class="paoc-report-box-inr">
												<span class="paoc-report-box-no"><?php echo number_format( $filter_clicks ); ?></span>
												<span class="paoc-report-box-desc"><?php echo esc_html( $date_text ); ?></span>
											</div>
										</div>
									</div>

									<div class="paoc-medium-6 paoc-columns">
										<div class="paoc-report-box">
											<div class="paoc-report-box-title"><?php esc_html_e('Views', 'popup-anything-on-click'); ?></div>
											<div class="paoc-report-box-inr">
												<span class="paoc-report-box-no"><?php echo number_format( $filter_views ); ?></span>
												<span class="paoc-report-box-desc"><?php echo esc_html( $date_text ); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div><!-- end .paoc-stats-row -->

							<div class="paoc-stats-row paoc-medium-6 paoc-columns">
								<h4><?php esc_html_e('Viewing Total Records', 'popup-anything-on-click'); ?></h4>
								<div class="paoc-row">
									<div class="paoc-medium-6 paoc-columns">
										<div class="paoc-report-box">
											<div class="paoc-report-box-title"><?php esc_html_e('Total Clicks', 'popup-anything-on-click'); ?></div>
											<div class="paoc-report-box-inr">
												<span class="paoc-report-box-no"><?php echo number_format( $total_clicks ); ?></span>
												<span class="paoc-report-box-desc"><?php esc_html_e('Total', 'popup-anything-on-click'); ?></span>
											</div>
										</div>
									</div>

									<div class="paoc-medium-6 paoc-columns">
										<div class="paoc-report-box">
											<div class="paoc-report-box-title"><?php esc_html_e('Total Views', 'popup-anything-on-click'); ?></div>
											<div class="paoc-report-box-inr">
												<span class="paoc-report-box-no"><?php echo number_format( $total_views ); ?></span>
												<span class="paoc-report-box-desc"><?php esc_html_e('Total', 'popup-anything-on-click'); ?></span>
											</div>
										</div>
									</div>
								</div>
							</div><!-- end .paoc-stats-row -->
						</div><!-- end .paoc-report-data-wrap -->

						<br/>

						<!-- Start - Reference Page URL Report -->
						<div class="paoc-report-data-wrap paoc-refer-data-wrap paoc-row paoc-clearfix">

							<h3 class="paoc-columns">
								<div class="paoc-report-sub-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Top Reference Page URL (Collect Lead Popup Only)', 'popup-anything-on-click'); ?></div>
							</h3>

							<div class="paoc-stats-row paoc-medium-6 paoc-columns">
								<h4><?php echo esc_html__('Viewing Record of', 'popup-anything-on-click') . ' : ' . esc_html( $date_text ); ?></h4>
								<div class="paoc-row">
									<div class="paoc-medium-12 paoc-columns">
										<table class="widefat striped paoc-report-tbl">
											<thead>
												<tr>
													<th><?php esc_html_e('Reference Page URL', 'popup-anything-on-click'); ?></th>
													<th><?php esc_html_e('Clicks', 'popup-anything-on-click'); ?></th>
												</tr>
											</thead>

											<tbody>
												<?php if( $filter_submitted_data ) { ?>
													<?php foreach ( $filter_submitted_data as $get_click_key => $get_click_val ) {

														$page_url		= $get_click_val->referral_link;
														$popup_clicks	= $get_click_val->page_clicks;
													?>
														<tr>
															<td><?php echo esc_html( $page_url ); ?></td>
															<td><?php echo number_format( $popup_clicks ); ?></td>
														</tr>
													<?php }
												} else { ?>
													<tr>
														<td colspan="2"><?php esc_html_e('No records found.', 'popup-anything-on-click'); ?></td>
													</tr>
												<?php } ?>
											</tbody>
										</table>
									</div>
								</div>
							</div><!-- end .paoc-stats-row -->

							<div class="paoc-stats-row paoc-medium-6 paoc-columns">
								<h4><?php esc_html_e('Viewing Total Records', 'popup-anything-on-click'); ?></h4>
								<div class="paoc-row">
									<div class="paoc-medium-12 paoc-columns">
										<table class="widefat striped paoc-report-tbl">
											<thead>
												<tr>
													<th><?php esc_html_e('Reference Page URL', 'popup-anything-on-click'); ?></th>
													<th><?php esc_html_e('Clicks', 'popup-anything-on-click'); ?></th>
												</tr>
											</thead>

											<tbody>
												<?php if( $total_submitted_data ) { ?>
													<?php foreach ( $total_submitted_data as $get_click_key => $get_click_val ) {

														$page_url		= $get_click_val->referral_link;
														$popup_clicks	= $get_click_val->page_clicks;
													?>
														<tr>
															<td><?php echo esc_html( $page_url ); ?></td>
															<td><?php echo number_format( $popup_clicks ); ?></td>
														</tr>
													<?php }
												} else { ?>
													<tr>
														<td colspan="2"><?php esc_html_e('No records found.', 'popup-anything-on-click'); ?></td>
													</tr>
												<?php } ?>
											</tbody>
										</table>
									</div>
								</div>
							</div><!-- end .paoc-stats-row -->
						</div><!-- end .paoc-report-data-wrap -->
						<!-- End - Reference Page URL Report -->

					</div><!-- end .inside -->

				</div><!-- end .postbox -->
			</div><!-- end .meta-box-sortables -->
		</div><!-- end .post-box-container -->
	</div><!-- end .metabox-holder -->
</div><!-- end .paoc-popup-report-wrp -->