<?php
/**
 * Display Rule Settings
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variable
$global_location	= paoc_pro_display_locations();
$reg_post_types		= paoc_pro_get_post_types( null, array('attachment', 'revision', 'nav_menu_item') );
$post_types			= paoc_pro_get_option( 'post_types', array() );
$welcome_popup		= paoc_pro_get_option( 'welcome_popup' );
$welcome_display_in	= paoc_pro_get_option( 'welcome_display_in', array() );
$exit_popup			= paoc_pro_get_option( 'exit_popup' );
$exit_display_in	= paoc_pro_get_option( 'exit_display_in', array() );
$general_popup		= paoc_pro_get_option( 'general_popup', array() );
$general_display_in	= paoc_pro_get_option( 'general_display_in', array() );

// Get Popup Post Argument
$general_args = array(
	'post_type'			=> PAOC_PRO_POST_TYPE,
	'post__in'			=> $general_popup,
	'posts_per_page'	=> -1,
);

// Getting Some Data
$welcome_popup_post 	= ( ! empty( $welcome_popup ) )					? get_post( $welcome_popup )		: '';
$welcome_popup_title	= ! empty( $welcome_popup_post->post_title )	? $welcome_popup_post->post_title	: esc_html__('Post', 'popup-anything-on-click');
$exit_popup_post		= ( ! empty( $exit_popup ) )					? get_post( $exit_popup )			: '';
$exit_popup_title		= ! empty( $exit_popup_post->post_title )		? $exit_popup_post->post_title		: esc_html__('Post', 'popup-anything-on-click');
$general_popup_post		= ( ! empty( $general_popup ) )					? get_posts( $general_args )		: '';

$welcome_meta_data	= paoc_pro_sugg_meta_data( 'welcome' );
$exit_meta_data		= paoc_pro_sugg_meta_data( 'exit' );
$general_meta_data	= paoc_pro_sugg_meta_data( 'general' );
?>

<div class="postbox paoc-no-toggle">

	<div class="postbox-header">
		<h3 class="hndle">
			<span><?php esc_html_e( 'Display Rule Settings', 'popup-anything-on-click' ); ?></span>
		</h3>
	</div>

	<div class="inside">
		<table class="form-table paoc-tbl">
			<tbody>

				<tr>
					<th>
						<label for="paoc-type"><?php esc_html_e('Post Types', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<?php if( ! empty( $reg_post_types ) ) {
							foreach ( $reg_post_types as $post_key => $post_label ) {
						?>
							<div class="paoc-loop-irow">
								<label>
									<input type="checkbox" value="<?php echo esc_attr( $post_key ); ?>" name="paoc_pro_options[post_types][]" <?php checked( in_array( $post_key, $post_types ), true ); ?> class="paoc-checkbox" />
									<?php echo esc_html( $post_label ); ?>
								</label>
							</div>
							<?php }
						} ?>
						<br/>
						<span class="description"><?php esc_html_e('Check these boxes if you want to show different popups for individual posts and pages. This will enable the setting box at enabled post types while you add or edit it.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>

				<!-- Start - Welcome Popup Settings -->
				<tr>
					<th colspan="2"><div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Welcome Popup Settings', 'popup-anything-on-click'); ?></div></th>
				</tr>
				<tr>
					<th>
						<label for="paoc-welcome-popup"><?php esc_html_e('Welcome Popup', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<select name="paoc_pro_options[welcome_popup]" id="paoc-welcome-popup" class="paoc-select2-medium paoc-post-title-sugg paoc-welcome-popup" data-placeholder="<?php esc_html_e('Select Welcome Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo PAOC_PRO_POST_TYPE; ?>" data-meta='<?php echo esc_attr( json_encode( $welcome_meta_data ) ); ?>'>
							<option></option>
							<?php if( $welcome_popup_post ) { ?>
							<option value="<?php echo esc_attr( $welcome_popup_post->ID ); ?>" selected="selected"><?php echo esc_html( $welcome_popup_title ." - (#{$welcome_popup_post->ID})" ); ?></option>
							<?php } ?>
						</select><br/>
						<span class="description"><?php esc_html_e('Select welcome popup to display globally. You can search popup by its name or ID.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>
				<tr>
					<th>
						<label for="paoc-wel-displayin"><?php esc_html_e('Display In', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<?php if( ! empty( $global_location ) ) {
							foreach ( $global_location as $global_location_key => $global_location_val ) { ?>
								<div class="paoc-loop-irow">
									<label>
										<input type="checkbox" name="paoc_pro_options[welcome_display_in][<?php echo esc_attr( $global_location_key ); ?>]" class="paoc-checkbox paoc-wel-gbl-locs" value="1" <?php checked( array_key_exists( $global_location_key, $welcome_display_in ), true ); ?> />
										<?php echo esc_html( $global_location_val ); ?>
									</label>
								</div>
							<?php }
						} ?>
						<br/>
						<span class="description"><?php esc_html_e('Check this box to display welcome popup globally. You can still choose the popup for single posts and pages.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>
				<!-- End - Welcome Popup Settings -->

				<!-- Start - Exit Popup Settings -->
				<tr>
					<th colspan="2"><div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('Exit Popup Settings', 'popup-anything-on-click'); ?></div></th>
				</tr>
				<tr>
					<th>
						<label for="paoc-exit-popup"><?php esc_html_e('Exit Popup', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<select name="paoc_pro_options[exit_popup]" id="paoc-exit-popup" class="paoc-select2-medium paoc-post-title-sugg paoc-exit-popup" data-placeholder="<?php esc_html_e('Select Exit Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo PAOC_PRO_POST_TYPE; ?>" data-meta='<?php echo esc_attr( json_encode( $exit_meta_data ) ); ?>'>
							<option></option>
							<?php if( $exit_popup_post ) { ?>
							<option value="<?php echo esc_attr( $exit_popup_post->ID ) ?>" selected="selected"><?php echo esc_html( $exit_popup_title ) ." - (#{$exit_popup_post->ID})" ?></option>
							<?php } ?>
						</select><br/>
						<span class="description"><?php esc_html_e('Select exit popup to display globally. You can search popup by its name or ID.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>
				<tr>
					<th>
						<label for="paoc-exit-displayin"><?php esc_html_e('Display In', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<?php if( ! empty( $global_location ) ) {
							foreach ( $global_location as $global_location_key => $global_location_val ) { ?>
								<div class="paoc-loop-irow">
								<label>
									<input type="checkbox" name="paoc_pro_options[exit_display_in][<?php echo esc_attr( $global_location_key ); ?>]" class="paoc-checkbox paoc-exit-gbl-locs" value="1" <?php checked( array_key_exists( $global_location_key, $exit_display_in ), true ); ?> />
									<?php echo esc_html( $global_location_val ); ?>
								</label>
								</div>
							<?php }
						} ?>
						<br/>
						<span class="description"><?php esc_html_e('Check this box to display exit popup globally. You can still choose the popup for single posts and pages.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>
				<!-- End - Exit Popup Settings -->

				<!-- Start - General Popup Settings -->
				<tr>
					<th colspan="2"><div class="paoc-sub-sett-title"><i class="dashicons dashicons-admin-generic"></i> <?php esc_html_e('General Popup Settings (All type of Popup Appear)', 'popup-anything-on-click'); ?></div></th>
				</tr>
				<tr>
					<th>
						<label for="paoc-general-popup"><?php esc_html_e('General Popup', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<select name="paoc_pro_options[general_popup][]" id="paoc-general-popup" class="paoc-select2-mul paoc-post-title-sugg paoc-general-popup" data-placeholder="<?php esc_html_e('Select General Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo PAOC_PRO_POST_TYPE; ?>" data-meta='<?php echo esc_attr( json_encode( $general_meta_data ) ); ?>' multiple="multiple">
							<option></option>
							<?php if( ! empty( $general_popup_post ) ) {
								foreach ( $general_popup_post as $general_popup_key => $general_popup_val ) { ?>
									<option value="<?php echo esc_attr( $general_popup_val->ID ); ?>" <?php selected( in_array( $general_popup_val->ID, $general_popup ), true ); ?>><?php echo esc_html( $general_popup_val->post_title ) ." - (#{$general_popup_val->ID})"; ?></option>
								<?php }
							} ?>
						</select><br/>
						<span class="description"><?php esc_html_e('Select general popup to display globally. You can search popup by its name or ID.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>
				<tr>
					<th>
						<label for="paoc-general-displayin"><?php esc_html_e('Display In', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<?php if( ! empty( $global_location ) ) {
							foreach ( $global_location as $global_location_key => $global_location_val ) { ?>
								<div class="paoc-loop-irow">
								<label>
									<input type="checkbox" name="paoc_pro_options[general_display_in][<?php echo esc_attr( $global_location_key ); ?>]" class="paoc-checkbox paoc-general-gbl-locs" value="1" <?php checked( array_key_exists( $global_location_key, $general_display_in ), true ); ?> />
									<?php echo esc_html( $global_location_val ); ?>
								</label>
								</div>
							<?php }
						} ?>
						<br/>
						<span class="description"><?php esc_html_e('Check this box to display general popup globally. You can still choose the popup for single posts and pages.', 'popup-anything-on-click'); ?></span>
					</td>
				</tr>
				<!-- End - General Popup Settings -->

				<tr>
					<td colspan="2">
						<input type="submit" name="paoc_display_rule_sett" class="button button-primary right paoc-btn paoc-sett-submit" value="<?php esc_attr_e('Save Changes', 'popup-anything-on-click'); ?>" />
					</td>
				</tr>
			</tbody>
		</table>
	</div><!-- end .inside -->
</div><!-- end .postbox -->