<?php
/**
 * Handle Email Integration HTML
 *
 * Handles the third party integration
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking stored data
$mc_api_key		= paoc_pro_get_option( 'mc_api_key' );
$mc_acc_info	= paoc_pro_integration_info( 'mailchimp', 'account_info' );
$mc_connected	= ( $mc_api_key && $mc_acc_info ) ? 1 : 0;
?>

<div class="postbox">
	<div class="postbox-header">
		<h3 class="hndle">
			<span><?php esc_html_e( 'MailChimp Settings', 'popup-anything-on-click' ); ?></span>
		</h3>
	</div>

	<div class="inside">
		<table class="form-table paoc-tbl">
			<tbody>
				
				<?php if ( $mc_connected ) { ?>
				<tr>
					<th colspan="2">
						<div class="paoc-success paoc-no-margin">
							<p><?php esc_html_e('MailChimp account is connected.','popup-anything-on-click'); ?></p>
						</div>
					</th>
				</tr>
				<?php } else { ?>
					<tr>
						<th colspan="2">
							<div class="paoc-notice"><?php esc_html_e('MailChimp account is not connected. Kindly be sure you have added the valid API key.', 'popup-anything-on-click'); ?></div>
						</th>
					</tr>
				<?php } ?>

				<tr>
					<th scope="row">
						<label for="paoc-intgs-mc-api-key"><?php esc_html_e('API Key', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<input type="text" name="paoc_pro_options[mc_api_key]" class="large-text" id="paoc-intgs-mc-api-key" value="<?php echo esc_attr( $mc_api_key ); ?>" /><br>
						<span class="description"><?php echo sprintf( __('The API key for connecting with your Mailchimp account. <a href="%s" target="_blank">Get your API key here</a>.', 'popup-anything-on-click'), 'https://admin.mailchimp.com/account/api' ); ?></span>
					</td>
				</tr>

				<tr>
					<th></th>
					<td class="paoc-no-tb-padding">
						<?php if ( $mc_connected ) { ?>
							<input type="submit" name="paoc_intgs_mc_connect" class="button button-secondary paoc-btn" value="<?php esc_attr_e('Refresh Account', 'popup-anything-on-click'); ?>" />
							<input type="submit" name="paoc_intgs_mc_dconnect" class="button button-secondary paoc-btn" value="<?php esc_attr_e('Disconnect Account', 'popup-anything-on-click'); ?>" />
						<?php } else { ?>
							<input type="submit" name="paoc_intgs_mc_connect" class="button button-secondary paoc-btn" value="<?php esc_attr_e('Connect Account', 'popup-anything-on-click'); ?>" />
						<?php } ?>
					</td>
				</tr>

				<?php if( $mc_connected ) { ?>
				<tr>
					<th colspan="2">
						<label for="paoc-mc-ac-info"><?php esc_html_e('Account Information','popup-anything-on-click'); ?></label>
						<hr>
					</th>
				</tr>
				<tr>
					<th>
						<label><?php esc_html_e('Account Name', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<span><?php echo esc_attr( $mc_acc_info['name'] ); ?></span>
					</td>
				</tr>
				<tr>
					<th>
						<label><?php esc_html_e('Account Email', 'popup-anything-on-click'); ?></label>
					</th>
					<td>
						<span><?php echo esc_attr( $mc_acc_info['email'] ); ?></span>
					</td>
				</tr>
				<?php } ?>

				<tr>
					<td colspan="2">
						<input type="submit" name="paoc_intgs_mc_sett_submit" class="button button-primary right paoc-btn paoc-intgs-sett-submit paoc-intgs-mc-sett-submit paoc-sett-submit" value="<?php esc_attr_e('Save Changes', 'popup-anything-on-click'); ?>" />
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>