<?php
/**
 * Settings Page
 *
 * @package Popup Anything on Click Pro
 * @since 1.3
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

global $paoc_pro_options;

// Plugin settings tab
$sett_tab		= paoc_pro_settings_tab();
$sett_tab_count	= count( $sett_tab );
$tab			= isset( $_GET['tab'] ) ? $_GET['tab'] : 'general';

// If no valid tab is there
if( ! isset( $sett_tab[ $tab ] ) ) {
	paoc_pro_display_message( 'error' );
	return;
}
?>

<div class="wrap">

	<h2><?php esc_html_e( 'Popup Anything Pro - Settings', 'popup-anything-on-click' ); ?></h2>

	<?php
	// Reset message
	if( ! empty( $_POST['paoc_pro_reset_settings'] ) ) {
		paoc_pro_display_message( 'reset' );
	}

	// Success message
	if( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] == 'true' ) {
		paoc_pro_display_message( 'update' );
	}

	settings_errors( 'paoc_pro_sett_error' );

	// If more than one settings tab
	if( $sett_tab_count > 1 ) { ?>

	<h2 class="nav-tab-wrapper">
		<?php foreach ( $sett_tab as $tab_key => $tab_val ) {
			$tab_url 		= add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-pro-settings', 'tab' => $tab_key ), admin_url('edit.php') );
			$active_tab_cls = ( $tab == $tab_key ) ? 'nav-tab-active' : '';
		?>
			<a class="nav-tab <?php echo esc_attr( $active_tab_cls ); ?>" href="<?php echo esc_url( $tab_url ); ?>"><?php echo esc_html( $tab_val ); ?></a>
		<?php } ?>
	</h2>

	<?php } ?>

	<div class="paoc-sett-wrap paoc-settings paoc-cnt-wrap paoc-pad-top-20">

		<!-- Plugin reset settings form -->
		<form action="" method="post" id="paoc-reset-sett-form" class="paoc-right paoc-reset-sett-form">
			<input type="submit" class="button button-primary paoc-confirm paoc-btn paoc-reset-sett paoc-resett-sett-btn paoc-reset-sett" name="paoc_pro_reset_settings" id="paoc-reset-sett" value="<?php esc_attr_e( 'Reset All Settings', 'popup-anything-on-click' ); ?>" />
			<?php wp_nonce_field( 'paoc_reset_setting', 'paoc_reset_sett_nonce' ); ?>
		</form>

		<form action="options.php" method="POST" id="paoc-settings-form" class="paoc-settings-form">

			<?php settings_fields( 'paoc_pro_plugin_options' ); ?>

			<div class="textright paoc-clearfix">
				<input type="submit" name="paoc_settings_submit" class="button button-primary right paoc-btn paoc-sett-submit paoc-sett-submit" value="<?php esc_attr_e('Save Changes', 'popup-anything-on-click'); ?>" />
			</div>

			<div class="metabox-holder">
				<div class="post-box-container">
					<div class="meta-box-sortables ui-sortable">

						<?php
						// Setting files
						switch ( $tab ) {
							case 'general':
								include_once( PAOC_PRO_DIR . '/includes/admin/settings/general-settings.php' );
								break;

							case 'display_rule':
								include_once( PAOC_PRO_DIR . '/includes/admin/settings/display-rule-settings.php' );
								break;

							case 'integration':
								include_once( PAOC_PRO_DIR . '/includes/admin/settings/integration-settings.php' );
								break;

							default:
								do_action( 'paoc_pro_sett_panel_' . $tab );
								do_action( 'paoc_pro_sett_panel', $tab );
								break;
						}
						?>

					</div><!-- end .meta-box-sortables -->
				</div><!-- end .post-box-container -->
			</div><!-- end .metabox-holder -->

		</form><!-- end .paoc-settings-form -->
	</div><!-- end .paoc-sett-wrap -->
</div><!-- end .wrap -->