<?php
/**
 * Export HTML
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// Taking some variables
$redirect_url = add_query_arg( array( 'post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-tools' ), admin_url('edit.php') );
?>

<div class="wrap paoc-cnt-wrap paoc-popup-tools-wrp">

	<h2><?php esc_html_e( 'Popup Anything Pro - Tools', 'popup-anything-on-click' ); ?></h2>

	<div class="metabox-holder">
		<div class="post-box-container">
			<div class="meta-box-sortables ui-sortable">
				<div class="postbox paoc-no-toggle">

					<div class="postbox-header">
						<h3 class="hndle">
							<span><?php esc_html_e( 'Export Form Entries', 'popup-anything-on-click' ); ?></span>
						</h3>
					</div>

					<div class="inside paoc-tools-wrp">

						<p><?php esc_html_e('Download a CSV of all form entries recorded.', 'popup-anything-on-click'); ?></p>

						<form id="paoc-tools-entry-form" class="paoc-tools-form paoc-tools-entry-form" method="post" action="">

							<input type="text" name="start_date" value="" class="paoc-text paoc-date paoc-start-date" placeholder="<?php esc_html_e('Choose start date', 'popup-anything-on-click'); ?>" />
							<input type="text" name="end_date" value="" class="paoc-text paoc-date paoc-end-date" placeholder="<?php esc_html_e('Choose end date', 'popup-anything-on-click'); ?>" />

							<select name="popup_id" class="paoc-post-title-sugg" data-placeholder="<?php esc_html_e('Select Collect Lead Popup', 'popup-anything-on-click'); ?>" data-nonce="<?php echo wp_create_nonce('paoc-post-title-sugg'); ?>" data-post-type="<?php echo esc_attr( PAOC_PRO_POST_TYPE ); ?>" data-meta='{"0":{"key":"_aoc_popup_goal","value":"email-lists"}}' data-post-status="any">
								<option></option>
							</select>

							<select name="popup_type" class="paoc-select paoc-popup-type">
								<option value=""><?php esc_html_e('All Popup Type', 'popup-anything-on-click'); ?></option>
								<option value="normal"><?php esc_html_e('Normal Popup', 'popup-anything-on-click'); ?></option>
								<option value="inline"><?php esc_html_e('Inline Popup', 'popup-anything-on-click'); ?></option>
							</select>

							<span class="paoc-tools-submit-wrp">
								<input type="submit" value="<?php esc_attr_e('Generate CSV', 'popup-anything-on-click'); ?>" class="button button-secondary paoc-tools-submit" />
							</span>

							<input type="hidden" name="nonce" value="<?php echo wp_create_nonce( 'paoc-export-nonce' ); ?>" />
							<input type="hidden" name="redirect_url" value="<?php echo esc_url( $redirect_url ); ?>" />
						</form><!-- end .paoc-tools-wrp -->
					</div><!-- end .inside -->
				</div><!-- end .postbox -->
			</div>
		</div><!-- end .post-box-container -->
	</div><!-- end .metabox-holder -->
</div><!-- end .wrap -->