<?php
/**
 * Integration Class
 *
 * @package Popup Anything on Click Pro
 * @since 2.0.5
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class Paoc_Pro_Integration {

	function __construct() {

		// Action to synchronize mailchimp list fields
		add_action( 'wp_ajax_paoc_pro_get_mc_fields', array($this, 'paoc_pro_get_mc_fields') );
	}

	/**
	 * Function to get mailchimp list fields
	 * 
	 * @since 2.0.5
	 */
	function paoc_pro_get_mc_fields() {

		$mc_field_arr		= array();
		$prefix				= PAOC_PRO_META_PREFIX;
		$result				= array( 'success' => 0, 'msg' => esc_html__('Sorry, Something happened wrong.', 'popup-anything-on-click') );
		$nonce				= isset( $_POST['nonce'] )		? paoc_pro_clean( $_POST['nonce'] )				: '';
		$mc_list_id			= isset( $_POST['mc_list_id'] )	? paoc_pro_clean( $_POST['mc_list_id'] )		: '';
		$popup_id			= isset( $_POST['popup_id'] )	? paoc_pro_clean_number( $_POST['popup_id'] )	: 0;
		$post_data			= isset( $_POST['form_data'] )	? parse_str( $_POST['form_data'], $form_data )	: '';
		$form_fields_data	= isset( $form_data[$prefix.'content']['form_fields'] ) ? $form_data[$prefix.'content']['form_fields'] : array();

		// MailChimp Fields
		$mc_field_opts = "<option value=''>".esc_html__( 'Select Mailchimp Field', 'popup-anything-on-click' )."</option>";

		// Form Fields
		$form_field_opts = "<option value=''>".esc_html__( 'Select Form Field', 'popup-anything-on-click' )."</option>";

		if( $popup_id && $mc_list_id && wp_verify_nonce( $nonce, 'paoc-mc-list-syn-'.$popup_id ) ) {

			// Initialize MailChimp API
			$mailchimp_data	= new Paoc_Pro_MailChimp();

			$mc_field_data	= $mailchimp_data->get_list_merge_fields( $mc_list_id );
			$email_field	= array(
								array(
									'merge_id'		=> 0,
									'tag'			=> 'EMAIL',
									'name'			=> esc_html__('Email Address', 'popup-anything-on-click'),
									'type'			=> 'email',
									'required'		=> 1,
									'default_value'	=> '',
									'public'		=> 1,
									'display_order'	=> 1,
								));

			if ( ! empty( $mc_field_data['merge_fields'] ) ) {
				$mc_fields = array_merge( $email_field, $mc_field_data['merge_fields'] );
			} else {
				$mc_fields = $email_field;
			}

			if( ! empty( $form_fields_data ) ) {
				foreach( $form_fields_data as $form_field_key => $form_field_data ) {
					
					$label = ( isset( $form_field_data['label'] ) && $form_field_data['label'] != '' ) ? $form_field_data['label'] : esc_html__('Field', 'popup-anything-on-click') .' - '. $form_field_key;

					$form_field_opts .= "<option value='". esc_attr( $form_field_key ) ."'>". esc_html( $label ) ."</option>";
				}
			}

			if ( ! empty( $mc_fields ) ) {
				foreach( $mc_fields as $mc_field_key => $mc_field_val ) {

					$mc_field_arr[ $mc_field_key ]['merge_id']		= $mc_field_val['merge_id'];
					$mc_field_arr[ $mc_field_key ]['tag']			= $mc_field_val['tag'];
					$mc_field_arr[ $mc_field_key ]['name']			= $mc_field_val['name'];
					$mc_field_arr[ $mc_field_key ]['type']			= $mc_field_val['type'];
					$mc_field_arr[ $mc_field_key ]['required']		= $mc_field_val['required'];
					$mc_field_arr[ $mc_field_key ]['default_value']	= $mc_field_val['default_value'];
					$mc_field_arr[ $mc_field_key ]['public']		= $mc_field_val['public'];
					$mc_field_arr[ $mc_field_key ]['display_order']	= $mc_field_val['display_order'];

					$mc_field_opts .= "<option value='". esc_attr( $mc_field_val['tag'] ) ."'>". esc_html( $mc_field_val['name'] ) ."</option>";
				}				
			}

			$result['success']	= 1;
			$result['msg']		= esc_html__('MailChimp List synchronized successfully.', 'popup-anything-on-click');

		} elseif ( empty( $mc_list_id ) ) {

			$result['msg'] = esc_html__('Please select MailChimp list to synchronize.', 'popup-anything-on-click');
		}

		$result['mc_field_opts']	= $mc_field_opts;
		$result['form_field_opts']	= $form_field_opts;
		$result['mc_fields']		= ! empty( $mc_field_arr ) ? serialize( $mc_field_arr ) : '';

		wp_send_json( $result );
	}
}

$paoc_pro_integration = new Paoc_Pro_Integration();