<?php
/**
 * Geolocation Functions
 *
 * @package Popup Anything on Click Pro
 * @since 2.0.7
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Function get countries.
 * 
 * @since 2.0.7
 */
function paoc_pro_countries() {

	$countries_opts = array(
						'AF' => __( 'Afghanistan', 'popup-anything-on-click' ),
						'AX' => __( 'Åland Islands', 'popup-anything-on-click' ),
						'AL' => __( 'Albania', 'popup-anything-on-click' ),
						'DZ' => __( 'Algeria', 'popup-anything-on-click' ),
						'AS' => __( 'American Samoa', 'popup-anything-on-click' ),
						'AD' => __( 'Andorra', 'popup-anything-on-click' ),
						'AO' => __( 'Angola', 'popup-anything-on-click' ),
						'AI' => __( 'Anguilla', 'popup-anything-on-click' ),
						'AQ' => __( 'Antarctica', 'popup-anything-on-click' ),
						'AG' => __( 'Antigua and Barbuda', 'popup-anything-on-click' ),
						'AR' => __( 'Argentina', 'popup-anything-on-click' ),
						'AM' => __( 'Armenia', 'popup-anything-on-click' ),
						'AW' => __( 'Aruba', 'popup-anything-on-click' ),
						'AU' => __( 'Australia', 'popup-anything-on-click' ),
						'AT' => __( 'Austria', 'popup-anything-on-click' ),
						'AZ' => __( 'Azerbaijan', 'popup-anything-on-click' ),
						'BS' => __( 'Bahamas', 'popup-anything-on-click' ),
						'BH' => __( 'Bahrain', 'popup-anything-on-click' ),
						'BD' => __( 'Bangladesh', 'popup-anything-on-click' ),
						'BB' => __( 'Barbados', 'popup-anything-on-click' ),
						'BY' => __( 'Belarus', 'popup-anything-on-click' ),
						'BE' => __( 'Belgium', 'popup-anything-on-click' ),
						'PW' => __( 'Belau', 'popup-anything-on-click' ),
						'BZ' => __( 'Belize', 'popup-anything-on-click' ),
						'BJ' => __( 'Benin', 'popup-anything-on-click' ),
						'BM' => __( 'Bermuda', 'popup-anything-on-click' ),
						'BT' => __( 'Bhutan', 'popup-anything-on-click' ),
						'BO' => __( 'Bolivia', 'popup-anything-on-click' ),
						'BQ' => __( 'Bonaire, Saint Eustatius and Saba', 'popup-anything-on-click' ),
						'BA' => __( 'Bosnia and Herzegovina', 'popup-anything-on-click' ),
						'BW' => __( 'Botswana', 'popup-anything-on-click' ),
						'BV' => __( 'Bouvet Island', 'popup-anything-on-click' ),
						'BR' => __( 'Brazil', 'popup-anything-on-click' ),
						'IO' => __( 'British Indian Ocean Territory', 'popup-anything-on-click' ),
						'BN' => __( 'Brunei', 'popup-anything-on-click' ),
						'BG' => __( 'Bulgaria', 'popup-anything-on-click' ),
						'BF' => __( 'Burkina Faso', 'popup-anything-on-click' ),
						'BI' => __( 'Burundi', 'popup-anything-on-click' ),
						'KH' => __( 'Cambodia', 'popup-anything-on-click' ),
						'CM' => __( 'Cameroon', 'popup-anything-on-click' ),
						'CA' => __( 'Canada', 'popup-anything-on-click' ),
						'CV' => __( 'Cape Verde', 'popup-anything-on-click' ),
						'KY' => __( 'Cayman Islands', 'popup-anything-on-click' ),
						'CF' => __( 'Central African Republic', 'popup-anything-on-click' ),
						'TD' => __( 'Chad', 'popup-anything-on-click' ),
						'CL' => __( 'Chile', 'popup-anything-on-click' ),
						'CN' => __( 'China', 'popup-anything-on-click' ),
						'CX' => __( 'Christmas Island', 'popup-anything-on-click' ),
						'CC' => __( 'Cocos (Keeling) Islands', 'popup-anything-on-click' ),
						'CO' => __( 'Colombia', 'popup-anything-on-click' ),
						'KM' => __( 'Comoros', 'popup-anything-on-click' ),
						'CG' => __( 'Congo (Brazzaville)', 'popup-anything-on-click' ),
						'CD' => __( 'Congo (Kinshasa)', 'popup-anything-on-click' ),
						'CK' => __( 'Cook Islands', 'popup-anything-on-click' ),
						'CR' => __( 'Costa Rica', 'popup-anything-on-click' ),
						'HR' => __( 'Croatia', 'popup-anything-on-click' ),
						'CU' => __( 'Cuba', 'popup-anything-on-click' ),
						'CW' => __( 'Cura&ccedil;ao', 'popup-anything-on-click' ),
						'CY' => __( 'Cyprus', 'popup-anything-on-click' ),
						'CZ' => __( 'Czech Republic', 'popup-anything-on-click' ),
						'DK' => __( 'Denmark', 'popup-anything-on-click' ),
						'DJ' => __( 'Djibouti', 'popup-anything-on-click' ),
						'DM' => __( 'Dominica', 'popup-anything-on-click' ),
						'DO' => __( 'Dominican Republic', 'popup-anything-on-click' ),
						'EC' => __( 'Ecuador', 'popup-anything-on-click' ),
						'EG' => __( 'Egypt', 'popup-anything-on-click' ),
						'SV' => __( 'El Salvador', 'popup-anything-on-click' ),
						'GQ' => __( 'Equatorial Guinea', 'popup-anything-on-click' ),
						'ER' => __( 'Eritrea', 'popup-anything-on-click' ),
						'EE' => __( 'Estonia', 'popup-anything-on-click' ),
						'ET' => __( 'Ethiopia', 'popup-anything-on-click' ),
						'FK' => __( 'Falkland Islands', 'popup-anything-on-click' ),
						'FO' => __( 'Faroe Islands', 'popup-anything-on-click' ),
						'FJ' => __( 'Fiji', 'popup-anything-on-click' ),
						'FI' => __( 'Finland', 'popup-anything-on-click' ),
						'FR' => __( 'France', 'popup-anything-on-click' ),
						'GF' => __( 'French Guiana', 'popup-anything-on-click' ),
						'PF' => __( 'French Polynesia', 'popup-anything-on-click' ),
						'TF' => __( 'French Southern Territories', 'popup-anything-on-click' ),
						'GA' => __( 'Gabon', 'popup-anything-on-click' ),
						'GM' => __( 'Gambia', 'popup-anything-on-click' ),
						'GE' => __( 'Georgia', 'popup-anything-on-click' ),
						'DE' => __( 'Germany', 'popup-anything-on-click' ),
						'GH' => __( 'Ghana', 'popup-anything-on-click' ),
						'GI' => __( 'Gibraltar', 'popup-anything-on-click' ),
						'GR' => __( 'Greece', 'popup-anything-on-click' ),
						'GL' => __( 'Greenland', 'popup-anything-on-click' ),
						'GD' => __( 'Grenada', 'popup-anything-on-click' ),
						'GP' => __( 'Guadeloupe', 'popup-anything-on-click' ),
						'GU' => __( 'Guam', 'popup-anything-on-click' ),
						'GT' => __( 'Guatemala', 'popup-anything-on-click' ),
						'GG' => __( 'Guernsey', 'popup-anything-on-click' ),
						'GN' => __( 'Guinea', 'popup-anything-on-click' ),
						'GW' => __( 'Guinea-Bissau', 'popup-anything-on-click' ),
						'GY' => __( 'Guyana', 'popup-anything-on-click' ),
						'HT' => __( 'Haiti', 'popup-anything-on-click' ),
						'HM' => __( 'Heard Island and McDonald Islands', 'popup-anything-on-click' ),
						'HN' => __( 'Honduras', 'popup-anything-on-click' ),
						'HK' => __( 'Hong Kong', 'popup-anything-on-click' ),
						'HU' => __( 'Hungary', 'popup-anything-on-click' ),
						'IS' => __( 'Iceland', 'popup-anything-on-click' ),
						'IN' => __( 'India', 'popup-anything-on-click' ),
						'ID' => __( 'Indonesia', 'popup-anything-on-click' ),
						'IR' => __( 'Iran', 'popup-anything-on-click' ),
						'IQ' => __( 'Iraq', 'popup-anything-on-click' ),
						'IE' => __( 'Ireland', 'popup-anything-on-click' ),
						'IM' => __( 'Isle of Man', 'popup-anything-on-click' ),
						'IL' => __( 'Israel', 'popup-anything-on-click' ),
						'IT' => __( 'Italy', 'popup-anything-on-click' ),
						'CI' => __( 'Ivory Coast', 'popup-anything-on-click' ),
						'JM' => __( 'Jamaica', 'popup-anything-on-click' ),
						'JP' => __( 'Japan', 'popup-anything-on-click' ),
						'JE' => __( 'Jersey', 'popup-anything-on-click' ),
						'JO' => __( 'Jordan', 'popup-anything-on-click' ),
						'KZ' => __( 'Kazakhstan', 'popup-anything-on-click' ),
						'KE' => __( 'Kenya', 'popup-anything-on-click' ),
						'KI' => __( 'Kiribati', 'popup-anything-on-click' ),
						'KW' => __( 'Kuwait', 'popup-anything-on-click' ),
						'KG' => __( 'Kyrgyzstan', 'popup-anything-on-click' ),
						'LA' => __( 'Laos', 'popup-anything-on-click' ),
						'LV' => __( 'Latvia', 'popup-anything-on-click' ),
						'LB' => __( 'Lebanon', 'popup-anything-on-click' ),
						'LS' => __( 'Lesotho', 'popup-anything-on-click' ),
						'LR' => __( 'Liberia', 'popup-anything-on-click' ),
						'LY' => __( 'Libya', 'popup-anything-on-click' ),
						'LI' => __( 'Liechtenstein', 'popup-anything-on-click' ),
						'LT' => __( 'Lithuania', 'popup-anything-on-click' ),
						'LU' => __( 'Luxembourg', 'popup-anything-on-click' ),
						'MO' => __( 'Macao', 'popup-anything-on-click' ),
						'MK' => __( 'North Macedonia', 'popup-anything-on-click' ),
						'MG' => __( 'Madagascar', 'popup-anything-on-click' ),
						'MW' => __( 'Malawi', 'popup-anything-on-click' ),
						'MY' => __( 'Malaysia', 'popup-anything-on-click' ),
						'MV' => __( 'Maldives', 'popup-anything-on-click' ),
						'ML' => __( 'Mali', 'popup-anything-on-click' ),
						'MT' => __( 'Malta', 'popup-anything-on-click' ),
						'MH' => __( 'Marshall Islands', 'popup-anything-on-click' ),
						'MQ' => __( 'Martinique', 'popup-anything-on-click' ),
						'MR' => __( 'Mauritania', 'popup-anything-on-click' ),
						'MU' => __( 'Mauritius', 'popup-anything-on-click' ),
						'YT' => __( 'Mayotte', 'popup-anything-on-click' ),
						'MX' => __( 'Mexico', 'popup-anything-on-click' ),
						'FM' => __( 'Micronesia', 'popup-anything-on-click' ),
						'MD' => __( 'Moldova', 'popup-anything-on-click' ),
						'MC' => __( 'Monaco', 'popup-anything-on-click' ),
						'MN' => __( 'Mongolia', 'popup-anything-on-click' ),
						'ME' => __( 'Montenegro', 'popup-anything-on-click' ),
						'MS' => __( 'Montserrat', 'popup-anything-on-click' ),
						'MA' => __( 'Morocco', 'popup-anything-on-click' ),
						'MZ' => __( 'Mozambique', 'popup-anything-on-click' ),
						'MM' => __( 'Myanmar', 'popup-anything-on-click' ),
						'NA' => __( 'Namibia', 'popup-anything-on-click' ),
						'NR' => __( 'Nauru', 'popup-anything-on-click' ),
						'NP' => __( 'Nepal', 'popup-anything-on-click' ),
						'NL' => __( 'Netherlands', 'popup-anything-on-click' ),
						'NC' => __( 'New Caledonia', 'popup-anything-on-click' ),
						'NZ' => __( 'New Zealand', 'popup-anything-on-click' ),
						'NI' => __( 'Nicaragua', 'popup-anything-on-click' ),
						'NE' => __( 'Niger', 'popup-anything-on-click' ),
						'NG' => __( 'Nigeria', 'popup-anything-on-click' ),
						'NU' => __( 'Niue', 'popup-anything-on-click' ),
						'NF' => __( 'Norfolk Island', 'popup-anything-on-click' ),
						'MP' => __( 'Northern Mariana Islands', 'popup-anything-on-click' ),
						'KP' => __( 'North Korea', 'popup-anything-on-click' ),
						'NO' => __( 'Norway', 'popup-anything-on-click' ),
						'OM' => __( 'Oman', 'popup-anything-on-click' ),
						'PK' => __( 'Pakistan', 'popup-anything-on-click' ),
						'PS' => __( 'Palestinian Territory', 'popup-anything-on-click' ),
						'PA' => __( 'Panama', 'popup-anything-on-click' ),
						'PG' => __( 'Papua New Guinea', 'popup-anything-on-click' ),
						'PY' => __( 'Paraguay', 'popup-anything-on-click' ),
						'PE' => __( 'Peru', 'popup-anything-on-click' ),
						'PH' => __( 'Philippines', 'popup-anything-on-click' ),
						'PN' => __( 'Pitcairn', 'popup-anything-on-click' ),
						'PL' => __( 'Poland', 'popup-anything-on-click' ),
						'PT' => __( 'Portugal', 'popup-anything-on-click' ),
						'PR' => __( 'Puerto Rico', 'popup-anything-on-click' ),
						'QA' => __( 'Qatar', 'popup-anything-on-click' ),
						'RE' => __( 'Reunion', 'popup-anything-on-click' ),
						'RO' => __( 'Romania', 'popup-anything-on-click' ),
						'RU' => __( 'Russia', 'popup-anything-on-click' ),
						'RW' => __( 'Rwanda', 'popup-anything-on-click' ),
						'BL' => __( 'Saint Barth&eacute;lemy', 'popup-anything-on-click' ),
						'SH' => __( 'Saint Helena', 'popup-anything-on-click' ),
						'KN' => __( 'Saint Kitts and Nevis', 'popup-anything-on-click' ),
						'LC' => __( 'Saint Lucia', 'popup-anything-on-click' ),
						'MF' => __( 'Saint Martin (French part)', 'popup-anything-on-click' ),
						'SX' => __( 'Saint Martin (Dutch part)', 'popup-anything-on-click' ),
						'PM' => __( 'Saint Pierre and Miquelon', 'popup-anything-on-click' ),
						'VC' => __( 'Saint Vincent and the Grenadines', 'popup-anything-on-click' ),
						'SM' => __( 'San Marino', 'popup-anything-on-click' ),
						'ST' => __( 'S&atilde;o Tom&eacute; and Pr&iacute;ncipe', 'popup-anything-on-click' ),
						'SA' => __( 'Saudi Arabia', 'popup-anything-on-click' ),
						'SN' => __( 'Senegal', 'popup-anything-on-click' ),
						'RS' => __( 'Serbia', 'popup-anything-on-click' ),
						'SC' => __( 'Seychelles', 'popup-anything-on-click' ),
						'SL' => __( 'Sierra Leone', 'popup-anything-on-click' ),
						'SG' => __( 'Singapore', 'popup-anything-on-click' ),
						'SK' => __( 'Slovakia', 'popup-anything-on-click' ),
						'SI' => __( 'Slovenia', 'popup-anything-on-click' ),
						'SB' => __( 'Solomon Islands', 'popup-anything-on-click' ),
						'SO' => __( 'Somalia', 'popup-anything-on-click' ),
						'ZA' => __( 'South Africa', 'popup-anything-on-click' ),
						'GS' => __( 'South Georgia/Sandwich Islands', 'popup-anything-on-click' ),
						'KR' => __( 'South Korea', 'popup-anything-on-click' ),
						'SS' => __( 'South Sudan', 'popup-anything-on-click' ),
						'ES' => __( 'Spain', 'popup-anything-on-click' ),
						'LK' => __( 'Sri Lanka', 'popup-anything-on-click' ),
						'SD' => __( 'Sudan', 'popup-anything-on-click' ),
						'SR' => __( 'Suriname', 'popup-anything-on-click' ),
						'SJ' => __( 'Svalbard and Jan Mayen', 'popup-anything-on-click' ),
						'SZ' => __( 'Swaziland', 'popup-anything-on-click' ),
						'SE' => __( 'Sweden', 'popup-anything-on-click' ),
						'CH' => __( 'Switzerland', 'popup-anything-on-click' ),
						'SY' => __( 'Syria', 'popup-anything-on-click' ),
						'TW' => __( 'Taiwan', 'popup-anything-on-click' ),
						'TJ' => __( 'Tajikistan', 'popup-anything-on-click' ),
						'TZ' => __( 'Tanzania', 'popup-anything-on-click' ),
						'TH' => __( 'Thailand', 'popup-anything-on-click' ),
						'TL' => __( 'Timor-Leste', 'popup-anything-on-click' ),
						'TG' => __( 'Togo', 'popup-anything-on-click' ),
						'TK' => __( 'Tokelau', 'popup-anything-on-click' ),
						'TO' => __( 'Tonga', 'popup-anything-on-click' ),
						'TT' => __( 'Trinidad and Tobago', 'popup-anything-on-click' ),
						'TN' => __( 'Tunisia', 'popup-anything-on-click' ),
						'TR' => __( 'Turkey', 'popup-anything-on-click' ),
						'TM' => __( 'Turkmenistan', 'popup-anything-on-click' ),
						'TC' => __( 'Turks and Caicos Islands', 'popup-anything-on-click' ),
						'TV' => __( 'Tuvalu', 'popup-anything-on-click' ),
						'UG' => __( 'Uganda', 'popup-anything-on-click' ),
						'UA' => __( 'Ukraine', 'popup-anything-on-click' ),
						'AE' => __( 'United Arab Emirates', 'popup-anything-on-click' ),
						'GB' => __( 'United Kingdom (UK)', 'popup-anything-on-click' ),
						'US' => __( 'United States (US)', 'popup-anything-on-click' ),
						'UM' => __( 'United States (US) Minor Outlying Islands', 'popup-anything-on-click' ),
						'UY' => __( 'Uruguay', 'popup-anything-on-click' ),
						'UZ' => __( 'Uzbekistan', 'popup-anything-on-click' ),
						'VU' => __( 'Vanuatu', 'popup-anything-on-click' ),
						'VA' => __( 'Vatican', 'popup-anything-on-click' ),
						'VE' => __( 'Venezuela', 'popup-anything-on-click' ),
						'VN' => __( 'Vietnam', 'popup-anything-on-click' ),
						'VG' => __( 'Virgin Islands (British)', 'popup-anything-on-click' ),
						'VI' => __( 'Virgin Islands (US)', 'popup-anything-on-click' ),
						'WF' => __( 'Wallis and Futuna', 'popup-anything-on-click' ),
						'EH' => __( 'Western Sahara', 'popup-anything-on-click' ),
						'WS' => __( 'Samoa', 'popup-anything-on-click' ),
						'YE' => __( 'Yemen', 'popup-anything-on-click' ),
						'ZM' => __( 'Zambia', 'popup-anything-on-click' ),
						'ZW' => __( 'Zimbabwe', 'popup-anything-on-click' ),
					);

	return apply_filters( 'paoc_pro_countries', $countries_opts );
}

/**
 * Fetches the country code from the request headers, if one is available.
 *
 * @since 2.0.7
 * @return string The country code pulled from the headers, or empty string if one was not found.
 */
function paoc_pro_get_country_from_header() {
	
	$country_code = '';

	$headers = array(
		'MM_COUNTRY_CODE',
		'GEOIP_COUNTRY_CODE',
		'HTTP_CF_IPCOUNTRY',
		'HTTP_X_COUNTRY_CODE',
		'HTTP_CLOUDFRONT_VIEWER_COUNTRY',
	);

	foreach ( $headers as $header ) {

		if ( empty( $_SERVER[ $header ] ) ) {
			continue;
		}

		$country_code = strtolower( sanitize_text_field( wp_unslash( $_SERVER[ $header ] ) ) );
		break;
	}

	return $country_code;
}

/**
 * Get user IP Address using an external service.
 * This can be used as a fallback for users on localhost where
 * paoc_pro_get_ip() will be a local IP and non-geolocatable.
 *
 * @since 2.0.7
 * @return string
 */
function paoc_pro_get_external_ip_address() {

	global $paoc_external_ip_address;

	$ip_address				= paoc_pro_get_ip();
	$external_ip_address	= '0.0.0.0';
	$ip_lookup_apis			= array(
									'ipify'	=> 'http://api.ipify.org/',
									'ident'	=> 'http://ident.me',
								);

	if ( empty( $paoc_external_ip_address ) ) {

		$external_ip_address		= '0.0.0.0';
		$ip_lookup_services			= apply_filters( 'paoc_pro_ip_lookup_apis', $ip_lookup_apis );
		$ip_lookup_services_keys	= array_keys( $ip_lookup_services );

		shuffle( $ip_lookup_services_keys );

		foreach ( $ip_lookup_services_keys as $service_name ) {
			$service_endpoint	= $ip_lookup_services[ $service_name ];
			$response			= wp_safe_remote_get( $service_endpoint, array( 'timeout' => 2 ) );

			if ( ! is_wp_error( $response ) && rest_is_ip_address( $response['body'] ) ) {
				$external_ip_address = apply_filters( 'paoc_pro_ip_lookup_api_response', paoc_pro_clean( $response['body'] ), $service_name, $ip_lookup_apis );
				break;
			}
		}

		$paoc_external_ip_address = $external_ip_address;
	}

	return $external_ip_address;
}

/**
 * Geolocate an IP address.
 *
 * @since 2.0.7
 * @param  string $ip_address   IP Address.
 * @param  bool   $fallback     If true, fallbacks to alternative IP detection (can be slower).
 * @param  bool   $api_fallback If true, uses geolocation APIs if the database file doesn't exist (can be slower).
 * @return array
 */
function paoc_pro_geolocate_ip( $ip_address = '', $fallback = false, $api_fallback = true ) {

	// Filter to allow custom geolocation of the IP address.
	$country_code = apply_filters( 'paoc_pro_geolocate_ip', false, $ip_address, $fallback, $api_fallback );

	if ( false !== $country_code ) {
		return array(
			'country' => $country_code,
		);
	}

	// Get IP Address
	if ( empty( $ip_address ) ) {
		$ip_address = paoc_pro_get_ip();
	}

	/**
	 * First try to get country code from headers
	 * If it is empty then it will get from MaxMind Db Reader
	 */
	$country_code = paoc_pro_get_country_from_header();

	if( empty( $country_code ) && $ip_address ) {
		$country_code = paoc_pro_get_country_code_for_ip( $ip_address );
	}

	// It's possible that we're in a local environment, in which case the geolocation needs to be done from the
	// external address.
	if ( empty( $country_code ) && $fallback ) {

		$external_ip_address = paoc_pro_get_external_ip_address();

		// Only bother with this if the external IP differs.
		if ( '0.0.0.0' !== $external_ip_address && $external_ip_address !== $ip_address ) {
			return paoc_pro_geolocate_ip( $external_ip_address, false, $api_fallback );
		}
	}

	return array(
		'country'		=> $country_code,
		'ip_address'	=> $ip_address,
	);
}

/**
 * Fetches the ISO country code associated with an IP address.
 *
 * @param string $ip_address The IP address to find the country code for.
 * @return string The country code for the IP address, or empty if not found.
 * 
 * @since 2.0.7
 */
function paoc_pro_get_country_code_for_ip( $ip_address ) {

	$country_code = '';

	if ( ! class_exists( 'MaxMind\Db\Reader' ) ) {
		return $country_code;
	}

	$database_path = PAOC_PRO_DIR."/includes/api/geolocation/geolite2/vendor/geoip2/geoip2/maxmind-db/GeoLite2-Country.mmdb";

	if ( ! file_exists( $database_path ) ) {
		return $country_code;
	}

	try {

		$reader	= new MaxMind\Db\Reader( $database_path );
		$data	= $reader->get( $ip_address );

		if ( isset( $data['country']['iso_code'] ) ) {
			$country_code = $data['country']['iso_code'];
		}

		$reader->close();
		
	} catch ( Exception $e ) {
		// $e->getMessage()
	}

	return $country_code;
}