<?php
/**
 * Script Class
 * Handles the script and style functionality of plugin
 *
 * @package Popup Anything on Click Pro
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Paoc_Pro_Script {

	function __construct() {

		// Action to add style at front side
		add_action( 'wp_enqueue_scripts', array( $this, 'paoc_pro_front_style' ), 99 );

		// Action to add script at front side
		add_action( 'wp_enqueue_scripts', array( $this, 'paoc_pro_front_script' ) );

		// Action to add style & script in backend
		add_action( 'admin_enqueue_scripts', array( $this, 'paoc_pro_admin_script_style' ) );
	}

	/**
	 * Function to add style at front side
	 * 
	 * @package Popup Anything on Click Pro
	 * @since 1.0
	 */
	function paoc_pro_front_style() {

		// Use minified libraries if SCRIPT_DEBUG is turned off
		$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '_' : '.min';

		// Registring font awesome css
		if( ! wp_style_is( 'font-awesome', 'registered' ) ) {
			wp_register_style( 'font-awesome', PAOC_PRO_URL.'assets/css/font-awesome.min.css', array(), PAOC_PRO_VERSION );
		}

		// Registring Tooltip Style
		wp_register_style( 'tooltipster', PAOC_PRO_URL.'assets/css/tooltipster.min.css', array(), PAOC_PRO_VERSION );

		// Registring and enqueing public css
		wp_register_style( 'paoc-pro-public-style', PAOC_PRO_URL."assets/css/paoc-public{$suffix}.css", array(), PAOC_PRO_VERSION );

		wp_enqueue_style('tooltipster');				// Tooltip
		wp_enqueue_style( 'font-awesome' );				// Font-Awesome
		wp_enqueue_style( 'paoc-pro-public-style' );	// Public
	}

	/**
	 * Function to add script at front side
	 * 
	 * @package Popup Anything on Click Pro
	 * @since 1.0
	 */
	function paoc_pro_front_script() {

		global $paoc_preview;

		// Taking some variables
		$add_legacy_js = paoc_pro_get_option( 'add_js' );

		// Use minified libraries if SCRIPT_DEBUG is turned off
		$suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '_' : '.min';

		if( ! wp_script_is( 'wpos-custombox-legacy-js', 'registered' ) ) {
			wp_register_script( 'wpos-custombox-legacy-js', PAOC_PRO_URL.'assets/js/custombox.legacy.min.js', array('jquery'), PAOC_PRO_VERSION, false );
		}

		// Enqueue js in header
		if( ! empty( $add_legacy_js ) && $add_legacy_js == 2 ) {
			wp_enqueue_script('wpos-custombox-legacy-js');
		}

		if( ! wp_script_is( 'wpos-custombox-popup-js', 'registered' ) ) {
			wp_register_script( 'wpos-custombox-popup-js', PAOC_PRO_URL.'assets/js/custombox.min.js', array('jquery'), PAOC_PRO_VERSION, true );
		}

		if( ! wp_script_is( 'paoc-ads-prebid', 'registered' ) ) {
			wp_register_script( 'paoc-ads-prebid', PAOC_PRO_URL.'assets/js/ads-prebid.js', array(), PAOC_PRO_VERSION, true );
		}

		// Registring tooltip script
		wp_register_script( 'tooltipster', PAOC_PRO_URL.'assets/js/tooltipster.min.js', array('jquery'), PAOC_PRO_VERSION, true );

		// Public Script
		wp_register_script( 'paoc-public-js', PAOC_PRO_URL."assets/js/paoc-public{$suffix}.js", array('jquery'), PAOC_PRO_VERSION, true );
		wp_localize_script( 'paoc-public-js', 'PaocProPublic', array(
																'paoc_preview'	=> $paoc_preview,
																'cookie_prefix'	=> paoc_pro_get_option( 'cookie_prefix' ),
																'geo_enable'	=> paoc_pro_get_option( 'geo_enable' ),
																'paoc_url'		=> paoc_pro_get_current_page_url(),
																'paoc_mobile'	=> wp_is_mobile() ? 1 : 0,
																'paoc_ajaxurl'	=> admin_url( 'admin-ajax.php', ( is_ssl() ? 'https' : 'http' ) ),
																'paoc_err_msg'	=> esc_html__('Sorry, There is something wrong with analytics.', 'popup-anything-on-click'),
															));
		wp_enqueue_script('wp-date');			// WP-Date
		wp_enqueue_script( 'tooltipster' );		// Tooltip
		wp_enqueue_script('paoc-public-js');	// Public JS
	}

	/**
	 * Function to add Scripts and Styles at admin side
	 * 
	 * @package Popup Anything on Click Pro
	 * @since 1.0
	 */
	function paoc_pro_admin_script_style( $hook ) {

		global $post, $typenow, $post_type, $wp_version, $wp_query;

		$paoc_post_types = paoc_pro_get_option( 'post_types', array() );

		/***** Registering Styles *****/
		// Registring jQuery UI style
		wp_register_style( 'jquery-ui', PAOC_PRO_URL.'assets/css/jquery-ui.min.css', array(), PAOC_PRO_VERSION );

		// Registring Select 2 Style
		wp_register_style( 'select2', PAOC_PRO_URL.'assets/css/select2.min.css', array(), PAOC_PRO_VERSION );

		// Registring Tooltip Style
		wp_register_style( 'tooltipster', PAOC_PRO_URL.'assets/css/tooltipster.min.css', array(), PAOC_PRO_VERSION );

		// Registring admin css
		wp_register_style( 'paoc-admin-style', PAOC_PRO_URL.'assets/css/paoc-admin.css', array(), PAOC_PRO_VERSION );


		/***** Registering Scripts *****/
		// Registring select 2 script
		wp_register_script( 'select2', PAOC_PRO_URL.'assets/js/select2.min.js', array('jquery'), PAOC_PRO_VERSION, true );

		// Registring tooltip script
		wp_register_script( 'tooltipster', PAOC_PRO_URL.'assets/js/tooltipster.min.js', array('jquery'), PAOC_PRO_VERSION, true );

		// Color Picker Alpha
		wp_register_script( 'wp-color-picker-alpha', PAOC_PRO_URL.'assets/js/wp-color-picker-alpha.js', array('wp-color-picker'), PAOC_PRO_VERSION, true );

		// Registring Jquery UI TimerPicker Addon Script
		wp_register_script( 'jquery-ui-timepicker', PAOC_PRO_URL.'assets/js/jquery-ui-timepicker-addon.min.js', array('jquery'), PAOC_PRO_VERSION, true );

		// Registring admin script
		wp_register_script( 'paoc-admin-script', PAOC_PRO_URL.'assets/js/paoc-admin.js', array('jquery'), PAOC_PRO_VERSION, true );
		wp_localize_script( 'paoc-admin-script', 'PaocProAdmin', array(
														'popup_id'					=> isset( $post->ID )	? $post->ID : 0,
														'is_mobile'					=> wp_is_mobile()		? 1 : 0,
														'code_editor'				=> ( version_compare( $wp_version, '4.9' ) >= 0 )				? 1 : 0,
														'syntax_highlighting'		=> ( 'false' === wp_get_current_user()->syntax_highlighting )	? 0 : 1,
														'cofirm_msg'				=> esc_js( __( 'Are you sure you want to do this?', 'popup-anything-on-click' ) ),
														'sorry_msg'					=> esc_js( __( 'Sorry, Something happened wrong.', 'popup-anything-on-click' ) ),
														'one_field_msg'				=> esc_js( __( 'Sorry, Atleast one field should be there.', 'popup-anything-on-click' ) ),
														'select2_input_too_short'	=> esc_js( __( 'Search popup by its name or ID', 'popup-anything-on-click' ) ),
														'select2_remove_all_items'	=> esc_js( __( 'Remove all items', 'popup-anything-on-click' ) ),
														'select2_remove_item'		=> esc_js( __( 'Remove item', 'popup-anything-on-click' ) ),
														'select2_searching'			=> esc_js( __( 'Searching…', 'popup-anything-on-click' ) ),
													));

		// Enqueue Required Script and Style For Post Metabox
		if( in_array( $post_type, $paoc_post_types ) && ($hook == 'post.php' || $hook == 'post-new.php') ) {

			// Style
			wp_enqueue_style('select2');			// Select2
			wp_enqueue_style('paoc-admin-style');	// Admin style

			// Script
			wp_enqueue_script('select2');			// Select2
			wp_enqueue_script('paoc-admin-script');	// Admin script
		}

		// If screen is Post Add / Edit page
		if( $typenow == PAOC_PRO_POST_TYPE && ( $hook == 'post.php' || $hook == 'post-new.php' ) ) {

			/*===== Styles =====*/
			wp_enqueue_style('select2');			// Select2
			wp_enqueue_style( 'wp-color-picker' );	// ColorPicker
			wp_enqueue_style('jquery-ui');			// jQuery UI
			wp_enqueue_style('tooltipster');		// Tooltip

			
			/*===== Scripts =====*/
			wp_enqueue_script('select2');					// Select2
			wp_enqueue_script( 'wp-color-picker' );			// ColorPicker
			wp_enqueue_script( 'wp-color-picker-alpha' );	// ColorPicker Alpha
			wp_enqueue_script( 'jquery-ui-datepicker' );	// Datepicker
			wp_enqueue_script( 'jquery-ui-timepicker' );	// DateTimePicker
			wp_enqueue_script( 'tooltipster' );				// Tooltip
			wp_enqueue_media();								// For media uploader

			// Check WordPress Version then Initialize Code Editor
			if( version_compare( $wp_version, '4.9' ) >= 0 ) {

				// WP CSS Code Editor
				wp_enqueue_code_editor( array(
					'type'			=> 'text/css',
					'codemirror'	=> array(
										'indentUnit'	=> 2,
										'tabSize'		=> 2,
										'lint'			=> false,
									),
				) );
			}
		}

		// Plugin Setting Page & Campaign Page
		if( $hook == PAOC_PRO_POST_TYPE.'_page_paoc-pro-settings' || $hook == PAOC_PRO_POST_TYPE.'_page_paoc-campaign' ) {

			// Style
			wp_enqueue_style('select2');

			// Script
			wp_enqueue_script('select2');
		}

		// Plugin Tools Page
		if( $hook == PAOC_PRO_POST_TYPE.'_page_paoc-tools' ) {

			// Style
			wp_enqueue_style('select2');
			wp_enqueue_style('jquery-ui');

			// Script
			wp_enqueue_script('select2');
			wp_enqueue_script( 'jquery-ui-datepicker' );
		}

		// Plugin Report Page
		if( $hook == PAOC_PRO_POST_TYPE.'_page_paoc-reports' ) {

			// Style
			wp_enqueue_style('jquery-ui'); // jQuery UI

			// Script
			wp_enqueue_script( 'jquery-ui-datepicker' ); // Datepicker
		}

		// Common Script & Style For All Pages
		if( $typenow == PAOC_PRO_POST_TYPE ) {
			wp_enqueue_style('paoc-admin-style');	// Admin style
			wp_enqueue_script('paoc-admin-script');	// Admin script
		}
	}
}

$paoc_pro_script = new Paoc_Pro_Script();