<?php
/**
 * Register Post type functionality
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * Function to register post type
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_register_post_type() {

	$paoc_post_lbls = apply_filters( 'paoc_pro_post_labels', array(
								'name'					=> __( 'Popup Anything Pro', 'popup-anything-on-click' ),
								'singular_name'			=> __( 'Popup Anything Pro', 'popup-anything-on-click' ),
								'add_new'				=> __( 'Add Popup', 'popup-anything-on-click' ),
								'add_new_item'			=> __( 'Add New Popup', 'popup-anything-on-click' ),
								'edit_item'				=> __( 'Edit Popup', 'popup-anything-on-click' ),
								'new_item'				=> __( 'New Popup', 'popup-anything-on-click' ),
								'view_item'				=> __( 'View Popup', 'popup-anything-on-click' ),
								'all_items'				=> __( 'All Popup', 'popup-anything-on-click' ),
								'search_items'			=> __( 'Search Popup', 'popup-anything-on-click' ),
								'not_found'				=> __( 'No Popup found', 'popup-anything-on-click' ),
								'not_found_in_trash'	=> __( 'No Popup found in trash', 'popup-anything-on-click' ),
								'insert_into_item'		=> __( 'Insert into Popup', 'popup-anything-on-click' ),
								'uploaded_to_this_item'	=> __( 'Uploaded to this Popup', 'popup-anything-on-click' ),
								'menu_name'				=> __( 'Popup Anything Pro', 'popup-anything-on-click' )
							));

	$paoc_args = array(
		'labels'			=> $paoc_post_lbls,
		'public'			=> false,
		'show_ui'			=> true,
		'query_var'			=> false,
		'rewrite'			=> false,
		'capability_type'	=> 'post',
		'hierarchical'		=> false,
		'menu_icon'			=> 'dashicons-welcome-comments',
		'supports'			=> apply_filters('paoc_pro_post_supports', array('title')),
	);

	// Register popup post type
	register_post_type( PAOC_PRO_POST_TYPE, apply_filters( 'paoc_pro_registered_post_type_args', $paoc_args ) );
}

// Action to register plugin post type
add_action('init', 'paoc_pro_register_post_type');

/**
 * Function to update post message for popup post type
 * 
 * @package Popup anything on click
 * @since 1.0
 */
function paoc_pro_post_updated_messages( $messages ) {

	global $post, $post_ID;

	$messages[PAOC_PRO_POST_TYPE] = array(
		0 => '', // Unused. Messages start at index 1.
		1 => sprintf( __( 'Popup updated.', 'popup-anything-on-click' ) ),
		2 => __( 'Custom field updated.', 'popup-anything-on-click' ),
		3 => __( 'Custom field deleted.', 'popup-anything-on-click' ),
		4 => __( 'Popup updated.', 'popup-anything-on-click' ),
		5 => isset( $_GET['revision'] ) ? sprintf( __( 'Popup restored to revision from %s', 'popup-anything-on-click' ), wp_post_revision_title( (int) $_GET['revision'], false ) ) : false,
		6 => sprintf( __( 'Popup published.', 'popup-anything-on-click' ) ),
		7 => __( 'Popup saved.', 'popup-anything-on-click' ),
		8 => sprintf( __( 'Popup submitted.', 'popup-anything-on-click' ) ),
		9 => sprintf( __( 'Popup scheduled for: <strong>%1$s</strong>.', 'popup-anything-on-click' ),
		  date_i18n( 'M j, Y @ G:i', strtotime( $post->post_date ) ) ),
		10 => sprintf( __( 'Popup draft updated.', 'popup-anything-on-click' ) ),
	);
	return $messages;
}

// Filter to update popup post message
add_filter( 'post_updated_messages', 'paoc_pro_post_updated_messages' );