<?php
/**
 * Template Functions
 *
 * @package Popup Anything on Click Pro
 * @version 1.2.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

/**
 * Returns the path to the plugin templates directory
 *
 * @package Popup Anything on Click Pro
 * @version 1.2.2
 */
function paoc_pro_get_templates_dir() {
	return apply_filters( 'paoc_pro_template_dir', PAOC_PRO_DIR . '/templates' );
}

/**
 * Locate a template and return the path for inclusion.
 *
 * This is the load order:
 *
 *	yourtheme/$template_path/$template_name
 *	yourtheme/$template_name
 *	$default_path/$template_name
 * 
 * @package Popup Anything on Click Pro
 * @version 1.2.2
 * 
 */
function paoc_pro_locate_template( $template_name, $template_path = '', $default_path = '', $default_template = '' ) {

	if ( ! $template_path ) {
		$template_path = trailingslashit( 'popup-anything-on-click-pro' );
	}

	if ( ! $default_path ) {
		$default_path = trailingslashit( paoc_pro_get_templates_dir() );
	}

	// Look within passed path within the theme - this is priority.
	$template_lookup = array(
							trailingslashit( $template_path ) . $template_name,
						);

	// Adding default path to check
	if( ! empty( $default_template ) ) {
		$template_lookup[] = trailingslashit( $template_path ) . $default_template;
	}

	// Look within passed path within the theme - this is priority
	$template = locate_template( $template_lookup );

	// Look within plugin template folder
	if ( ! $template || WPOS_TEMPLATE_DEBUG_MODE ) {
		$template = $default_path . $template_name;
	}

	// If template does not exist then load passed $default_template
	if ( ! empty( $default_path ) && ! file_exists( $template ) ) {
		$template = $default_path . $default_template;
	}

	// Return what we found
	return apply_filters( 'paoc_pro_locate_template', $template, $template_name, $template_path, $default_path, $default_template );
}

/**
 * Get other templates (e.g. attributes) passing attributes and including the file.
 *
 * @package Popup Anything on Click Pro
 * @version 1.2.2
 */
function paoc_pro_get_template( $template, $args = array(), $template_path = '', $default_path = '', $default_template = '' ) {

	$located = paoc_pro_locate_template( $template, $template_path, $default_path, $default_template );

	if ( ! file_exists( $located ) ) {
		return;
	}

	if ( $args && is_array( $args ) ) {
		extract( $args );
	}

	do_action( 'paoc_pro_before_template_part', $args, $located, $template, $template_path, $default_path, $default_template );

	include( $located );

	do_action( 'paoc_pro_after_template_part', $args, $located, $template, $template_path, $default_path, $default_template );
}

/**
 * Like paoc_pro_get_template, but returns the HTML instead of outputting.
 * 
 * @package Popup Anything on Click Pro
 * @version 1.2.2
 */
function paoc_pro_get_template_html( $template_name, $args = array(), $template_path = '', $default_path = '', $default_template = '' ) {
	ob_start();
	paoc_pro_get_template( $template_name, $args, $template_path, $default_path, $default_template );
	return ob_get_clean();
}

/**
 * Render Push Notification and Slide In Popup Trigger Icon HTML
 * 
 * @package Popup Anything on Click Pro
 * @version 2.0
 */
function paoc_pro_render_popup_triggers( $template_args ) {

	// Push Notification Icon
	if ( $template_args['display_type'] == 'push-notification' && $template_args['type'] != 'inline' ) {
		paoc_pro_get_template( "push-notification/{$template_args['popup_goal']}/push-notification.php", $template_args, '', '', "push-notification.php" );
	}
	
	// Slide-In Popup Icon
	if( $template_args['display_type'] == 'slide-in' && $template_args['type'] != 'inline' ) {
		paoc_pro_get_template( "slide-in/{$template_args['popup_goal']}/slide-in.php", $template_args, '', '', "slide-in.php" );
	}
}
add_action( 'paoc_pro_after_popup_render', 'paoc_pro_render_popup_triggers' );