<?php
/**
 * Popup Preview Screen
 *
 * Handles the popup preview functionality of plugin
 *
 * @package Popup Anything on Click Pro
 * @since 2.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

$popup_preview_link			= add_query_arg( array('paoc_popup_preview' => 1), site_url('index.php') );
$popup_default_preview_link = add_query_arg( array('paoc_default_popup_preview' => 1), $popup_preview_link );
?>
<div class="paoc-popup-modal paoc-popup-modal-preview paoc-fullscreen-popup-modal paoc-cnt-wrap">
	<div class="paoc-popup-modal-act-btn-wrp">
		<span class="paoc-popup-modal-act-btn paoc-popup-modal-preview-toggle paoc-tooltip" title="<?php esc_attr_e('Popup Default Preview with Dummy Content', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-welcome-view-site"></i></span>
		<span class="paoc-popup-modal-act-btn paoc-popup-modal-info paoc-tooltip" title="<?php echo esc_attr__("Note: Preview will be displayed according to responsive layout mode. Live preview may display differently when added to your page based on inheritance from some styles.", 'popup-anything-on-click') ."<br/><br/>". esc_html__("Some setting options will not work here like 'When Popup Appear?', 'Cookie Expiry Time', 'Advance Settings' and etc for better user experience and preview restriction.", 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-info"></i></span>
		<span class="paoc-popup-modal-act-btn paoc-popup-modal-close paoc-popup-close paoc-tooltip" title="<?php esc_attr_e('Close', 'popup-anything-on-click'); ?>"><i class="dashicons dashicons-no-alt"></i></span>
	</div>
	<div class="paoc-popup-modal-title-wrp">
		<span class="paoc-popup-modal-title"><?php esc_html_e('Popup Anything On Click Pro - Preview', 'popup-anything-on-click'); ?></span>
	</div>
	<div class="paoc-popup-modal-cnt">
		<iframe src="about:blank" data-src="<?php echo esc_url( $popup_preview_link ); ?>" data-default-preview-src="<?php echo esc_url( $popup_default_preview_link ); ?>" class="paoc-preview-frame" name="paoc_preview_frame" scrolling="auto" frameborder="0"></iframe>
		<div class="paoc-popup-modal-loader"></div>
	</div>
</div>
<div class="paoc-popup-modal-overlay"></div>