<?php
/**
 * 'popup_anything' Shortcode
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

function paoc_pro_popup_shortcode( $atts, $shrt_content = null ) {

	global $paoc_popup_data, $paoc_popup_post, $paoc_adblocker, $paoc_advance_sett;

	// Shortcode Parameter
	$atts = shortcode_atts(array(
		'id'					=> 0,
		'type'					=> 'popup',
		'analytics_action'		=> '',
		'analytics_category'	=> '',
		'analytics_label'		=> '',
		'display'				=> '',
	), $atts, 'popup_anything');

	$atts['type']				= ( $atts['type'] == 'inline' ) 		? 'inline'										: 'popup';
	$atts['id']					= isset( $atts['id'] )					? paoc_pro_clean_number( $atts['id'] )			: false;
	$atts['display']			= isset( $atts['display'] )				? paoc_pro_clean( $atts['display'] )			: '';
	$atts['analytics_action']	= isset( $atts['analytics_action'] )	? paoc_pro_clean( $atts['analytics_action'] )	: '';
	$atts['analytics_category']	= isset( $atts['analytics_category'] )	? paoc_pro_clean( $atts['analytics_category'] )	: '';
	$atts['analytics_label']	= isset( $atts['analytics_label'] )		? paoc_pro_clean( $atts['analytics_label'] )	: '';

	extract( $atts );

	// Taking some variable
	$prefix		= PAOC_PRO_META_PREFIX;
	$enable		= paoc_pro_get_option( 'enable' );

	// Return if popup is disabled from plugin settings or id is not there
	if( ! $enable || empty( $id ) ) {
		return false;
	}

	// Query args
	$args = array(
			'post_type'			=> PAOC_PRO_POST_TYPE,
			'post__in'			=> array( $id ),
			'post_status'		=> array( 'publish' ),
			'posts_per_page'	=> 1,
			'no_found_rows'		=> true,
		);

	// WP Query for Popup
	$popup_query = get_posts( $args );

	// If no query post found
	if ( ! $popup_query ) {
		return false;
	}

	// Taking advance tab data
	$current_time		= current_time( 'timestamp' );
	$add_legacy_js		= paoc_pro_get_option( 'add_js' );
	$advance			= get_post_meta( $id, $prefix.'advance', true );
	$show_for			= isset( $advance['show_for'] )		? $advance['show_for']	: '';
	$allowed_roles		= ! empty( $advance['role'] )		? $advance['role']		: array();
	$current_user_role	= ! empty( $current_user->roles ) 	? $current_user->roles	: array();

	// Checking `Show for` & `Schedule` popup
	if( ( $show_for == 'guest' && is_user_logged_in() )		// Check guest user
		|| ( $show_for == 'member' && ( ! is_user_logged_in() || ($allowed_roles && ! array_intersect( $current_user_role, $allowed_roles )) ) ) )	// Check current user with show for member
	{
		return false;
	}

	// Enqueue required script
	wp_enqueue_script('jquery');

	if( empty( $add_legacy_js ) ) {
		wp_enqueue_script('wpos-custombox-legacy-js');
	}

	wp_enqueue_script('wpos-custombox-popup-js');	// Custombox JS
	wp_enqueue_script('paoc-public-js');			// Public JS
	paoc_pro_enqueue_script();

	// Assigning Global Variables
	$paoc_popup_data	= ( ! empty( $paoc_popup_data ) && is_array( $paoc_popup_data ) ) ? $paoc_popup_data : array();
	$paoc_popup_post	= $popup_query[0];
	$paoc_advance_sett	= $advance;

	ob_start();

	// Taking some variable
	$atts['popup_classes']	= '';
	$atts['unique']			= paoc_pro_get_unique();
	$atts['popup_appear']	= get_post_meta( $id, $prefix.'popup_appear', true );
	
	$geo_enable				= paoc_pro_get_option( 'geo_enable' );
	$behaviour				= paoc_pro_get_meta( $id, $prefix.'behaviour' );
	$referrer_mode			= isset( $advance['referrer_mode'] )		? $advance['referrer_mode'] : '';
	$utm_mode				= isset( $advance['utm_mode'] )				? $advance['utm_mode']		: '';
	$referrer_url			= isset( $advance['referrer_url'] )			? $advance['referrer_url'] 	: '';
	$utm_params				= isset( $advance['utm_params'] )			? $advance['utm_params'] 	: '';
	$cookie_params			= isset( $advance['cookie_params'] )		? $advance['cookie_params'] : '';
	$geo_countries			= ! empty( $advance['geo_countries'] )		? $advance['geo_countries'] : array();
	$paoc_adblocker			= ( ! empty( $advance['adblocker'] ) && empty( $paoc_adblocker ) ) ? $advance['adblocker'] : $paoc_adblocker;
	$adblocker				= ! empty( $advance['adblocker'] )			? $advance['adblocker']		: 0;
	$referrer_enable		= ! empty( $advance['referrer_enable'] )	? 1	: 0;
	$utm_enable				= ! empty( $advance['utm_enable'] )			? 1	: 0;
	$cookie_enable			= ! empty( $advance['cookie_enable'] )		? 1	: 0;

	// If `Display` is 'force'
	if( $display == 'force' ) {
		$atts['popup_classes'] .= " paoc-popup-has-force";
	} else {
		$atts['popup_classes'] .= " paoc-action-popup";
	}

	// If geolocation enable, geolocation country are there
	if( ! empty( $geo_enable ) && $geo_countries ) {
		$atts['popup_classes'] .= " paoc-popup-has-geolocation";
	}

	// If Adblocker is there
	if( $paoc_adblocker ) {
		$atts['popup_classes'] .= " paoc-popup-adblocker";
	}

	// If `Referer Popup` is there
	if( $referrer_enable && ! empty( $referrer_url ) ) {

		$referrer_url_arr = explode( "\n", $referrer_url );

		foreach ($referrer_url_arr as $referrer_url_key => $referrer_url_val) {
			
			$referrer_url_data	= explode('/', $referrer_url_val);
			$referrer_url_data	= array_map( 'urlencode', $referrer_url_data );
			$referrer_url_val	= implode('/', $referrer_url_data);

			$data_domain[ $referrer_url_key ] = strtolower( $referrer_url_val );
		}

		$atts['popup_classes'] .= " paoc-popup-has-referrer";
	}

	// If `UTM Popup` is there
	if( $utm_enable && ! empty( $utm_params ) ) {

		$utm_param_arr = explode( "\n", $utm_params );

		if( ! empty( $utm_param_arr ) ) {
			foreach ($utm_param_arr as $utm_param_key => $utm_param_val) {

				$utm_par = explode( '|', $utm_param_val );
				$utm_key = trim( $utm_par[0] );
				$utm_val = esc_attr( trim( $utm_par[1] ) );

				$data_utm[$utm_key][] = $utm_val;
			}
		}

		$atts['popup_classes'] .= " paoc-popup-has-utm";
	}

	/* If `Cookie Popup` is there */
	if( $cookie_enable && ! empty( $cookie_params ) ) {

		$cookie_param_arr = explode( "\n", $cookie_params );

		if( ! empty( $cookie_param_arr ) ) {
			foreach ($cookie_param_arr as $cookie_param_key => $cookie_param_val) {

				$cookie_par	= explode( '|', $cookie_param_val );
				$cookie_key	= trim( $cookie_par[0] );
				$cookie_val	= esc_attr( trim( $cookie_par[1] ) );

				$data_cookie[$cookie_key][] = $cookie_val;
			}
		}

		$atts['popup_classes'] .= " paoc-popup-has-cookie";
	}

	// If `Popup Appear` is `Simple Link`
	if( $atts['popup_appear'] == 'simple_link' ) {
		$atts['link_text'] = isset( $behaviour['link_text'] ) ? $behaviour['link_text'] : __('Click Me!!!', 'popup-anything-on-click');
	}

	// If `Popup Appear` is `Image Click`
	if( $atts['popup_appear'] == 'image' ) {

		$atts['image_url']			= isset( $behaviour['image_url'] )			? $behaviour['image_url']		: '';
		$atts['popup_img_id']		= isset( $behaviour['popup_img_id'] )		? $behaviour['popup_img_id']	: 0;
		$atts['show_img_title']		= ! empty( $behaviour['image_title'] )		? 1 : 0;
		$atts['show_img_caption']	= ! empty( $behaviour['image_caption'] )	? 1 : 0;
		$atts['image_title']		= '';
		$atts['image_caption']		= '';
		$atts['image_alt']			= '';

		// Get Image `Title` & `Caption`
		if( ! empty( $atts['popup_img_id'] ) ) {
			$image_data				= get_post( $atts['popup_img_id'] );
			$atts['image_title']	= $image_data->post_title;
			$atts['image_caption']	= $image_data->post_excerpt;
			$atts['image_alt']		= get_post_meta( $atts['popup_img_id'], '_wp_attachment_image_alt', true );
		}
	}

	// If `Popup Appear` is `Button Click`
	if( $atts['popup_appear'] == 'button' ) {

		$atts['btn_text']		= isset( $behaviour['btn_text'] )	? $behaviour['btn_text']	: __('Click Here!!!', 'popup-anything-on-click');
		$atts['button_class']	= isset( $behaviour['btn_class'] )	? $behaviour['btn_class']	: '';
	}

	// If Inline Popup is there
	if( $type == 'inline' ) {

		// Taking some data
		$behaviour		= paoc_pro_get_meta( $id, $prefix.'behaviour' );
		$popup_goal		= paoc_pro_get_meta( $id, $prefix.'popup_goal' );
		$display_type	= paoc_pro_get_meta( $id, $prefix.'display_type' );
		$design			= paoc_pro_get_meta( $id, $prefix.'design' );
		$social			= paoc_pro_get_meta( $id, $prefix.'social' );
		$content		= paoc_pro_get_meta( $id, $prefix.'content' );
		$analytics		= paoc_pro_get_meta( $id, $prefix.'analytics' );

		// Google Analytics Tab Data
		$analytics_enable	= ! empty( $analytics['enable'] )	? 1	: 0;
		$analytics_action	= ( $atts['analytics_action'] == '' && ! empty( $analytics['action'] ) )		? $analytics['action']		: $atts['analytics_action'];
		$analytics_category	= ( $atts['analytics_category'] == '' && ! empty( $analytics['category'] ) )	? $analytics['category']	: $atts['analytics_category'];
		$analytics_label	= ( $atts['analytics_label'] == '' && ! empty( $analytics['label'] ) )			? $analytics['label']		: $atts['analytics_label'];

		// Taking design data
		$atts['template']	= isset( $design['template'] )				? $design['template']	: 'design-1';
		$popup_img			= isset( $design['popup_img'] )				? $design['popup_img']	: '';
		$fullscreen_popup	= ! empty( $design['fullscreen_popup'] )	? true	: false;

		// Taking some variable
		$atts['popup_id']		= $id;
		$atts['display_type']	= $display_type;
		$atts['popup_goal']		= $popup_goal;
		$atts['hide_close']		= true;
		$atts['style']			= paoc_pro_generate_popup_style( $id );

		// Taking content data
		$atts['cust_close_txt']	= '';
		$atts['main_heading']	= isset( $content['main_heading'] )		? $content['main_heading']	: '';
		$atts['sub_heading']	= isset( $content['sub_heading'] )		? $content['sub_heading']	: '';
		$atts['security_note']	= isset( $content['security_note'] )	? $content['security_note']	: '';

		/* Social tab data */
		$atts['social_type'] = isset( $social['social_type'] )		? $social['social_type'] : '';
		$atts['social_data'] = isset( $social['social_traffic'] )	? paoc_pro_get_social_data( $social['social_traffic'] ) : '';

		// Advance Tab Data
		$atts['show_credit']	= ! empty( $advance['show_credit'] )	? 1 : 0;
		$atts['credit_link']	= add_query_arg( array('utm_source' => site_url(), 'utm_medium' => 'popup', 'utm_campaign' => 'credit-link'), PAOC_PRO_LINK );

		// Taking schedule data
		$recurring_data		= paoc_pro_recurring_dates( $atts['popup_id'] );
		$popup_start_date	= ! empty( $advance['start_time'] )		? $advance['start_time']		: '';
		$popup_end_date		= ! empty( $advance['end_time'] )		? $advance['end_time']			: '';
		$schedule_mode		= ! empty( $advance['schedule_mode'] )	? $advance['schedule_mode']		: 'default';
		$recurring_type		= ! empty( $advance['recurring_type'] )	? $advance['recurring_type']	: 'daily';

		// Add schedule class
		if( $popup_start_date || $popup_end_date || $schedule_mode == 'recurring' ) {
			$atts['popup_classes'] .= ' paoc-popup-has-schedule';
		}

		/* Popup Type : Bar */
		if( $display_type == 'bar' ) {
			$atts['template'] = ! empty( $design['bar_template'] ) ? $design['bar_template'] : $atts['template'];
		}

		/* Popup Goal : Collect Lead */
		if( $popup_goal == 'email-lists' ) {
			$atts['form_fields']	= isset( $content['form_fields'] )		? $content['form_fields']		: '';
			$atts['submit_btn_txt']	= isset( $content['submit_btn_txt'] )	? $content['submit_btn_txt']	: '';
		}

		/* Popup Goal : Target URL */
		if( $popup_goal == 'target-url' ) {
			$atts['btn1_text']		= isset( $content['target_url']['btn1_text'] )		? $content['target_url']['btn1_text']	: '';
			$atts['btn1_link']		= isset( $content['target_url']['btn1_link'] )		? $content['target_url']['btn1_link']	: '';
			$atts['btn1_target']	= isset( $content['target_url']['btn1_target'] )	? $content['target_url']['btn1_target']	: '';

			$atts['btn2_text']		= isset( $content['target_url']['btn2_text'] )		? $content['target_url']['btn2_text']	: '';
			$atts['btn2_link']		= isset( $content['target_url']['btn2_link'] )		? $content['target_url']['btn2_link']	: '';
			$atts['btn2_target']	= isset( $content['target_url']['btn2_target'] )	? $content['target_url']['btn2_target']	: '';

			$atts['btn1_click']		= 'onclick="window.open(\''.$atts['btn1_link'].'\', \''.$atts['btn1_target'].'\');"';
			
			if( $atts['btn2_link'] ) {
				$atts['btn2_click']	= 'onclick="window.open(\''.$atts['btn2_link'].'\', \''.$atts['btn2_target'].'\');"';
			} else {
				$atts['btn2_click']	= 'onclick="jQuery.magnificPopup.close();"';
			}
		}

		/* Popup Goal : Phone Call */
		if( $popup_goal == 'phone-calls' ) {
			$atts['btn_txt']	= isset( $content['phone_calls']['btn_txt'] )	? $content['phone_calls']['btn_txt']	: '';
			$atts['phone_num']	= isset( $content['phone_calls']['phone_num'] )	? $content['phone_calls']['phone_num']	: '';
		}

		// Set Popup Classes
		$atts['popup_classes'] .= " paoc-popup-{$atts['popup_id']} paoc-inline-popup-{$atts['popup_id']} paoc-popup-{$popup_goal} paoc-{$atts['template']} paoc-modal-{$atts['template']} paoc-inline-popup";

		// If full screen popup is there
		if( $fullscreen_popup ) {
			$atts['popup_classes'] .= " paoc-popup-fullscreen";
		}

		$atts['popup_classes'] .= ( $popup_img ) ? " paoc-has-image" : " paoc-no-image";

		// Creating Popup Configuration
		$data_conf = array(
						'id'				=> $id,
						'popup_type'		=> $type,
						'geo_countries'		=> $geo_countries,
						'adblocker'			=> $adblocker,
						'display'			=> $display,
						'popup_start_date'	=> $popup_start_date,
						'popup_end_date'	=> $popup_end_date,
						'schedule_mode'		=> $schedule_mode,
						'recurring_data'	=> $recurring_data,
						'utm_params'		=> isset( $data_utm )		? $data_utm		: array(),
						'cookie_params'		=> isset( $data_cookie )	? $data_cookie	: array(),
						'referrer_url'		=> isset( $data_domain )	? $data_domain	: array(),
					);
		$data_conf	= htmlspecialchars( json_encode( $data_conf ) );

		// Set Data Attribute
		$atts['popup_attr'] = "data-conf='{$data_conf}'";

		// Google Analytics is there
		if( $analytics_enable && $analytics_action && $analytics_category && $analytics_label ) {
			$atts['popup_attr'] .= " data-label='".esc_attr( $analytics_label )."' data-event='".esc_attr( $analytics_category )."' data-event-action='".esc_attr( $analytics_action )."'";
		}

		// Math Captcha
		$captcha_digit1	= mt_rand(1, 10);
		$captcha_digit2	= mt_rand(1, 89);

		if( mt_rand(0,1) === 1 ) {
			$atts['paoc_captcha']	= "$captcha_digit1 + $captcha_digit2";
			$captcha_sum 			= $captcha_digit1 + $captcha_digit2;
		} else {
			$atts['paoc_captcha']	= "$captcha_digit2 - $captcha_digit1";
			$captcha_sum 			= $captcha_digit2 - $captcha_digit1;
		}

		$captcha_token			= wp_salt( 'auth' );
		$atts['captcha_val']	= sha1( $captcha_token . $captcha_sum ); // Hashing algorithm

		// Print Inline Style
		echo "<style type='text/css'>{$atts['style']['inline']}</style>";

		// If Popup Preview is there
		$popup_content				= $popup_query[0]->post_content;
		$secondary_content			= isset( $content['secondary_content'] ) ? $content['secondary_content'] : '';
		$atts['popup_content']		= paoc_pro_render_popup_content( $popup_content );
		$atts['secondary_content']	= paoc_pro_render_popup_content( $secondary_content );

		do_action( 'paoc_pro_before_popup_render', $atts );

		// Design File
		paoc_pro_get_template( "{$display_type}/{$popup_goal}/{$atts['template']}.php", $atts, '', '', "designs/{$atts['template']}.php" );

		do_action( 'paoc_pro_after_popup_render', $atts );

	} else {

		// paoc-pro-popup-cust is taken first so in JS loop it will be detected on as early as possible
		$atts['popup_classes'] = "paoc-pro-popup-cust-{$id} paoc-popup-click paoc-popup-{$atts['popup_appear']} {$atts['popup_classes']}";

		// Assigning global var for popup type only
		$paoc_popup_data[ $id ]['popup_id']		= $id;
		$paoc_popup_data[ $id ]['popup_type']	= $type;

		// Design File
		paoc_pro_get_template( "content.php", $atts );
	}

	// Flush some global var
	$paoc_popup_post = '';

	$shrt_content .= ob_get_clean();
	return $shrt_content;
}

// Popup Shortcode
add_shortcode( 'popup_anything', 'paoc_pro_popup_shortcode' );