<?php
/**
 * Plugin Name: Popup Anything Pro - A Marketing Popup
 * Plugin URI: https://www.essentialplugin.com/wordpress-plugin/popup-anything-click/
 * Text Domain: popup-anything-on-click
 * Description: Display a modal popup on Page Load, After X Second of Inactivity, When Page Scroll Down, When Page Scroll UP, Exit Intent, Simple Link, Image Click, Button Click, HTML Element Click and more.
 * Domain Path: /languages/
 * Version: 2.3
 * Author: Essential Plugin
 * Author URI: https://www.essentialplugin.com/
 * Contributors: WP OnlineSupport, Essential Plugin
 *
 * @package Popup Anything Pro - A Marketing Popup
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $wpdb;

if( ! defined( 'PAOC_PRO_VERSION' ) ) {
	define( 'PAOC_PRO_VERSION', '2.3' ); // Version of plugin
}

if( ! defined( 'PAOC_PRO_DIR' ) ) {
	define( 'PAOC_PRO_DIR', dirname( __FILE__ ) ); // Plugin dir
}

if( ! defined( 'PAOC_PRO_URL' ) ) {
	define( 'PAOC_PRO_URL', plugin_dir_url( __FILE__ )); // Plugin url
}

if( ! defined( 'PAOC_PRO_PLUGIN_BASENAME' ) ) {
	define( 'PAOC_PRO_PLUGIN_BASENAME', plugin_basename( __FILE__ ) ); // plugin base name
}

if( ! defined( 'PAOC_PRO_POST_TYPE' ) ) {
	define('PAOC_PRO_POST_TYPE', 'aoc_popup'); // Plugin post type
}

if( ! defined( 'PAOC_PRO_META_PREFIX' ) ) {
	define('PAOC_PRO_META_PREFIX', '_aoc_'); // Plugin metabox prefix
}

if( ! defined( 'PAOC_PRO_ENTRY_TBL' ) ) {
	define('PAOC_PRO_ENTRY_TBL', $wpdb->prefix.'paoc_entry'); // Form Entry Table
}

if( ! defined( 'PAOC_PRO_ENTRY_META_TBL' ) ) {
	define('PAOC_PRO_ENTRY_META_TBL', $wpdb->prefix.'paoc_entry_meta'); // Form Entry Meta Table
}

if( ! defined( 'PAOC_PRO_REPORT_TBL' ) ) {
	define('PAOC_PRO_REPORT_TBL', $wpdb->prefix.'paoc_report'); // Popup Report Table
}

if( ! defined( 'PAOC_PRO_CAMPAIGN_TBL' ) ) {
	define('PAOC_PRO_CAMPAIGN_TBL', $wpdb->prefix.'paoc_campaign'); // Popup Campaign Table
}

if( ! defined( 'PAOC_PRO_ADD_CAMPAIGN_LINK' ) ) {
	define('PAOC_PRO_ADD_CAMPAIGN_LINK', add_query_arg( array('post_type' => PAOC_PRO_POST_TYPE, 'page' => 'paoc-campaign', 'action' => 'add'), admin_url('edit.php') ) ); // Add A/B Testing Link
}

if( ! defined( 'PAOC_PRO_LINK' ) ) {
	define('PAOC_PRO_LINK', "https://www.essentialplugin.com/wordpress-plugin/popup-anything-click/" ); // Plugin Pro Link
}

if( ! defined( 'WPOS_TEMPLATE_DEBUG_MODE' ) ) {
	define('WPOS_TEMPLATE_DEBUG_MODE', false); // Template debug mode
}

if( ! defined( 'WPOS_HIDE_LICENSE' ) ) {
	define( 'WPOS_HIDE_LICENSE', 'info' ); // Hide License
}

/**
 * Activation Hook
 * 
 * Register plugin activation hook.
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
register_activation_hook( __FILE__, 'paoc_pro_install' );

/**
 * Deactivation Hook
 * 
 * Register plugin deactivation hook.
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
register_deactivation_hook( __FILE__, 'paoc_pro_uninstall');

/**
 * Plugin Activation Function
 * Does the initial setup, sets the default values for the plugin options
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_install() {

	// Get settings for the plugin
	$paoc_pro_options = get_option( 'paoc_pro_options' );

	if( empty( $paoc_pro_options ) ) { // Check plugin version option

		// Set default settings
		paoc_pro_default_settings();

		// Update plugin version to option
		update_option( 'paoc_pro_plugin_version', '1.3' );
	}

	// Register post type function
	paoc_pro_register_post_type();

	// Create Table
	paoc_pro_create_tables();

	// IMP need to flush rules for custom registered post type
	flush_rewrite_rules( false );

	if( is_plugin_active('popup-anything-on-click/popup-anything-on-click.php') ) {
		add_action('update_option_active_plugins', 'paoc_pro_deactivate_free_version');
	}
}

/**
 * Plugin Functinality (On Deactivation)
 * 
 * Delete  plugin options.
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_uninstall() {
}

/**
 * Deactivate free plugin
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0.0
 */
function paoc_pro_deactivate_free_version() {
	deactivate_plugins('popup-anything-on-click/popup-anything-on-click.php', true);
}

/**
 * Function to display admin notice of activated plugin.
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_admin_notice() {

	global $pagenow;

	// If not plugin screen
	if( 'plugins.php' != $pagenow ) {
		return;
	}

	// Check Lite Version
	$dir = WP_PLUGIN_DIR . '/popup-anything-on-click/popup-anything-on-click.php';

	if( ! file_exists( $dir ) ) {
		return;
	}

	$notice_link		= add_query_arg( array('message' => 'paoc-pro-plugin-notice'), admin_url('plugins.php') );
	$notice_transient	= get_transient( 'paoc_pro_install_notice' );

	// If PRO plugin is active and free plugin exist
	if( $notice_transient == false && current_user_can( 'install_plugins' ) ) {
		echo '<div class="updated notice" style="position:relative;">
				<p>
					<strong>'.esc_html__('Thank you for activating Popup Anything Pro - A Marketing Popup', 'popup-anything-on-click').'</strong>.<br/>
					'.esc_html__('It looks like you had FREE version Popup Anything - A Marketing Popup of this plugin activated. To avoid conflicts the extra version has been deactivated and we recommend you delete it.', 'popup-anything-on-click').'
				</p>
				<a href="'.esc_url( $notice_link ).'" class="notice-dismiss" style="text-decoration:none;"></a>
			</div>';
	}
}
add_action( 'admin_notices', 'paoc_pro_admin_notice');

/**
 * Load Text Domain
 * This gets the plugin ready for translation
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_load_textdomain() {

	global $wp_version;

	// Set filter for plugin's languages directory
	$popupaoc_lang_dir = dirname( plugin_basename( __FILE__ ) ) . '/languages/';
	$popupaoc_lang_dir = apply_filters( 'paoc_pro_languages_directory', $popupaoc_lang_dir );

	// Traditional WordPress plugin locale filter.
	$get_locale = get_locale();

	if ( $wp_version >= 4.7 ) {
		$get_locale = get_user_locale();
	}

	// Traditional WordPress plugin locale filter
	$locale = apply_filters( 'plugin_locale',  $get_locale, 'popup-anything-on-click' );
	$mofile = sprintf( '%1$s-%2$s.mo', 'popup-anything-on-click', $locale );

	// Setup paths to current locale file
	$mofile_global  = WP_LANG_DIR . '/plugins/' . basename( PAOC_PRO_DIR ) . '/' . $mofile;

	if ( file_exists( $mofile_global ) ) { // Look in global /wp-content/languages/plugin-name folder
		load_textdomain( 'popup-anything-on-click', $mofile_global );
	} else { // Load the default language files
		load_plugin_textdomain( 'popup-anything-on-click', false, $popupaoc_lang_dir );
	}
}

/**
 * Run functionality once all the plugin is loaded.
 *
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_plugins_loaded() {

	// Load Plugin Translation
	paoc_pro_load_textdomain();

	// Database Upgrade File for post data migration
	$plugin_version = get_option( 'paoc_pro_plugin_version' );
	
	if ( current_user_can( 'manage_options' ) && version_compare( $plugin_version, '1.3' ) < 0 ) {
		require_once( PAOC_PRO_DIR . '/includes/admin/paoc-db-upgrade.php' );
	}
}
add_action( 'plugins_loaded', 'paoc_pro_plugins_loaded' );

/***** Updater Code Starts *****/
define( 'PAOC_PRO_STORE_URL', 'https://www.wponlinesupport.com' );
define( 'PAOC_PRO_ITEM_NAME', 'Popup Anything on Click Pro' );

// Plugin Updator Class
if( ! class_exists( 'EDD_SL_Plugin_Updater' ) ) {
	include( dirname( __FILE__ ) . '/EDD_SL_Plugin_Updater.php' );
}

/**
 * Updater Function
 * 
 * @package Popup Anything on Click Pro
 * @since 1.0
 */
function paoc_pro_plugin_updater() {

	if ( ! current_user_can( 'manage_options' ) && ! ( defined( 'DOING_CRON' ) && DOING_CRON ) ) {
		return;
	}

	$license_key = trim( get_option( 'edd_popupaoc_license_key' ) );

	$edd_updater = new EDD_SL_Plugin_Updater( PAOC_PRO_STORE_URL, __FILE__, array(
			'version' 	=> PAOC_PRO_VERSION,		// current version number
			'license' 	=> $license_key,			// license key (used get_option above to retrieve from DB)
			'item_name' => PAOC_PRO_ITEM_NAME,		// name of this plugin
			'author' 	=> 'WP OnlineSupport'		// author of this plugin
		));
}

add_action( 'admin_init', 'paoc_pro_plugin_updater', 0 );
/***** Updater Code Ends *****/

// Taking some global variable
global $paoc_pro_options;

// Funcions File
require_once( PAOC_PRO_DIR .'/includes/paoc-functions.php' );
$paoc_pro_options = paoc_pro_get_settings();

// Template Function file
require_once( PAOC_PRO_DIR . '/includes/paoc-template-functions.php' );

// Campaign Function File
require_once ( PAOC_PRO_DIR . '/includes/ab-testing/campaign-functions.php' );

// Post Type File
require_once( PAOC_PRO_DIR . '/includes/paoc-post-types.php' );

// Script Class File
require_once( PAOC_PRO_DIR . '/includes/class-paoc-script.php' );

// Email Class File
require_once( PAOC_PRO_DIR . '/includes/class-paoc-email.php' );

// Public Class File
require_once( PAOC_PRO_DIR . '/includes/class-paoc-public.php' );

// Popup Shortcode file
require_once( PAOC_PRO_DIR . '/includes/shortcode/popup-shortcode.php' );

// Popup Details Shortcode file
require_once( PAOC_PRO_DIR . '/includes/shortcode/paoc-details-shrt.php' );

// MailChimp API Class file
require_once( PAOC_PRO_DIR . '/includes/api/class-paoc-mailchimp.php' );

// Geolocation Function file
require_once( PAOC_PRO_DIR . '/includes/api/geolocation/geolocation-functions.php' );

// Autoload file
require_once( PAOC_PRO_DIR . '/includes/api/geolocation/geolite2/index.php' );

// Load Admin Files
if ( is_admin() || ( defined( 'WP_CLI' ) && WP_CLI ) ) {

	// Plugin Settings
	require_once( PAOC_PRO_DIR . '/includes/admin/settings/register-settings.php' );

	// Form Entries Functions
	require_once ( PAOC_PRO_DIR . '/includes/admin/form/form-entries-functions.php' );

	// Form Entries Export Function File
	require_once( PAOC_PRO_DIR . '/includes/admin/tools/export-functions.php' );

	// Admin Class File
	require_once( PAOC_PRO_DIR . '/includes/admin/class-paoc-admin.php' );

	// Campaign Admin Class File
	require_once( PAOC_PRO_DIR . '/includes/ab-testing/class-campaign-admin.php' );

	// Admin Popup Content Class File
	require_once( PAOC_PRO_DIR . '/includes/admin/popup/class-popup-content.php' );

	// Admin Help Class File
	require_once( PAOC_PRO_DIR . '/includes/admin/class-paoc-admin-help.php' );
	
	// Integrations Class File
	require_once( PAOC_PRO_DIR . '/includes/api/class-paoc-integrations.php' );

	if( ! defined( 'WPOS_HIDE_LICENSE' ) || ( defined( 'WPOS_HIDE_LICENSE' ) && WPOS_HIDE_LICENSE != 'page' ) ) {
		include( dirname( __FILE__ ) . '/paoc-plugin-updator.php' );
	}
}