<?php
/**
* Template for Bar Popup Phone Calls Design 2
*
* This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/bar/phone-calls/design-2.php
*
* @package Popup Anything On Click Pro
* @since 2.0
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<div class="paoc-cb-popup-body paoc-popup paoc-bar-popup <?php echo esc_attr( $popup_classes ); ?>" id="paoc-popup-<?php echo esc_attr( $popup_id ).'-'.esc_attr( $unique ); ?>" <?php echo $popup_attr; ?> style="<?php echo esc_attr( $style['bg_clr'] ); ?>">
	<div class="paoc-popup-inr-wrap">
		<div class="paoc-display-flex">

			<?php if ( $style['bg_img'] ) { ?>
				<div class="paoc-padding-10 paoc-popup-first paoc-popup-img-wrap">
					<div class="paoc-popup-bg-img">
						<img src="<?php echo esc_url( $style['popup_img'] ); ?>" />
					</div>
				</div>
			<?php } ?>

			<?php if( $main_heading || $sub_heading || $popup_content || $secondary_content ) { ?>
				<div class="paoc-padding-10 paoc-popup-column paoc-popup-middle">
					<?php if( $main_heading ) { ?>
						<div class="paoc-popup-margin paoc-popup-mheading"><?php echo wp_kses_post( $main_heading ); ?></div>
					<?php }

					if( $sub_heading ) { ?>
						<div class="paoc-popup-margin paoc-popup-sheading"><?php echo wp_kses_post( $sub_heading ); ?></div>
					<?php }

					if( $popup_content ) { ?>
						<div class="paoc-popup-margin paoc-popup-content"><?php echo $popup_content; // WPCS: XSS ok. ?></div>
					<?php }

					if( $secondary_content ) { ?>
						<div class="paoc-popup-margin paoc-secondary-con"><?php echo $secondary_content; // WPCS: XSS ok. ?></div>
					<?php } ?>
				</div>
			<?php } ?>

			<div class="paoc-padding-10 paoc-popup-column paoc-popup-last">
				<?php if( $btn_txt && $phone_num ) { ?>
					<div class="paoc-popup-margin paoc-phone-wrap">
						<a class="paoc-btn paoc-btn-1" href="tel:+<?php echo $phone_num; ?>"><?php echo wp_kses_post( $btn_txt ); ?></a>
					</div>
				<?php }

				if( $cust_close_txt ) { ?>
					<div class="paoc-popup-margin paoc-cus-close-txt">
						<span class="paoc-popup-close"><?php echo esc_html( $cust_close_txt ); ?></span>
					</div>
				<?php }

				paoc_pro_get_template( "social.php", $args );

				if( $security_note ) { ?>
					<div class="paoc-popup-margin paoc-popup-snote"><i class="fa fa-lock"></i> <span><?php echo esc_html( $security_note ); ?></span></div>
				<?php } ?>
			</div>

		</div>
	</div>

	<?php
	// Credit
	paoc_pro_get_template( "credit.php", $args );

	// Close Button
	paoc_pro_get_template( "close-button.php", $args ); ?>
</div>