<?php
/**
* Template for Bar Popup Target URL Design 3
*
* This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/bar/target-url/design-3.php
*
* @package Popup Anything On Click Pro
* @since 2.0
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<div class="paoc-cb-popup-body paoc-popup paoc-bar-popup <?php echo esc_attr( $popup_classes ); ?>" id="paoc-popup-<?php echo esc_attr( $popup_id ).'-'.esc_attr( $unique ); ?>" <?php echo $popup_attr; ?> style="<?php echo esc_attr( $style['bg_clr'] ); ?>">
	<div class="paoc-center paoc-popup-inr-wrap">
		<div class="paoc-display-flex">

			<?php if ( $style['bg_img'] ) { ?>
				<div class="paoc-padding-10 paoc-popup-first paoc-popup-img-wrap">
					<div class="paoc-popup-bg-img">
						<img src="<?php echo esc_url( $style['popup_img'] ); ?>" />
					</div>
				</div>
			<?php } ?>

			<?php if( $main_heading || $sub_heading || $popup_content || $secondary_content ) { ?>
				<div class="paoc-padding-10 paoc-popup-column paoc-popup-middle">
					<?php if( $main_heading ) { ?>
						<div class="paoc-popup-margin paoc-popup-mheading"><?php echo wp_kses_post( $main_heading ); ?></div>
					<?php }

					if( $sub_heading ) { ?>
						<div class="paoc-popup-margin paoc-popup-sheading"><?php echo wp_kses_post( $sub_heading ); ?></div>
					<?php }

					if( $popup_content ) { ?>
						<div class="paoc-popup-margin paoc-popup-content"><?php echo $popup_content; // WPCS: XSS ok. ?></div>
					<?php }

					if( $secondary_content ) { ?>
						<div class="paoc-popup-margin paoc-secondary-con"><?php echo $secondary_content; // WPCS: XSS ok. ?></div>
					<?php } ?>
				</div>
			<?php } ?>

			<div class="paoc-padding-10 paoc-popup-column paoc-popup-last">
				<?php if( ( $btn1_text && $btn1_link ) || $btn2_text ) { ?>
					<div class="paoc-cta-wrap">
						<?php if( $btn1_text && $btn1_link ) { ?>
							<div class="paoc-btn-1 paoc-btn-wrap">
								<span class="paoc-btn" <?php echo $btn1_click; ?>>
									<?php echo wp_kses_post( $btn1_text ); ?>
									<svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-double-right" class="svg-inline--fa fa-angle-double-right fa-w-14 " role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34zm192-34l-136-136c-9.4-9.4-24.6-9.4-33.9 0l-22.6 22.6c-9.4 9.4-9.4 24.6 0 33.9l96.4 96.4-96.4 96.4c-9.4 9.4-9.4 24.6 0 33.9l22.6 22.6c9.4 9.4 24.6 9.4 33.9 0l136-136c9.4-9.2 9.4-24.4 0-33.8z"></path></svg>
								</span>
							</div>
						<?php }

						if( $btn2_text ) { ?>
							<div class="paoc-btn-2 paoc-btn-wrap">
								<span class="paoc-btn" <?php echo $btn2_click; ?>>
									<?php echo wp_kses_post( $btn2_text ); ?>
									<svg aria-hidden="true" focusable="false" data-prefix="fas" data-icon="angle-double-right" class="svg-inline--fa fa-angle-double-right fa-w-14 " role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512"><path fill="currentColor" d="M224.3 273l-136 136c-9.4 9.4-24.6 9.4-33.9 0l-22.6-22.6c-9.4-9.4-9.4-24.6 0-33.9l96.4-96.4-96.4-96.4c-9.4-9.4-9.4-24.6 0-33.9L54.3 103c9.4-9.4 24.6-9.4 33.9 0l136 136c9.5 9.4 9.5 24.6.1 34zm192-34l-136-136c-9.4-9.4-24.6-9.4-33.9 0l-22.6 22.6c-9.4 9.4-9.4 24.6 0 33.9l96.4 96.4-96.4 96.4c-9.4 9.4-9.4 24.6 0 33.9l22.6 22.6c9.4 9.4 24.6 9.4 33.9 0l136-136c9.4-9.2 9.4-24.4 0-33.8z"></path></svg>
								</span>
							</div>
						<?php } ?>
					</div>
				<?php }

				if( $cust_close_txt ) { ?>
					<div class="paoc-popup-margin paoc-cus-close-txt">
						<span class="paoc-popup-close"><?php echo esc_html( $cust_close_txt ); ?></span>
					</div>
				<?php }

				paoc_pro_get_template( "social.php", $args );

				if( $security_note ) { ?>
					<div class="paoc-popup-margin paoc-popup-snote"><i class="fa fa-lock"></i> <span><?php echo esc_html( $security_note ); ?></span></div>
				<?php } ?>
			</div>

		</div>
	</div>

	<?php
	// Credit
	paoc_pro_get_template( "credit.php", $args );

	// Close Button
	paoc_pro_get_template( "close-button.php", $args ); ?>
</div>