<?php
/**
 * Template for Popup Anything on Click Pro Content
 *
 * This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/content.php
 *
 * @package Popup Anything on Click Pro
 * @version 1.2.2
 */

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// If `Simple Popup` is there
if( $popup_appear == 'simple_link' ) { ?>

	<a class="<?php echo esc_attr( $popup_classes ); ?> paoc-pro-popup-link" href="javascript:void(0);"><?php echo wp_kses_post( $link_text ); ?></a>

<?php } else if( $popup_appear == 'image' && $image_url ) { // If `Image Popup` is there ?>

	<div class="paoc-pro-image-popup">
		<a class="<?php echo esc_attr( $popup_classes ); ?> paoc-pro-popup-image" href="javascript:void(0);">
			<img class="popupaoc-img" src="<?php echo esc_url( $image_url ); ?>" alt="<?php echo esc_attr( $image_alt ); ?>" />
		</a>

		<?php if( ! empty( $show_img_title ) && $image_title ) { ?>

			<h4 class="paoc-pro-image-title"><?php echo wp_kses_post( $image_title ); ?></h4>

		<?php } if( ! empty( $show_img_caption ) && $image_caption ) { ?>

			<div class="paoc-pro-image-caption"><?php echo wp_kses_post( wpautop( wptexturize( $image_caption ) ) ); ?></div>

		<?php } ?>
	</div>

<?php } else if( $popup_appear == 'button' ) { // If `Button Popup` is there ?>
	<a class="<?php echo esc_attr( $popup_classes ); ?> paoc-pro-popup-button <?php echo esc_attr( $button_class ); ?>" href="javascript:void(0);"><?php echo wp_kses_post( $btn_text ); ?></a>
<?php }