<?php
/**
* Template for Announcement Design 2
*
* This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/designs/design-2.php
*
* @package Popup Anything On Click Pro
* @since 2.0.5
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
} ?>

<div class="paoc-cb-popup-body paoc-popup paoc-modal-popup <?php echo esc_attr( $popup_classes ); ?>" id="paoc-popup-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $unique ); ?>" <?php echo $popup_attr; ?> style="<?php echo esc_attr( $style['bg_clr'] ); ?>">
	<div class="paoc-popup-inr-wrap">
		<div class="paoc-display-flex">
			<div class="paoc-display-flex-inr paoc-popup-con-bg">
				<div class="paoc-padding-30 paoc-popup-inr">

					<?php if( $main_heading ) { ?>
						<div class="paoc-popup-margin paoc-popup-mheading"><?php echo wp_kses_post( $main_heading ); ?></div>
					<?php }

					if( $sub_heading ) { ?>
						<div class="paoc-popup-margin paoc-popup-sheading"><?php echo wp_kses_post( $sub_heading ); ?></div>
					<?php }

					if( $popup_content ) { ?>
						<div class="paoc-popup-margin paoc-popup-content"><?php echo $popup_content; // WPCS: XSS ok. ?></div>
					<?php }

					paoc_pro_get_template( "popup-goal.php", $args );

					if( $secondary_content ) { ?>
						<div class="paoc-popup-margin paoc-secondary-con"><?php echo $secondary_content; // WPCS: XSS ok. ?></div>
					<?php }

					if( $cust_close_txt ) { ?>
						<div class="paoc-popup-margin paoc-cus-close-txt">
							<span class="paoc-popup-close"><?php echo esc_html( $cust_close_txt ); ?></span>
						</div>
					<?php }

					paoc_pro_get_template( "social.php", $args );

					if( $security_note ) { ?>
						<div class="paoc-popup-margin paoc-popup-snote"><i class="fa fa-lock"></i> <span><?php echo esc_html( $security_note ); ?></span></div>
					<?php } ?>
				</div>
			</div>

			<?php if ( $style['bg_img'] ) { ?>
				<div class="paoc-display-flex-inr paoc-popup-img-wrap">
					<div class="paoc-popup-bg-img" style="<?php echo esc_attr( $style['bg_img'] ); ?>"></div>
				</div>
			<?php } ?>
		</div>
	</div>

	<?php
	// Credit
	paoc_pro_get_template( "credit.php", $args );

	// Close Button
	paoc_pro_get_template( "close-button.php", $args ); ?>
</div>