<?php
/**
* Template for Popup Form Fields Design
*
* This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/form-fields.php
*
* @package Popup Anything on Click Pro
* @since 2.0
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if( empty( $form_fields ) ) {
	return;
}

// Taking some variable
$count				= 0;
$field_type_data	= paoc_pro_form_field_type_options();
?>
<div class="paoc-form-fields">
	<form class="paoc-fields-form paoc-fields-form-<?php echo esc_attr( $popup_id ); ?> paoc-clearfix" action="" method="POST" novalidate="novalidate">
		<div class="paoc-fields-form-innr paoc-popup-margin">
			<?php foreach ( $form_fields as $form_field_key => $form_field_val ) {

				$count++;
				$type			= isset( $form_field_val['type'] )				? $form_field_val['type']			: 'text';
				$field_type		= isset( $field_type_data[ $type ]['type'] )	? $field_type_data[ $type ]['type']	: 'text';
				$label			= isset( $form_field_val['label'] )				? $form_field_val['label']			: '';
				$placeholder	= isset( $form_field_val['placeholder'] )		? $form_field_val['placeholder']	: '';
				$choices		= isset( $form_field_val['choices'] )			? $form_field_val['choices']		: '';
				$multiple		= ! empty( $form_field_val['multiple'] )		? 1 : 0;
				$require		= ! empty( $form_field_val['require'] )			? 1 : 0;
				$require_lbl	= ( $require ) 									? "<span>*</span>" : '';
				$choices_arr	= explode( "\n", $choices );

				if( $type == 'checkbox' ) { ?>

					<div class="paoc-form-field-row paoc-field-row-grid">
						<label class="paoc-form-ckbox-lbl">
							<input type="checkbox" name="paoc_field_<?php echo esc_attr( $form_field_key ); ?>" class="paoc-form-ckbox paoc_field_<?php echo esc_attr( $form_field_key ); ?>" id="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>" value="1" />
							<?php echo esc_html( $label ); ?>
						</label>
					</div>

				<?php } elseif ( $type == 'textarea' ) { ?>

					<div class="paoc-form-field-row paoc-field-row-grid">
						<?php if( $label ) { ?>
						<label class="paoc-form-lbl" for="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>"><?php echo esc_html( $label ); ?> <?php echo $require_lbl; ?></label>
						<?php } ?>
						<textarea name="paoc_field_<?php echo esc_attr( $form_field_key ); ?>" class="paoc-form-inp paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ); ?> paoc_field_<?php echo esc_attr( $form_field_key ); ?>" id="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>"></textarea>
					</div>

				<?php } else if( $type == 'math_captcha' ) { ?>

					<div class="paoc-form-field-row paoc-field-row-grid">
						<?php if( $label ) { ?>
						<label class="paoc-form-lbl" for="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>"><?php echo esc_html( $label ); ?> <?php echo wp_kses_post( $paoc_captcha ); ?> = </label>
						<?php } ?>
						<input type="text" name="paoc_math_input_<?php echo esc_attr( $form_field_key ); ?>" value="" id="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>" class="paoc-form-inp paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ); ?> paoc_field_<?php echo esc_attr( $form_field_key ); ?>" autocomplete="off" />
						<input type="hidden" name="paoc_math_<?php echo esc_attr( $form_field_key ); ?>" value="<?php echo esc_attr( $captcha_val ); ?>" />
					</div>

				<?php } elseif ( $type == 'dropdown' ) { ?>
					<div class="paoc-form-field-row paoc-field-row-grid">
						<?php if( $label ) { ?>
						<label class="paoc-form-lbl" for="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>"><?php echo esc_html( $label ); ?> <?php echo $require_lbl; ?></label>
						<?php } ?>
						<select name="paoc_field_<?php echo esc_attr( $form_field_key ); ?>[]" class="paoc-form-inp paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ); ?> paoc_field_<?php echo esc_attr( $form_field_key ); ?>" id="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>" <?php if( $multiple ) { echo 'multiple="multiple"'; } ?>>
							<?php if( ! empty( $placeholder ) ) { ?>
								<option value=""><?php echo esc_html( $placeholder ); ?></option>
							<?php } ?>
							<?php if( ! empty( $choices_arr ) ) {
								foreach ($choices_arr as $choices_key => $choices_data) {

									// Taking some variable
									$choices_data	= explode( "|", $choices_data );
									$choices_val	= isset( $choices_data[0] )	? trim( $choices_data[0] )	: '';
									$choices_name	= isset( $choices_data[1] )	? trim( $choices_data[1] )	: '';
									$choices_name	= ! empty( $choices_name )	? $choices_name				: $choices_val;

									if( $choices_name != '' ) { ?>
										<option value="<?php echo esc_attr( $choices_val ); ?>"><?php echo esc_html( $choices_name ); ?></option>
								<?php }
								}
							} ?>
						</select>
					</div>
				<?php } else { ?>

					<div class="paoc-form-field-row paoc-field-row-grid">
						<?php if( $label ) { ?>
						<label class="paoc-form-lbl" for="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>"><?php echo esc_html( $label ); ?> <?php echo $require_lbl; ?></label>
						<?php } ?>
						<input type="<?php echo esc_attr( $field_type ); ?>" name="paoc_field_<?php echo esc_attr( $form_field_key ); ?>" value="" class="paoc-form-inp paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ); ?> paoc_field_<?php echo esc_attr( $form_field_key ); ?>" id="paoc-form-<?php echo esc_attr( $popup_id ) .'-'. esc_attr( $form_field_key ) .'-'. esc_attr( $unique ); ?>" placeholder="<?php echo esc_attr( $placeholder ); ?>" />
					</div>

				<?php } ?>

			<?php } // End of foreach ?>

			<div class="paoc-center paoc-form-field-row paoc-form-submit-row">
				<button type="submit" name="" class="paoc-form-submit"><?php echo wp_kses_post( $submit_btn_txt ); ?> <span class="paoc-loader paoc-hide"></span></button>
			</div>
		</div>
	</form>
</div>