<?php
/**
* Template for Popup Goal (Behaviour) Data
* This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/popup-goal.php
*
* @package Popup Anything on Click Pro
* @since 2.0
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if( $popup_goal == 'email-lists' ) { ?>

	<div class="paoc-popup-margin paoc-popup-form-process">
		<?php paoc_pro_get_template( "form-fields.php", $args ); ?>
	</div>

<?php } elseif ( $popup_goal == 'phone-calls' && $btn_txt && $phone_num ) { ?>

	<div class="paoc-phone-wrap paoc-popup-margin">
		<a class="paoc-btn paoc-btn-click paoc-btn-1" href="tel:+<?php echo esc_attr( $phone_num ); ?>"><?php echo wp_kses_post( $btn_txt ); ?></a>
	</div>

<?php } elseif ( $popup_goal == 'target-url' && ( ( $btn1_text && $btn1_link ) || $btn2_text ) ) { ?>

	<div class="paoc-popup-margin paoc-cta-wrap">
		<?php if( $btn1_text && $btn1_link ) { ?>
		<div class="paoc-btn-1 paoc-btn-wrap">
			<span class="paoc-btn paoc-btn-click" <?php echo $btn1_click; ?>><?php echo wp_kses_post( $btn1_text ); ?></span>
		</div>
		<?php }

		if( $btn2_text ) { ?>
		<div class="paoc-btn-2 paoc-btn-wrap">
			<span class="paoc-btn" <?php echo $btn2_click; ?>><?php echo wp_kses_post( $btn2_text ); ?></span>
		</div>
		<?php } ?>
	</div>

<?php } ?>