<?php
/**
* Template for Popup Social Design
*
* This template can be overridden by copying it to yourtheme/popup-anything-on-click-pro/social.php
*
* @package Popup Anything on Click Pro
* @since 2.0
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if( empty( $social_data ) ) {
	return;
}
?>
<div class="paoc-social-wrap paoc-popup-margin">
	<?php foreach ( $social_data as $social_data_key => $social_arr ) {

		// Taking some variable
		$social_attr	= '';
		$social_name	= $social_arr['name'];
		$social_link	= $social_arr['link'];
		$social_icon	= $social_arr['icon'];

		if( $social_name == 'whatsapp' ) {

			$social_link	= esc_attr( $social_link );
			$mobile_link	= add_query_arg( array('phone' => $social_link), 'whatsapp://send' );
			$social_link	= add_query_arg( array('phone' => $social_link), 'https://web.whatsapp.com/send' );
			$social_attr	= 'data-desktop="'. $social_link .'" data-mobile="'. $mobile_link .'"';

		} else if( $social_name == 'mail' ) {

			$social_link = 'mailto:'.$social_link;

		} else if( $social_name == 'skype' ) {

			$social_link = 'skype:'.$social_link;

		} else {

			$social_link = esc_url( $social_link );
		}

		if( $social_type == 'text' ) { ?>
			<a class="paoc-social-icon paoc-social-text paoc-<?php echo esc_attr( $social_name ); ?>-icon" href="<?php echo $social_link; ?>" target="_blank" <?php echo $social_attr; ?>><span class="paoc-<?php echo esc_attr( $social_name ); ?>-text"><?php echo esc_html( $social_arr['title'] ); ?></span></a>
		<?php } elseif ( $social_type == 'icon-text' ) { ?>
			<a class="paoc-social-icon paoc-social-icon-text paoc-<?php echo esc_attr( $social_name ); ?>-icon" href="<?php echo $social_link; ?>" target="_blank" <?php echo $social_attr; ?>><i class="<?php echo esc_attr( $social_icon ); ?>"></i> <span class="paoc-<?php echo esc_attr( $social_name ); ?>-text"><?php echo esc_html( $social_arr['title'] ); ?></span></a>
		<?php } else { ?>
			<a class="paoc-social-icon paoc-<?php echo esc_attr( $social_name ); ?>-icon" href="<?php echo $social_link; ?>" target="_blank" <?php echo $social_attr; ?>><i class="<?php echo esc_attr( $social_icon ); ?>"></i></a>
		<?php }
	} ?>
</div>