<?php
/**
 * Admin Page Template
 */

if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="pbg-admin-container">
        <div class="pbg-admin-header">
            <h2>🎯 Enhanced Prop Bet Generator</h2>
            <p>AI-powered prop bet recommendations with real player stats and game selection.</p>
        </div>
        
        <div class="pbg-admin-content">
            <div class="pbg-admin-card">
                <h3>📊 Quick Stats</h3>
                <div class="pbg-stats-grid">
                    <div class="pbg-stat-item">
                        <span class="pbg-stat-number">4</span>
                        <span class="pbg-stat-label">Sports Supported</span>
                    </div>
                    <div class="pbg-stat-item">
                        <span class="pbg-stat-number">40+</span>
                        <span class="pbg-stat-label">Prop Types</span>
                    </div>
                    <div class="pbg-stat-item">
                        <span class="pbg-stat-number">100+</span>
                        <span class="pbg-stat-label">Players Available</span>
                    </div>
                    <div class="pbg-stat-item">
                        <span class="pbg-stat-number">∞</span>
                        <span class="pbg-stat-label">AI Recommendations</span>
                    </div>
                </div>
            </div>
            
            <div class="pbg-admin-card">
                <h3>🚀 Getting Started</h3>
                <ol>
                    <li><strong>Configure API Keys:</strong> Go to Settings to add your TheOddsAPI and OpenAI API keys.</li>
                    <li><strong>Add to Page:</strong> Use the shortcode <code>[prop_bet_generator]</code> on any page or post.</li>
                    <li><strong>Customize:</strong> Use shortcode attributes to customize the display.</li>
                </ol>
            </div>
            
            <div class="pbg-admin-card">
                <h3>📋 Shortcode Usage</h3>
                <div class="pbg-shortcode-examples">
                    <div class="pbg-example">
                        <h4>Basic Usage:</h4>
                        <code>[prop_bet_generator]</code>
                    </div>
                    
                    <div class="pbg-example">
                        <h4>With Custom Theme:</h4>
                        <code>[prop_bet_generator theme="light"]</code>
                    </div>
                    
                    <div class="pbg-example">
                        <h4>NFL Only:</h4>
                        <code>[prop_bet_generator sports="americanfootball_nfl" default_sport="americanfootball_nfl"]</code>
                    </div>
                </div>
            </div>
            
            <div class="pbg-admin-card">
                <h3>🏈🏀⚾🏒 Supported Sports</h3>
                <div class="pbg-sports-grid">
                    <div class="pbg-sport-item">
                        <span class="pbg-sport-icon">🏈</span>
                        <h4>NFL</h4>
                        <p>10 prop types including passing, rushing, receiving yards and touchdowns.</p>
                    </div>
                    <div class="pbg-sport-item">
                        <span class="pbg-sport-icon">🏀</span>
                        <h4>NBA</h4>
                        <p>10 prop types including points, rebounds, assists, and three-pointers.</p>
                    </div>
                    <div class="pbg-sport-item">
                        <span class="pbg-sport-icon">⚾</span>
                        <h4>MLB</h4>
                        <p>10 prop types including hits, home runs, RBIs, and strikeouts.</p>
                    </div>
                    <div class="pbg-sport-item">
                        <span class="pbg-sport-icon">🏒</span>
                        <h4>NHL</h4>
                        <p>10 prop types including goals, assists, points, and saves.</p>
                    </div>
                </div>
            </div>
            
            <div class="pbg-admin-card">
                <h3>⚠️ Important Notes</h3>
                <div class="pbg-notice pbg-notice-warning">
                    <p><strong>Responsible Gambling:</strong> This plugin is for educational and entertainment purposes only. Please gamble responsibly.</p>
                </div>
                <div class="pbg-notice pbg-notice-info">
                    <p><strong>API Requirements:</strong> You need API keys from TheOddsAPI and OpenAI for full functionality. The plugin will work with fallback data if keys are not provided.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.pbg-admin-container {
    max-width: 1200px;
    margin: 20px 0;
}

.pbg-admin-header {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 30px;
    border-radius: 10px;
    margin-bottom: 20px;
    text-align: center;
}

.pbg-admin-header h2 {
    margin: 0 0 10px 0;
    font-size: 2.5em;
}

.pbg-admin-card {
    background: white;
    border: 1px solid #ddd;
    border-radius: 8px;
    padding: 20px;
    margin-bottom: 20px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.pbg-admin-card h3 {
    margin-top: 0;
    color: #333;
    border-bottom: 2px solid #667eea;
    padding-bottom: 10px;
}

.pbg-stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.pbg-stat-item {
    text-align: center;
    padding: 20px;
    background: #f8f9fa;
    border-radius: 8px;
}

.pbg-stat-number {
    display: block;
    font-size: 2.5em;
    font-weight: bold;
    color: #667eea;
}

.pbg-stat-label {
    display: block;
    color: #666;
    margin-top: 5px;
}

.pbg-sports-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.pbg-sport-item {
    text-align: center;
    padding: 20px;
    border: 2px solid #eee;
    border-radius: 8px;
    transition: all 0.3s ease;
}

.pbg-sport-item:hover {
    border-color: #667eea;
    transform: translateY(-2px);
}

.pbg-sport-icon {
    font-size: 3em;
    display: block;
    margin-bottom: 10px;
}

.pbg-sport-item h4 {
    margin: 10px 0;
    color: #333;
}

.pbg-shortcode-examples {
    margin-top: 20px;
}

.pbg-example {
    margin-bottom: 15px;
    padding: 15px;
    background: #f8f9fa;
    border-radius: 5px;
}

.pbg-example h4 {
    margin: 0 0 10px 0;
    color: #333;
}

.pbg-example code {
    background: #fff;
    padding: 5px 10px;
    border-radius: 3px;
    border: 1px solid #ddd;
}

.pbg-notice {
    padding: 15px;
    border-radius: 5px;
    margin: 10px 0;
}

.pbg-notice-warning {
    background: #fff3cd;
    border: 1px solid #ffeaa7;
    color: #856404;
}

.pbg-notice-info {
    background: #d1ecf1;
    border: 1px solid #bee5eb;
    color: #0c5460;
}
</style>
