# AI Sports Betting Picks WordPress Plugin

Transform your WordPress site into a professional sports betting analysis platform with AI-powered picks, real-time odds, and comprehensive sports coverage.

## 🏆 Plugin Features

- **Pick of the Day**: AI-generated featured betting recommendations from today/tomorrow games
- **Multi-Sport Coverage**: NFL, NBA, MLB, NHL, MLS support
- **Real-time Odds**: Live data from top sportsbooks (BetMGM, FanDuel, DraftKings, Caesars, ESPN BET)
- **AI Analysis**: Detailed explanations for every betting recommendation  
- **Confidence Scoring**: Visual confidence indicators with color-coded progress bars
- **American Odds Format**: Professional sportsbook-style odds display
- **WordPress Integration**: Seamless shortcodes and admin interface
- **Historical Tracking**: Store and analyze AI pick performance
- **Responsive Design**: Mobile-optimized for all devices
- **Admin Dashboard**: Complete management and analytics interface

## 📁 Installation

### Method 1: Upload via WordPress Admin

1. Download the plugin files as a ZIP
2. In WordPress admin, go to **Plugins** → **Add New** → **Upload Plugin**
3. Select the ZIP file and click **Install Now**
4. Activate the plugin

### Method 2: FTP Upload

1. Upload the `ai-sports-betting-picks` folder to `/wp-content/plugins/`
2. Go to **Plugins** in WordPress admin
3. Activate **AI Sports Betting Picks**

### Method 3: Manual Installation

1. Copy all plugin files to `/wp-content/plugins/ai-sports-betting-picks/`
2. Ensure proper file permissions (755 for directories, 644 for files)
3. Activate through WordPress admin

## 🔑 Required API Keys

### TheOddsAPI Configuration

1. Visit [the-odds-api.com](https://the-odds-api.com)
2. Create a free account (500 requests/month)
3. Copy your API key
4. In WordPress admin: **Sports Picks** → **Settings**
5. Paste key in "TheOddsAPI Key" field

### OpenAI API Configuration  

1. Visit [platform.openai.com](https://platform.openai.com)
2. Create account and generate API key
3. Copy the API key (starts with `sk-`)
4. In WordPress admin: **Sports Picks** → **Settings** 
5. Paste key in "OpenAI API Key" field

## 🚀 Usage

### Shortcodes

#### Full Sports Picks Interface
```php
[ai_sports_picks]
```
Displays complete interface with pick of the day and sport selection.

#### Pick of the Day Only
```php
[ai_pick_of_day]
```
Shows only the featured pick in a compact widget format.

#### Custom Options
```php
[ai_sports_picks show_pick_of_day="true" show_sports_selector="true"]
```

**Available Parameters:**
- `show_pick_of_day`: Show/hide pick of the day section (`true`/`false`)
- `show_sports_selector`: Show/hide sports selection (`true`/`false`)
- `theme`: Display theme (`dark`/`light`) - coming soon

### Template Integration

#### PHP Template Files
```php
// In your theme's functions.php or template files
if (function_exists('asbp_get_pick_of_day')) {
    $pick = asbp_get_pick_of_day();
    // Display pick data
}
```

#### Widget Areas
Add shortcodes to any widget area through **Appearance** → **Widgets**.

## 📊 Admin Interface

### Dashboard Overview

Access via **Sports Picks** in WordPress admin menu:

- **Total Picks Generated**: Complete statistics
- **Weekly Activity**: Recent pick generation trends  
- **API Status**: Real-time connection monitoring
- **Recent Picks Table**: Last 10 generated picks with details

### Settings Configuration

Navigate to **Sports Picks** → **Settings**:

#### API Keys Section
- TheOddsAPI key input with validation
- OpenAI API key secure storage
- Connection testing tools

#### Sports Configuration  
- Supported leagues: NFL, NBA, MLB, NHL, MLS
- Sportsbook preferences (BetMGM, FanDuel, DraftKings, Caesars, ESPN BET)
- Priority ordering for odds selection

#### Cache Settings
- Pick of the day cache duration (5-1440 minutes)
- Games data cache timing (1-60 minutes)
- Performance optimization controls

## 🎯 How It Works

### Pick of the Day Generation

1. **Game Selection**: Scans all sports for games happening today/tomorrow
2. **Prioritization**: Selects earliest game with complete odds data
3. **AI Analysis**: Processes team data, odds, and market trends
4. **Pick Generation**: Creates recommendation with confidence level
5. **Display**: Shows formatted pick with analysis and sportsbook attribution

### Custom Pick Generation

1. **Sport Selection**: User chooses from NFL, NBA, MLB, NHL, MLS
2. **Game Loading**: Fetches upcoming games with real-time odds
3. **Game Selection**: User clicks "Get AI Pick" for specific matchup
4. **AI Processing**: Generates analysis using OpenAI GPT-4
5. **Result Display**: Shows pick with confidence, odds, and reasoning

### Data Flow

```
User Request → WordPress → TheOddsAPI → Game Data → OpenAI → AI Analysis → Display
```

## 🔧 Technical Details

### Database Tables

The plugin creates one main table:

#### `wp_asbp_picks`
- `id`: Primary key
- `pick_id`: Unique pick identifier  
- `game_id`: TheOddsAPI game identifier
- `sport_key`: Sport league code
- `home_team`/`away_team`: Team names
- `commence_time`: Game start time
- `pick_type`: moneyline/spread/total
- `recommendation`: Specific pick recommendation  
- `confidence_level`: AI confidence (0.0-1.0)
- `odds`: American odds format
- `sportsbook`: Sportsbook identifier
- `sportsbook_display_name`: User-friendly sportsbook name
- `analysis`: AI-generated explanation
- `is_pick_of_day`: Boolean flag
- `created_at`: Timestamp

### AJAX Endpoints

The plugin registers these WordPress AJAX actions:

- `asbp_get_pick_of_day`: Fetch/generate pick of the day
- `asbp_get_sports`: Get available sports list  
- `asbp_get_games`: Get games for specific sport
- `asbp_generate_pick`: Generate AI pick for specific game

### Caching Strategy

- **Pick of Day**: Cached for 1 hour to prevent API overuse
- **Sports Data**: Cached for 15 minutes  
- **Games Data**: Cached for 5 minutes due to changing odds
- **Transient Storage**: Uses WordPress transients for automatic cleanup

## 🛠 Customization

### Styling Customization

Add custom CSS to your theme:

```css
/* Override pick of day styling */
.asbp-pick-of-day {
    background: your-custom-gradient;
}

/* Customize confidence bars */
.asbp-confidence-high {
    background: your-success-color;
}
```

### Functionality Extensions

#### Custom Hooks
```php
// Filter pick of day selection
add_filter('asbp_pick_of_day_games', 'your_game_filter');

// Modify AI analysis prompt  
add_filter('asbp_ai_prompt', 'your_prompt_modifier');

// Custom sportsbook prioritization
add_filter('asbp_preferred_sportsbooks', 'your_sportsbook_order');
```

#### Template Overrides
Copy plugin templates to your theme:
```
your-theme/
  ai-sports-betting-picks/
    pick-of-day.php
    main-display.php
```

## 🚨 Troubleshooting

### Common Issues

#### "API Key Not Configured" Error
- **Solution**: Add API keys in **Sports Picks** → **Settings**
- **Verification**: Use "Test API Connections" button

#### Pick of Day Not Loading  
- **Check**: API key validity and usage limits
- **Solution**: Clear cache in admin dashboard  
- **Debug**: Enable WordPress debug logging

#### No Games Available
- **Cause**: Some sports may not have games on certain days
- **Check**: TheOddsAPI usage limits
- **Solution**: Try different sport or wait for upcoming games

#### AJAX Errors
- **Check**: WordPress AJAX nonce validation
- **Solution**: Refresh page to regenerate nonces
- **Debug**: Check browser console for JavaScript errors

### Debug Mode

Enable debug logging in `wp-config.php`:

```php
define('WP_DEBUG', true);
define('WP_DEBUG_LOG', true);
```

Plugin logs appear in `/wp-content/debug.log`.

### Performance Issues

#### High API Usage
- Increase cache durations in settings
- Limit pick generation frequency
- Monitor TheOddsAPI usage dashboard

#### Slow Page Loading
- Enable WordPress object caching
- Optimize database queries
- Check for plugin conflicts

## 📈 Analytics & Performance

### Usage Tracking

Monitor plugin performance through:

- WordPress admin dashboard statistics  
- TheOddsAPI usage dashboard
- OpenAI API usage monitoring
- Database query performance

### Optimization Tips

1. **Cache Management**: Increase cache durations for stable data
2. **API Efficiency**: Batch requests when possible
3. **Database Optimization**: Regular cleanup of old picks
4. **CDN Integration**: Cache static assets  

## 🔐 Security

### Best Practices Implemented

- **Nonce Validation**: All AJAX requests validated
- **Input Sanitization**: User inputs properly cleaned
- **SQL Injection Prevention**: Prepared statements used  
- **XSS Protection**: Output escaped
- **API Key Security**: Stored securely in WordPress options

### Recommended Settings

- Use HTTPS for all API communications
- Regularly update API keys  
- Monitor access logs for unusual activity
- Keep WordPress and plugin updated

## 🚀 Deployment

### Production Checklist

- [ ] API keys configured and tested
- [ ] Cache settings optimized  
- [ ] SSL certificate installed
- [ ] Performance monitoring setup
- [ ] Backup system configured
- [ ] Error logging enabled

### Staging Environment

Test the plugin on staging before production:

1. Copy production site to staging
2. Install and configure plugin
3. Test all functionality with live API keys
4. Verify performance under load
5. Deploy to production

## 📞 Support

### Documentation Resources

- **Plugin Settings**: In-admin help sections
- **API Documentation**: TheOddsAPI and OpenAI docs
- **WordPress Codex**: WordPress development standards

### Getting Help

1. **Check Settings**: Verify API key configuration
2. **Review Logs**: Check WordPress debug logs  
3. **Test APIs**: Use connection testing tools
4. **Community Support**: WordPress plugin forums

## 📄 License

This plugin is licensed under the GPL v2 or later.

## 🙏 Credits

- **TheOddsAPI**: Sports odds and data provider
- **OpenAI**: AI analysis and recommendations  
- **WordPress**: Platform and framework
- **jQuery**: JavaScript functionality

---

**⚠️ Disclaimer**: This plugin is for entertainment and educational purposes only. Please gamble responsibly and within your means. Users must comply with local gambling laws and regulations.