<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <div class="asbp-admin-container">
        <div class="asbp-stats-grid">
            <div class="asbp-stat-card">
                <h3>Total Picks Generated</h3>
                <div class="asbp-stat-number">
                    <?php
                    global $wpdb;
                    $table_name = $wpdb->prefix . 'asbp_picks';
                    $total_picks = $wpdb->get_var("SELECT COUNT(*) FROM $table_name");
                    echo esc_html($total_picks ?: 0);
                    ?>
                </div>
            </div>
            
            <div class="asbp-stat-card">
                <h3>Picks This Week</h3>
                <div class="asbp-stat-number">
                    <?php
                    $week_picks = $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)");
                    echo esc_html($week_picks ?: 0);
                    ?>
                </div>
            </div>
            
            <div class="asbp-stat-card">
                <h3>Pick of the Day Generated</h3>
                <div class="asbp-stat-number">
                    <?php
                    $pod_picks = $wpdb->get_var("SELECT COUNT(*) FROM $table_name WHERE is_pick_of_day = 1");
                    echo esc_html($pod_picks ?: 0);
                    ?>
                </div>
            </div>
            
            <div class="asbp-stat-card">
                <h3>API Status</h3>
                <div class="asbp-stat-status">
                    <?php
                    $odds_key = get_option('asbp_odds_api_key');
                    $openai_key = get_option('asbp_openai_api_key');
                    
                    if (!empty($odds_key) && !empty($openai_key)) {
                        echo '<span class="asbp-status-active">✅ Active</span>';
                    } else {
                        echo '<span class="asbp-status-inactive">❌ Needs Setup</span>';
                    }
                    ?>
                </div>
            </div>
        </div>
        
        <div class="asbp-recent-picks">
            <h2>Recent Picks</h2>
            <div class="asbp-picks-table">
                <?php
                $recent_picks = $wpdb->get_results("
                    SELECT * FROM $table_name 
                    ORDER BY created_at DESC 
                    LIMIT 10
                ");
                
                if ($recent_picks) {
                    echo '<table class="wp-list-table widefat fixed striped">';
                    echo '<thead>';
                    echo '<tr>';
                    echo '<th>Date</th>';
                    echo '<th>Game</th>';
                    echo '<th>Pick</th>';
                    echo '<th>Confidence</th>';
                    echo '<th>Odds</th>';
                    echo '<th>Sportsbook</th>';
                    echo '<th>Type</th>';
                    echo '</tr>';
                    echo '</thead>';
                    echo '<tbody>';
                    
                    foreach ($recent_picks as $pick) {
                        echo '<tr>';
                        echo '<td>' . esc_html(date('M j, Y', strtotime($pick->created_at))) . '</td>';
                        echo '<td>' . esc_html($pick->home_team . ' vs ' . $pick->away_team) . '</td>';
                        echo '<td><strong>' . esc_html($pick->recommendation) . '</strong></td>';
                        echo '<td>' . esc_html(round($pick->confidence_level * 100)) . '%</td>';
                        echo '<td>' . esc_html($pick->odds ? ($pick->odds > 0 ? '+' . $pick->odds : $pick->odds) : 'N/A') . '</td>';
                        echo '<td>' . esc_html($pick->sportsbook_display_name ?: 'N/A') . '</td>';
                        echo '<td>' . ($pick->is_pick_of_day ? '<span class="asbp-badge-pod">Pick of Day</span>' : '<span class="asbp-badge-regular">Regular</span>') . '</td>';
                        echo '</tr>';
                    }
                    
                    echo '</tbody>';
                    echo '</table>';
                } else {
                    echo '<p>No picks generated yet. <a href="' . admin_url('admin.php?page=asbp-settings') . '">Configure your API keys</a> to get started.</p>';
                }
                ?>
            </div>
        </div>
        
        <div class="asbp-quick-actions">
            <h2>Quick Actions</h2>
            <div class="asbp-action-buttons">
                <a href="<?php echo admin_url('admin.php?page=asbp-settings'); ?>" class="button button-primary">
                    Configure Settings
                </a>
                <button type="button" class="button" onclick="asbpTestPickOfDay()">
                    Test Pick of Day
                </button>
                <button type="button" class="button" onclick="asbpClearCache()">
                    Clear Cache
                </button>
            </div>
        </div>
        
        <div class="asbp-shortcode-help">
            <h2>How to Use</h2>
            <div class="asbp-help-grid">
                <div class="asbp-help-card">
                    <h3>Full Sports Picks Interface</h3>
                    <code>[ai_sports_picks]</code>
                    <p>Displays the complete sports betting picks interface with pick of the day and sport selection.</p>
                </div>
                
                <div class="asbp-help-card">
                    <h3>Pick of the Day Only</h3>
                    <code>[ai_pick_of_day]</code>
                    <p>Shows only the featured pick of the day in a compact format.</p>
                </div>
                
                <div class="asbp-help-card">
                    <h3>Custom Options</h3>
                    <code>[ai_sports_picks show_pick_of_day="true" show_sports_selector="true"]</code>
                    <p>Customize which components to display.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.asbp-admin-container {
    max-width: 1200px;
}

.asbp-stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 20px;
    margin-bottom: 30px;
}

.asbp-stat-card {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
    text-align: center;
}

.asbp-stat-card h3 {
    margin: 0 0 10px 0;
    font-size: 14px;
    color: #666;
    text-transform: uppercase;
}

.asbp-stat-number {
    font-size: 32px;
    font-weight: bold;
    color: #0073aa;
}

.asbp-status-active {
    color: #46b450;
    font-weight: bold;
}

.asbp-status-inactive {
    color: #dc3232;
    font-weight: bold;
}

.asbp-recent-picks {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
    margin-bottom: 30px;
}

.asbp-badge-pod {
    background: #46b450;
    color: white;
    padding: 3px 8px;
    border-radius: 3px;
    font-size: 11px;
}

.asbp-badge-regular {
    background: #666;
    color: white;
    padding: 3px 8px;
    border-radius: 3px;
    font-size: 11px;
}

.asbp-quick-actions {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
    margin-bottom: 30px;
}

.asbp-action-buttons {
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.asbp-shortcode-help {
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
}

.asbp-help-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.asbp-help-card {
    border: 1px solid #e1e1e1;
    border-radius: 4px;
    padding: 15px;
}

.asbp-help-card h3 {
    margin-top: 0;
}

.asbp-help-card code {
    display: block;
    background: #f1f1f1;
    padding: 8px;
    margin: 10px 0;
    border-radius: 3px;
}
</style>

<script>
function asbpTestPickOfDay() {
    if (confirm('This will generate a new pick of the day. Continue?')) {
        // You can add AJAX call here to test pick generation
        alert('Feature coming soon!');
    }
}

function asbpClearCache() {
    if (confirm('This will clear all cached picks. Continue?')) {
        // You can add AJAX call here to clear cache
        alert('Cache cleared!');
    }
}
</script>