<?php
if (!defined('ABSPATH')) {
    exit;
}

$odds_api_key = get_option('asbp_odds_api_key', '');
$openai_api_key = get_option('asbp_openai_api_key', '');
?>

<div class="wrap">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
    
    <form method="post" action="">
        <?php wp_nonce_field('asbp_settings_nonce'); ?>
        
        <table class="form-table">
            <tr>
                <th scope="row">
                    <label for="odds_api_key">TheOddsAPI Key</label>
                </th>
                <td>
                    <input type="text" 
                           id="odds_api_key" 
                           name="odds_api_key" 
                           value="<?php echo esc_attr($odds_api_key); ?>" 
                           class="regular-text" 
                           placeholder="Enter your TheOddsAPI key">
                    <p class="description">
                        Get your free API key at <a href="https://the-odds-api.com" target="_blank">the-odds-api.com</a>. 
                        Free tier includes 500 requests per month.
                    </p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">
                    <label for="openai_api_key">OpenAI API Key</label>
                </th>
                <td>
                    <input type="password" 
                           id="openai_api_key" 
                           name="openai_api_key" 
                           value="<?php echo esc_attr($openai_api_key); ?>" 
                           class="regular-text" 
                           placeholder="Enter your OpenAI API key">
                    <p class="description">
                        Get your API key at <a href="https://platform.openai.com" target="_blank">platform.openai.com</a>. 
                        Required for AI-powered betting analysis.
                    </p>
                </td>
            </tr>
        </table>
        
        <h2>API Configuration Test</h2>
        <table class="form-table">
            <tr>
                <th scope="row">API Status</th>
                <td>
                    <div class="asbp-api-status">
                        <div class="asbp-api-test" id="asbp-odds-api-status">
                            <strong>TheOddsAPI:</strong> 
                            <span class="asbp-status-loading">⏳ Not tested</span>
                        </div>
                        <div class="asbp-api-test" id="asbp-openai-api-status">
                            <strong>OpenAI API:</strong> 
                            <span class="asbp-status-loading">⏳ Not tested</span>
                        </div>
                    </div>
                    <button type="button" class="button" onclick="asbpTestAPIs()">Test API Connections</button>
                </td>
            </tr>
        </table>
        
        <h2>Sports Configuration</h2>
        <table class="form-table">
            <tr>
                <th scope="row">Supported Sports</th>
                <td>
                    <fieldset>
                        <legend class="screen-reader-text"><span>Supported Sports</span></legend>
                        <label><input type="checkbox" checked disabled> NFL (American Football)</label><br>
                        <label><input type="checkbox" checked disabled> NBA (Basketball)</label><br>
                        <label><input type="checkbox" checked disabled> MLB (Baseball)</label><br>
                        <label><input type="checkbox" checked disabled> NHL (Ice Hockey)</label><br>
                        <label><input type="checkbox" checked disabled> MLS (Soccer)</label><br>
                    </fieldset>
                    <p class="description">All major US sports leagues are supported by default.</p>
                </td>
            </tr>
        </table>
        
        <h2>Preferred Sportsbooks</h2>
        <table class="form-table">
            <tr>
                <th scope="row">Sportsbook Priority</th>
                <td>
                    <div class="asbp-sportsbook-list">
                        <div class="asbp-sportsbook-item">
                            <span class="asbp-priority">1.</span>
                            <strong>BetMGM</strong>
                            <span class="asbp-status-enabled">✅ Enabled</span>
                        </div>
                        <div class="asbp-sportsbook-item">
                            <span class="asbp-priority">2.</span>
                            <strong>FanDuel</strong>
                            <span class="asbp-status-enabled">✅ Enabled</span>
                        </div>
                        <div class="asbp-sportsbook-item">
                            <span class="asbp-priority">3.</span>
                            <strong>DraftKings</strong>
                            <span class="asbp-status-enabled">✅ Enabled</span>
                        </div>
                        <div class="asbp-sportsbook-item">
                            <span class="asbp-priority">4.</span>
                            <strong>Caesars Sportsbook</strong>
                            <span class="asbp-status-enabled">✅ Enabled</span>
                        </div>
                        <div class="asbp-sportsbook-item">
                            <span class="asbp-priority">5.</span>
                            <strong>ESPN BET</strong>
                            <span class="asbp-status-enabled">✅ Enabled</span>
                        </div>
                    </div>
                    <p class="description">Odds are sourced from these sportsbooks in order of preference.</p>
                </td>
            </tr>
        </table>
        
        <h2>Cache Settings</h2>
        <table class="form-table">
            <tr>
                <th scope="row">Pick of the Day Cache</th>
                <td>
                    <label>
                        <input type="number" name="pod_cache_duration" value="60" min="5" max="1440" class="small-text"> 
                        minutes
                    </label>
                    <p class="description">How long to cache the pick of the day (5-1440 minutes).</p>
                </td>
            </tr>
            
            <tr>
                <th scope="row">Games Data Cache</th>
                <td>
                    <label>
                        <input type="number" name="games_cache_duration" value="15" min="1" max="60" class="small-text"> 
                        minutes
                    </label>
                    <p class="description">How long to cache games and odds data (1-60 minutes).</p>
                </td>
            </tr>
        </table>
        
        <?php submit_button('Save Settings'); ?>
    </form>
    
    <div class="asbp-help-section">
        <h2>Setup Instructions</h2>
        <div class="asbp-setup-steps">
            <div class="asbp-step">
                <div class="asbp-step-number">1</div>
                <div class="asbp-step-content">
                    <h3>Get TheOddsAPI Key</h3>
                    <p>Visit <a href="https://the-odds-api.com" target="_blank">the-odds-api.com</a> and sign up for a free account. You'll get 500 API requests per month.</p>
                </div>
            </div>
            
            <div class="asbp-step">
                <div class="asbp-step-number">2</div>
                <div class="asbp-step-content">
                    <h3>Get OpenAI API Key</h3>
                    <p>Visit <a href="https://platform.openai.com" target="_blank">platform.openai.com</a> and create an API key. You'll need this for AI-powered analysis.</p>
                </div>
            </div>
            
            <div class="asbp-step">
                <div class="asbp-step-number">3</div>
                <div class="asbp-step-content">
                    <h3>Add to Your Site</h3>
                    <p>Use the shortcode <code>[ai_sports_picks]</code> on any page or post to display the sports betting interface.</p>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.asbp-api-status {
    margin-bottom: 15px;
}

.asbp-api-test {
    margin-bottom: 8px;
}

.asbp-status-loading {
    color: #666;
}

.asbp-status-success {
    color: #46b450;
    font-weight: bold;
}

.asbp-status-error {
    color: #dc3232;
    font-weight: bold;
}

.asbp-sportsbook-list {
    border: 1px solid #ddd;
    border-radius: 4px;
    padding: 15px;
    background: #fafafa;
}

.asbp-sportsbook-item {
    display: flex;
    align-items: center;
    margin-bottom: 8px;
    padding: 8px;
    background: white;
    border-radius: 3px;
}

.asbp-priority {
    width: 25px;
    font-weight: bold;
    color: #666;
}

.asbp-sportsbook-item strong {
    flex: 1;
    margin-left: 10px;
}

.asbp-status-enabled {
    color: #46b450;
    font-size: 12px;
}

.asbp-help-section {
    margin-top: 40px;
    background: #fff;
    border: 1px solid #ccd0d4;
    border-radius: 4px;
    padding: 20px;
}

.asbp-setup-steps {
    margin-top: 20px;
}

.asbp-step {
    display: flex;
    margin-bottom: 20px;
    padding-bottom: 20px;
    border-bottom: 1px solid #eee;
}

.asbp-step:last-child {
    border-bottom: none;
}

.asbp-step-number {
    width: 40px;
    height: 40px;
    background: #0073aa;
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-weight: bold;
    margin-right: 20px;
    flex-shrink: 0;
}

.asbp-step-content h3 {
    margin-top: 0;
    margin-bottom: 8px;
}

.asbp-step-content code {
    background: #f1f1f1;
    padding: 2px 6px;
    border-radius: 3px;
}
</style>

<script>
function asbpTestAPIs() {
    document.getElementById('asbp-odds-api-status').innerHTML = '<strong>TheOddsAPI:</strong> <span class="asbp-status-loading">⏳ Testing...</span>';
    document.getElementById('asbp-openai-api-status').innerHTML = '<strong>OpenAI API:</strong> <span class="asbp-status-loading">⏳ Testing...</span>';
    
    // Test TheOddsAPI
    jQuery.post(ajaxurl, {
        action: 'asbp_test_odds_api',
        nonce: '<?php echo wp_create_nonce("asbp_test_nonce"); ?>'
    }, function(response) {
        if (response.success) {
            document.getElementById('asbp-odds-api-status').innerHTML = '<strong>TheOddsAPI:</strong> <span class="asbp-status-success">✅ Connected</span>';
        } else {
            document.getElementById('asbp-odds-api-status').innerHTML = '<strong>TheOddsAPI:</strong> <span class="asbp-status-error">❌ Failed: ' + response.data + '</span>';
        }
    });
    
    // Test OpenAI API
    jQuery.post(ajaxurl, {
        action: 'asbp_test_openai_api',
        nonce: '<?php echo wp_create_nonce("asbp_test_nonce"); ?>'
    }, function(response) {
        if (response.success) {
            document.getElementById('asbp-openai-api-status').innerHTML = '<strong>OpenAI API:</strong> <span class="asbp-status-success">✅ Connected</span>';
        } else {
            document.getElementById('asbp-openai-api-status').innerHTML = '<strong>OpenAI API:</strong> <span class="asbp-status-error">❌ Failed: ' + response.data + '</span>';
        }
    });
}
</script>