<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="asbp-container" id="asbp-main-app">
    <div class="asbp-loading" id="asbp-loading">
        <div class="asbp-spinner"></div>
        <p>Loading AI Sports Betting Picks...</p>
    </div>
    
    <?php if ($atts['show_pick_of_day'] === 'true'): ?>
    <!-- Pick of the Day Section -->
    <section class="asbp-pick-of-day-section">
        <h2 class="asbp-section-title">
            🌟 Pick of the Day
        </h2>
        
        <div id="asbp-pick-of-day-container">
            <!-- Pick of day will be loaded here via AJAX -->
        </div>
    </section>
    <?php endif; ?>
    
    <?php if ($atts['show_sports_selector'] === 'true'): ?>
    <!-- Sports Selection Section -->
    <section class="asbp-sports-section">
        <h2 class="asbp-section-title">
            Browse Picks by Sport
        </h2>
        
        <div class="asbp-sports-buttons" id="asbp-sports-buttons">
            <!-- Sports buttons will be loaded here -->
        </div>
    </section>
    
    <!-- Games List Section -->
    <section class="asbp-games-section" id="asbp-games-section" style="display: none;">
        <h3 class="asbp-games-title" id="asbp-games-title">Upcoming Games</h3>
        
        <div class="asbp-games-grid" id="asbp-games-grid">
            <!-- Games will be loaded here -->
        </div>
    </section>
    
    <!-- Generated Pick Section -->
    <section class="asbp-generated-pick-section" id="asbp-generated-pick-section" style="display: none;">
        <h3 class="asbp-section-title">Generated Pick</h3>
        <div id="asbp-generated-pick-container">
            <!-- Generated pick will be displayed here -->
        </div>
    </section>
    <?php endif; ?>
    
    <!-- Error Display -->
    <div class="asbp-error" id="asbp-error" style="display: none;">
        <div class="asbp-error-content">
            <span class="asbp-error-message" id="asbp-error-message"></span>
            <button type="button" class="asbp-retry-btn" onclick="asbpRetry()">Retry</button>
        </div>
    </div>
</div>

<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    asbpInitialize();
});

let asbpCurrentSport = '';
let asbpRetryAction = null;

function asbpInitialize() {
    asbpShowLoading();
    
    <?php if ($atts['show_pick_of_day'] === 'true'): ?>
    asbpLoadPickOfDay();
    <?php endif; ?>
    
    <?php if ($atts['show_sports_selector'] === 'true'): ?>
    asbpLoadSports();
    <?php endif; ?>
}

function asbpShowLoading() {
    document.getElementById('asbp-loading').style.display = 'block';
}

function asbpHideLoading() {
    document.getElementById('asbp-loading').style.display = 'none';
}

function asbpShowError(message, retryFn = null) {
    document.getElementById('asbp-error-message').textContent = message;
    document.getElementById('asbp-error').style.display = 'block';
    asbpRetryAction = retryFn;
    asbpHideLoading();
}

function asbpHideError() {
    document.getElementById('asbp-error').style.display = 'none';
}

function asbpRetry() {
    asbpHideError();
    if (asbpRetryAction) {
        asbpRetryAction();
    }
}

function asbpLoadPickOfDay() {
    jQuery.post(asbp_ajax.ajax_url, {
        action: 'asbp_get_pick_of_day',
        nonce: asbp_ajax.nonce
    }, function(response) {
        if (response.success && response.data) {
            asbpDisplayPickOfDay(response.data);
        } else {
            asbpShowError('Failed to load pick of the day', asbpLoadPickOfDay);
        }
        asbpHideLoading();
    }).fail(function() {
        asbpShowError('Failed to load pick of the day', asbpLoadPickOfDay);
        asbpHideLoading();
    });
}

function asbpDisplayPickOfDay(data) {
    const container = document.getElementById('asbp-pick-of-day-container');
    
    if (data.error) {
        container.innerHTML = '<div class="asbp-error-card"><p>' + data.error + '</p></div>';
        return;
    }
    
    const pick = data.pick;
    const confidenceColor = asbpGetConfidenceColor(pick.confidence_level);
    const confidenceText = asbpGetConfidenceText(pick.confidence_level);
    const gameDate = asbpFormatGameDate(pick.commence_time);
    const americanOdds = asbpFormatAmericanOdds(pick.odds);
    
    container.innerHTML = `
        <div class="asbp-pick-card asbp-pick-of-day">
            <div class="asbp-pick-header">
                <h3 class="asbp-game-title">${pick.home_team} vs ${pick.away_team}</h3>
                ${pick.commence_time ? `<p class="asbp-game-date">${gameDate}</p>` : ''}
            </div>
            
            <div class="asbp-pick-content">
                <div class="asbp-pick-details">
                    <div class="asbp-pick-item">
                        <span class="asbp-label">AI Pick:</span>
                        <span class="asbp-recommendation">${pick.recommendation} (${pick.pick_type.toUpperCase()})</span>
                    </div>
                    <div class="asbp-pick-item">
                        <span class="asbp-label">Odds:</span>
                        <span class="asbp-odds">${americanOdds}</span>
                        ${pick.sportsbook_display_name ? `<span class="asbp-sportsbook">${pick.sportsbook_display_name}</span>` : ''}
                    </div>
                </div>
                
                <div class="asbp-confidence-section">
                    <div class="asbp-confidence-header">
                        <span class="asbp-label">Confidence Level</span>
                        <span class="asbp-confidence-percent">${Math.round(pick.confidence_level * 100)}%</span>
                    </div>
                    <div class="asbp-confidence-bar">
                        <div class="asbp-confidence-fill ${confidenceColor}" style="width: ${pick.confidence_level * 100}%"></div>
                    </div>
                    <p class="asbp-confidence-text">${confidenceText}</p>
                </div>
            </div>
            
            <div class="asbp-analysis-section">
                <h4 class="asbp-analysis-title">AI Analysis</h4>
                <p class="asbp-analysis-text">${pick.analysis}</p>
            </div>
            
            <div class="asbp-featured-reason">
                <p><strong>Why this pick?</strong> ${data.featured_reason}</p>
            </div>
        </div>
    `;
}

function asbpLoadSports() {
    jQuery.post(asbp_ajax.ajax_url, {
        action: 'asbp_get_sports',
        nonce: asbp_ajax.nonce
    }, function(response) {
        if (response.success && response.data) {
            asbpDisplaySports(response.data);
        } else {
            asbpShowError('Failed to load sports', asbpLoadSports);
        }
    }).fail(function() {
        asbpShowError('Failed to load sports', asbpLoadSports);
    });
}

function asbpDisplaySports(sports) {
    const container = document.getElementById('asbp-sports-buttons');
    
    container.innerHTML = sports.map(sport => 
        `<button type="button" class="asbp-sport-btn" onclick="asbpSelectSport('${sport}')">${sport}</button>`
    ).join('');
}

function asbpSelectSport(sport) {
    asbpCurrentSport = sport;
    asbpHideError();
    
    // Update active button
    document.querySelectorAll('.asbp-sport-btn').forEach(btn => {
        btn.classList.remove('asbp-sport-btn-active');
    });
    event.target.classList.add('asbp-sport-btn-active');
    
    // Load games for this sport
    asbpLoadGames(sport);
}

function asbpLoadGames(sport) {
    asbpShowLoading();
    document.getElementById('asbp-games-section').style.display = 'none';
    document.getElementById('asbp-generated-pick-section').style.display = 'none';
    
    jQuery.post(asbp_ajax.ajax_url, {
        action: 'asbp_get_games',
        sport: sport,
        nonce: asbp_ajax.nonce
    }, function(response) {
        if (response.success && response.data) {
            asbpDisplayGames(response.data.games, sport);
        } else {
            asbpShowError('Failed to load games for ' + sport, function() { asbpLoadGames(sport); });
        }
        asbpHideLoading();
    }).fail(function() {
        asbpShowError('Failed to load games for ' + sport, function() { asbpLoadGames(sport); });
        asbpHideLoading();
    });
}

function asbpDisplayGames(games, sport) {
    const container = document.getElementById('asbp-games-grid');
    const titleElement = document.getElementById('asbp-games-title');
    
    titleElement.textContent = `Upcoming ${sport} Games`;
    
    if (!games || games.length === 0) {
        container.innerHTML = '<div class="asbp-no-games"><p>No games available for this sport at the moment.</p></div>';
    } else {
        container.innerHTML = games.map(game => {
            const gameDate = asbpFormatDate(game.commence_time);
            return `
                <div class="asbp-game-card">
                    <div class="asbp-game-info">
                        <h4 class="asbp-game-matchup">${game.home_team} vs ${game.away_team}</h4>
                        <p class="asbp-game-time">${gameDate}</p>
                    </div>
                    <button type="button" class="asbp-generate-pick-btn" onclick="asbpGeneratePick('${game.id}', '${sport}')">
                        Get AI Pick
                    </button>
                </div>
            `;
        }).join('');
    }
    
    document.getElementById('asbp-games-section').style.display = 'block';
}

function asbpGeneratePick(gameId, sport) {
    asbpShowLoading();
    asbpHideError();
    
    jQuery.post(asbp_ajax.ajax_url, {
        action: 'asbp_generate_pick',
        game_id: gameId,
        sport: sport,
        nonce: asbp_ajax.nonce
    }, function(response) {
        if (response.success && response.data) {
            asbpDisplayGeneratedPick(response.data.pick);
            // Scroll to generated pick
            setTimeout(function() {
                document.getElementById('asbp-generated-pick-section').scrollIntoView({ 
                    behavior: 'smooth', 
                    block: 'center' 
                });
            }, 100);
        } else {
            asbpShowError('Failed to generate pick for this game', function() { asbpGeneratePick(gameId, sport); });
        }
        asbpHideLoading();
    }).fail(function() {
        asbpShowError('Failed to generate pick for this game', function() { asbpGeneratePick(gameId, sport); });
        asbpHideLoading();
    });
}

function asbpDisplayGeneratedPick(pick) {
    const container = document.getElementById('asbp-generated-pick-container');
    const confidenceColor = asbpGetConfidenceColor(pick.confidence_level);
    const americanOdds = asbpFormatAmericanOdds(pick.odds);
    
    container.innerHTML = `
        <div class="asbp-pick-card asbp-generated-pick">
            <div class="asbp-pick-header">
                <h4 class="asbp-game-title">${pick.home_team} vs ${pick.away_team}</h4>
            </div>
            
            <div class="asbp-pick-content">
                <div class="asbp-pick-details">
                    <div class="asbp-pick-item">
                        <span class="asbp-label">AI Pick:</span>
                        <span class="asbp-recommendation">${pick.recommendation} (${pick.pick_type.toUpperCase()})</span>
                    </div>
                    <div class="asbp-pick-item">
                        <span class="asbp-label">Odds:</span>
                        <span class="asbp-odds">${americanOdds}</span>
                        ${pick.sportsbook_display_name ? `<span class="asbp-sportsbook">${pick.sportsbook_display_name}</span>` : ''}
                    </div>
                </div>
                
                <div class="asbp-confidence-section">
                    <div class="asbp-confidence-header">
                        <span class="asbp-label">Confidence</span>
                        <span class="asbp-confidence-percent">${Math.round(pick.confidence_level * 100)}%</span>
                    </div>
                    <div class="asbp-confidence-bar">
                        <div class="asbp-confidence-fill ${confidenceColor}" style="width: ${pick.confidence_level * 100}%"></div>
                    </div>
                </div>
            </div>
            
            <div class="asbp-analysis-section">
                <h5 class="asbp-analysis-title">Analysis</h5>
                <p class="asbp-analysis-text">${pick.analysis}</p>
            </div>
        </div>
    `;
    
    document.getElementById('asbp-generated-pick-section').style.display = 'block';
}

// Utility functions
function asbpGetConfidenceColor(confidence) {
    if (confidence >= 0.8) return 'asbp-confidence-high';
    if (confidence >= 0.6) return 'asbp-confidence-medium';
    return 'asbp-confidence-low';
}

function asbpGetConfidenceText(confidence) {
    if (confidence >= 0.8) return 'High Confidence';
    if (confidence >= 0.6) return 'Medium Confidence';
    return 'Low Confidence';
}

function asbpFormatAmericanOdds(odds) {
    if (!odds) return 'N/A';
    return odds > 0 ? '+' + odds : odds.toString();
}

function asbpFormatDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('en-US', {
        weekday: 'short',
        month: 'short',
        day: 'numeric',
        hour: 'numeric',
        minute: '2-digit',
    });
}

function asbpFormatGameDate(dateString) {
    const date = new Date(dateString);
    return date.toLocaleDateString('en-US', {
        weekday: 'long',
        month: 'long',
        day: 'numeric',
        year: 'numeric',
    });
}
</script>