<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="asbp-pick-of-day-widget" id="asbp-pod-widget">
    <div class="asbp-loading asbp-loading-small" id="asbp-pod-loading">
        <div class="asbp-spinner asbp-spinner-small"></div>
        <p>Loading pick of the day...</p>
    </div>
    
    <div id="asbp-pod-content">
        <!-- Pick of day content will be loaded here -->
    </div>
    
    <div class="asbp-error asbp-error-small" id="asbp-pod-error" style="display: none;">
        <span class="asbp-error-message" id="asbp-pod-error-message"></span>
        <button type="button" class="asbp-retry-btn asbp-retry-btn-small" onclick="asbpPodRetry()">Retry</button>
    </div>
</div>

<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    asbpLoadPickOfDayWidget();
});

function asbpLoadPickOfDayWidget() {
    document.getElementById('asbp-pod-loading').style.display = 'block';
    document.getElementById('asbp-pod-error').style.display = 'none';
    
    jQuery.post(asbp_ajax.ajax_url, {
        action: 'asbp_get_pick_of_day',
        nonce: asbp_ajax.nonce
    }, function(response) {
        if (response.success && response.data) {
            asbpDisplayPickOfDayWidget(response.data);
        } else {
            asbpShowPickOfDayError('Failed to load pick of the day');
        }
        document.getElementById('asbp-pod-loading').style.display = 'none';
    }).fail(function() {
        asbpShowPickOfDayError('Failed to load pick of the day');
        document.getElementById('asbp-pod-loading').style.display = 'none';
    });
}

function asbpDisplayPickOfDayWidget(data) {
    const container = document.getElementById('asbp-pod-content');
    
    if (data.error) {
        container.innerHTML = '<div class="asbp-error-message">' + data.error + '</div>';
        return;
    }
    
    const pick = data.pick;
    const confidenceColor = asbpGetConfidenceColorWidget(pick.confidence_level);
    const americanOdds = asbpFormatAmericanOddsWidget(pick.odds);
    const gameDate = asbpFormatGameDateWidget(pick.commence_time);
    
    container.innerHTML = `
        <div class="asbp-pod-card">
            <div class="asbp-pod-header">
                <h3 class="asbp-pod-title">🌟 Pick of the Day</h3>
            </div>
            
            <div class="asbp-pod-game">
                <h4 class="asbp-pod-matchup">${pick.home_team} vs ${pick.away_team}</h4>
                ${pick.commence_time ? `<p class="asbp-pod-date">${gameDate}</p>` : ''}
            </div>
            
            <div class="asbp-pod-pick">
                <div class="asbp-pod-recommendation">
                    <strong>${pick.recommendation}</strong> (${pick.pick_type.toUpperCase()})
                </div>
                <div class="asbp-pod-odds">
                    ${americanOdds}
                    ${pick.sportsbook_display_name ? `<span class="asbp-pod-sportsbook">${pick.sportsbook_display_name}</span>` : ''}
                </div>
            </div>
            
            <div class="asbp-pod-confidence">
                <div class="asbp-pod-confidence-label">
                    Confidence: <strong>${Math.round(pick.confidence_level * 100)}%</strong>
                </div>
                <div class="asbp-pod-confidence-bar">
                    <div class="asbp-pod-confidence-fill ${confidenceColor}" style="width: ${pick.confidence_level * 100}%"></div>
                </div>
            </div>
            
            <div class="asbp-pod-analysis">
                <p>${pick.analysis}</p>
            </div>
        </div>
    `;
}

function asbpShowPickOfDayError(message) {
    document.getElementById('asbp-pod-error-message').textContent = message;
    document.getElementById('asbp-pod-error').style.display = 'block';
}

function asbpPodRetry() {
    document.getElementById('asbp-pod-error').style.display = 'none';
    asbpLoadPickOfDayWidget();
}

// Widget-specific utility functions
function asbpGetConfidenceColorWidget(confidence) {
    if (confidence >= 0.8) return 'asbp-pod-confidence-high';
    if (confidence >= 0.6) return 'asbp-pod-confidence-medium';
    return 'asbp-pod-confidence-low';
}

function asbpFormatAmericanOddsWidget(odds) {
    if (!odds) return 'N/A';
    return odds > 0 ? '+' + odds : odds.toString();
}

function asbpFormatGameDateWidget(dateString) {
    if (!dateString) return '';
    const date = new Date(dateString);
    return date.toLocaleDateString('en-US', {
        weekday: 'short',
        month: 'short',
        day: 'numeric',
    });
}
</script>