<?php
if (!defined('ABSPATH'))
{
    exit;
}


function tooltips_pdf_viwer_control_meta_box()
{
    global $post;
    
    if ($post->post_type == 'tooltips')
    {
        add_meta_box("tooltips_pdf_viwer_control_meta_box_id", __( 'Insert PDF viwer into tooltips', 'wordpress-tooltips' ), 'content_tooltips_pdf_viwer_control_meta_box', null, "side", "high", null);
    }
}


function content_tooltips_pdf_viwer_control_meta_box()
{
    global $wpdb, $post;
    $current_page_id = get_the_ID();
    
    $get_post_meta_value_full_video_url = get_post_meta($current_page_id, 'toolstipsfullpdfurl', true);
    $get_post_meta_value_full_video_url =  trim($get_post_meta_value_full_video_url);
    
    $get_post_meta_value_pdf_viewer_height = get_post_meta($current_page_id, 'toolstipspdfheight', true);
    $get_post_meta_value_pdf_viewer_height = trim($get_post_meta_value_pdf_viewer_height);
    
    if (empty($get_post_meta_value_pdf_viewer_height))
    {
        $get_post_meta_value_pdf_viewer_height = '400px';
    }
    
    $get_post_meta_value_pdf_viewer_width = get_post_meta($current_page_id, 'toolstipspdfwidth', true);
    $get_post_meta_value_pdf_viewer_width = trim($get_post_meta_value_pdf_viewer_width);
    if (empty($get_post_meta_value_pdf_viewer_width))
    {
        $get_post_meta_value_pdf_viewer_width = '315px';
    }
    
    ?>
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
	    <tbody>
	    <tr class="form-field">
	        <td>
	        	<p>
				<?php
					echo __("PDF URL", "wordpress-tooltips");
				?>	        	
	        	</p>
				<input type="text" id="toolstipsfullpdfurl" name="toolstipsfullpdfurl" value="<?php echo $get_post_meta_value_full_video_url;  ?>">
				<p style="color:gray;font-size:12px;"><i>https://www.yourdomain.com/wp-content/uploads/un.pdf</i></p>
					        
				<p style="margin-top:10px;">
				PDF Viwer Height<font color='gray'><i>(px)</i></font>
				</p>	
				<p>
				<input type="text" id="toolstipspdfheight" name="toolstipspdfheight" value="<?php echo $get_post_meta_value_pdf_viewer_height;  ?>">
				</p>
				
				<p style="margin-top:10px;">
				PDF Viwer Width<font color='gray'><i>(px)</i></font>
				</p>
				<p>
				<input type="text" id="toolstipspdfwidth" name="toolstipspdfwidth" value="<?php echo $get_post_meta_value_pdf_viewer_width;  ?>">
				</p>
	        </td>
	    </tr>
	    </tbody>
	</table>
	<?php
}

function save_content_tooltips_pdf_viwer_control_meta_box($post_id, $post, $update)
{
	global $post;

	$current_page_id = get_the_ID();

	$get_post_meta_value_full_video_url = get_post_meta($current_page_id, 'toolstipsfullpdfurl', true);
	$get_post_meta_value_pdf_viewer_height = get_post_meta($current_page_id, 'toolstipspdfheight', true);
	$get_post_meta_value_pdf_viewer_height = trim($get_post_meta_value_pdf_viewer_height);
	$get_post_meta_value_pdf_viewer_width = get_post_meta($current_page_id, 'toolstipspdfwidth', true);
	$get_post_meta_value_pdf_viewer_width = trim($get_post_meta_value_pdf_viewer_width);

	if(isset($_POST['toolstipsfullpdfurl']) != "") {
		$meta_box_checkbox_value = $_POST['toolstipsfullpdfurl'];
		update_post_meta( $current_page_id, 'toolstipsfullpdfurl', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'toolstipsfullpdfurl', '' );
	}
	

	if(isset($_POST['toolstipspdfheight']) != "") {
		$meta_box_checkbox_value = $_POST['toolstipspdfheight'];
		update_post_meta( $current_page_id, 'toolstipspdfheight', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'toolstipspdfheight', '' );
	}

	if(isset($_POST['toolstipspdfwidth']) != "") {
		$meta_box_checkbox_value = $_POST['toolstipspdfwidth'];
		update_post_meta( $current_page_id, 'toolstipspdfwidth', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'toolstipspdfwidth', '' );
	}
}

$tooltipHookPriorityValue = get_option("tooltipHookPriorityValue");
if (empty($tooltipHookPriorityValue))
{
    $tooltipHookPriorityValue = 10;
}

$tooltipHookPriorityValuePlus = $tooltipHookPriorityValue +1;

function functooltipspdfviwer($m_content)
{
    global $post;
    
    if ($post->post_type == 'tooltips')
    {
        //16.1.8 tooltip pdf viewer
        if (is_object($post))
        {
            $tooltip_post_id = $post->ID;
            $get_post_meta_value_full_pdf_url = get_post_meta($tooltip_post_id, 'toolstipsfullpdfurl', true);
            $get_post_meta_value_full_pdf_url = trim($get_post_meta_value_full_pdf_url);
            
            $get_post_meta_value_pdf_height = get_post_meta($tooltip_post_id, 'toolstipspdfheight', true);
            
            $get_post_meta_value_pdf_height = trim($get_post_meta_value_pdf_height);
            if (empty($get_post_meta_value_pdf_height))
            {
                $get_post_meta_value_pdf_height = '100%';
            }
            
            $get_post_meta_value_pdf_width = get_post_meta($tooltip_post_id, 'toolstipspdfwidth', true);
            $get_post_meta_value_pdf_width = trim($get_post_meta_value_pdf_width);
            if (empty($get_post_meta_value_pdf_width))
            {
                $get_post_meta_value_pdf_width = '100%';
            }
            
            if (!(empty($get_post_meta_value_full_pdf_url)))
            {
                $tooltipspdfcode = "<div class='tooltips_youtube_class' >". "<iframe width='".esc_html($get_post_meta_value_pdf_width)."' height='$get_post_meta_value_pdf_height'  src='$get_post_meta_value_full_pdf_url' frameborder='0' allowfullscreen></iframe>"."</div>";
                $m_content = $m_content.$tooltipspdfcode;
            }
        }

        //end 16.1.8
    }
    return $m_content;
}
add_filter('the_content','functooltipspdfviwer',$tooltipHookPriorityValuePlus,1);

add_action( 'add_meta_boxes',  'tooltips_pdf_viwer_control_meta_box' );
add_action( 'save_post', 'save_content_tooltips_pdf_viwer_control_meta_box' , 10, 3);


