<?php
if (!defined('ABSPATH'))
{
    exit;
}


function tooltips_soundcloud_control_meta_box()
{
    global $post;
    
    if ($post->post_type == 'tooltips')
    {
        add_meta_box("tooltips_soundcloud_control_meta_box_id", __( 'SoundCloud Tooltips', 'wordpress-tooltips' ), 'content_tooltips_soundcloud_control_meta_box', null, "side", "high", null);
    }
}


function content_tooltips_soundcloud_control_meta_box()
{
    global $wpdb, $post;
    $current_page_id = get_the_ID();
    
    $get_post_meta_value_full_soundcloud_url = get_post_meta($current_page_id, 'toolstipssoundcloudurl', true);
    $get_post_meta_value_full_soundcloud_url =  trim($get_post_meta_value_full_soundcloud_url);
    
    $get_post_meta_value_soundcloud_height = get_post_meta($current_page_id, 'toolstipssoundcloudheight', true);
    $get_post_meta_value_soundcloud_height = trim($get_post_meta_value_soundcloud_height);
    
    if (empty($get_post_meta_value_soundcloud_height))
    {
        $get_post_meta_value_soundcloud_height = '400px';
    }
    
    $get_post_meta_value_soundcloud_width = get_post_meta($current_page_id, 'toolstipssoundcloudwidth', true);
    $get_post_meta_value_soundcloud_width = trim($get_post_meta_value_soundcloud_width);
    if (empty($get_post_meta_value_soundcloud_width))
    {
        $get_post_meta_value_soundcloud_width = '315px';
    }
    
    ?>
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
	    <tbody>
	    <tr class="form-field">
	        <td>
	        	<p>
				<?php
					echo __("SoundCloud URL", "wordpress-tooltips");
				?>	        	
	        	</p>
				<input type="text" id="toolstipssoundcloudurl" name="toolstipssoundcloudurl" value="<?php echo $get_post_meta_value_full_soundcloud_url;  ?>">
				<p style="color:gray;font-size:12px;"><i>http://soundcloud.com/yourmusicurl/</i></p>
					        
				<p style="margin-top:10px;">
				SoundCloud Player Height<font color='gray'><i>(px)</i></font>
				</p>	
				<p>
				<input type="text" id="toolstipssoundcloudheight" name="toolstipssoundcloudheight" value="<?php echo $get_post_meta_value_soundcloud_height;  ?>">
				</p>
				
				<p style="margin-top:10px;">
				SoundCloud Player Width<font color='gray'><i>(px)</i></font>
				</p>
				<p>
				<input type="text" id="toolstipssoundcloudwidth" name="toolstipssoundcloudwidth" value="<?php echo $get_post_meta_value_soundcloud_width;  ?>">
				</p>
	        </td>
	    </tr>
	    </tbody>
	</table>
	<?php
}

function save_content_tooltips_soundcloud_control_meta_box($post_id, $post, $update)
{
	global $post;

	$current_page_id = get_the_ID();

	$get_post_meta_value_full_soundcloud_url = get_post_meta($current_page_id, 'toolstipssoundcloudurl', true);
	$get_post_meta_value_soundcloud_height = get_post_meta($current_page_id, 'toolstipssoundcloudheight', true);
	$get_post_meta_value_soundcloud_height = trim($get_post_meta_value_soundcloud_height);
	$get_post_meta_value_soundcloud_width = get_post_meta($current_page_id, 'toolstipssoundcloudwidth', true);
	$get_post_meta_value_soundcloud_width = trim($get_post_meta_value_soundcloud_width);

	if(isset($_POST['toolstipssoundcloudurl']) != "") {
		$meta_box_checkbox_value = $_POST['toolstipssoundcloudurl'];
		update_post_meta( $current_page_id, 'toolstipssoundcloudurl', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'toolstipssoundcloudurl', '' );
	}
	

	if(isset($_POST['toolstipssoundcloudheight']) != "") {
		$meta_box_checkbox_value = $_POST['toolstipssoundcloudheight'];
		update_post_meta( $current_page_id, 'toolstipssoundcloudheight', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'toolstipssoundcloudheight', '' );
	}

	if(isset($_POST['toolstipssoundcloudwidth']) != "") {
		$meta_box_checkbox_value = $_POST['toolstipssoundcloudwidth'];
		update_post_meta( $current_page_id, 'toolstipssoundcloudwidth', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'toolstipssoundcloudwidth', '' );
	}
}

$tooltipHookPriorityValue = get_option("tooltipHookPriorityValue");
if (empty($tooltipHookPriorityValue))
{
    $tooltipHookPriorityValue = 10;
}

$tooltipHookPriorityValuePlus = $tooltipHookPriorityValue +1;

function functooltipssoundcloud($m_content)
{
    global $post;
    
    if ($post->post_type == 'tooltips')
    {
        if (is_object($post))
        {
            $tooltip_post_id = $post->ID;
            $get_post_meta_value_soundcloud_url = get_post_meta($tooltip_post_id, 'toolstipssoundcloudurl', true);
            $get_post_meta_value_soundcloud_url = trim($get_post_meta_value_soundcloud_url);
            
            $get_post_meta_value_soundcloud_height = get_post_meta($tooltip_post_id, 'toolstipssoundcloudheight', true);
            
            $get_post_meta_value_soundcloud_height = trim($get_post_meta_value_soundcloud_height);
            if (empty($get_post_meta_value_soundcloud_height))
            {
                $get_post_meta_value_soundcloud_height = '100%';
            }
            
            $get_post_meta_value_soundcloud_width = get_post_meta($tooltip_post_id, 'toolstipssoundcloudwidth', true);
            $get_post_meta_value_soundcloud_width = trim($get_post_meta_value_soundcloud_width);
            if (empty($get_post_meta_value_soundcloud_width))
            {
                $get_post_meta_value_soundcloud_width = '100%';
            }
            
            if (!(empty($get_post_meta_value_soundcloud_url)))
            {
                $soundcloud_options = array(
                    'url'   => $get_post_meta_value_soundcloud_url,
                    'auto_play'  => 'false',
                    'show_comments' => 'false',
                    'visual' => 'false',
                );
                
                $get_post_meta_value_soundcloud_url_full = 'https://w.soundcloud.com/player?' . http_build_query($soundcloud_options);
                //$get_post_meta_value_soundcloud_url
                $tooltipssoundcloudcode = "<div class='tooltips_youtube_class' >". "<iframe width='".esc_html($get_post_meta_value_soundcloud_width)."' height='$get_post_meta_value_soundcloud_height'  src='$get_post_meta_value_soundcloud_url_full' frameborder='0' allowfullscreen></iframe>"."</div>";
                $m_content = $m_content.$tooltipssoundcloudcode;
            }
        }

        //end 16.1.8
    }
    return $m_content;
}
add_filter('the_content','functooltipssoundcloud',$tooltipHookPriorityValuePlus,1);

add_action( 'add_meta_boxes',  'tooltips_soundcloud_control_meta_box' );
add_action( 'save_post', 'save_content_tooltips_soundcloud_control_meta_box' , 10, 3);


