<?php
if (!defined('ABSPATH'))
{
	exit;
}


function alt_tooltips_content($content)
{
    global $post;
    $pattern = '/<img.*?alt="(.*?)"[^>]+>/';
    preg_match_all($pattern, $content, $matches);
    if (!(empty($matches[1])))
    {
        foreach ($matches[1] as $key => $alt)
        {
            $new_alt = do_shortcode($alt);
            $changed_alt = str_replace($alt,$new_alt,$matches[0][$key]);
            $content = str_replace($matches[0][$key], $changed_alt, $content);
        }
    }
    return $content;
}

add_filter('the_content','alt_tooltips_content');

//21.3.8


function rel_tooltips_content($content)
{
    global $post;
    $pattern = '/<img.*?rel="(.*?)"[^>]+>/';
    preg_match_all($pattern, $content, $matches);
    if (!(empty($matches[1])))
    {
        foreach ($matches[1] as $key => $alt)
        {
            $new_alt = do_shortcode($alt);
            $changed_alt = str_replace($alt,$new_alt,$matches[0][$key]);
            $content = str_replace($matches[0][$key], $changed_alt, $content);
        }
    }
    return $content;
}

add_filter('the_content','rel_tooltips_content');


//20.8.8
function tomas_tooltip_content_by_id_shortcode_pro($atts, $content = null)
{
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    
    $keyword = '';
    extract(shortcode_atts(array(
        'tooltip_id' => __("Proper Shortcode Usage is: <div>[tt_content_by_id tooltip_id='1']</div>", 'wordpress-tooltips')
    ), $atts));
    
    $tooltip_id = (int) $tooltip_id;
    
    if (! (is_int($tooltip_id))) {
        return false;
    }
    
    $tooltip_id_post = tooltips_get_by_id_pro($tooltip_id);
    
    if ($tooltip_id_post == false) {
        return false;
    }
    
    if ((! (empty($tooltip_id_post))) && (is_array($tooltip_id_post)) && (count($tooltip_id_post) > 0)) 
    {
        $content = $tooltip_id_post['content'];
        $content = base64_encode($content);
        $content = 'tooltips-'.$content;
        
        return $content;
    }
    return false;
}

add_shortcode('tt_content_by_id', 'tomas_tooltip_content_by_id_shortcode_pro');

