<?php
if (!defined('ABSPATH'))
{
	exit;
}


function get_tooltips_search_form( $args = array() ) {
	do_action( 'pre_get_search_form' );

	$echo = true;
	if ( ! is_array( $args ) ) {
		$echo = (bool) $args;
		$args = array();
	}

	$defaults = array(
			'echo'       => $echo,
			'aria_label' => '',
	);

	$args = wp_parse_args( $args, $defaults );

	$args = apply_filters( 'search_form_args', $args );

	$format = current_theme_supports( 'html5', 'search-form' ) ? 'html5' : 'xhtml';
	$format = apply_filters( 'search_form_format', $format );

	//!!! no need $search_form_template = locate_template( 'searchform.php' );
	$search_form_template = '';

	if ( '' != $search_form_template ) 
	{
		ob_start();
		require( $search_form_template );
		$form = ob_get_clean();
	}
	else 
	{
		if ( isset( $args['aria_label'] ) && $args['aria_label'] ) 
		{
			$aria_label = 'aria-label="' . esc_attr( $args['aria_label'] ) . '" ';
		} 
		else 
		{
			$aria_label = '';
		}
		
		//!!!start
		/*
		$tooltips_html5_search_buttons =  '<span class="span-back-all-button">';
		$tooltips_html5_search_buttons .= '<input type="submit" class="button-back-all-button-submit" value="' . esc_attr_x( 'Reset', 'submit button' ) . '" />';
		$tooltips_html5_search_buttons .=   '</span>';
		$tooltips_html5_search_buttons .=  '<span class="screen-tooltips-button">';
		$tooltips_html5_search_buttons .= '<input type="search" class="tooltip-search-field" placeholder="' . esc_attr_x( 'Search &hellip;', 'placeholder' ) . '" value="' . get_search_query() . '" name="ts" />';
		$tooltips_html5_search_buttons .=   '</span>';

		
		$tooltips_non_html5_search_buttons =  '<span class="back-all-button">';
		$tooltips_non_html5_search_buttons .= '<input type="submit" class="button-back-all-button-submit" value="' . esc_attr_x( 'Reset', 'submit button' ) . '" />';
		$tooltips_non_html5_search_buttons .=   '</span>';
		$tooltips_non_html5_search_buttons .=  '<span class="screen-tooltips-button">';
		$tooltips_non_html5_search_buttons .= '<input class="tooltip-search-field" type="text" value="' . get_search_query() . '" name="ts" id="s" />';
		$tooltips_non_html5_search_buttons .=   '</span>';
		*/
		
		if (isset($_GET['ts']))
		{
			$tooltips_html5_search_buttons =  '<span class="span-back-all-button">';
			$tooltips_html5_search_buttons .= '<input type="submit" style="background-color:gray; color:#999;" class="button-back-all-button-submit" value="' . esc_attr_x( 'Reset', 'submit button' ) . '" name="rs"  />';
			$tooltips_html5_search_buttons .=   '</span>';
			$tooltips_html5_search_buttons .=  '<span class="screen-tooltips-button">';
			$tooltips_html5_search_buttons .= '<input type="submit" class="tooltip-search-submit" value="' . esc_attr_x( 'Search', 'submit button' ) . '" />';
			$tooltips_html5_search_buttons .=   '</span>';			
		}
		else 
		{
			$tooltips_html5_search_buttons = '<input type="submit" class="tooltip-search-submit" value="' . esc_attr_x( 'Search', 'submit button' ) . '" />';
		}
		
		if (isset($_GET['ts']))
		{
			$tooltips_non_html5_search_buttons =  '<span class="back-all-button">';
			$tooltips_non_html5_search_buttons .= '<input type="submit"  style="background-color:gray; color:#999;" class="button-back-all-button-submit" value="' . esc_attr_x( 'Reset', 'submit button' ) . '"  name="rs" />';
			$tooltips_non_html5_search_buttons .=   '</span>';
			$tooltips_non_html5_search_buttons .=  '<span class="screen-tooltips-button">';
			$tooltips_non_html5_search_buttons .= '<input class="tooltip-search-submit" type="submit" id="searchsubmit" value="' . esc_attr_x( 'Search', 'submit button' ) . '" />';
			$tooltips_non_html5_search_buttons .=   '</span>';
		}
		else
		{
			$tooltips_non_html5_search_buttons = '<input class="tooltip-search-submit" type="submit" id="searchsubmit" value="' . esc_attr_x( 'Search', 'submit button' ) . '" />';
		}
		
		//!!!end
		if ( 'html5' == $format ) 
		{
			/*
			$form = '<form role="search" ' . $aria_label . 'method="get" class="tooltip-search-form" action="' . '' . '">
				<label class="tooltip-search-label">
					<span class="screen-reader-text">' . _x( 'Search for:', 'label' ) . '</span>
					<input type="search" class="tooltip-search-field" placeholder="' . esc_attr_x( 'Search &hellip;', 'placeholder' ) . '" value="' . get_search_query() . '" name="ts" />
				</label>
				<input type="submit" class="tooltip-search-submit" value="' . esc_attr_x( 'Search', 'submit button' ) . '" />
			</form>';
			*/
			$form = '<form role="search" ' . $aria_label . 'method="get" class="tooltip-search-form" action="' . '' . '">
				<label class="tooltip-search-label">
					<span class="screen-reader-text">' . _x( 'Search for:', 'label' ) . '</span>
					<input type="search" class="tooltip-search-field" placeholder="' . esc_attr_x( 'Search &hellip;', 'placeholder' ) . '" value="' . get_search_query() . '" name="ts" />
				</label>'
				. $tooltips_html5_search_buttons .
			'</form>';
			
		} 
		else 
		{
			/*
			$form = '<form role="search" ' . $aria_label . 'method="get" id="searchform" class="tooltip-search-form" action="' . '' . '">
				<div class="tooltip-search-label">
					<label class="screen-reader-text" for="s">' . _x( 'Search for:', 'label' ) . '</label>
					<input class="tooltip-search-field" type="text" value="' . get_search_query() . '" name="ts" id="s" />
					<input class="tooltip-search-submit" type="submit" id="searchsubmit" value="' . esc_attr_x( 'Search', 'submit button' ) . '" />
				</div>
			</form>';
			*/
			$form = '<form role="search" ' . $aria_label . 'method="get" id="searchform" class="tooltip-search-form" action="' . '' . '">
				<div class="tooltip-search-label">
					<label class="screen-reader-text" for="s">' . _x( 'Search for:', 'label' ) . '</label>
					<input class="tooltip-search-field" type="text" value="' . get_search_query() . '" name="ts" id="s" />'
					.$tooltips_non_html5_search_buttons .
				'</div>
			</form>';
		}		
	}
	$result = apply_filters( 'get_search_form', $form );

	if ( null === $result ) {
		$result = $form;
	}

	if ( isset( $args['echo'] ) && $args['echo'] ) {
		echo $result;
	} else {
		return $result;
	}
}


