<?php

if (! defined('ABSPATH')) {
    exit();
}

function ttfa_load_font_awesome() {
	wp_enqueue_style( 'font-awesome',TOOLTIP_PLUGIN_URL.'/rules/tt-font-awesome/fontawesome/css/all.css' );
}
add_action( 'wp_enqueue_scripts', 'ttfa_load_font_awesome' );


add_filter('wp_nav_menu_items', 'do_shortcode');
add_filter('widget_text', 'do_shortcode');
add_filter('widget_title', 'do_shortcode');



function ttfa_shortcode_pro( $atts ) 
{
	

	if (tooltips_pro_disable_tooltip_in_mobile())
	{
		return '';
	}

	$keyword = '';
	
	extract( shortcode_atts( array( 'tooltip_id' => '', 'icon' => 'heart', 'size' => '', 'color' => '', 'set' => '' ), $atts ) );
	
	$tooltip_id = (INT) $tooltip_id;
	
	if (!(is_int($tooltip_id)))
	{
		return false;
	}
	//!!! this section will allow users inter content, so id can be ignored in future version

	if ( $size )
	{
		$size = esc_attr(' fa-'.$size);
	}
	else
	{
		$size = '';
	}
	
	if ( $color )
	{
		$color = ' color: '.esc_attr($color) . '; ' ;
	}
	else
	{
		$color = '';
	}
	
	$set = esc_attr($set);
	
	$icon = str_ireplace('fa-', '', $icon);
	$icon = esc_attr($icon);
	$icon = 'fa-'.$icon;
	
	
	$iconcontent = '<i class="'.$set.' '.$icon . ' " '.' style="'.$color.'"> '.'</i>';
	
	$tooltip_id_post = tooltips_get_by_id_pro($tooltip_id);
	
	if ($tooltip_id_post == false)
	{
		return false;
	}
	
	if ((!(empty($tooltip_id_post))) && (is_array($tooltip_id_post)) && (count($tooltip_id_post) >0))
	{
		$keyword = $tooltip_id_post['keyword'];
		$content = $tooltip_id_post['content'];
	}
	
	if (!empty(trim($iconcontent)))
	{
		$keyword = $iconcontent;
	}
	
	$m_keyword_result = '';
	$keywordmd = $tooltip_id;
	
	$m_replace = "<span class='tooltipsall tooltip_post_id_custom_icon_$keywordmd classtoolTipsCustomShortCodeOnlyForMultiTooltips'>$iconcontent</span>";
	$m_keyword_result .= $m_replace;
	
	return $m_keyword_result;
			
}
add_shortcode( 'ttfa', 'ttfa_shortcode_pro' );

