<?php
if (!defined('ABSPATH'))
{
	exit;
}

function tooltipsExport()
{
?>
<div class="wrap tooltipsaddonclass">
	<h2>
	<?php
		echo __("Export Tooltips", "wordpress-tooltips");
	?>
	</h2>
	<table class="wp-list-table widefat fixed" style="margin-top:20px;">
		<tr><td>
    			<form action="" method="POST">			
    			<h3><?php echo __("Export tooltips to csv", "wordpress-tooltips"); ?></h3>
    			<?php 
    			wp_nonce_field ( 'tooltipsexportcsvnonce' );
    			?>
			    <div style="margin-top:30px !important;margin-bottom:30px  !important;">
   				<input type="submit" value=" <?php echo __("Export", "wordpress-tooltips"); ?> " name="export_tooltips" />
    			</div>
			</form>
			<div>
			<hr />
				<h4>Please note:</h4>
				<div style="margin-bottom:10px;">
				<span style="color:#888;">#1</span> In EXPORT.csv, there are two fields, "tooltips term" and "tooltips content", title of tooltips will be exported as "tooltips term", and content of tooltips will be exported as "tooltips content".  
				</div>
				<div style="margin-bottom:10px;">
				<span style="color:#888;">#2</span> We just export tooltips term and tooltips content automatically, related settings of tooltips will not be exported, you still need finish settings of tooltips manually</span> 
				</div>
			</div>
		</td></tr>
	</table>
<?php
}

function tooltipsExportCSV()
{
	global $wpdb,$table_prefix;

	if (isset($_POST['export_tooltips']))
	{
		check_admin_referer ( 'tooltipsexportcsvnonce' );	
		header('Content-type: application/csv');
		header('Content-Disposition: attachment; filename="export.csv"');
		$post_table = $wpdb->prefix . 'posts';
		$m_tooltipSql = "SELECT `post_title`, `post_content` FROM `".$post_table."` WHERE `post_status` = 'publish' and `post_type` = 'tooltips'";
		$m_tooltipResult = $wpdb->get_results($m_tooltipSql,ARRAY_A);
		$m_showExcelHead = "tooltips term,tooltips content";
	
		if (empty($m_tooltipResult))
		{
			die(0);
		}
			
		$m_first_name = 'tooltips term';
		$m_second_name = 'tooltips content';
			
		echo $m_first_name.',';
		echo $m_second_name;
		echo "\n";
		
		foreach ($m_tooltipResult as $tooltips_exporting)
		{
			$m_first_name = $tooltips_exporting['post_title'];
			$m_second_name = $tooltips_exporting['post_content'];
			
			$m_first_name = str_replace('"', '\"', $m_first_name);
			$m_second_name = str_replace('"', '\"', $m_second_name);
			
			echo "\"$m_first_name\",";
			echo "\"$m_second_name\",";
			echo "\n";
		}
		die(0);
	}
}

add_action('init', 'tooltipsExportCSV');

