<?php
/*
 * Plugin Name: Tooltips Pro Plus
 * Plugin URI: https://tooltips.org/
 * Description: Tooltips Pro Multisite License
 * Version: 31.3.8
 * Author: Tomas Zhu
 * Author URI: https://tooltips.org/
 * Text Domain: wordpress-tooltips
 * License: GPLv3
 */
/*                                                                                  
 * Copyright 2011 - 2024 Tomas Zhu https://tooltips.org/
 * This program comes with ABSOLUTELY NO WARRANTY;
 * https://www.gnu.org/licenses/gpl-3.0.html
 * https://www.gnu.org/licenses/quick-guide-gplv3.html
 */
/* Wordpress Tooltips Pro Multi-Site License */
if (! defined('ABSPATH')) {
    exit();
}

define('TOOLTIPS_PRO_PLUGIN_PATH', plugin_dir_path(__FILE__));
define('TOOLTIPS_ADDONS_PATH', plugin_dir_path(__FILE__) . 'addons' . '/');
define('TOOLTIPS_PRO_ADMIN_PATH', plugin_dir_path(__FILE__) . 'admin' . '/');
define('TOOLTIP_VERSION', '31.3.8');
define('TOOLTIP_PLUGIN_URL', plugin_dir_url(__FILE__));

require_once (ABSPATH . 'wp-admin/includes/plugin.php');
if (is_plugin_active('wordpress-tooltips/tooltips.php')) {
    deactivate_plugins(('wordpress-tooltips/tooltips.php'));
}

function upgrade_under_3_check()
{
    $currentVersion = get_option('ztooltipversion');

    if (empty($currentVersion)) {
        $m_result = get_option('tooltipsarray');
        if (! (empty($m_result))) {
            $m_keyword_id = 0;
            foreach ($m_result as $m_single) {
                $m_keyword = $m_single['keyword'];
                $m_content = $m_single['content'];
                $my_post = array(
                    'post_title' => $m_keyword,
                    'post_content' => $m_content,
                    'post_status' => 'publish',
                    'post_type' => 'tooltips',
                    'post_author' => 1
                );
                wp_insert_post($my_post);
            }
            // !!! start 16.5.4 for avoid jquery migrate problem
            update_option("seletEnableJqueryMigrate", 'YES');
            // !!! end 16.5.4
        }
    }
    update_option('ztooltipversion', '3.0.0');
}

function init_tooltips_settings_for_first_installation()
{
    $tooltips_pro_installed = get_option('tooltipsprocurrentversion');

    if (empty($tooltips_pro_installed)) {

        // setup tooltip style default values
        $toolstipswidth = get_option("toolstipswidth");
        if (empty($toolstipswidth)) {
            update_option("toolstipswidth", 400);
        }

        $toolstipsbackground = get_option("toolstipsbackground");
        if (empty($toolstipsbackground)) {
            // !!! 14.4.0 update_option("toolstipsbackground",'#6aaf6d');
            update_option("toolstipsbackground", '#ffffff'); // !!! 14.4.0
        }

        $toolstipsTextAlignSelect = get_option("toolstipsTextAlignSelect");
        if (empty($toolstipsTextAlignSelect)) {
            update_option("toolstipsTextAlignSelect", 'left');
        }

        $toolstipsBorderWidth = get_option("toolstipsBorderWidth");
        if (empty($toolstipsBorderWidth)) {
            update_option("toolstipsBorderWidth", 2);
        }

        $toolstipsPadding = get_option("toolstipsPadding");
        if (empty($toolstipsPadding)) {
            update_option("toolstipsPadding", 10);
        }

        $toolstipsBorderColor = get_option("toolstipsBorderColor");
        if (empty($toolstipsBorderColor)) {
            // !!! 14.4.0 update_option("toolstipsBorderColor",'#f7de71');
            update_option("toolstipsBorderColor", '#98d4ff'); // !!! 14.4.0
        }

        $tooltipShowSelect = get_option("tooltipShowSelect");
        if (empty($tooltipShowSelect)) {
            update_option("tooltipShowSelect", 'mouseover');
        }

        $tooltipHiddenSelect = get_option("tooltipHiddenSelect");
        if (empty($tooltipHiddenSelect)) {
            update_option("tooltipHiddenSelect", 'stayopen');
        }

        $toolstipsClass = get_option("toolstipsClass");
        if (empty($toolstipsClass)) {
            update_option("toolstipsClass", 'skyisblue');
        }

        $toolstipsBorderRadius = get_option("toolstipsBorderRadius");
        if (empty($toolstipsBorderRadius)) {
            update_option("toolstipsBorderRadius", 4);
        }

        $toolstipsPostion = get_option("toolstipsPostion");
        if (empty($toolstipsPostion)) {
            update_option("toolstipsPostion", 'bottomMiddle');
        }
        $toolstipsTitleColor = get_option("toolstipsTitleColor");
        if (empty($toolstipsTitleColor)) {
            // !!! 14.4.0 update_option("toolstipsTitleColor",'#ffffff');
            update_option("toolstipsTitleColor", '#21313c'); // !!! 14.4.0
        }

        $toolstipsOpacity = get_option("toolstipsOpacity");
        if (empty($toolstipsOpacity)) {
            update_option("toolstipsOpacity", 0.9);
        }

        $tooltipBorderBottomSelect = get_option("tooltipBorderBottomSelect");
        if (empty($tooltipBorderBottomSelect)) {
            update_option("tooltipBorderBottomSelect", 'dotted');
        }

        $toolstipsUnderLineColor = get_option("toolstipsUnderLineColor");
        if (empty($toolstipsUnderLineColor)) {
            update_option("toolstipsUnderLineColor", '#888888');
        }

        $tooltipShowShadowSelect = get_option("tooltipShowShadowSelect");
        if (empty($tooltipBorderBottomSelect)) {
            update_option("tooltipShowShadowSelect", 'display');
        }

        $toolstipsFontSize = get_option("toolstipsFontSize");
        if (empty($toolstipsFontSize)) {
            update_option("toolstipsFontSize", 14);
        }

        $toolstipsTitleFontSize = get_option("toolstipsTitleFontSize");
        if (empty($toolstipsTitleFontSize)) {
            update_option("toolstipsTitleFontSize", 14);
        }

        $toolstipsLineHeight = get_option("toolstipsLineHeight");
        if (empty($toolstipsLineHeight)) {
            update_option("toolstipsLineHeight", 20);
        }
        
        //23.0.8
        
        $toolstipsLineSpace = get_option("toolstipsLineSpace");
        /*
        if (empty($toolstipsLineSpace)) {
            update_option("toolstipsLineSpace", 20);
        }
        */
        $toolstipsTermColor = get_option("toolstipsTermColor");
        if (empty($toolstipsTermColor)) {
            update_option("toolstipsTermColor", '#81d884');
        }

        $toolstipsTitleBackgrounColor = get_option("toolstipsTitleBackgrounColor");
        if (empty($toolstipsTitleBackgrounColor)) {
            update_option("toolstipsTitleBackgrounColor", '#3e8843');
        }

        $toolstipsTitleFontColor = get_option("toolstipsTitleFontColor");
        if (empty($toolstipsTitleFontColor)) {
            update_option("toolstipsTitleFontColor", '#81d884');
        }

        $toolstipsAnimationClass = get_option("toolstipsAnimationClass");
        if (empty($toolstipsAnimationClass)) {
            update_option("toolstipsAnimationClass", 'tipscale');
        }

        $showToolstipsTitleSelect = get_option("showToolstipsTitleSelect");
        if (empty($showToolstipsTitleSelect)) {
            update_option("showToolstipsTitleSelect", 'no');
        }

        $showToolstipsCloseButtonSelect = get_option("showToolstipsCloseButtonSelect");
        if (empty($showToolstipsCloseButtonSelect)) {
            update_option("showToolstipsCloseButtonSelect", 'no');
        }

        $tooltipsCloseButtonBackground = get_option("tooltipsCloseButtonBackground");
        if (empty($tooltipsCloseButtonBackground)) {
            update_option("tooltipsCloseButtonBackground", '#eeee22');
        }

        $tooltipCloseButtonFontColor = get_option("tooltipCloseButtonFontColor");
        if (empty($tooltipCloseButtonFontColor)) {
            update_option("tooltipCloseButtonFontColor", '#c43c92');
        }

        $tooltipcolorofglossarylinkintooltippop = get_option("tooltipcolorofglossarylinkintooltippop");
        if (empty($tooltipcolorofglossarylinkintooltippop)) {
            update_option("tooltipcolorofglossarylinkintooltippop", '#333');
        }

        $tooltipCloseButtonRadius = get_option("tooltipCloseButtonRadius");
        if (empty($tooltipCloseButtonRadius)) {
            update_option("tooltipCloseButtonRadius", 4);
        }

        $tiptooltiptitlefontfamily = get_option("tiptooltiptitlefontfamily");
        if (empty($tiptooltiptitlefontfamily)) {
            update_option("tiptooltiptitlefontfamily", 'Default');
        }

        $coloroftooltipsupportlinkintooltippop = get_option("coloroftooltipsupportlinkintooltippop");
        if (empty($coloroftooltipsupportlinkintooltippop)) {
            update_option("coloroftooltipsupportlinkintooltippop", '#333');
        }

        $toolstipsMargin = get_option("toolstipsMargin"); // !!!
        if (empty($toolstipsMargin)) {
            update_option("toolstipsMargin", '0px 10px 0px -6px');
        }

        $tiptooltipcontentfontfamily = get_option("tiptooltipcontentfontfamily");
        if (empty($tiptooltipcontentfontfamily)) {
            update_option("tiptooltipcontentfontfamily", 'Default');
        }

        $delaytooltipfunction = get_option('delaytooltipfunction');
        if (empty($delaytooltipfunction)) {
            update_option("delaytooltipfunction", 0);
        }
    }
}

// 12.3.6
add_action('init', 'upgrade_under_3_check');

function new_activate_or_upgrade_init()
{
    // upgrade_under_3_check();
    init_tooltips_settings_for_first_installation();
}
new_activate_or_upgrade_init();
// 12.3.6

require_once ("tooltipfunctions.php");
require_once ("license/tooltipslicensetype.php");
require_once ("license/tooltipsaddonlicensepermission.php");
require_once ("rules/ttsimport.php");
require_once ("rules/ttsexport.php");
require_once (TOOLTIPS_ADDONS_PATH . "addons.php");
require_once ("rules/removetooltipscssjsinpage.php");
require_once ('rules/disabletooltipsinglossarypage.php');
require_once ('rules/disablespecifictooltipsarray.php');
require_once ('rules/glossary-search.php');
require_once ('rules/generatetooltipjs.php');
require_once ('admin/tooltipsettingforpost.php');
require_once ('admin/tooltipsoptionalsettings.php');  //26.9.8
require_once ('rules/regeneratetooltipstyle.php');
require_once ('rules/tooltipsearchform.php');
require_once ('rules/tooltipbreadcrumbs.php');
require_once ('rules/custom-tooltips-code.php');
require_once ('rules/tooltipssupporttips.php');
require_once ('rules/detectmobile.php');
require_once ('rules/glossaryshortcode.php');
require_once ('rules/tooltippaginate.php');
require_once ('rules/tooltipsonwidget.php'); // 14.5.6
require_once ('rules/tooltipfromanything.php'); //20.1.8
require_once (TOOLTIPS_PRO_ADMIN_PATH . 'glosssaryglobalsettings.php');
// 18.3.8
require_once ("directory/rules/useroles.php");
require_once ("directory/admin/admin.php");
require_once ("rules/tt-font-awesome/tt-font-awesome.php"); //19.9.8
require_once ("rules/glossaryuseanycontent.php"); //26.3.8

/*
 * require_once("directory/member-directory.php");
 * require_once("directory/wppostdirectoryshortcode.php");
 * require_once("directory/wppagedirectoryshortcode.php");
 * require_once("directory/jobmamagerdirectoryshortcode.php"); //18.8.8
 * //18.5.8
 * require_once('rules/productdirectoryshortcode.php');
 */

// 19.2.8
//!!! before 30.5.8 $memberDirectoryUserRoleSelect = get_option('memberDirectoryUserRoleSelect');
//!!! before 30.5.8 if ($memberDirectoryUserRoleSelect == 'disableMemberDirectoryUserRolesOption') 

//30.5.8
$memberDirectorySelect = get_option('memberDirectorySelect');
if ($memberDirectorySelect == 'disablememberDirectorySelectOption')
{} 
else 
{
    require_once ("directory/member-directory.php");
}
//end 30.5.8

$postDirectorySelect = get_option('postDirectorySelect');
if ($postDirectorySelect == 'disablepostDirectorySelectOption') {} else {
    require_once ("directory/wppostdirectoryshortcode.php");
}

$pageDirectorySelect = get_option('pageDirectorySelect');
if ($pageDirectorySelect == 'disablepageDirectorySelectOption') {} else {
    require_once ("directory/wppagedirectoryshortcode.php");
}

$jobboardDirectorySelect = get_option('jobboardDirectorySelect');
if ($jobboardDirectorySelect == 'disablejobboardDirectorySelectOption') {} else {
    require_once ("directory/jobmamagerdirectoryshortcode.php"); // 18.8.8
}

$woocommerceProductDirectorySelect = get_option('woocommerceProductDirectorySelect');
if ($woocommerceProductDirectorySelect == 'disablewoocommerceProductDirectorySelectOption') {} else {
    // 18.5.8
    //require_once ('rules/productdirectoryshortcode.php');
    //24.6.8 
    require_once ('directory/productdirectoryshortcode.php');
}

//20.8.8
$runningttshortcodeinalt = get_option("runningttshortcodeinalt");
$runningttshortcodeinglossaryalt = get_option("runningttshortcodeinglossaryalt"); //21.2.8
$runningttshortcodeintitle = get_option("runningttshortcodeintitle");

if (($runningttshortcodeinalt == 'YES') || ($runningttshortcodeinglossaryalt == 'YES') || ($runningttshortcodeintitle == 'YES'))
{
    require_once ("rules/alttooltips.php");
}

// 19.4.8
require_once ('rules/AITooltipsSettings.php');

update_option('tooltipsprocurrentversion', TOOLTIP_VERSION);

// 12.3.2

add_action('admin_menu', 'tooltips_menu_pro');

function tooltips_menu_pro()
{
    add_submenu_page('edit.php?post_type=tooltips', __('Tooltips Style', 'wordpress-tooltips'), __('Tooltips Style', 'wordpress-tooltips'), "manage_options", 'tooltipssettings', 'tooltipSettings');
    add_submenu_page('edit.php?post_type=tooltips', __('Glossary Setttings', 'wordpress-tooltips'), __('Glossary Settings', 'wordpress-tooltips'), "manage_options", 'glossarysettings', 'glossarysettings');
    add_submenu_page("edit.php?post_type=tooltips", __("Bullet Screen", "wordpress-tooltips"), __("Bullet Screen", "wordpress-tooltips"), "manage_options", "bulletscreensettings", "bulletScreenSettingsManager");
    add_submenu_page('edit.php?post_type=tooltips', __('Global Settings', 'wordpress-tooltips'), __('Global Settings', 'wordpress-tooltips'), "manage_options", 'tooltipglobalsettings', 'tooltipGlobalSettingsPro');
    add_submenu_page('edit.php?post_type=tooltips', __('Optional Settings', 'wordpress-tooltips'), __('Optional Settings', 'wordpress-tooltips'), "manage_options", 'tooltipOptionalSettings', 'tooltipOptionalSettings');
    // add_submenu_page('edit.php?post_type=tooltips', __('Directory Settings', 'member-directory'), __('Directory Settings', 'member-directory'), "manage_options", 'memberdirectoryrolesetting_pro', 'memberdirectoryrolesetting_pro'); // 18.3.8
    // 19.2.8
    add_submenu_page('edit.php?post_type=tooltips', __('Directory Settings', 'wordpress-tooltips'), __('Directory Settings', 'wordpress-tooltips'), "manage_options", 'tooltipdirectorysetting_pro', 'tooltipdirectorysetting_pro');
    add_submenu_page('edit.php?post_type=tooltips', __('Post Types', 'wordpress-tooltips'), __('Post Types', 'wordpress-tooltips'), "manage_options", 'tooltipPostTypesSettings', 'tooltipPostTypesSettings');
    // 19.4.8
    add_submenu_page('edit.php?post_type=tooltips', __('AI Tooltips', 'wordpress-tooltips'), __('AI Tooltips', 'wordpress-tooltips'), "manage_options", 'AITooltipsSettings', 'AITooltipsSettings');
    add_submenu_page("edit.php?post_type=tooltips", __("Import Tooltips", "wordpress-tooltips"), __("Import Tooltips", "wordpress-tooltips"), "manage_options", "tooltipsimport", "tooltipsImport");
    add_submenu_page("edit.php?post_type=tooltips", __("Export Tooltips", "wordpress-tooltips"), __("Export Tooltips", "wordpress-tooltips"), "manage_options", "tooltipsexport", "tooltipsExport");
    add_submenu_page("edit.php?post_type=tooltips", __("Reset Tooltips", "wordpress-tooltips"), __("Reset Tooltips", "wordpress-tooltips"), "manage_options", "tooltipsregeneratestyle", "tooltipsRegenerateManager");
    add_submenu_page('edit.php?post_type=tooltips', __('Tooltips Coder', 'wordpress-tooltips'), __('Tooltips Coder', 'wordpress-tooltips'), 'manage_options', 'Tooltips Coder', 'tooltipsProCustomStyle'); // !!! start end
    add_submenu_page("edit.php?post_type=tooltips", __("Addons", "wordpress-tooltips"), __("Addons", "wordpress-tooltips"), "manage_options", "tooltipsaddonmanager", "tooltipsaddonmanager");
    add_submenu_page('edit.php?post_type=tooltips', __('Knowledge Base', 'wordpress-tooltips'), __('Knowledge Base', 'wordpress-tooltips'), "manage_options", 'tooltipsfaq', 'tooltipFAQ');
}

function add_tooltips_post_type_pro()
{
    global $wp_rewrite;
    $catlabels = array(
        'name' => 'Categories',
        'singular_name' => 'Tooltips Categories',
        'all_items' => 'All Tooltips',
        'parent_item' => 'Parent Tooltips',
        'edit_item' => 'Edit Tooltips',
        'update_item' => 'Update Tooltips',
        'add_new_item' => 'Add New Tooltips',
        'new_item_name' => 'New Tooltips'
    );

    $args = array(
        'label' => 'Categories',
        'labels' => $catlabels,
        'public' => true,
        'hierarchical' => true,
        'show_ui' => true,
        'show_in_nav_menus' => true,
        'args' => array(
            'orderby' => 'term_order'
        ),
        'rewrite' => array(
            'slug' => 'tooltips_categories',
            'with_front' => false
        ),
        'query_var' => true
    );

    register_taxonomy('tooltips_categories', 'tooltips', $args);

    $labels = array(
        'name' => __('Tooltips', 'wordpress-tooltips'),
        'singular_name' => __('Tooltip', 'wordpress-tooltips'),
        'add_new' => __('Add New', 'wordpress-tooltips'),
        'add_new_item' => __('Add New Tooltip', 'wordpress-tooltips'),
        'edit_item' => __('Edit Tooltip', 'wordpress-tooltips'),
        'new_item' => __('New Tooltip', 'wordpress-tooltips'),
        'all_items' => __('All Tooltips', 'wordpress-tooltips'),
        'view_item' => __('View Tooltip', 'wordpress-tooltips'),
        'search_items' => __('Search Tooltip', 'wordpress-tooltips'),
        'not_found' => __('No Tooltip found', 'wordpress-tooltips'),
        'not_found_in_trash' => __('No Tooltip found in Trash', 'wordpress-tooltips'),
        'menu_name' => __('Tooltips', 'wordpress-tooltips')
    );

    $enableGlossarySearchable = get_option("enableGlossarySearchable");
    $enableGlossarySearchableFlag = false;
    if (empty($enableGlossarySearchable)) {
        $enableGlossarySearchableFlag = false;
    } elseif ($enableGlossarySearchable == 'yes') {
        $enableGlossarySearchableFlag = false;
    } elseif ($enableGlossarySearchable == 'no') {
        $enableGlossarySearchableFlag = true;
    }

    $enabGlossaryIndexPage = get_option("enabGlossaryIndexPage");
    if (empty($enabGlossaryIndexPage)) {
        $enabGlossaryIndexPage = 'YES';
    }

    if ($enabGlossaryIndexPage == 'YES') {
        $hasGlossaryIndex = true;
        $tooltipsGlossaryIndexPage = get_option('tooltipsGlossaryIndexPage');
        if (empty($tooltipsGlossaryIndexPage)) {
            $glossarySlug = 'glossary';
        } else {
            $glossaryPost = get_post($tooltipsGlossaryIndexPage);
            if (empty($glossaryPost->ID)) {
                $glossarySlug = 'glossary';
            } else {
                $glossarySlug = $glossaryPost->post_name;
            }
        }

        $hasGlossaryIndexRewrite = array(
            'slug' => $glossarySlug,
            'with_front' => true,
            'feeds' => true,
            'pages' => true
        );
    } else {
        $hasGlossaryIndex = false;
        $hasGlossaryIndexRewrite = false;
    }

    $args = array(
        'labels' => $labels,
        'public' => $hasGlossaryIndex,
        'show_ui' => true,
        'show_in_menu' => true,
        '_builtin' => false,
        'query_var' => "tooltips",
        'rewrite' => $hasGlossaryIndexRewrite,
        'capability_type' => 'post',
        'has_archive' => $hasGlossaryIndex,
        'hierarchical' => false,
        'menu_position' => null,
        'exclude_from_search' => $enableGlossarySearchableFlag,
        'supports' => array(
            'title',
            'editor',
            'author',
            'custom-fields',
            'thumbnail',
            'excerpt'
        )
    );
    register_post_type('tooltips', $args);
    $wp_rewrite->flush_rules();
}
add_action('init', 'add_tooltips_post_type_pro');

function tooltipFAQ()
{
    require_once (TOOLTIPS_PRO_ADMIN_PATH . "howto.php");
}

function tooltipsaddonmanager()
{
    require_once (TOOLTIPS_ADDONS_PATH . "addonspanel.php");
}

function bulletScreenSettingsManager()
{
    require_once (TOOLTIPS_PRO_ADMIN_PATH . "bulletscreensettings.php");
}

function tooltipsRegenerateManager()
{
    require_once (TOOLTIPS_PRO_ADMIN_PATH . "tooltipsregenerate.php");
}

$onlyFirstKeyword = get_option("tootipsformenu");
if ($onlyFirstKeyword == false)
    $onlyFirstKeyword = 'no';
if ($onlyFirstKeyword == 'yes') {
    if (file_exists(TOOLTIPS_ADDONS_PATH . 'tooltips_menu.php')) {
        require_once TOOLTIPS_ADDONS_PATH . 'tooltips_menu.php';
    }
}

//22.2.8
//!!!
$enableTooltipsSCL = get_option('enableTooltipsSCL');
if ($enableTooltipsSCL == false)
    $enableTooltipsSCL = 'no';
    if ($enableTooltipsSCL == 'yes') {
        if (file_exists(TOOLTIPS_ADDONS_PATH . 'tooltips_smart_content_link.php')) {
            require_once TOOLTIPS_ADDONS_PATH . 'tooltips_smart_content_link.php';
        }
    }


$disabletooltipentiresite = get_option('disabletooltipentiresite');
if ('NO' == $disabletooltipentiresite) {
    return;
}

// 12.3.2
function tooltipsInContentPro($content)
{
    global $post;

    if (is_admin()) {
        return $content;
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return $content;
    }

    // 11.4.6

    $disableInHomePage = get_option("disableInHomePage");

    if ($disableInHomePage == 'NO') {
        if (is_home() || is_front_page()) {
            return $content;
        }
    }

    $showOnlyInSingleCategory = get_option("showOnlyInSingleCategory");

    if ($showOnlyInSingleCategory != 0) {

        $post_cats = wp_get_post_categories($post->ID);
        if (in_array($showOnlyInSingleCategory, $post_cats)) {} else {
            return $content;
        }
    }

    //9.2.9 and 26.6.8
	$content_ori = $content;
	// end 9.2.9 and 26.6.8

    $tooltipCaseSensitiveSelect = get_option('tooltipCaseSensitiveSelect');
    if (empty($tooltipCaseSensitiveSelect)) {
        $tooltipCaseSensitiveSelect = 'YES';
    }

    $post_id = 0;
    if (is_object($post)) {
        $post_id = $post->ID;
    }

    $disable_tootips = get_post_meta($post_id, 'disable_to_this_page', true);

    if ($disable_tootips == 'yes') {
        // 14.2.6
        $content = str_ireplace('[[[[[', '', $content);
        $content = str_ireplace(']]]]]', '', $content);

        return $content;
    }

    global $post;

    $bulkdisabletooltipbypostid = '';
    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $bulkdisabletooltipbypostid = get_option("bulkdisabletooltipbypostid");
        if (! (empty($bulkdisabletooltipbypostid))) {
            $patterns = '';
            $replacements = '';
            $bulkdisabletooltipbypostid = trim($bulkdisabletooltipbypostid);
            $bulkdisabletooltipbypostidarray = explode(',', $bulkdisabletooltipbypostid);

            // 16.0.2
            if ((! (empty($bulkdisabletooltipbypostidarray))) && (is_array($bulkdisabletooltipbypostidarray)) && (count($bulkdisabletooltipbypostidarray) > 0)) {
                $bulkdisabletooltipbypostidarray = array_filter($bulkdisabletooltipbypostidarray);
            }
            // end 16.0.2

            if ((! (empty($bulkdisabletooltipbypostidarray))) && (is_array($bulkdisabletooltipbypostidarray)) && (count($bulkdisabletooltipbypostidarray) > 0)) {
                if (in_array($post->ID, $bulkdisabletooltipbypostidarray)) {
                    return $content;
                }
            }
        }
    }

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return $content;
        }
    }

    $disableTooltipsForGlossaryPage = disableTooltipsForGlossaryPage($post_id);
    if ($disableTooltipsForGlossaryPage == true) {
        return $content;
    }

    $disable_specific_tooltips_array = array();
    $disable_specific_tooltips_array = disable_specific_tooltips_array($post_id);

    // !!! start 14.9.8
    $disable_specific_tooltips_categories_array = array();
    $disable_specific_tooltips_categories_array = disable_specific_tooltips_category_array($post_id);
    // !!! end 14.9.8

    $tooltips_enabled_poty_type = get_option("tooltips_enabled_poty_type");
    if ((! (empty($tooltips_enabled_poty_type))) && (is_array($tooltips_enabled_poty_type)) && (count($tooltips_enabled_poty_type) > 0)) {
        $current_post_type = get_post_type();
        if (! (in_array($current_post_type, $tooltips_enabled_poty_type))) {
            return $content;
        }
    }

    do_action('action_before_tooltipsincontent', $content);
    $content = apply_filters('filter_before_tooltipsincontent', $content);

    $onlyFirstKeyword = get_option("onlyFirstKeyword");
    if ($onlyFirstKeyword == false) {
        $onlyFirstKeyword = 'all';
    }

    $m_result = tooltips_get_option_pro('tooltipsarray', 'post_title', 'DESC', 'LENGTH');

    // start 17.3.4
    $restricted_array = array();
    // end 17.3.4
    if (! (empty($m_result))) {
        $m_keyword_id = 0;
        foreach ($m_result as $m_single) {
            $m_keyword = $m_single['keyword'];
            $m_content = $m_single['content'];
            $tooltip_post_id = $m_single['post_id'];
            $tooltip_unique_id = $m_single['unique_id'];

            $is_specific_tooltips = is_specific_tooltips($m_keyword, $disable_specific_tooltips_array);
            if ($is_specific_tooltips == true) {
                continue;
            }

            // !!! start 14.9.8
            if ((isset($post->ID)) && (! (empty($post->ID))) && ($post->ID == $post_id)) {
                $disable_specific_tooltips_categories_array = disable_specific_tooltips_category_array($post_id);
                $is_specific_tooltips_categories = is_specific_tooltips($tooltip_post_id, $disable_specific_tooltips_categories_array);
                if ($is_specific_tooltips_categories == true) {
                    continue;
                }
            }
            // !!! end 14.9.8

            $get_post_meta_value_for_this_page = get_post_meta($tooltip_post_id, 'toolstipssynonyms', true);
            $get_post_meta_value_for_this_page = trim($get_post_meta_value_for_this_page);
            $toolstipsyoutubevideo = get_post_meta($tooltip_post_id, 'toolstipsyoutubevideo', true);
            $toolstipsyoutubevideo = trim($toolstipsyoutubevideo);

            $tooltsip_synonyms = false;
            if (! (empty($get_post_meta_value_for_this_page))) {
                $tooltsip_synonyms = explode('|', $get_post_meta_value_for_this_page);
            }

            // 16.0.2
            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {
                $tooltsip_synonyms = array_filter($tooltsip_synonyms); // delete empty
                $tooltsip_synonyms = array_map('trim',$tooltsip_synonyms);  //23.3.8

                
            }
            // end 16.0.2

            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {} else {
                $tooltsip_synonyms = array();
                $tooltsip_synonyms[] = $m_keyword;
            }

            // start 17.3.4
            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {
                $restricted_mime = array();
                $restricted_mime[] = '.jpeg';
                $restricted_mime[] = '.jpg';
                $restricted_mime[] = '.png';
                $restricted_mime[] = '.gif';
                $restricted_mime[] = '.svg';

                foreach ($tooltsip_synonyms as $tooltsip_synonyms_single_restricts) {
                    if (stripos($content, $tooltsip_synonyms_single_restricts) === false) {} else {
                        foreach ($restricted_mime as $restricted_mime_single) {
                            $tooltsip_synonyms_single_restricts_mime = $tooltsip_synonyms_single_restricts . $restricted_mime_single;
                            
                            $tooltsip_synonyms_single_restricts_mime  = preg_quote($tooltsip_synonyms_single_restricts_mime , '/' ); // 23.6.8 because ser using A / B testing
                            
                            preg_match_all("/$tooltsip_synonyms_single_restricts_mime/is", $content, $tooltsip_restricts_matches);
                            
                            if ((! (empty($tooltsip_restricts_matches))) && (is_array($tooltsip_restricts_matches)) && (count($tooltsip_restricts_matches) > 0)) {
                                if ((! (empty($tooltsip_restricts_matches[0]))) && (is_array($tooltsip_restricts_matches[0])) && (count($tooltsip_restricts_matches[0]) > 0)) {
                                    $restricted_array[$tooltsip_synonyms_single_restricts]['term'] = $tooltsip_synonyms_single_restricts;
                                    foreach ($tooltsip_restricts_matches[0] as $tooltsip_restricts_matches_single) {

                                        $restricted_array[$tooltsip_synonyms_single_restricts]['mime'][$tooltsip_restricts_matches_single]['term'] = $tooltsip_restricts_matches_single;
                                        $restricted_array[$tooltsip_synonyms_single_restricts]['mime'][$tooltsip_restricts_matches_single]['unique_id'] = tooltips_unique_id_pro();
                                        $content = preg_replace("/" . "(" . $tooltsip_restricts_matches_single . ")(?![^@@@@]*[####])/s", '@@@@' . $restricted_array[$tooltsip_synonyms_single_restricts]['mime'][$tooltsip_restricts_matches_single]['unique_id'] . '####' . "\\2", $content);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            // end 17.3.4

            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {
                // before 13.9.0 $tooltsip_synonyms[] = $m_keyword;
                array_unshift($tooltsip_synonyms, $m_keyword); // 13.9.0
                $tooltsip_synonyms = array_unique($tooltsip_synonyms);

                // 19.8.8
                $linktooltiptermtotooltippage = get_option('linktooltiptermtotooltippage');
                $tooltip_post_link = get_permalink($tooltip_post_id);
                $tooltip_post_link_start = '';
                $tooltip_post_link_end = '';

                if ('YES' == $linktooltiptermtotooltippage) {
                    $tooltip_post_link = get_permalink($tooltip_post_id);
                    if (empty($tooltip_post_link)) {} else {
                        $tooltip_post_link_start = "<a href='$tooltip_post_link' target='_blank'>";
                        $tooltip_post_link_end = "</a>";
                    }
                }

                foreach ($tooltsip_synonyms as $tooltsip_synonyms_single) {
                    $m_keyword = $tooltsip_synonyms_single;
                    // 19.8.8
                    $m_keyword_link = $tooltip_post_link_start . $m_keyword . $tooltip_post_link_end;
                    // end 19.8.8
                    // !!! 14.9.8 $m_replace = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>$m_keyword</span>";
                    $m_replace = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>$m_keyword</span>";
                    
                    if (stripos($content, $m_keyword) === false) 
                        {} 
                    else 
                    {
                        //$m_keyword = str_replace('/', '\/', $m_keyword); // 10.8.8 //23.6.8 because we using $m_keyword = preg_quote($m_keyword, '/'); now
                        if ($onlyFirstKeyword == 'all') {
                            $m_keyword = preg_quote($m_keyword, '/');
                            //25.5.8
                            if ($m_keyword_link == $m_keyword)
                            {
                                $m_keyword_link= preg_quote($m_keyword_link, '/');
                            }
                            else
                            {
                                $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                            }
                            
                            if ($tooltipCaseSensitiveSelect == 'YES') {
                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content);
                                // !!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>"."\\2"."</span>"."\\3",$content);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>".$m_keyword_link."</span>"."\\3",$content);

                                if (stripos($content1, '</a></span></a>') === false) 
                                {
                                    
                                } 
                                else 
                                {
                                    // !!! before 19.8.8 23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>"."\\2"."</span>"."\\3",$content);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>".$m_keyword_link."</span>"."\\3",$content);
                                }
                            } 
                            else 
                            {
                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content);
                                // !!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>"."\\2"."</span>"."\\3",$content);
                                
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>".$m_keyword_link."</span>"."\\3",$content);

                                if (stripos($content1, '</a></span></a>') === false) 
                                {
                                    
                                } 
                                else 
                                {
                                    // !!! before 19.8.8 23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>"."\\2"."</span>"."\\3",$content);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>".$m_keyword_link."</span>"."\\3",$content);
                                }
                            }
                        }

                        if ($onlyFirstKeyword == 'first') {
                            $m_keyword = preg_quote($m_keyword, '/');
                            //25.5.8
                            if ($m_keyword_link == $m_keyword)
                            {
                                $m_keyword_link= preg_quote($m_keyword_link, '/');
                            }
                            else
                            {
                                $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                            }
                            
                            if ($tooltipCaseSensitiveSelect == 'YES') {
                                // !!! 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,1);
                                // !!! 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>"."\\2"."</span>"."\\3",$content,1);

                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>".$m_keyword_link."</span>"."\\3",$content,1);
                                if (stripos($content1, '</a></span></a>') === false) {} 
                                else 
                                {
                                    // !!! 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>"."\\2"."</span>"."\\3",$content,1);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>".$m_keyword_link."</span>"."\\3",$content,1);
                                    
                                }
                            } else {

                                // !!! 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,1);
                                //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, 1);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, 1);
                                if (stripos($content1, '</a></span></a>') === false)
                                {
                                    
                                }
                                else
                                {
                                    //!!! before 19.8.8 23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, 1);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, 1);
                                    
                                }
                            }
                        }

                        // 14.6.8
                        if ($onlyFirstKeyword == 'firstn') {
                            $inputFirstNKeywordSetting = get_option('inputFirstNKeywordSetting');
                            if (empty($inputFirstNKeywordSetting)) {
                                $inputFirstNKeywordSetting = 1;
                            }

                            $m_keyword = preg_quote($m_keyword, '/');
                            //25.5.8
                            if ($m_keyword_link == $m_keyword)
                            {
                                $m_keyword_link= preg_quote($m_keyword_link, '/');
                            }
                            else
                            {
                                $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                            }
                            
                            if ($tooltipCaseSensitiveSelect == 'YES') {
                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,$inputFirstNKeywordSetting);
                                //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                if (stripos($content1, '</a></span></a>') === false)
                                {
                                    
                                }
                                else
                                {
                                    //!!! before 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    
                                }
                            } else {

                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,$inputFirstNKeywordSetting);
                                //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);

                                if (stripos($content1, '</a></span></a>') === false)
                                {
                                    
                                }
                                else
                                {
                                    //!!! before 19.8.8 23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    
                                }
                                
                            }
                        }

                        if ($content1 == $content) {
                            $content1 = " x98 " . $content . " x98 ";
                            if ($onlyFirstKeyword == 'all') {
                                $m_keyword = preg_quote($m_keyword, '/');
                                //25.5.8
                                if ($m_keyword_link == $m_keyword)
                                {
                                    $m_keyword_link= preg_quote($m_keyword_link, '/');
                                }
                                else
                                {
                                    $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                                }
                                
                                if ($tooltipCaseSensitiveSelect == 'YES') {
                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1);
                                    //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1);
                                    
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1);
                                    if (stripos($content1, '</a></span></a>') === false)
                                    {
                                        
                                    }
                                    else
                                    {
                                        //!!! before 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1);
                                        $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1);
                                        
                                    }
                                    
                                } else {

                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1);
                                    //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1);
                                    
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1);
                                    if (stripos($content1, '</a></span></a>') === false)
                                    {
                                        
                                    }
                                    else
                                    {
                                        //!!! before 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1);
                                        $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1);
                                        
                                    }
                                }
                            }

                            if ($onlyFirstKeyword == 'first') {
                                $m_keyword = preg_quote($m_keyword, '/');
                                //25.5.8
                                if ($m_keyword_link == $m_keyword)
                                {
                                    $m_keyword_link= preg_quote($m_keyword_link, '/');
                                }
                                else
                                {
                                    $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                                }
                                
                                if ($tooltipCaseSensitiveSelect == 'YES') {
                                    // !!! 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1,1);
                                    //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1, 1);
                                    
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1, 1);
                                    if (stripos($content1, '</a></span></a>') === false)
                                    {
                                        
                                    }
                                    else
                                    {
                                        //!!! before 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1, 1);
                                        $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1, 1);
                                    }
                                    
                                } else {

                                    // !!! 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1,1);
                                    //!!! before 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1, 1);
                                    
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1, 1);
                                    if (stripos($content1, '</a></span></a>') === false)
                                    {
                                        
                                    }
                                    else
                                    {
                                        //!!! before 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1, 1);
                                        $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content1, 1);
                                        
                                    }
                                    
                                }
                            }

                            // 14.6.8
                            if ($onlyFirstKeyword == 'firstn') {
                                $inputFirstNKeywordSetting = get_option('inputFirstNKeywordSetting');
                                if (empty($inputFirstNKeywordSetting)) {
                                    $inputFirstNKeywordSetting = 1;
                                }

                                $m_keyword = preg_quote($m_keyword, '/');
                                //25.5.8
                                if ($m_keyword_link == $m_keyword)
                                {
                                    $m_keyword_link= preg_quote($m_keyword_link, '/');
                                }
                                else
                                {
                                    $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                                }
                                
                                if ($tooltipCaseSensitiveSelect == 'YES') {
                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,$inputFirstNKeywordSetting);
                                    //!!! 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    if (stripos($content1, '</a></span></a>') === false)
                                    {
                                        
                                    }
                                    else
                                    {
                                        //!!! 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                        $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                        
                                    }
                                    
                                } else {

                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,$inputFirstNKeywordSetting);
                                    //!!! beforfe 19.8.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    if (stripos($content1, '</a></span></a>') === false)
                                    {
                                        
                                    }
                                    else
                                    {
                                        //!!! beforfe 19.8.8  23.2.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                        $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . $m_keyword_link . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                                    }
                                    
                                }
                            }

                            $content1 = trim($content1, " x98 ");
                        }
                        // !!! old 14.9.8 $m_check = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>";
                        $m_check = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>";

                        if (stripos($content1, $m_check . $m_check) === false) {
                            $content = $content1;
                        } else {
                            $content = $content;
                        }
                    }
                }

                $tooltipCaseSensitiveSelect = get_option('tooltipCaseSensitiveSelect');
                if (empty($tooltipCaseSensitiveSelect)) {
                    $tooltipCaseSensitiveSelect = 'YES';
                }

                $m_singlekeyword = str_replace('/', '\/', $m_single['keyword']); // 10.8.8

                //26.0.8
                $m_singlekeyword_search = $m_singlekeyword;
                
                //!!! before 29.8.8 $m_singlekeyword_search = preg_quote($m_singlekeyword_search);

                //29.8.8
				$m_singlekeyword_search = preg_quote($m_singlekeyword_search,'/');
                
                
                if ($tooltipCaseSensitiveSelect == 'YES') {

                    //!!! old before 26.0.8 $content = preg_replace("/" . "(" . $m_singlekeyword . ")(?![^@@@@]*[####])/s", '@@@@' . $tooltip_unique_id . '####' . "\\2", $content);
                    $content = preg_replace("/" . "(" . $m_singlekeyword_search . ")(?![^@@@@]*[####])/s", '@@@@' . $tooltip_unique_id . '####' . "\\2", $content);
                } else {
                    /*
                     * old works well $content = preg_replace("/"."(".$m_singlekeyword.")(?![^@@@@]*[####])/s",'@@@@'.$tooltip_unique_id.'####'."\\2",$content);
                     */
                    // 16.2.4 is model
                    // !!! old before 26.0.8 $content = preg_replace("/" . "(" . $m_singlekeyword . ")(?![^@@@@]*[####])/is", '@@@@' . $tooltip_unique_id . '####' . "\\2", $content);
                    $content = preg_replace("/" . "(" . $m_singlekeyword_search . ")(?![^@@@@]*[####])/is", '@@@@' . $tooltip_unique_id . '####' . "\\2", $content);
                }
            }

            $m_keyword_id ++;
        }

        foreach ($m_result as $m_single) {
            $m_keyword = $m_single['keyword'];
            $m_content = $m_single['content'];
            $tooltip_post_id = $m_single['post_id'];
            $tooltip_unique_id = $m_single['unique_id'];

            $tooltipCaseSensitiveSelect = get_option('tooltipCaseSensitiveSelect');
            if (empty($tooltipCaseSensitiveSelect)) {
                $tooltipCaseSensitiveSelect = 'YES';
            }

            if ($tooltipCaseSensitiveSelect == 'YES') {

                $content = str_replace($tooltip_unique_id, $m_keyword, $content);
            } else {
                $content = str_replace($tooltip_unique_id, $m_keyword, $content);
            }
        }
    }

    // 17.3.4
    if ((! (empty($restricted_array))) && (is_array($restricted_array)) && (count($restricted_array) > 0)) {
        foreach ($restricted_array as $restricted_array_single) {
            if ((! (empty($restricted_array_single['mime']))) && (is_array($restricted_array_single['mime'])) && (count($restricted_array_single['mime']) > 0)) {
                foreach ($restricted_array_single['mime'] as $restricted_array_single_mime) {
                    $content = str_replace($restricted_array_single_mime['unique_id'], $restricted_array_single_mime['term'], $content);
                }
            }
        }
    }
    // end 17.3.4

	//9.2.9 and 26.6.8
	if (empty($content))
	{
		$content = $content_ori;
	}
	// end 9.2.9 and 26.6.8


    do_action('action_after_tooltipsincontent', $content);
    $content = apply_filters('filter_after_tooltipsincontent', $content);

    $content = str_replace('@@@@', '', $content);
    $content = str_replace('####', '', $content);

    $content = str_ireplace('//##', '', $content);
    $content = str_ireplace('##]]', '', $content);

    $content = str_ireplace('[[[[[', '', $content);
    $content = str_ireplace(']]]]]', '', $content);

    return $content;
}

function tooltipsInTitle($content, $id)
{
    $post_id = $id;

    if ((isset($post_id)) && (! (empty($post_id)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post_id);
        if (true == $return_content_remove_css_js) {
            return $content;
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return $content;
    }
    // 11.4.6

    $now_posttype = get_post_type($id);
    if ('nav_menu_item' == $now_posttype) {
        $tootipsformenu = get_option("tootipsformenu");
        if ($tootipsformenu == false)
            $onlyFirstKeyword = 'no';

        if ($tootipsformenu == 'yes') {} else {
            $content = strip_tags($content);
            return $content;
        }
    }

    $now_posttype = get_post_type($id);
    if ('hrf_faq' == $now_posttype) {
        return $content;
    }

    if (is_admin())
        return $content;
    do_action('action_before_tooltipsintitle', $content, $id);
    $content = apply_filters('filter_before_tooltipsintitle', $content, $id);

    $now_posttype = get_post_type($id);
    if ('tooltips' == $now_posttype) {
        return $content;
    }

    $post_id = $id;
    $disable_tootips = get_post_meta($post_id, 'disable_to_this_page', true);

    if ($disable_tootips == 'yes') {
        // 14.2.6
        $content = str_ireplace('[[[[[', '', $content);
        $content = str_ireplace(']]]]]', '', $content);

        return $content;
    }

    $bulkdisabletooltipbypostid = '';
    if ((isset($id)) && (! (empty($id)))) {
        $bulkdisabletooltipbypostid = get_option("bulkdisabletooltipbypostid");
        if (! (empty($bulkdisabletooltipbypostid))) {
            $patterns = '';
            $replacements = '';
            $bulkdisabletooltipbypostid = trim($bulkdisabletooltipbypostid);
            $bulkdisabletooltipbypostidarray = explode(',', $bulkdisabletooltipbypostid);
            // 16.0.2
            if ((! (empty($bulkdisabletooltipbypostidarray))) && (is_array($bulkdisabletooltipbypostidarray)) && (count($bulkdisabletooltipbypostidarray) > 0)) {
                $bulkdisabletooltipbypostidarray = array_filter($bulkdisabletooltipbypostidarray);
            }
            // end 16.0.2

            if ((! (empty($bulkdisabletooltipbypostidarray))) && (is_array($bulkdisabletooltipbypostidarray)) && (count($bulkdisabletooltipbypostidarray) > 0)) {
                if (in_array($id, $bulkdisabletooltipbypostidarray)) {
                    return $content;
                }
            }
        }
    }

    $tooltips_enabled_poty_type = get_option("tooltips_enabled_poty_type");
    if ((! (empty($tooltips_enabled_poty_type))) && (is_array($tooltips_enabled_poty_type)) && (count($tooltips_enabled_poty_type) > 0)) {
        $current_post_type = get_post_type();
        if (! (in_array($current_post_type, $tooltips_enabled_poty_type))) {
            return $content;
        }
    }

    $tooltipCaseSensitiveSelect = get_option('tooltipCaseSensitiveSelect');
    if (empty($tooltipCaseSensitiveSelect)) {
        $tooltipCaseSensitiveSelect = 'YES';
    }

    $onlyFirstKeyword = get_option("onlyFirstKeyword");
    if ($onlyFirstKeyword == false) {
        $onlyFirstKeyword = 'all';
    }

    $m_result = tooltips_get_option_pro('tooltipsarray', 'post_title', 'DESC', 'LENGTH');
    if (! (empty($m_result))) {
        $m_keyword_id = 0;
        foreach ($m_result as $m_single) {

            $m_keyword = $m_single['keyword'];
            $m_content = $m_single['content'];
            $tooltip_post_id = $m_single['post_id'];
            $tooltip_unique_id = $m_single['unique_id'];

            $get_post_meta_value_for_this_page = get_post_meta($tooltip_post_id, 'toolstipssynonyms', true);
            $get_post_meta_value_for_this_page = trim($get_post_meta_value_for_this_page);
            $toolstipsyoutubevideo = get_post_meta($tooltip_post_id, 'toolstipsyoutubevideo', true);
            $toolstipsyoutubevideo = trim($toolstipsyoutubevideo);

            $tooltsip_synonyms = false;
            if (! (empty($get_post_meta_value_for_this_page))) {
                $tooltsip_synonyms = explode('|', $get_post_meta_value_for_this_page);
            }

            // 16.0.2
            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {
                $tooltsip_synonyms = array_filter($tooltsip_synonyms);
            }
            // end 16.0.2

            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {} else {
                $tooltsip_synonyms = array();
                $tooltsip_synonyms[] = $m_keyword;
            }

            if ((! (empty($tooltsip_synonyms))) && (is_array($tooltsip_synonyms)) && (count($tooltsip_synonyms) > 0)) {
                $tooltsip_synonyms[] = $m_keyword;
                $tooltsip_synonyms = array_unique($tooltsip_synonyms);

                foreach ($tooltsip_synonyms as $tooltsip_synonyms_single) {
                    $m_keyword = $tooltsip_synonyms_single;
                    // !!! old 14.9.8 $m_replace = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>$m_keyword</span>";
                    $m_replace = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>$m_keyword</span>";

                    if (stripos($content, $m_keyword) === false) {} else {
                        //27.2.8
                        if ((stripos($m_keyword, '(') === false) && (stripos($m_keyword, ')') === false))
                        {

                        }
                        else
                        {
                            $content = str_ireplace($m_keyword, $tooltip_unique_id, $content);
                            $m_keyword = $tooltip_unique_id;
                            
                        }
                        //end 27.2.8                        

                        $m_keyword = str_replace('/', '\/', $m_keyword); // 10.8.8

                        if ($onlyFirstKeyword == 'all') {

                            if ($tooltipCaseSensitiveSelect == 'YES') {
                                // !!! 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content);
                            } else {

                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content);
                            }
                        }

                        if ($onlyFirstKeyword == 'first') {

                            if ($tooltipCaseSensitiveSelect == 'YES') {
                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,1);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, 1);
                            } else {

                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,1);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, 1);
                            }
                        }

                        // 14.6.8
                        if ($onlyFirstKeyword == 'firstn') {
                            $inputFirstNKeywordSetting = get_option('inputFirstNKeywordSetting');
                            if (empty($inputFirstNKeywordSetting)) {
                                $inputFirstNKeywordSetting = 1;
                            }

                            $m_keyword = preg_quote($m_keyword, '/');
                            //25.5.8
                            /*
                            //27.0.8 not need again
                            if ($m_keyword_link == $m_keyword)
                            {
                                $m_keyword_link= preg_quote($m_keyword_link, '/');
                            }
                            else
                            {
                                $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                            }
                            */
                            if ($tooltipCaseSensitiveSelect == 'YES') {
                                // !!! 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,$inputFirstNKeywordSetting);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                            } else {

                                // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content,$inputFirstNKeywordSetting);
                                $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content, $inputFirstNKeywordSetting);
                            }
                        }

                        if ($content1 == $content) {
                            $content1 = " x98 " . $content . " x98 ";
                            if ($onlyFirstKeyword == 'all') {
                                $m_keyword = str_ireplace('(', '\(', $m_keyword);
                                $m_keyword = str_ireplace(')', '\)', $m_keyword);

                                if ($tooltipCaseSensitiveSelect == 'YES') {
                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1);
                                } else {

                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1);
                                }
                            }

                            if ($onlyFirstKeyword == 'first') {
                                $m_keyword = preg_quote($m_keyword, '/');
                                /*
                                //27.0.8 not need again
                                //25.5.8
                                if ($m_keyword_link == $m_keyword)
                                {
                                    $m_keyword_link= preg_quote($m_keyword_link, '/');
                                }
                                else
                                {
                                    $m_keyword_link = str_replace('$','\$',$m_keyword_link);
                                }
                                */

                                if ($tooltipCaseSensitiveSelect == 'YES') {
                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1,1);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1, 1);
                                } else {

                                    // !!! old 14.9.8 $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(".$m_keyword.")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/s","\\1"."<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>"."\\2"."</span>"."\\3",$content1,1);
                                    $content1 = preg_replace("/([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])(" . $m_keyword . ")(?![^<|^\[]*[>|\]])([^A-Za-z0-9àâåäąæÀÂĄÄÅÆçćÇĆéèëêęÉÈÊËĘłŁñńÑŃîïÎÏòôöœóøÔŒÓÖØšśŚŠùûüÙÛÜÿŸžźżŹŻŽбвгдёжзийлпфцчщъыьэюяß])/is", "\\1" . "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>" . "\\2" . "</span>" . "\\3", $content1, 1);
                                }
                            }

                            $content1 = trim($content1, " x98 ");
                        }

                        // !!! old 14.9.8 $m_check = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$m_keyword_id'>";
                        $m_check = "<span class='tooltipsall tooltip_post_id_$tooltip_post_id classtoolTips$tooltip_post_id'>";

                        if (stripos($content1, $m_check . $m_check) === false) {
                            $content = $content1;
                        } else {
                            $content = $content;
                        }
                    }
                }

                $tooltipCaseSensitiveSelect = get_option('tooltipCaseSensitiveSelect');
                if (empty($tooltipCaseSensitiveSelect)) {
                    $tooltipCaseSensitiveSelect = 'YES';
                }

                $m_singlekeyword = str_replace('/', '\/', $m_single['keyword']); // !!! 10.8.8

                if ($tooltipCaseSensitiveSelect == 'YES') {

                    $content = preg_replace("/" . "(" . $m_singlekeyword . ")(?![^@@@@]*[####])/s", '@@@@' . $tooltip_unique_id . '####' . "\\2", $content);
                } else {

                    $content = preg_replace("/" . "(" . $m_singlekeyword . ")(?![^@@@@]*[####])/s", '@@@@' . $tooltip_unique_id . '####' . "\\2", $content);
                }
            }

            $m_keyword_id ++;
        }

        foreach ($m_result as $m_single) {
            $m_keyword = $m_single['keyword'];
            $m_content = $m_single['content'];
            $tooltip_post_id = $m_single['post_id'];
            $tooltip_unique_id = $m_single['unique_id'];

            $tooltipCaseSensitiveSelect = get_option('tooltipCaseSensitiveSelect');
            if (empty($tooltipCaseSensitiveSelect)) {
                $tooltipCaseSensitiveSelect = 'YES';
            }
            if ($tooltipCaseSensitiveSelect == 'YES') {

                $content = str_replace($tooltip_unique_id, $m_keyword, $content);
            } else {
                $content = str_replace($tooltip_unique_id, $m_keyword, $content);
            }
        }
    }

    do_action('action_after_tooltipsintitle', $content, $id);

    $content = str_replace('@@@@', '', $content);
    $content = str_replace('####', '', $content);

    $content = str_ireplace('//##', '', $content);
    $content = str_ireplace('##]]', '', $content);

    $content = str_ireplace('[[[[[', '', $content);
    $content = str_ireplace(']]]]]', '', $content);

    $content = apply_filters('filter_after_tooltipsintitle', $content, $id);

    return $content;
}
add_action('wp_enqueue_scripts', 'tooltips_loader_scripts_pro');

function tooltips_loader_scripts_pro()
{
    global $post;

    $post_id = 0;
    if (is_object($post)) {
        $post_id = $post->ID;
    }

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    wp_register_style('qtip2css', plugin_dir_url(__FILE__) . 'js/qtip3/jquery.qtip.min.css');
    wp_enqueue_style('qtip2css');

    wp_register_style('tooltipscss', plugin_dir_url(__FILE__) . 'tooltips.css');
    wp_enqueue_style('tooltipscss');

    wp_register_style( 'directorycss', plugin_dir_url( __FILE__ ).'js/jdirectory/directory.css'); //24.6.8
    //wp_register_style('directorycss', plugin_dir_url(__FILE__) . 'js/jdirectory/directory.min.css');
    
    wp_enqueue_style('directorycss');

    if (file_exists(plugin_dir_path(__FILE__) . 'asset/css/global/tooltip/tooltips_global.css')) {
        wp_register_style('tooltipglobalcss', plugin_dir_url(__FILE__) . 'asset/css/global/tooltip/tooltips_global.css');
        wp_enqueue_style('tooltipglobalcss');
    }

    $selectedGlossaryStyle = get_option("selectedGlossaryStyle");
    if (empty($selectedGlossaryStyle)) {
        $selectedGlossaryStyle = 'glossary-blue';
    }

    if (! (empty($selectedGlossaryStyle))) {
        wp_register_style('directorytemplates', plugin_dir_url(__FILE__) . "js/jdirectory/templates/$selectedGlossaryStyle.css");
        wp_enqueue_style('directorytemplates');
    }

    /*
     * //!!! wp_register_script( 'imagesloadedjs', plugin_dir_url( __FILE__ ).'js/imagesloaded.pkgd.min.js', array('jquery'));
     * wp_register_script( 'imagesloadedjs', plugin_dir_url( __FILE__ ).'js/imagesloaded.pkgd.min.js', array('jquery'),false,true);
     * wp_enqueue_script( 'imagesloadedjs' );
     * //!!! wp_register_script( 'qtip2js', plugin_dir_url( __FILE__ ).'js/qtip3/jquery.qtip.js', array('jquery'));
     * wp_register_script( 'qtip2js', plugin_dir_url( __FILE__ ).'js/qtip3/jquery.qtip.js', array('jquery'),false,true);
     * wp_enqueue_script( 'qtip2js' );
     * //!!! wp_register_script( 'directoryjs', plugin_dir_url( __FILE__ ).'js/jdirectory/jquery.directory.js', array('jquery'));
     * wp_register_script( 'directoryjs', plugin_dir_url( __FILE__ ).'js/jdirectory/jquery.directory.js', array('jquery'),false,true);
     * wp_enqueue_script( 'directoryjs' );
     */

    // 15.3.6
    $seletEnableJqueryMigrate = get_option('seletEnableJqueryMigrate');
    //20.7.8 enable jquery migreate for new user by default
    if (empty($seletEnableJqueryMigrate))
    {
        $seletEnableJqueryMigrate = 'YES';
    }
    
    /*
    if ($seletEnableJqueryMigrate == 'YES') 
    {
        wp_register_script('loadedjquerymigratejs', plugin_dir_url(__FILE__) . 'js/jquery-migrate-3.3.2.min.js', array(
            'jquery'
        ));
        wp_enqueue_script('loadedjquerymigratejs');
    }
    */
    //22.6.8
    if ($seletEnableJqueryMigrate == 'YES')
    {
        if (! is_admin() && isset($_GET['ver'])  && $_GET['ver'] == '3.6.0'  )
        {
            if (! wp_script_is('jquery-migrate','registered') && ! wp_script_is('jquery-migrate','enqueued')  )
            {
                wp_register_script('jquery-migrate', plugin_dir_url(__FILE__) . 'js/jquery-migrate-3.3.2.min.js', array(
                    'jquery'
                ));
                wp_enqueue_script('jquery-migrate');
                
            }
        }
        
    }
    
    $loadTooltipJsInHeaderOrFooter = get_option("loadTooltipJsInHeaderOrFooter");
    if (empty($loadTooltipJsInHeaderOrFooter)) {
        $loadTooltipJsInHeaderOrFooter = 'HEADER';
    }

    if ($loadTooltipJsInHeaderOrFooter == 'HEADER') {
        wp_register_script('imagesloadedjs', plugin_dir_url(__FILE__) . 'js/imagesloaded.pkgd.min.js', array(
            'jquery'
        ));
        wp_enqueue_script('imagesloadedjs');
        wp_register_script('qtip2js', plugin_dir_url(__FILE__) . 'js/qtip3/jquery.qtip.js', array(
            'jquery'
        )); // 14.1.8 support hit
            // wp_register_script( 'qtip2js', plugin_dir_url( __FILE__ ).'js/qtip3/jquery.qtip.min.js', array('jquery'));// before 14.1.8
        wp_enqueue_script('qtip2js');
        wp_localize_script('qtip2js', 'ttajax', array('tt_ajax_url' => admin_url('admin-ajax.php'),'nonce'=>wp_create_nonce('tt_ajax_nonce'))); //!!!20.3.8
        wp_register_script('directoryjs', plugin_dir_url(__FILE__) . 'js/jdirectory/jquery.directory.js', array(
            'jquery'
        ));
        // wp_register_script( 'directoryjs', plugin_dir_url( __FILE__ ).'js/jdirectory/jquery.directory.min.js', array('jquery'));
        wp_enqueue_script('directoryjs');
        
        
        //25.9.8
        wp_register_script('ttsjs', plugin_dir_url(__FILE__) . 'js/articulate.js', array(
            'jquery'
        ));
        wp_enqueue_script('ttsjs');
        //end 25.9.8
    }

    if ($loadTooltipJsInHeaderOrFooter == 'FOOTER') {
        wp_register_script('imagesloadedjs', plugin_dir_url(__FILE__) . 'js/imagesloaded.pkgd.min.js', array(
            'jquery'
        ), false, true);
        wp_enqueue_script('imagesloadedjs');
        wp_register_script('qtip2js', plugin_dir_url(__FILE__) . 'js/qtip3/jquery.qtip.js', array(
            'jquery'
        ), false, true); // 14.1.8 support hit
                         // wp_register_script( 'qtip2js', plugin_dir_url( __FILE__ ).'js/qtip3/jquery.qtip.min.js', array('jquery'),false,true); // before 14.1.8
        wp_enqueue_script('qtip2js');
        wp_localize_script('qtip2js', 'ttajax', array('tt_ajax_url' => admin_url('admin-ajax.php'),'nonce'=>wp_create_nonce('tt_ajax_nonce'))); //!!!20.3.8
        wp_register_script('directoryjs', plugin_dir_url(__FILE__) . 'js/jdirectory/jquery.directory.js', array(
            'jquery'
        ), false, true);
        // wp_register_script( 'directoryjs', plugin_dir_url( __FILE__ ).'js/jdirectory/jquery.directory.min.js', array('jquery'),false,true);
        wp_enqueue_script('directoryjs');
        //25.9.8
        wp_register_script('ttsjs', plugin_dir_url(__FILE__) . 'js/articulate.js', array(
            'jquery'
        ));
        wp_enqueue_script('ttsjs');
        //end 25.9.8
    }
    
    //!!! 20.4.8
    $savettjsinstaticfileandloadit = get_option("savettjsinstaticfileandloadit");
    
    if (strtolower($savettjsinstaticfileandloadit) == 'yes')
    {
        //tooltipsgeneratejs(true);
        wp_register_script('tooltitermpstaticjs', plugin_dir_url(__FILE__) . 'asset/js/tooltips_all_term.js', array(
            'jquery'
        ), false, true);
        // wp_register_script( 'directoryjs', plugin_dir_url( __FILE__ ).'js/jdirectory/jquery.directory.min.js', array('jquery'),false,true);
        wp_enqueue_script('tooltitermpstaticjs');
        
    }
    //end 20.4.8
}

function loadTooltipsStyle()
{
    global $post;
    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    $toolstipswidth = get_option("toolstipswidth");

    if (strtolower($toolstipswidth) == 'auto') {} else {
        $toolstipswidth = get_option("toolstipswidth") . 'px'; // !!! 14.8.2
    }
    // !!! old before 14.8.2 $toolstipswidth = get_option("toolstipswidth").'px';
    $toolstipsbackground = get_option("toolstipsbackground");
    $toolstipsTextAlignSelect = get_option("toolstipsTextAlignSelect");
    $toolstipsBorderWidth = get_option("toolstipsBorderWidth") . 'px';
    $toolstipsPadding = get_option("toolstipsPadding") . 'px';

    $toolstipsBorderColor = get_option("toolstipsBorderColor");
    $tooltipShowSelect = get_option("tooltipShowSelect");
    $tooltipHiddenSelect = get_option("tooltipHiddenSelect");
    $toolstipsClass = get_option("toolstipsClass");
    $toolstipsBorderRadius = get_option("toolstipsBorderRadius") . 'px';
    $toolstipsTitleColor = get_option("toolstipsTitleColor");
    $toolstipsPostion = get_option("toolstipsPostion");
    $toolstipsFontSize = get_option("toolstipsFontSize") . 'px';
    $toolstipsLineHeight = get_option("toolstipsLineHeight") . 'px';
    $toolstipsLineSpace = get_option("toolstipsLineSpace") . 'px'; //20.3.8
    $toolstipsTitleBackgrounColor = get_option("toolstipsTitleBackgrounColor");
    $toolstipsTitleFontColor = get_option("toolstipsTitleFontColor");
    $tooltipsCloseButtonBackground = get_option("tooltipsCloseButtonBackground");
    $tooltipCloseButtonRadius = get_option("tooltipCloseButtonRadius") . 'px';
    $toolstipsTitleFontSize = get_option("toolstipsTitleFontSize") . 'px';
    $tooltipCloseButtonFontColor = get_option("tooltipCloseButtonFontColor");
    $m_pluginURL = get_option('siteurl') . '/wp-content/plugins';
    $showImageinglossary = get_option("showImageinglossary");
    $tiptooltiptitlefontfamily = get_option("tiptooltiptitlefontfamily"); // !!!
    $tiptooltipcontentfontfamily = get_option("tiptooltipcontentfontfamily"); // !!!
    $glossaryTermUnderLineColorOnGlossaryPage = get_option("glossaryTermUnderLineColorOnGlossaryPage"); // !!!
    $glossaryTermFontColorOnGlossaryPage = get_option("glossaryTermFontColorOnGlossaryPage"); // !!!
    $glossaryIndexPageTermFontSize = get_option("glossaryIndexPageTermFontSize"); // !!!
    $glossaryContentFontColorOnGlossaryPage = get_option("glossaryContentFontColorOnGlossaryPage"); // !!!
                                                                                                    // !!! start 14.4.2
    $tooltipcontentfontstyle = get_option('tooltipcontentfontstyle');

    if (empty($tooltipcontentfontstyle)) {
        $tooltipcontentfontstyle = 'normal';
    }
    // !!! end 14.4.2

    $linkcoloroftooltipcontentintooltippop = get_option('linkcoloroftooltipcontentintooltippop'); // 14.9.2
    if (empty($linkcoloroftooltipcontentintooltippop)) {
        $linkcoloroftooltipcontentintooltippop = 'auto'; // that means this will not work
    }

    $tooltipZindexValue = get_option("tooltipZindexValue");
    if (empty($tooltipZindexValue)) {
        $tooltipZindexValue = 15001;
    }
    if ((! (empty($tooltipZindexValue))) && ($tooltipZindexValue != 15001)) {
        ?>
<style type="text/css">
			.qtip
			{
				z-index:<?php echo $tooltipZindexValue; ?> !important;
			}
			</style>
<?php
    }

    if (! (empty($glossaryTermUnderLineColorOnGlossaryPage))) {
        ?>
<style type="text/css">
					.tooltips_table_title span
					{
					text-decoration:none;
					border-bottom: 1px solid <?php echo $glossaryTermUnderLineColorOnGlossaryPage;  ?> !important;
					}
				</style>
<?php
    }

    if (! (empty($glossaryTermFontColorOnGlossaryPage))) {
        ?>
<style type="text/css">
						.tooltips_table_title span
						{
						color: <?php echo $glossaryTermFontColorOnGlossaryPage;  ?> !important;
						}
					</style>
<?php
    }

    if (! (empty($glossaryIndexPageTermFontSize))) {
        ?>
<style type="text/css">
							.tooltips_table_title span
							{
							font-size: <?php echo $glossaryIndexPageTermFontSize.'px';  ?> !important;
							}
						</style>
<?php
    }
//23.4.8
    $hidecountnumberitem = get_option("hidecountnumberitem");
    if ('yes' == strtolower($hidecountnumberitem)) 
    {
        ?>
<style type="text/css">
							.tooltiplist_count
							{
							display: none !important;
							}
						</style>
<?php
    }
//end 23.4.8
    if (! (empty($glossaryContentFontColorOnGlossaryPage))) {
        ?>
<style type="text/css">
							.tooltips_table_content
							{
							color: <?php echo $glossaryContentFontColorOnGlossaryPage;  ?> !important;
							}
						</style>
<?php
    }
    // !!! start 13.7.8
    $glossaryglossarylistbordercolor = get_option("glossaryglossarylistbordercolor");
    if (! (empty($glossaryglossarylistbordercolor))) {
        ?>
<style type="text/css">
								.tooltips_table_content, .tooltips_table_title
								{
								border: 1px solid <?php echo $glossaryglossarylistbordercolor;  ?> !important;
								}
								.tooltips_list
								{
								 border:none !important;
								}
							</style>
<?php
    }

    // !!! end 13.7.8

    // !!! start 13.8.4
    $inputtextglossarytermtitlebackgroundcolor = get_option("inputtextglossarytermtitlebackgroundcolor");
    if (! (empty($inputtextglossarytermtitlebackgroundcolor))) {
        ?>
<style type="text/css">
										.tooltips_table .tooltips_table_title
										{
										background-color: <?php echo $inputtextglossarytermtitlebackgroundcolor;  ?>;
										}
									</style>
<?php
    }

    // !!! end 13.8.4
    // !!! start 13.8.6
    $inputtextglossarytermcontentbackgroundcolor = get_option("inputtextglossarytermcontentbackgroundcolor");
    if (! (empty($inputtextglossarytermcontentbackgroundcolor))) {
        ?>
<style type="text/css">
												.tooltips_table .tooltips_table_content
												{
												background-color: <?php echo $inputtextglossarytermcontentbackgroundcolor;  ?>;
												}
											</style>
<?php
    }

    // !!! end 13.8.6

    if ($showImageinglossary == 'NO') {
        ?>
<style type="text/css">
.tooltips_list img {
	display: none;
}
</style>
<?php
    }
    ?>
<style type="text/css">
.tooltips_table .tooltipsall {
	border-bottom: none !important;
}

.tooltips_table span {
	color: inherit;
}

.qtip-content .tooltipsall {
	border-bottom: none !important;
	color: inherit !important;
}
</style>
<?php
    $toolstipsTermColor = get_option("toolstipsTermColor");

    if (empty($toolstipsTermColor)) {
        $toolstipsTermColor = '#81d884';
    }
    ?>
<style type="text/css">
	.tooltipsall:hover {
		color: <?php echo $toolstipsTermColor?>;
	}
	</style>
<?php //!!! start version 16.9.4 ?>
	<?php
    $tooltipsursorstyle = get_option('tooltipsursorstyle');
    if (! empty($toolstipsTermColor)) {
        ?>
<style type="text/css">
		.tooltipsall {
					cursor: <?php echo $tooltipsursorstyle ?> !important;
				}
		</style>
<?php
    }
    ?>
	<?php //end version 16.9.4 ?>
	<?php //!!! start version 17.0.4 ?>
	<?php
    $tooltipsursorstyleinpopup = get_option('tooltipsursorstyleinpopup');
    if (! empty($tooltipsursorstyleinpopup)) {
        ?>
<style type="text/css">
		.ui-wordpress-tooltip-pro {
					cursor: <?php echo $tooltipsursorstyleinpopup; ?> !important;
				}
		</style>
<?php
    }
    ?>
	<?php //end version 17.0.4 ?>	
	<?php //!!! version 15.6.8 ?>									
	<?php
    /*
     * 17.6.8
     * //old before 17.1.8 $toolstipsEnableTermColorinPost = get_option('toolstipsEnableTermColorinPost');
     * //!!!17.1.8 xxx this is error , not use post_meta of this wordpress post, should use tooltip id
     * $toolstipsEnableTermColorinPost = get_post_meta($post->ID,'toolstipsEnableTermColorinPost',true);
     * //!!! end 17.1.8
     * if (empty($toolstipsEnableTermColorinPost))
     * {
     * //before 17.6.4 $toolstipsEnableTermColorinPost = 'YES';
     *
     * $toolstipsEnableTermColorinPost = 'NO'; //17.6.4
     * }
     */
    ?>
	<?php //!!! end version 15.6.8 ?>	
	<?php
    /*
     * !!! old before 15.6.8
     * // 14.8.0
     * $toolstipsTermColorinPost = get_option("toolstipsTermColorinPost");
     *
     * if (!(empty($toolstipsTermColorinPost)))
     * {
     * ?>
     * <style type="text/css">
     * .tooltipsall {
     * color: <?php echo $toolstipsTermColorinPost; ?> !important;;
     * }
     * </style>
     * <?php
     * }
     * //end 14.8.0
     */

    // 15.6.8 tooltips pro plus
    // 14.8.0
    // 17.6.8
    {
        $toolstipsEnableTermColorinPost = get_option('toolstipsEnableTermColorinPost');
        if (empty($toolstipsEnableTermColorinPost)) {
            $toolstipsEnableTermColorinPost = 'NO'; // 17.6.4
        }
        if ($toolstipsEnableTermColorinPost == 'YES') {
            $toolstipsTermColorinPost = get_option("toolstipsTermColorinPost");

            if (! (empty($toolstipsTermColorinPost))) {
                ?>
<style type="text/css">
        	.tooltipsall {
        		color: <?php echo $toolstipsTermColorinPost; ?> ;
        	}
        	</style>
<?php
            }
        }
    }
    // end 14.8.0
    // end 15.6.8 tooltips pro plus
    // end 17.6.8
    // 17.7.8
    $toolstipsTerminPadding = get_option('toolstipsTerminPadding');
    if (empty($toolstipsTerminPadding)) {} else {
        $toolstipsTerminPadding = $toolstipsTerminPadding . 'px';
        ?>
<style type="text/css">
        	.tooltipsall {
        		padding: <?php echo $toolstipsTerminPadding; ?>;
        	}
        	</style>
<?php
    }

    // 17.8.8
    $toolstipsTerminMargin = get_option("toolstipsTerminMargin");
    if (empty($toolstipsTerminMargin)) {} else {
        $toolstipsTerminMargin = $toolstipsTerminMargin . 'px';
        ?>
<style type="text/css">
        	.tooltipsall {
        		margin: <?php echo $toolstipsTerminMargin; ?>;
        	}
        	</style>
<?php
    }

    // end 17.7.8
    $toolstipsEnableTermBackgroundinPost = get_option('toolstipsEnableTermBackgroundinPost');
    if (empty($toolstipsEnableTermBackgroundinPost)) {
        $toolstipsEnableTermBackgroundinPost = 'NO'; // 17.6.4
    }
    if ($toolstipsEnableTermBackgroundinPost == 'YES') {

        $toolstipstermbackground = get_option("toolstipstermbackground"); // 17.6.8

        if (! (empty($toolstipstermbackground))) {
            ?>
<style type="text/css">
        	.tooltipsall {
        		background-color: <?php echo $toolstipstermbackground; ?> ;
        	}
        	</style>
<?php
        }
    }
    // end 17.6.8

    // start 30.8.8
    $toolstipsEnableTermBackgroundColorinPost = get_option('toolstipsEnableTermBackgroundColorinPost');
    if (empty($toolstipsEnableTermBackgroundColorinPost)) {
        $toolstipsEnableTermBackgroundColorinPost = 'NO'; // 17.6.4
    }
    if ($toolstipsEnableTermBackgroundColorinPost == 'YES') {

        $toolstipsTermBackgroundColorinPost = get_option("toolstipsTermBackgroundColorinPost"); // 17.6.8

        if (! (empty($toolstipsTermBackgroundColorinPost))) {
            ?>
<style type="text/css">
        	.tooltipsall:hover {
        		background-color: <?php echo $toolstipsTermBackgroundColorinPost; ?> ;
        	}
        	</style>
<?php
        }
    }
    // end 30.8.8
    $toolstipsOpacity = get_option("toolstipsOpacity");
    if (empty($toolstipsOpacity)) {
        $toolstipsOpacity = 1;
        $toolstipsOpacity100 = 100;
    } else {
        $toolstipsOpacity100 = $toolstipsOpacity * 100;
    }
    $clientIP = tooltipsGetIP();

    $selectedTooltipStyle = get_option("selectedTooltipStyle");
    if ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized')) {
        ?>
<style type="text/css">
.tooltipsall {
	border-bottom: 2px dotted #888;
}
</style>
<?php
    } else {
        ?>
<!--[if IE]>
    <style type="text/css">
    .qtip {
       filter:alpha(Opacity=<?php echo $toolstipsOpacity100;  ?>); // IE7 and below
       -ms-filter:"progid:DXImageTransform.Microsoft.Alpha(Opacity=<?php echo $toolstipsOpacity100;  ?>)"; // IE8
    }
    </style>
<![endif]-->

<style type="text/css">
    .qtip {
        opacity: <?php echo $toolstipsOpacity; // Santdard compliant browsers ?>; 
        -moz-opacity: <?php echo $toolstipsOpacity; // Firefox and Mozilla browsers  ?>; 
        -webkit-opacity: <?php echo $toolstipsOpacity; // WebKit browser e.g. Safari ?>; 
    }
    .ui-wordpress-tooltip-pro
    {
	width:<?php echo $toolstipswidth; ?>;    
	max-width:<?php echo '80%';    ?>;
    }
    
    <?php
        $selectedTooltipStyle = get_option("selectedTooltipStyle");
        if (! ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized'))) 
        {
            ?>
	.ui-wordpress-tooltip-pro
	{
	color: <?php echo $toolstipsTitleColor; ?> !important;
	width:<?php echo $toolstipswidth; ?>;
	font-size:<?php echo $toolstipsFontSize; ?>;
	line-height:<?php echo $toolstipsLineHeight; ?>;
	background-color: <?php echo $toolstipsbackground; ?>  !important;
	text-align:<?php echo $toolstipsTextAlignSelect; ?>  !important;
	border-width:<?php echo $toolstipsBorderWidth; ?>  !important;
	border-color: <?php echo $toolstipsBorderColor; ?> !important;
	border-style: solid !important;
	padding: <?php echo $toolstipsPadding; ?>;
	border-radius: <?php echo $toolstipsBorderRadius; ?>;
	font-style: <?php echo $tooltipcontentfontstyle; // 14.4.2 ?>;
	}
	.qtip-content
	{
		text-align:<?php echo $toolstipsTextAlignSelect; ?>  !important;
	}
	.ui-wordpress-tooltip-pro a
	{
		color: <?php echo $linkcoloroftooltipcontentintooltippop ?>  !important;
	}
<?php
            //23.0.8
            $toolstipsLineSpace = get_option("toolstipsLineSpace");
            if (!(empty($toolstipsLineSpace)))
            {
                $toolstipsLineSpace = $toolstipsLineSpace . 'px'; //20.3.8
                ?>
                .ui-wordpress-tooltip-pro br
                {
                    margin-bottom:<?php echo $toolstipsLineSpace; ?>;
                }
                <?php 
            }
            //end 23.0.8
            
            // !!! 15.1.2 and 15.1.6
            if ($toolstipsPadding == 0) {
                ?>
		.qtip-content
		{
			padding: 0  !important;
		}
		.qtip .qtip-tip canvas
		{
			display:none !important;
		}		
		<?php
            }
            // !!! end 15.1.2 and 15.1.6
            $toolstipsMargin = get_option("toolstipsMargin");
            $toolstipsMargin = trim($toolstipsMargin);
            if (! (empty($toolstipsMargin))) {
                $toolstipsMargin = get_option("toolstipsMargin");
                ?>
	.ui-wordpress-tooltip-pro
	{
		margin: <?php echo $toolstipsMargin; ?>;	
	}
<?php
            }

            $tooltipcolorofglossarylinkintooltippop = get_option("tooltipcolorofglossarylinkintooltippop");
            if (empty($tooltipcolorofglossarylinkintooltippop)) {
                $tooltipcolorofglossarylinkintooltippop = '#333';
            }
            ?>
			.tooltipglossarylinkintooltipbox a
			{
				color: <?php echo $tooltipcolorofglossarylinkintooltippop; ?>;
			}		
		<?php

            $coloroftooltipsupportlinkintooltippop = get_option("coloroftooltipsupportlinkintooltippop");
            if (empty($coloroftooltipsupportlinkintooltippop)) {
                $coloroftooltipsupportlinkintooltippop = '#333';
            }
            ?>
			.tooltipsPopupCreditLink a
			{
				color: <?php echo $coloroftooltipsupportlinkintooltippop; ?>;
			}		
		<?php

            if (! (empty($toolstipsTitleBackgrounColor))) {

                ?>
			.qtip-default .qtip-titlebar
			{
				font-size: <?php echo $toolstipsTitleFontSize; ?>;
				color: <?php echo $toolstipsTitleFontColor; ?>;
				background-color: <?php echo $toolstipsTitleBackgrounColor; ?>;
			}
			.qtip-icon .ui-icon
			{
				padding:2px;
			}
			<?php
            }

            // start 18.9.8
            $tooltipCloseButtonMargin = get_option("tooltipCloseButtonMargin");
            if (! (empty($tooltipCloseButtonMargin))) {
                $tooltipCloseButtonMargin = str_ireplace("px", "", $tooltipCloseButtonMargin);
                ?>
			.qtip-icon .ui-icon
			{
				margin:<?php echo $tooltipCloseButtonMargin.'px' ?>;
			}
			<?php
            }
            // end 18.9.8

            if ((! (empty($tiptooltiptitlefontfamily))) && ($tiptooltiptitlefontfamily != 'Default')) {
                $tiptooltiptitlefontfamilyCSS = '';
                if ($tiptooltiptitlefontfamily == 'Andale Mono') {
                    $tiptooltiptitlefontfamilyCSS = 'andale mono, monospace';
                }

                if ($tiptooltiptitlefontfamily == 'Arial') {
                    $tiptooltiptitlefontfamilyCSS = 'arial, helvetica, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Arial Black') {
                    $tiptooltiptitlefontfamilyCSS = 'arial black, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Book Antiqua') {
                    $tiptooltiptitlefontfamilyCSS = 'book antiqua, palatino, serif';
                }

                if ($tiptooltiptitlefontfamily == 'Comic Sans MS') {
                    $tiptooltiptitlefontfamilyCSS = 'comic sans ms, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Courier New') {
                    $tiptooltiptitlefontfamilyCSS = 'courier new, courier, monospace';
                }

                if ($tiptooltiptitlefontfamily == 'Georgia') {
                    $tiptooltiptitlefontfamilyCSS = 'georgia, palatino, serif';
                }

                if ($tiptooltiptitlefontfamily == 'Helvetica') {
                    $tiptooltiptitlefontfamilyCSS = 'helvetica, arial, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Impact') {
                    $tiptooltiptitlefontfamilyCSS = 'impact, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Symbol') {
                    $tiptooltiptitlefontfamilyCSS = 'symbol';
                }

                if ($tiptooltiptitlefontfamily == 'Tahoma') {
                    $tiptooltiptitlefontfamilyCSS = 'tahoma, arial, helvetica, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Terminal') {
                    $tiptooltiptitlefontfamilyCSS = 'terminal, monaco, monospace';
                }

                if ($tiptooltiptitlefontfamily == 'Times New Roman') {
                    $tiptooltiptitlefontfamilyCSS = 'times new roman, times, serif';
                }

                if ($tiptooltiptitlefontfamily == 'Trebuchet MS') {
                    $tiptooltiptitlefontfamilyCSS = 'trebuchet ms, geneva, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Verdana') {
                    $tiptooltiptitlefontfamilyCSS = 'verdana, geneva, sans-serif';
                }

                if ($tiptooltiptitlefontfamily == 'Webdings') {
                    $tiptooltiptitlefontfamilyCSS = 'webdings';
                }

                if ($tiptooltiptitlefontfamily == 'Wingdings') {
                    $tiptooltiptitlefontfamilyCSS = 'wingdings, zapf dingbats';
                }

                ?>
					.qtip-default .qtip-titlebar .qtip-title
					{
						font-family: <?php echo $tiptooltiptitlefontfamilyCSS; ?> !important;
					}
					<?php
            }

            if ((! (empty($tiptooltipcontentfontfamily))) && ($tiptooltipcontentfontfamily != 'Default')) {
                $tiptooltipcontentfontfamilyCSS = '';
                if ($tiptooltipcontentfontfamily == 'Andale Mono') {
                    $tiptooltipcontentfontfamilyCSS = 'andale mono, monospace';
                }

                if ($tiptooltipcontentfontfamily == 'Arial') {
                    $tiptooltipcontentfontfamilyCSS = 'arial, helvetica, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Arial Black') {
                    $tiptooltipcontentfontfamilyCSS = 'arial black, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Book Antiqua') {
                    $tiptooltipcontentfontfamilyCSS = 'book antiqua, palatino, serif';
                }

                if ($tiptooltipcontentfontfamily == 'Comic Sans MS') {
                    $tiptooltipcontentfontfamilyCSS = 'comic sans ms, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Courier New') {
                    $tiptooltipcontentfontfamilyCSS = 'courier new, courier, monospace';
                }

                if ($tiptooltipcontentfontfamily == 'Georgia') {
                    $tiptooltipcontentfontfamilyCSS = 'georgia, palatino, serif';
                }

                if ($tiptooltipcontentfontfamily == 'Helvetica') {
                    $tiptooltipcontentfontfamilyCSS = 'helvetica, arial, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Impact') {
                    $tiptooltipcontentfontfamilyCSS = 'impact, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Symbol') {
                    $tiptooltipcontentfontfamilyCSS = 'symbol';
                }

                if ($tiptooltipcontentfontfamily == 'Tahoma') {
                    $tiptooltipcontentfontfamilyCSS = 'tahoma, arial, helvetica, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Terminal') {
                    $tiptooltipcontentfontfamilyCSS = 'terminal, monaco, monospace';
                }

                if ($tiptooltipcontentfontfamily == 'Times New Roman') {
                    $tiptooltipcontentfontfamilyCSS = 'times new roman, times, serif';
                }

                if ($tiptooltipcontentfontfamily == 'Trebuchet MS') {
                    $tiptooltipcontentfontfamilyCSS = 'trebuchet ms, geneva, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Verdana') {
                    $tiptooltipcontentfontfamilyCSS = 'verdana, geneva, sans-serif';
                }

                if ($tiptooltipcontentfontfamily == 'Webdings') {
                    $tiptooltipcontentfontfamilyCSS = 'webdings';
                }

                if ($tiptooltipcontentfontfamily == 'Wingdings') {
                    $tiptooltipcontentfontfamilyCSS = 'wingdings, zapf dingbats';
                }

                ?>
							.qtip-default .qtip-content
							{
								font-family: <?php echo $tiptooltipcontentfontfamilyCSS; ?> !important;
							}
							<?php
            }

            if (! (empty($tooltipsCloseButtonBackground))) {
                ?>
			.qtip-default .qtip-icon
			{
				background-color: <?php echo $tooltipsCloseButtonBackground; ?>;
			}
			<?php
            }
            if (! (empty($tooltipCloseButtonRadius))) {
                ?>
			.qtip-icon, .qtip-icon .ui-icon
			{
    			-moz-border-radius: <?php echo $tooltipCloseButtonRadius; ?>;
    			-webkit-border-radius: <?php echo $tooltipCloseButtonRadius; ?>;
    			border-radius: <?php echo $tooltipCloseButtonRadius; ?>;
			}
			<?php
            }
            if (! (empty($tooltipCloseButtonFontColor))) {
                ?>
					.qtip-default .qtip-icon
					{
		    			color: <?php echo $tooltipCloseButtonFontColor; ?>;
					}
					.qtip-default .qtip-titlebar .qtip-close
					{
						color: <?php echo $tooltipCloseButtonFontColor; ?>;
					}
					<?php
            }
        } else {
            ?>
		.ui-wordpress-tooltip-pro .qtip-content
		{
			color: <?php echo $toolstipsTitleColor; ?>  !important;
			width:<?php echo $toolstipswidth; ?>;
			font-size:<?php echo $toolstipsFontSize; ?>;
			line-height:<?php echo $toolstipsLineHeight; ?>;
			background-color: <?php echo $toolstipsbackground; ?>;
			text-align:<?php echo $toolstipsTextAlignSelect; ?>;
			border-width:<?php echo $toolstipsBorderWidth; ?>;
			border-color: <?php echo $toolstipsBorderColor; ?>;
			border-style: solid;
			padding: <?php echo $toolstipsPadding; ?>;
			border-radius: <?php echo $toolstipsBorderRadius; ?>;
			}
		<?php
        }
        $tooltipShowShadowSelect = get_option("tooltipShowShadowSelect");
        if (empty($tooltipShowShadowSelect)) {
            $tooltipShowShadowSelect = 'hidden';
        }
        if ($tooltipShowShadowSelect == 'display') {
            $selectedTooltipStyle = get_option("selectedTooltipStyle");
            if (! ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized'))) {
                ?>
			.ui-wordpress-tooltip-pro
			{
				-webkit-box-shadow: 4px 4px 3px 1px rgba(0, 0, 0, 0.15);
				-moz-box-shadow: 4px 4px 3px 1px rgba(0, 0, 0, 0.15);
				box-shadow: 4px 4px 3px 1px rgba(0, 0, 0, 0.15);
			}
		<?php
            } else {
                ?>
			.ui-wordpress-tooltip-pro .qtip-content
			{	
				-webkit-box-shadow: 4px 4px 3px 1px rgba(0, 0, 0, 0.15);
				-moz-box-shadow: 4px 4px 3px 1px rgba(0, 0, 0, 0.15);
				box-shadow: 4px 4px 3px 1px rgba(0, 0, 0, 0.15);
			}			
			<?php
            }
        }

        $toolstipsUnderLineColor = get_option("toolstipsUnderLineColor");
        if (empty($toolstipsUnderLineColor)) {
            $toolstipsUnderLineColor = '#888';
        }

        $tooltipBorderBottomSelect = get_option("tooltipBorderBottomSelect");

        // !!! start 15.7.4
        if (empty($tooltipBorderBottomSelect)) {
            ?>
	.tooltipsall
	{
		    border-bottom:2px dotted <?php echo $toolstipsUnderLineColor; ?>;
	}		
		<?php
        } else {

            if ($tooltipBorderBottomSelect == 'dotted') {
                ?>
			.tooltipsall
			{
		    	border-bottom:2px dotted <?php echo $toolstipsUnderLineColor; ?>;
			}
		<?php
            } elseif ($tooltipBorderBottomSelect == 'double') {
                ?>
			.tooltipsall
			{
				border-bottom: 4px double <?php echo $toolstipsUnderLineColor; ?>;
			}			
			<?php
            } elseif ($tooltipBorderBottomSelect == 'solid') {
                ?>
			.tooltipsall
			{
				border-bottom: 1px solid <?php echo $toolstipsUnderLineColor; ?>;
			}			
			<?php
            } elseif ($tooltipBorderBottomSelect == 'dashed') {
                ?>
			.tooltipsall
			{
				border-bottom: 1px dashed <?php echo $toolstipsUnderLineColor; ?>;
			}			
			<?php
            } elseif ($tooltipBorderBottomSelect == 'hidden') {
                ?>
			.tooltipsall
			{
				border-bottom: 1px hidden <?php echo $toolstipsUnderLineColor; ?>;
			}			
			<?php
            }
        }
        // !!! end 15.7.4
        /*
         * //old before 15.7.4
         * if (empty($tooltipBorderBottomSelect))
         * {
         * ?>
         * .tooltipsall
         * {
         * border-bottom:2px dotted <?php echo $toolstipsUnderLineColor; ?> !important;
         * }
         * <?php
         * }
         * else
         * {
         *
         * if ($tooltipBorderBottomSelect == 'dotted')
         * {
         * ?>
         * .tooltipsall
         * {
         * border-bottom:2px dotted <?php echo $toolstipsUnderLineColor; ?> !important;
         * }
         * <?php
         * }
         * elseif ($tooltipBorderBottomSelect == 'double')
         * {
         * ?>
         * .tooltipsall
         * {
         * border-bottom: 4px double <?php echo $toolstipsUnderLineColor; ?> !important;
         * }
         * <?php
         * }
         * elseif ($tooltipBorderBottomSelect == 'solid')
         * {
         * ?>
         * .tooltipsall
         * {
         * border-bottom: 1px solid <?php echo $toolstipsUnderLineColor; ?> !important;
         * }
         * <?php
         * }
         * elseif ($tooltipBorderBottomSelect == 'dashed')
         * {
         * ?>
         * .tooltipsall
         * {
         * border-bottom: 1px dashed <?php echo $toolstipsUnderLineColor; ?> !important;
         * }
         * <?php
         * }
         * elseif ($tooltipBorderBottomSelect == 'hidden')
         * {
         * ?>
         * .tooltipsall
         * {
         * border-bottom: 1px hidden <?php echo $toolstipsUnderLineColor; ?> !important;
         * }
         * <?php
         * }
         * }
         * //old before 15.7.4
         */
        //!!! 28.2.8
        
        $tooltiptermfontweight = get_option('tooltiptermfontweight');
        if (empty($tooltiptermfontweight)) 
        {
            //$tooltiptermfontweight = 'normal';
            $tooltiptermfontweight = 'inherit';
        } 
        else 
        {
            ?>
			.tooltipsall
			{
			    font-weight: <?php echo $tooltiptermfontweight; ?>;
			}
		<?php
        }
        // end 28.2.8

        // !!! 14.1.6
        $tooltiptermfontstyle = get_option('tooltiptermfontstyle');
        if (empty($tooltiptermfontstyle)) {
            $tooltiptermfontstyle = 'normal';
        } else {
            ?>
			.tooltipsall
			{
			    font-style: <?php echo $tooltiptermfontstyle; ?>;
			}
		<?php
        }
        // end 14.1.6

        if (! (empty($toolstipsBorderRadius))) {
            ?>
		.qtip-default
		{
    		border: none;
    		background-color: initial;
    		color: inherit;
        }
		<?php
            // !!! 17.0.8 remove this not needed
            // } which under .qtip-default
        }
        ?>
</style>
<?php
    }

    // !!!17.0.8 start bullet css
    $tipbulletscontentfontfamily = get_option("tipbulletscontentfontfamily");
    if ((! (empty($tipbulletscontentfontfamily))) && ($tipbulletscontentfontfamily != 'Default')) {
        $tipbulletscontentfontfamilyCSS = '';
        if ($tipbulletscontentfontfamily == 'Andale Mono') {
            $tipbulletscontentfontfamilyCSS = 'andale mono, monospace';
        }

        if ($tipbulletscontentfontfamily == 'Arial') {
            $tipbulletscontentfontfamilyCSS = 'arial, helvetica, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Arial Black') {
            $tipbulletscontentfontfamilyCSS = 'arial black, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Book Antiqua') {
            $tipbulletscontentfontfamilyCSS = 'book antiqua, palatino, serif';
        }

        if ($tipbulletscontentfontfamily == 'Comic Sans MS') {
            $tipbulletscontentfontfamilyCSS = 'comic sans ms, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Courier New') {
            $tipbulletscontentfontfamilyCSS = 'courier new, courier, monospace';
        }

        if ($tipbulletscontentfontfamily == 'Georgia') {
            $tipbulletscontentfontfamilyCSS = 'georgia, palatino, serif';
        }

        if ($tipbulletscontentfontfamily == 'Helvetica') {
            $tipbulletscontentfontfamilyCSS = 'helvetica, arial, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Impact') {
            $tipbulletscontentfontfamilyCSS = 'impact, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Symbol') {
            $tipbulletscontentfontfamilyCSS = 'symbol';
        }

        if ($tipbulletscontentfontfamily == 'Tahoma') {
            $tipbulletscontentfontfamilyCSS = 'tahoma, arial, helvetica, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Terminal') {
            $tipbulletscontentfontfamilyCSS = 'terminal, monaco, monospace';
        }

        if ($tipbulletscontentfontfamily == 'Times New Roman') {
            $tipbulletscontentfontfamilyCSS = 'times new roman, times, serif';
        }

        if ($tipbulletscontentfontfamily == 'Trebuchet MS') {
            $tipbulletscontentfontfamilyCSS = 'trebuchet ms, geneva, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Verdana') {
            $tipbulletscontentfontfamilyCSS = 'verdana, geneva, sans-serif';
        }

        if ($tipbulletscontentfontfamily == 'Webdings') {
            $tipbulletscontentfontfamilyCSS = 'webdings';
        }

        if ($tipbulletscontentfontfamily == 'Wingdings') {
            $tipbulletscontentfontfamilyCSS = 'wingdings, zapf dingbats';
        }
        ?>
<style>
					.bulletscreenfortoolTips
					{
						font-family: <?php echo $tipbulletscontentfontfamilyCSS; ?> !important;
					}
        </style>
<?php
    }
    // !!! end 17.0.8 end bullet css

    /*
     * ?>
     * <script type="text/javascript">
     * var ajaxurl = '<?php echo esc_js( admin_url( 'admin-ajax.php', 'relative' ) ); ?>';
     *
     * function tooltipsdate()
     * {
     * var d=new Date();
     * str='';
     * str +=d.getFullYear()+'-';
     * str +=d.getMonth()+1+'-';
     * str +=d.getDate()+'-';
     * str +=d.getHours()+'-';
     * str +=d.getMinutes()+'-';
     * str +=d.getSeconds();
     * return str;
     * }
     * var nowtime = tooltipsdate();
     * var tooltipsClientIP = '<?php echo $clientIP; ?>';
     *
     * function toolTips(whichID,theTipContent,toolTipPostID,theTipTitle, toolTipCustomizedStyle)
     * {
     * <?php
     * $toolstipsPostionMyQtip2 = 'bottom center';
     * ?>
     * if (typeof toolTipPostID==='undefined')
     * {
     * toolTipPostID = '0';
     * }
     *
     * toolTipPostStyleName = 'ui-wordpress-tooltip-pro';
     * if (typeof toolTipCustomizedStyle==='undefined')
     * {
     * toolTipCustomizedStyle = 'ui-wordpress-tooltip-pro';
     * }
     *
     * jQuery(whichID).qtip
     * (
     * {
     * content:
     * {
     * <?php
     * $selectedTooltipStyle = get_option("selectedTooltipStyle");
     * $showToolstipsCloseButtonSelect = get_option("showToolstipsCloseButtonSelect");
     * if (!((!(empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized')))
     * {
     * $showToolstipsTitleSelect = get_option("showToolstipsTitleSelect");
     * if ($showToolstipsTitleSelect == 'yes')
     * {
     * echo "title:theTipTitle, ";
     * }
     * }
     * ?>
     * text:theTipContent,
     * <?php
     * if ((!(empty($showToolstipsCloseButtonSelect))) && ($showToolstipsCloseButtonSelect == 'yes'))
     * {
     * echo "button:'Close'";
     * }
     * ?>
     * },
     * postid:toolTipPostID,
     * <?php
     * $selectedTooltipStyle = get_option("selectedTooltipStyle");
     * if((!(empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized'))
     * {
     * $toolstipsPostionQtip2 = 'top center';
     * $toolstipsClass = $selectedTooltipStyle;
     * ?>
     * style:
     * {
     * classes:'<?php echo $toolstipsClass; ?>'
     *
     * },
     * <?php
     * $tooltipShowSelect = 'mouseover';
     * $tooltipHiddenSelect = 'mouseout';
     * }
     * else
     * {
     *
     * $toolstipswidth = get_option("toolstipswidth");
     * $toolstipsbackground = get_option("toolstipsbackground");
     * $toolstipsTextAlignSelect = get_option("toolstipsTextAlignSelect");
     * $toolstipsBorderWidth = get_option("toolstipsBorderWidth");
     * $toolstipsPadding = get_option("toolstipsPadding");
     * $toolstipsBorderWidth = get_option("toolstipsBorderWidth");
     * $toolstipsBorderColor = get_option("toolstipsBorderColor");
     * $tooltipShowSelect = get_option("tooltipShowSelect");
     * $tooltipHiddenSelect = get_option("tooltipHiddenSelect");
     * $toolstipsClass = get_option("toolstipsClass");
     * $toolstipsAnimationClass = get_option("toolstipsAnimationClass");
     * $toolstipsBorderRadius = get_option("toolstipsBorderRadius");
     * $toolstipsBorderRadius = get_option("toolstipsBorderRadius");
     * $toolstipsTitleColor = get_option("toolstipsTitleColor");
     * $toolstipsPostion = get_option("toolstipsPostion");
     * // 13.9.4
     * $tooltipTimeofHiddenStayAWhile = get_option('tooltipTimeofHiddenStayAWhile');
     * if (empty($tooltipTimeofHiddenStayAWhile))
     * {
     * $tooltipTimeofHiddenStayAWhile = 200;
     * }
     * // 13.9.4 end
     *
     * if (!(empty($toolstipsPostion)))
     * {
     *
     * if ($toolstipsPostion == 'bottomRight')
     * {
     * $toolstipsPostionQtip2 = 'bottom right';
     * $toolstipsPostionMyQtip2 = 'top left';
     * }
     * if ($toolstipsPostion == 'bottomLeft')
     * {
     * $toolstipsPostionQtip2 = 'bottom left';
     * $toolstipsPostionMyQtip2 = 'top right';
     * }
     * if ($toolstipsPostion == 'topRight')
     * {
     * $toolstipsPostionQtip2 = 'top right';
     * $toolstipsPostionMyQtip2 = 'bottom left';
     * }
     * if ($toolstipsPostion == 'topLeft')
     * {
     * $toolstipsPostionQtip2 = 'top left';
     * $toolstipsPostionMyQtip2 = 'bottom right';
     * }
     * if ($toolstipsPostion == 'topMiddle')
     * {
     * $toolstipsPostionQtip2 = 'top center';
     * $toolstipsPostionMyQtip2 = 'bottom center';
     * }
     * if ($toolstipsPostion == 'bottomMiddle')
     * {
     * $toolstipsPostionQtip2 = 'bottom center';
     * $toolstipsPostionMyQtip2 = 'top center';
     * }
     * if ($toolstipsPostion == 'rightMiddle')
     * {
     * $toolstipsPostionQtip2 = 'right center';
     * $toolstipsPostionMyQtip2 = 'left center';
     * }
     * if ($toolstipsPostion == 'leftMiddle')
     * {
     * $toolstipsPostionQtip2 = 'left center';
     * $toolstipsPostionMyQtip2 = 'right center';
     * }
     * }
     * ?>
     * style:
     * {
     * classes: toolTipCustomizedStyle + ' <?php echo $toolstipsClass; ?> '
     * },
     * <?php
     * }
     * ?>
     * position:
     * {
     * viewport: jQuery(window),
     * my: '<?php echo $toolstipsPostionMyQtip2; ?>',
     * at: <?php echo "'$toolstipsPostionQtip2'"; ?>
     * },
     * show:
     * {
     * <?php
     * $delaytooltippopup = get_option('delaytooltippopup');
     * if (empty($delaytooltippopup))
     * {
     * $delaytooltippopup = 0;
     * }
     * $delaytooltippopup = (int)$delaytooltippopup;
     * ?>
     * delay:<?php echo $delaytooltippopup; ?>,
     * event: '<?php if ($tooltipShowSelect == 'pageload') {echo 'mouseover';} else {echo $tooltipShowSelect;} // 11.9.2 ?>',
     * <?php if ($tooltipShowSelect == 'pageload')
     * {
     * echo "ready:'TRUE',";
     * }
     * // 11.9.2
     * ?>
     * effect: function() {
     * <?php
     * //14.4.8
     * $tooltipfadespeed = get_option('tooltipfadespeed');
     * if (empty($tooltipfadespeed))
     * {
     * $tooltipfadespeed = 200;
     * }
     *
     * ?>
     * jQuery(this).fadeTo(<?php echo $tooltipfadespeed; ?>, <?php echo $toolstipsOpacity; ?>);
     * jQuery('.qtip iframe').attr('id','stopplayingyoutube');
     * oldsrc = jQuery("#stopplayingyoutube").attr("oldsrc");
     *
     * if ('undefined' == oldsrc)
     * {
     *
     * }
     * else
     * {
     *
     * jQuery("#stopplayingyoutube").attr("src", jQuery("#stopplayingyoutube").attr("oldsrc"));
     * }
     * }
     * },
     * hide:
     * <?php
     * if ($tooltipHiddenSelect == "stayopen")
     * {
     * ?>
     * {
     * fixed: true,
     * // delay: 200,
     * delay: <?php echo $tooltipTimeofHiddenStayAWhile; // 13.9.4 ?>,
     * effect: function(offset)
     * {
     * jQuery('.qtip iframe').attr('id','stopplayingyoutube');
     * jQuery("#stopplayingyoutube").attr("oldsrc", jQuery("#stopplayingyoutube").attr("src"));
     * jQuery("#stopplayingyoutube").attr("src", '');
     * jQuery(this).slideDown(100); // "this" refers to the tooltip
     * }
     * }
     * <?php
     * }
     * else
     * {
     * // 11.9.6
     * if ($tooltipHiddenSelect == "never")
     * {
     * echo 'false';
     * }
     * else // 11.9.6
     * {
     * ?>
     * {
     * event: '<?php echo $tooltipHiddenSelect; ?>',
     * effect: function(offset)
     * {
     * jQuery('.qtip iframe').attr('id','stopplayingyoutube');
     * jQuery("#stopplayingyoutube").attr("oldsrc", jQuery("#stopplayingyoutube").attr("src"));
     * jQuery("#stopplayingyoutube").attr("src", '');
     * jQuery(this).slideDown(100); // "this" refers to the tooltip
     * }
     * }
     * <?php
     * }
     * }
     * ?>
     * }
     * )
     * }
     * </script>
     * <?php
     */
}

// !!! start 15.5.2
function loadTooltipsJs()
{
    global $post;
    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    $toolstipswidth = get_option("toolstipswidth");

    if (strtolower($toolstipswidth) == 'auto') {} else {
        $toolstipswidth = get_option("toolstipswidth") . 'px'; // !!! 14.8.2
    }
    // !!! old before 14.8.2 $toolstipswidth = get_option("toolstipswidth").'px';
    $toolstipsbackground = get_option("toolstipsbackground");
    $toolstipsTextAlignSelect = get_option("toolstipsTextAlignSelect");
    $toolstipsBorderWidth = get_option("toolstipsBorderWidth") . 'px';
    $toolstipsPadding = get_option("toolstipsPadding") . 'px';

    $toolstipsBorderColor = get_option("toolstipsBorderColor");
    $tooltipShowSelect = get_option("tooltipShowSelect");
    $tooltipHiddenSelect = get_option("tooltipHiddenSelect");
    $toolstipsClass = get_option("toolstipsClass");
    $toolstipsBorderRadius = get_option("toolstipsBorderRadius") . 'px';
    $toolstipsTitleColor = get_option("toolstipsTitleColor");
    $toolstipsPostion = get_option("toolstipsPostion");
    $toolstipsFontSize = get_option("toolstipsFontSize") . 'px';
    $toolstipsLineHeight = get_option("toolstipsLineHeight") . 'px';
    $toolstipsLineSpace = get_option("toolstipsLineSpace") . 'px'; //20.3.8
    $toolstipsTitleBackgrounColor = get_option("toolstipsTitleBackgrounColor");
    $toolstipsTitleFontColor = get_option("toolstipsTitleFontColor");
    $tooltipsCloseButtonBackground = get_option("tooltipsCloseButtonBackground");
    $tooltipCloseButtonRadius = get_option("tooltipCloseButtonRadius") . 'px';
    $toolstipsTitleFontSize = get_option("toolstipsTitleFontSize") . 'px';
    $tooltipCloseButtonFontColor = get_option("tooltipCloseButtonFontColor");
    $m_pluginURL = get_option('siteurl') . '/wp-content/plugins';
    $showImageinglossary = get_option("showImageinglossary");
    $tiptooltiptitlefontfamily = get_option("tiptooltiptitlefontfamily"); // !!!
    $tiptooltipcontentfontfamily = get_option("tiptooltipcontentfontfamily"); // !!!
    $glossaryTermUnderLineColorOnGlossaryPage = get_option("glossaryTermUnderLineColorOnGlossaryPage"); // !!!
    $glossaryTermFontColorOnGlossaryPage = get_option("glossaryTermFontColorOnGlossaryPage"); // !!!
    $glossaryIndexPageTermFontSize = get_option("glossaryIndexPageTermFontSize"); // !!!
    $glossaryContentFontColorOnGlossaryPage = get_option("glossaryContentFontColorOnGlossaryPage"); // !!!
                                                                                                    // !!! start 14.4.2
    $tooltipcontentfontstyle = get_option('tooltipcontentfontstyle');

    if (empty($tooltipcontentfontstyle)) {
        $tooltipcontentfontstyle = 'normal';
    }
    // !!! end 14.4.2

    $linkcoloroftooltipcontentintooltippop = get_option('linkcoloroftooltipcontentintooltippop'); // 14.9.2
    if (empty($linkcoloroftooltipcontentintooltippop)) {
        $linkcoloroftooltipcontentintooltippop = 'auto'; // that means this will not work
    }

    $tooltipZindexValue = get_option("tooltipZindexValue");
    if (empty($tooltipZindexValue)) {
        $tooltipZindexValue = 15001;
    }

    $glossaryglossarylistbordercolor = get_option("glossaryglossarylistbordercolor");

    $inputtextglossarytermtitlebackgroundcolor = get_option("inputtextglossarytermtitlebackgroundcolor");
    $inputtextglossarytermcontentbackgroundcolor = get_option("inputtextglossarytermcontentbackgroundcolor");

    $toolstipsTermColor = get_option("toolstipsTermColor");

    $toolstipsTermColorinPost = get_option("toolstipsTermColorinPost");

    $toolstipsOpacity = get_option("toolstipsOpacity");
    if (empty($toolstipsOpacity)) {
        $toolstipsOpacity = 1;
        $toolstipsOpacity100 = 100;
    } else {
        $toolstipsOpacity100 = $toolstipsOpacity * 100;
    }
    $clientIP = tooltipsGetIP();

    $selectedTooltipStyle = get_option("selectedTooltipStyle");
    if ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized')) {} else {
        $selectedTooltipStyle = get_option("selectedTooltipStyle");
        if (! ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized'))) {

            if ($toolstipsPadding == 0) {}

            $toolstipsMargin = get_option("toolstipsMargin");
            $toolstipsMargin = trim($toolstipsMargin);
            if (! (empty($toolstipsMargin))) {
                $toolstipsMargin = get_option("toolstipsMargin");
            }

            $tooltipcolorofglossarylinkintooltippop = get_option("tooltipcolorofglossarylinkintooltippop");

            $coloroftooltipsupportlinkintooltippop = get_option("coloroftooltipsupportlinkintooltippop");
        }

        $tooltipShowShadowSelect = get_option("tooltipShowShadowSelect");
        if (empty($tooltipShowShadowSelect)) {
            $tooltipShowShadowSelect = 'hidden';
        }
        if ($tooltipShowShadowSelect == 'display') {
            $selectedTooltipStyle = get_option("selectedTooltipStyle");
        }

        $toolstipsUnderLineColor = get_option("toolstipsUnderLineColor");
        if (empty($toolstipsUnderLineColor)) {
            $toolstipsUnderLineColor = '#888';
        }

        $tooltipBorderBottomSelect = get_option("tooltipBorderBottomSelect");

        $tooltiptermfontstyle = get_option('tooltiptermfontstyle');
    }
    ?>
<script type="text/javascript">
	var ajaxurl = '<?php echo esc_js( admin_url( 'admin-ajax.php', 'relative' ) ); ?>';
	
	function tooltipsdate()
	{
			var d=new Date();
			str='';
			str +=d.getFullYear()+'-';
			str +=d.getMonth()+1+'-';
			str +=d.getDate()+'-';
			str +=d.getHours()+'-';
			str +=d.getMinutes()+'-';
			str +=d.getSeconds();
			return str; 
	}
	var nowtime = tooltipsdate();
	var tooltipsClientIP = '<?php echo $clientIP;  ?>';
<?php 
//21.1.8 
/*
 * 		theTipContent = theTipContent.replace('[[[[[','');
		theTipContent = theTipContent.replace(']]]]]','');
 */
?>
	function toolTips(whichID,theTipContent,toolTipPostID,theTipTitle, toolTipCustomizedStyle) 
	{
		theTipContent = theTipContent.replace('[[[[[','');
		theTipContent = theTipContent.replace(']]]]]','');
		theTipContent = theTipContent.replace('@@@@','');
		theTipContent = theTipContent.replace('####','');
		theTipContent = theTipContent.replace('%%%%','');
		theTipContent = theTipContent.replace('//##','');
		theTipContent = theTipContent.replace('##]]','');
    				
		<?php
    $toolstipsPostionMyQtip2 = 'bottom center';
    ?>
		if (typeof toolTipPostID==='undefined')
		{
			toolTipPostID = '0';
		}

		toolTipPostStyleName = 'ui-wordpress-tooltip-pro';
		if (typeof toolTipCustomizedStyle==='undefined')
		{
			toolTipCustomizedStyle = 'ui-wordpress-tooltip-pro';
		}

			jQuery(whichID).qtip
			(
				{
					content:
					{
						<?php
    $selectedTooltipStyle = get_option("selectedTooltipStyle");
    $showToolstipsCloseButtonSelect = get_option("showToolstipsCloseButtonSelect");
    if (! ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized'))) {
        $showToolstipsTitleSelect = get_option("showToolstipsTitleSelect");
        if ($showToolstipsTitleSelect == 'yes') {
            echo "title:theTipTitle, ";
        }
    }
    ?>
							text:theTipContent,
						<?php
    if ((! (empty($showToolstipsCloseButtonSelect))) && ($showToolstipsCloseButtonSelect == 'yes')) {
        echo "button:'Close'";
    }
    ?>
					},
    				postid:toolTipPostID,  					
<?php
    $selectedTooltipStyle = get_option("selectedTooltipStyle");
    if ((! (empty($selectedTooltipStyle))) && ($selectedTooltipStyle != 'customized')) {
        $toolstipsPostionQtip2 = 'top center';
        $toolstipsClass = $selectedTooltipStyle;
        ?>
						style:
	   					{
							classes:'<?php echo $toolstipsClass; ?>'
							
	    				},
						<?php
        $tooltipShowSelect = 'mouseover';
        $tooltipHiddenSelect = 'mouseout';
    } else {

        $toolstipswidth = get_option("toolstipswidth");
        $toolstipsbackground = get_option("toolstipsbackground");
        $toolstipsTextAlignSelect = get_option("toolstipsTextAlignSelect");
        $toolstipsBorderWidth = get_option("toolstipsBorderWidth");
        $toolstipsPadding = get_option("toolstipsPadding");
        $toolstipsBorderWidth = get_option("toolstipsBorderWidth");
        $toolstipsBorderColor = get_option("toolstipsBorderColor");
        $tooltipShowSelect = get_option("tooltipShowSelect");
        $tooltipHiddenSelect = get_option("tooltipHiddenSelect");
        $toolstipsClass = get_option("toolstipsClass");
        $toolstipsAnimationClass = get_option("toolstipsAnimationClass");
        $toolstipsBorderRadius = get_option("toolstipsBorderRadius");
        $toolstipsBorderRadius = get_option("toolstipsBorderRadius");
        $toolstipsTitleColor = get_option("toolstipsTitleColor");
        $toolstipsPostion = get_option("toolstipsPostion");
        // 13.9.4
        $tooltipTimeofHiddenStayAWhile = get_option('tooltipTimeofHiddenStayAWhile');
        if (empty($tooltipTimeofHiddenStayAWhile)) {
            $tooltipTimeofHiddenStayAWhile = 200;
        }
        // 13.9.4 end

        if (! (empty($toolstipsPostion))) {

            if ($toolstipsPostion == 'bottomRight') {
                $toolstipsPostionQtip2 = 'bottom right';
                $toolstipsPostionMyQtip2 = 'top left';
            }
            if ($toolstipsPostion == 'bottomLeft') {
                $toolstipsPostionQtip2 = 'bottom left';
                $toolstipsPostionMyQtip2 = 'top right';
            }
            if ($toolstipsPostion == 'topRight') {
                $toolstipsPostionQtip2 = 'top right';
                $toolstipsPostionMyQtip2 = 'bottom left';
            }
            if ($toolstipsPostion == 'topLeft') {
                $toolstipsPostionQtip2 = 'top left';
                $toolstipsPostionMyQtip2 = 'bottom right';
            }
            if ($toolstipsPostion == 'topMiddle') {
                $toolstipsPostionQtip2 = 'top center';
                $toolstipsPostionMyQtip2 = 'bottom center';
            }
            if ($toolstipsPostion == 'bottomMiddle') {
                $toolstipsPostionQtip2 = 'bottom center';
                $toolstipsPostionMyQtip2 = 'top center';
            }
            if ($toolstipsPostion == 'rightMiddle') {
                $toolstipsPostionQtip2 = 'right center';
                $toolstipsPostionMyQtip2 = 'left center';
            }
            if ($toolstipsPostion == 'leftMiddle') {
                $toolstipsPostionQtip2 = 'left center';
                $toolstipsPostionMyQtip2 = 'right center';
            }
        }
        ?>
					style:
   					{
						classes: toolTipCustomizedStyle + ' <?php echo $toolstipsClass; ?> '
    				},
    				<?php
    }
    ?>
					position:
    				{
    					viewport: jQuery(window),
    					my: '<?php echo $toolstipsPostionMyQtip2; ?>',
    					at: <?php echo "'$toolstipsPostionQtip2'"; ?>
    				},
					show:
						{
						<?php
    $delaytooltippopup = get_option('delaytooltippopup');
    if (empty($delaytooltippopup)) {
        $delaytooltippopup = 0;
    }
    $delaytooltippopup = (int) $delaytooltippopup;
    ?>
						delay:<?php echo $delaytooltippopup; ?>,
						event: '<?php if ($tooltipShowSelect == 'pageload') {echo 'mouseover';} else {echo $tooltipShowSelect;}  // 11.9.2 ?>',
						<?php

if ($tooltipShowSelect == 'pageload') {
        echo "ready:'TRUE',";
    }
    // 11.9.2
    ?>
						effect: function() {
							<?php
    // 14.4.8
    $tooltipfadespeed = get_option('tooltipfadespeed');
    if (empty($tooltipfadespeed)) {
        $tooltipfadespeed = 200;
    }
    /*
     * jQuery(this).fadeTo(200, <?php echo $toolstipsOpacity; ?>);
     */
    ?>
			                jQuery(this).fadeTo(<?php echo $tooltipfadespeed; ?>, <?php echo $toolstipsOpacity; ?>);
			                		jQuery('.qtip iframe').attr('id','stopplayingyoutube');
			                		oldsrc =  jQuery("#stopplayingyoutube").attr("oldsrc");

			                		if ('undefined' == oldsrc)
			                		{

			                		}
			                		else
			                		{

			                			jQuery("#stopplayingyoutube").attr("src", jQuery("#stopplayingyoutube").attr("oldsrc"));
			                		}
			            }
						},
                        <?php /* //25.9.8 */ ?>
                    events: {
                        render: function(event, api) 
                        {
                            var contentElement = api.elements.content;
                            var currentpopupwindow = 'tooltip_window_for_post_id_' + toolTipPostID;
                            jQuery(contentElement).addClass(currentpopupwindow);
                            var isPlaying = false;
                            var playButton = jQuery(".ttsTooltipPlayButton");
                            jQuery('.ttsTooltipPlayButton', api.elements.content).click(function() 
                            {
                                if (isPlaying) {
                                jQuery(this).parent().parent().articulate('stop');
                                playButton.text("Click to Listen");
                                isPlaying = false;
                                } else {
                                    jQuery(this).parent().parent().articulate('rate','0.8');
                                    jQuery(this).parent().parent().articulate('speak');
                                playButton.text(" Click to Stop ");
                                isPlaying = true;
                                }
                            });
                        }
                    },
                     <?php   //end 25.9.8  ?>						
					hide:
						<?php
    if ($tooltipHiddenSelect == "stayopen") {
        ?>
								{
									fixed: true, 
									// delay: 200,
									delay: <?php echo $tooltipTimeofHiddenStayAWhile;  // 13.9.4 ?>,
									effect: function(offset) 
									{
										jQuery('.qtip iframe').attr('id','stopplayingyoutube');
							 			jQuery("#stopplayingyoutube").attr("oldsrc", jQuery("#stopplayingyoutube").attr("src"));
										 jQuery("#stopplayingyoutube").attr("src", '');
							            jQuery(this).slideDown(100); // "this" refers to the tooltip
							        }
								}
						<?php
    } else {
        // 11.9.6
        if ($tooltipHiddenSelect == "never") {
            echo 'false';
        } else // 11.9.6
        {
            // 19.6.8
            if ($tooltipHiddenSelect == "outoftooltip") {

                echo 'false';
            } else {
                // end 19.6.8
                ?>						
    									{
    										event: '<?php echo $tooltipHiddenSelect; ?>',
    										effect: function(offset) 
    										{
    											jQuery('.qtip iframe').attr('id','stopplayingyoutube');
    								 			jQuery("#stopplayingyoutube").attr("oldsrc", jQuery("#stopplayingyoutube").attr("src"));
    											jQuery("#stopplayingyoutube").attr("src", '');
    								            jQuery(this).slideDown(100); // "this" refers to the tooltip
    								        }
    									}
							<?php
            }
        }
    }
    ?>						
				}
			)
	}
</script>

<?php
}

$loadTooltipJsInHeaderOrFooter = get_option("loadTooltipJsInHeaderOrFooter");
if (empty($loadTooltipJsInHeaderOrFooter)) {
    $loadTooltipJsInHeaderOrFooter = 'HEADER';
}
// HEADER
// FOOTER
if ($loadTooltipJsInHeaderOrFooter == 'HEADER') {
    add_action('wp_head', 'loadTooltipsJs');
}
if ($loadTooltipJsInHeaderOrFooter == 'FOOTER') {
    add_action('wp_footer', 'loadTooltipsJs');
}

// !!! end 15.5.2
function nextgenTooltipsPro_brefore_2098()
{
    global $post;

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6
//21.2.8 old:
/*
if (tempAlt !== '')
{
    
    toolTips(jQuery(this),jQuery(this).attr('alt'),'0');
}
 */
    ?>
<script type="text/javascript">
jQuery("document").ready(function()
{
	jQuery("body img").each(function()
	{
		if ((jQuery(this).parent("a").attr('title') != '' )  && (jQuery(this).parent("a").attr('title') != undefined ))
		{
			toolTips(jQuery(this).parent("a"),jQuery(this).parent("a").attr('title'),'0');
		}
		else
		{
			var tempAlt = jQuery(this).attr('alt');
			if (typeof(tempAlt) !== "undefined")
			{

				tempAlt = tempAlt.replace(' ', '');
				if (tempAlt !== '')
				{
                    var alt = jQuery(this).attr('alt');
                    var prefix = alt.substr(0, 9);
                    if (prefix === 'tooltips-') {
                        var decodedAlt = atob(alt.substr(9));
                        
                        toolTips(jQuery(this),decodedAlt,'0');
                    }
                    else
    				{
						toolTips(jQuery(this),jQuery(this).attr('alt'),'0');
					}
				}
			}
		}
	}

	);
});
</script>
<?php
}

function nextgenTooltipsPro()
{
    global $post;
    
    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }
    
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6
    
    ?>
<script type="text/javascript">
jQuery("document").ready(function()
{
	jQuery("body img").each(function()
	{
		if ((jQuery(this).parent("a").attr('title') != '' )  && (jQuery(this).parent("a").attr('title') != undefined ))
		{
			toolTips(jQuery(this).parent("a"),jQuery(this).parent("a").attr('title'),'0');
		}
		else
		{
			var tempAlt = jQuery(this).attr('alt');
			if (typeof(tempAlt) !== "undefined")
			{

				tempAlt = tempAlt.replace(' ', '');
				if (tempAlt !== '')
				{
                    var alt = jQuery(this).attr('alt');
                    var prefix = alt.substr(0, 9);
                    if (prefix === 'tooltips-') { 
                        var decodedAlt = atob(alt.substr(9));
            
            			toolTips(jQuery(this),decodedAlt,'0');
                    }
                    else
                    {
                    toolTips(jQuery(this),jQuery(this).attr('alt'),'0');
                    }
				}
			}
		}
	}
	);
});
</script>
<?php
}

function imageTooltipsRel()
{
    global $post;

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6
/* 
 * 				if (tempREL !== '')
				{
					toolTips(jQuery(this),jQuery(this).parent("a").attr('rel'),'0');
				}
 */
    
    ?>
<script type="text/javascript">
jQuery("document").ready(function()
{
	jQuery("a img").each(function()
	{
			var tempREL = jQuery(this).parent("a").attr('rel');
			if (typeof(tempREL) !== "undefined")
			{
				tempAlt = tempREL.replace(' ', '');
				if (tempREL !== '')
				{
                    var alt = jQuery(this).attr('alt');
                    var prefix = alt.substr(0, 9);
                    if (prefix === 'tooltips-') { 
                        var decodedAlt = atob(alt.substr(9));
            
            			toolTips(jQuery(this),decodedAlt,'0');
                    }
                    else
                    {				
						toolTips(jQuery(this),jQuery(this).parent("a").attr('rel'),'0');
					}
				}
			}
	});
});
</script>
<?php
}

/*
 * 
 * 21.3.8
 * 			if ((jQuery(this).attr('title') != '' )  && (jQuery(this).attr('title') != undefined ))
			{
				toolTips(jQuery(this),jQuery(this).attr('title'),'0');
			}
 */

function imageTooltipsTitle()
{
    global $post;

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    ?>
<script type="text/javascript">
jQuery("document").ready(function()
{
	jQuery("img").each(function()
	{
		if ((jQuery(this).parent("a").attr('title') != '' )  && (jQuery(this).parent("a").attr('title') != undefined ))
		{
			toolTips(jQuery(this).parent("a"),jQuery(this).parent("a").attr('title'),'0');
		}
		else
		{
			if ((jQuery(this).attr('title') != '' )  && (jQuery(this).attr('title') != undefined ))
			{
                    var alt = jQuery(this).attr('title');
                    var prefix = alt.substr(0, 9);
                    if (prefix === 'tooltips-') { 
                        var decodedAlt = atob(alt.substr(9));
            
            			toolTips(jQuery(this),decodedAlt,'0');
                    }
                    else
                    {
                    	toolTips(jQuery(this),jQuery(this).attr('title'),'0');
                    }			
				
			}

		}
	}

	);
});
</script>
<?php
}

function imageTooltipsAlt()
{
    global $post;

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    ?>
<script type="text/javascript">
jQuery("document").ready(function()
{
	jQuery("img").each(function()
	{
    	var tempAlt = jQuery(this).attr('alt');
<?php 
//31.3.8 start
?>
        var imgSrcRemoveTooltip = jQuery(this).attr('src');
        var imgSrcRemoveTooltipName = imgSrcRemoveTooltip.split('/').pop();
<?php
        $disabletooltiponspecifimage = get_option("disabletooltiponspecifimage");
        if (! (empty($disabletooltiponspecifimage))) {
            $patterns = '';
            $replacements = '';
            $disabletooltiponspecifimage = trim($disabletooltiponspecifimage);
            $disabletooltiponspecifimagearray = explode(',', $disabletooltiponspecifimage);

            if ((! (empty($disabletooltiponspecifimagearray))) && (is_array($disabletooltiponspecifimagearray)) && (count($disabletooltiponspecifimagearray) > 0)) 
            {
                $disabletooltiponspecifimagearray = array_filter($disabletooltiponspecifimagearray);
            }

            if ((! (empty($disabletooltiponspecifimagearray))) && (is_array($disabletooltiponspecifimagearray)) && (count($disabletooltiponspecifimagearray) > 0)) 
            {
                //echo '<script type="text/javascript">';
                foreach ($disabletooltiponspecifimagearray as $disabletooltiponspecifimageSingle) 
                {
                    $disabletooltiponspecifimageSingle = trim($disabletooltiponspecifimageSingle);
                    ?>
                    if (imgSrcRemoveTooltipName == '<?php echo $disabletooltiponspecifimageSingle;?>' )
                    {
                        return;
                    }
                    <?php
                }
            }
        }
//31.3.8 end
?>
			if (typeof(tempAlt) !== "undefined")
			{
				tempAlt = tempAlt.replace(' ', '');
				
				if (tempAlt !== '')
				{
					toolTips(jQuery(this),jQuery(this).attr('alt'),'0');
				}
			}
	}
	);
});
</script>
<?php
}

$selectedTooltipStyle1 = get_option("selectedTooltipStyle");
if (empty($selectedTooltipStyle1)) {
    update_option("selectedTooltipStyle", "defaults");
}

$tooltipHookPriorityValue = get_option("tooltipHookPriorityValue");
if (empty($tooltipHookPriorityValue)) {
    $tooltipHookPriorityValue = 10;
}

$tooltipHookPriorityValuePlus = $tooltipHookPriorityValue + 1;

// 15.7.0
$seletOnlyTooltipShortcode = get_option('seletOnlyTooltipShortcode');
/*
 * if ($seletOnlyTooltipShortcode == 'YES')
 * {
 * add_action('the_content','tooltipsInContentProWithShortcodeOnly',$tooltipHookPriorityValuePlus);
 * }
 * else
 * {
 * add_action('the_content','tooltipsInContentPro',$tooltipHookPriorityValuePlus);
 * }
 */
// !!! start 15.7.4
$disableTooltipandEnableGlossary = get_option('disableTooltipandEnableGlossary');
if ($disableTooltipandEnableGlossary == 'YES') {} else {
    if ($seletOnlyTooltipShortcode == 'YES') {
        add_action('the_content', 'tooltipsInContentProWithShortcodeOnly', $tooltipHookPriorityValuePlus);
    } else {
        add_action('the_content', 'tooltipsInContentPro', $tooltipHookPriorityValuePlus);
    }
}

// !!! end 15.7.4
function tooltipsInContentProWithShortcodeOnly($content)
{
    global $post;

    if (is_admin()) {
        return $content;
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return $content;
    }
    // 11.4.6

    $disableInHomePage = get_option("disableInHomePage");

    if ($disableInHomePage == 'NO') {
        if (is_home() || is_front_page()) {
            return $content;
        }
    }

    $showOnlyInSingleCategory = get_option("showOnlyInSingleCategory");

    if ($showOnlyInSingleCategory != 0) {

        $post_cats = wp_get_post_categories($post->ID);
        if (in_array($showOnlyInSingleCategory, $post_cats)) {} else {
            return $content;
        }
    }

    $content = str_ireplace('[[[[[', '', $content);
    $content = str_ireplace(']]]]]', '', $content);

    return $content;
}
// !!! end 15.7.0

// !!! old before 15.7.0 add_action('the_content','tooltipsInContentPro',$tooltipHookPriorityValuePlus);

// 11.2.6
$enableTooltipsForTags = get_option("enableTooltipsForTags");
if ($enableTooltipsForTags == 'YES') {
    add_action('the_tags', 'tooltipsInContentPro', $tooltipHookPriorityValuePlus);
}

// 11.2.6
add_action('wp_head', 'loadTooltipsStyle');

// 14.4.6
function loadGlossaryStylePro()
{
    global $post;
    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    $glossarynavtextdecoration = get_option("glossarynavtextdecoration");
    if (empty($glossarynavtextdecoration)) {
        $glossarynavtextdecoration = 'no';
    }

    if ($glossarynavtextdecoration == 'no') {
        ?>
<style type="text/css">
.navitems a {
	text-decoration: none !important;
}
</style>
<?php
    }
    // 16.0.0

    //22.0.8
    $marginforallltteringlossarynavbar = get_option("marginforallltteringlossarynavbar");
    if (!(empty($marginforallltteringlossarynavbar)))
    {
        $marginforallltteringlossarynavbar = $marginforallltteringlossarynavbar.'px';
        ?>
        <style type="text/css">
        .navitems a {
            margin: <?php echo $marginforallltteringlossarynavbar; ?> !important;
        }
        </style>
        <?php 
    }
    
    //end 22.0.8
    
    //22.1.8
    
    $paddingforallltteringlossarynavbar = get_option("paddingforallltteringlossarynavbar");
    if (!(empty($paddingforallltteringlossarynavbar)))
    {
        $paddingforallltteringlossarynavbar = $paddingforallltteringlossarynavbar.'px';
        ?>
        <style type="text/css">
        .navitems a {
            padding: <?php echo $paddingforallltteringlossarynavbar; ?> !important;
        }
        </style>
        <?php 
    }
    //end 22.1.8
    
    $glossaryColorofLettersHaveNoTerm = get_option('glossaryColorofLettersHaveNoTerm'); // 16.0.0
    if (! (empty($glossaryColorofLettersHaveNoTerm))) {
        ?>
<style type="text/css">
			.navitemzerocount
			{
				color: <?php echo $glossaryColorofLettersHaveNoTerm; ?> !important;
			}
		</style>
<?php
    }

    // 16.0.8
    $glossaryColorofLettersHaveTerm = get_option('glossaryColorofLettersHaveTerm'); // 16.0.8
    if (! (empty($glossaryColorofLettersHaveTerm))) {
        ?>
<style type="text/css">
			.navitemhavecount
			{
				color: <?php echo $glossaryColorofLettersHaveTerm; ?> !important;
			}
		</style>
<?php
    }
}

// 14.4.6
add_action('wp_head', 'loadGlossaryStylePro');

$enableTooltipsForExcerpt = get_option("enableTooltipsForExcerpt");
if ($enableTooltipsForExcerpt == 'YES') {
    // before 16.5.8 add_action('the_excerpt','tooltipsInContentPro',$tooltipHookPriorityValuePlus);
    // 16.5.8 for some new wordpress block theme
    // works well before 16.7.4 add_action('get_the_excerpt','tooltipsInContentPro',$tooltipHookPriorityValue+1);
    // end 16.5.8
    // !!! 16.7.4
    $disableTooltipandEnableGlossary = get_option('disableTooltipandEnableGlossary');

    if ($disableTooltipandEnableGlossary == 'YES') {} else {
        add_action('get_the_excerpt', 'tooltipsInContentPro', $tooltipHookPriorityValue + 1);
    }

    // !!! end 16.7.4
}

$enableTooltipsForTitle = get_option("enableTooltipsForTitle");
if ($enableTooltipsForTitle == 'YES') {
    add_filter('the_title', 'tooltipsInTitle', $tooltipHookPriorityValue, 2);
    $tooltipHookPriorityValuePlus = $tooltipHookPriorityValue + 1;
}


$enableTooltipsForCategoryTitle = get_option("enableTooltipsForCategoryTitle");
if ($enableTooltipsForCategoryTitle == 'YES') {
    add_filter('get_the_archive_title', 'tooltipsInTitle', $tooltipHookPriorityValue, 2);
    $tooltipHookPriorityValuePlus = $tooltipHookPriorityValue + 1;
}

$enableTooltipsForImageCheck = get_option("enableTooltipsForImage");
if ($enableTooltipsForImageCheck == false) {
    update_option("enableTooltipsForImage", "YES");
}
if ($enableTooltipsForImageCheck == 'YES') {
    $tooltipsForImageSettingCheck = get_option("tooltipsForImageSetting");
    if ($tooltipsForImageSettingCheck == 'NEXTGEN') {
        add_action('wp_footer', 'nextgenTooltipsPro');
    }
    if ($tooltipsForImageSettingCheck == 'IMGALT') {
        add_action('wp_footer', 'imageTooltipsAlt');
    }
    if ($tooltipsForImageSettingCheck == 'IMGREL') {
        add_action('wp_footer', 'imageTooltipsRel');
    }
    if ($tooltipsForImageSettingCheck == 'LINKTITLE') {
        add_action('wp_footer', 'imageTooltipsTitle');
    }
    if ($tooltipsForImageSettingCheck == '') {
        add_action('wp_footer', 'nextgenTooltipsPro');
    }
}

function tooltips_get_option_pro($type, $orderby = 'null', $orderdesc = 'null', $funccall = 'null')
{
    global $wpdb;
    $tooltipsarray = array();
    $m_single = array();
    if ($type == 'tooltipsarray') {
        $post_type = 'tooltips';
        if (($orderby == 'null') || ($orderdesc == 'null')) {
            $orderbysql = '';
        } else {
            if ($funccall == 'null') {
                $orderbysql = "ORDER BY $orderby $orderdesc";
            } else {
                $orderbysql = "ORDER BY $funccall($orderby) $orderdesc";
            }
        }

        // !!! 14.9.6
        // $get_post_meta_value_for_only_allow_specific_category_tooltips = get_post_meta($current_page_id, 'only_allow_specific_category_to_this_page', true); // !!! 14.9.6

        $sql = $wpdb->prepare("SELECT ID, post_title, post_content, post_excerpt FROM $wpdb->posts WHERE post_type=%s AND post_status='publish' $orderbysql", $post_type);
        $results = $wpdb->get_results($sql);

        if ((! (empty($results))) && (is_array($results)) && (count($results) > 0)) {
            $m_single = array();
            foreach ($results as $single) {
                // !!! 15.0.8
                if (empty($single->post_title)) {
                    continue;
                }
                // !!! end 15.0.8

                $m_single['keyword'] = $single->post_title;
                $m_single['content'] = $single->post_content;
                $m_single['post_id'] = $single->ID;

                //26.2.8
                
                
                $get_post_meta_value_for_tt_use_post_title_and_content_as_tooltips_via_id = get_post_meta($single->ID, 'tt_use_post_title_and_content_as_tooltips_via_id', true);
                if (!(empty($get_post_meta_value_for_tt_use_post_title_and_content_as_tooltips_via_id)))
                {
                    $tooltips_via_post = get_post($get_post_meta_value_for_tt_use_post_title_and_content_as_tooltips_via_id);
                    
                    
                    if (!(empty($tooltips_via_post)))
                    {
                        //$tt_tooltips_for_wp_how_to_bar_title = $tooltips_via_post->post_title;
                        //$tt_tooltips_for_wp_how_to_bar_content = $tooltips_via_post->post_content;
                        
                        $m_single['content'] = $tooltips_via_post->post_content;
                        if (! (empty($m_single['content'])))
                        {
                            // !!! 15.0.4 //$m_single['post_excerpt'] = wp_trim_excerpt($single->post_content); //!!! 12.9.0
                            // !!! 15.0.4 start
                            
                            //before 27.0.8 $excerpt_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');

                            //27.0.8
                            $excerpt_more = tt_excerpt_more($single->ID,'Read More');

                            $excerpt_length = 55;
                            //!!! before 26.1.8 $m_single['post_excerpt'] = tt_wp_trim_words($single->post_content, $excerpt_length, $excerpt_more);
                            $m_single['post_excerpt'] = tt_wp_trim_words($m_single['content'], $excerpt_length, $excerpt_more);
                            
                            // !!! 15.0.4 end
                        }
                        
                    }
                }
                
                //!!! end 26.2.8
                if (empty($single->post_excerpt)) 
                {
                    //!!! works well before 26.1.8 if (! (empty($single->post_content))) 
                    if (! (empty($m_single['content'])))
                    {
                        // !!! 15.0.4 //$m_single['post_excerpt'] = wp_trim_excerpt($single->post_content); //!!! 12.9.0
                        // !!! 15.0.4 start
                        //before 27.0.8 $excerpt_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');
                        
                        //27.0.8
                        $excerpt_more = tt_excerpt_more($single->ID,'Read More');
                        
                        

                        $excerpt_length = 55;
                        //!!! before 26.1.8 $m_single['post_excerpt'] = tt_wp_trim_words($single->post_content, $excerpt_length, $excerpt_more);
                        $m_single['post_excerpt'] = tt_wp_trim_words($m_single['content'], $excerpt_length, $excerpt_more);
                        
                        // !!! 15.0.4 end
                    } 
                    else 
                    {
                        $m_single['post_excerpt'] = $single->post_excerpt; // !!! 12.9.0
                    }
                }
                else 
                {
                    $m_single['post_excerpt'] = $single->post_excerpt; // !!! 12.9.0
                }

                // wikipedia
                $get_post_meta_wikipedia_for_this_page = get_post_meta($single->ID, 'tooltip_wikipedia_keyword', true);
                $get_post_meta_wikipedia_for_this_page = trim($get_post_meta_wikipedia_for_this_page);

                if (! (empty($get_post_meta_wikipedia_for_this_page))) {
                    if (function_exists('get_text_from_wikipedia')) {
                        // $get_content_from_wikipedia = get_text_from_wikipedia($get_post_meta_wikipedia_for_this_page);
                        // 14.8.8
                        $get_content_from_wikipedia = get_text_from_wikipedia($get_post_meta_wikipedia_for_this_page, $single->ID);
                        if (! (empty($get_content_from_wikipedia))) {
                            $m_single['content'] = $get_content_from_wikipedia;
                            
                            // before 25.0.8 $m_single['post_excerpt'] = wp_trim_excerpt($get_content_from_wikipedia);
                            
                            //25.0.8
                            //before 27.0.8 $excerpt_more = apply_filters('excerpt_more', ' ' . '[&hellip;]');
                            //27.0.8
                            $excerpt_more = tt_excerpt_more($single->ID,'Read More');

                            $excerpt_length = 55;
                            $m_single['post_excerpt'] = tt_wp_trim_words($get_content_from_wikipedia, $excerpt_length, $excerpt_more);
                            
                            //end 25.0.8
                        }
                    }
                }
                // end wikipedia
                $m_single['unique_id'] = tooltips_unique_id_pro();
                $tooltipsarray[] = $m_single;
            }
        }
    }
    return $tooltipsarray;
}

function tooltips_get_by_id_pro($tooltip_id)
{
    global $wpdb;
    $tooltipsarray = false;
    $m_single = array();
    if (empty($tooltip_id)) {
        return false;
    }

    $post_type = 'tooltips';

    $sql = $wpdb->prepare("SELECT ID, post_title, post_content FROM $wpdb->posts WHERE post_type=%s AND post_status='publish' AND ID=%s", $post_type, $tooltip_id);
    $results = $wpdb->get_row($sql, ARRAY_A);

    if ((! (empty($results))) && (is_array($results)) && (count($results) > 0)) {
        $tooltipsarray = array();
        $tooltipsarray['keyword'] = $results['post_title'];
        $tooltipsarray['content'] = $results['post_content'];
        $tooltipsarray['post_id'] = $results['ID'];
        // !!!15.6.0
        $tooltipsarray['post_title'] = $results['post_title'];
        // !!!end 15.6.0
        $tooltipsarray['unique_id'] = tooltips_unique_id_pro();
    }
    return $tooltipsarray;
}

function showTooltipsInShorcodePro($content)
{
    global $table_prefix, $wpdb, $post;

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return $content;
    }
    // 11.4.6

    do_action('action_before_showtooltips', $content);
    $content = apply_filters('filter_before_showtooltips', $content);

    $curent_content = $content;

    $m_result = tooltips_get_option_pro('tooltipsarray', 'post_title', 'DESC', 'LENGTH');
    $m_keyword_result = '';
    if (! (empty($m_result))) {
        $m_keyword_id = 0;
        foreach ($m_result as $m_single) {

            if (stripos($curent_content, $m_single['keyword']) === false) {} else {
                $m_keyword_result .= '<script type="text/javascript">';
                $m_keyword_result .= 'jQuery("document").ready(function(){'; // !!!

                $m_content = $m_single['content'];
                $tooltip_post_id = $m_single['post_id'];
                $tooltip_unique_id = $m_single['unique_id'];

                $m_content = do_shortcode($m_content);

                $m_content = str_ireplace('\\', '', $m_content);
                $m_content = str_ireplace("'", "\'", $m_content);
                $m_content = str_ireplace('"', '\"', $m_content);

                /*
                 * // old works well before 16.4.4
                 * $m_content = preg_replace('/([^>])(\r\n)/is', "\\1".'<br/>', $m_content);
                 * $m_content = preg_replace('/([>])(\r\n)/is', "\\1".'', $m_content);
                 *
                 */
                // added in 16.4.4
                $enableRemoveWPautop = get_option("enableRemoveWPautop");
                if ($enableRemoveWPautop == 'NO') {} else {
                    $m_content = preg_replace('/([^>])(\r\n)/is', "\\1" . '<br/>', $m_content);
                    $m_content = preg_replace('/([>])(\r\n)/is', "\\1" . '', $m_content);
                }
                // end in 16.4.4

                if (! (empty($m_content))) {

                    // !!! old 14.9.8 $m_keyword_result .= " toolTips('.classtoolTips$m_keyword_id','$m_content','$tooltip_post_id'); ";
                    $m_keyword_result .= " toolTips('.classtoolTips$tooltip_post_id','$m_content','$tooltip_post_id'); ";
                }
                $m_keyword_result .= '});'; // !!!
                $m_keyword_result .= '</script>';
                $m_bulletscreen_result = show_bullet_screen_for_one_tooltips($tooltip_post_id, $m_keyword_id, 'content');
                $m_keyword_result .= $m_bulletscreen_result;
            }
            $m_keyword_id ++;
        }
    }
    $content = $content . $m_keyword_result;
    do_action('action_after_showtooltips', $content);
    $content = apply_filters('filter_after_showtooltips', $content);
    return $content;
}

function tooltips_list_shortcode_pro($atts)
{
    global $table_prefix, $wpdb, $post;

    $tooltipsarray = array();
    $m_single = array();

    $return_content = '';
    $return_content .= '<div class="tooltips_directory">';

    $post_type = 'tooltips';
    $sql = $wpdb->prepare("SELECT ID, post_title, post_content FROM $wpdb->posts WHERE post_type=%s AND post_status='publish' order by post_title ASC", $post_type);
    $results = $wpdb->get_results($sql);

    if ((! (empty($results))) && (is_array($results)) && (count($results) > 0)) {
        $m_single = array();
        foreach ($results as $single) {
            // !!! 15.0.8
            if (empty($single->post_title)) {
                continue;
            }
            // !!! end 15.0.8
            $return_content .= '<div class="tooltips_content_wrap"><div class="tooltips_list">' . $single->post_title . '</div></div>';
        }
    }

    $return_content = tooltipsInContentPro($return_content);
    $return_content = showTooltipsInShorcodePro($return_content);

    $return_content .= '</div>';

    $return_content = do_shortcode($return_content);

    return $return_content;
}
add_shortcode('tooltipslist', 'tooltips_list_shortcode_pro');

function tooltips_wiki_reference_pro($atts, $keyword = null)
{
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6
    extract(shortcode_atts(array(
        'content' => __("Proper Shortcode Usage is: <div>[tooltips keyword='wordpress' content = 'hello, wp']</div>", 'wordpress-tooltips')
    ), $atts));

    $m_keyword_result = '';
    $keywordmd = md5(uniqid('', TRUE));

    $m_replace = "<span class='tooltipsall tooltip_post_id_custom_$keywordmd classtoolTipsCustomShortCode'>" . $keyword . "</span>";
    $m_keyword_result .= $m_replace;

    $m_keyword_result .= '<script type="text/javascript">';
    $m_keyword_result .= 'jQuery("document").ready(function(){'; // !!!

    $m_content = $content;

    $m_content = do_shortcode($m_content);

    $m_content = str_ireplace('\\', '', $m_content);
    $m_content = str_ireplace("'", "\'", $m_content);
    $m_content = str_ireplace('"', '\"', $m_content);

    /*
     * before 16.4.4
     * $m_content = preg_replace('/([^>])(\r\n)/is', "\\1".'<br/>', $m_content);
     * $m_content = preg_replace('/([>])(\r\n)/is', "\\1".'', $m_content);
     */
    // added in 16.4.4
    $enableRemoveWPautop = get_option("enableRemoveWPautop");
    if ($enableRemoveWPautop == 'NO') {} else {
        $m_content = preg_replace('/([^>])(\r\n)/is', "\\1" . '<br/>', $m_content);
        $m_content = preg_replace('/([>])(\r\n)/is', "\\1" . '', $m_content);
    }
    // end in 16.4.4

    if (! (empty($m_content))) {
        $m_keyword_result .= " toolTips('.tooltip_post_id_custom_$keywordmd','$m_content','0'); ";
    }
    $m_keyword_result .= '});'; // !!!
    $m_keyword_result .= '</script>';

    return $m_keyword_result;
}

add_shortcode('tooltips_wiki_reference', 'tooltips_wiki_reference_pro');

add_shortcode('ttsref', 'tooltips_wiki_reference_pro');

/**
 * ** localization ***
 */
add_action('plugins_loaded', 'tooltips_load_textdomain_pro');

function tooltips_load_textdomain_pro()
{
    load_plugin_textdomain('wordpress-tooltips', false, dirname(plugin_basename(__FILE__)) . '/languages/');
}

add_action('widgets_init', 'TooltipsWidgetInitPro');

function footernavpro()
{
    global $post;

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    $choseLanguageForGlossary = get_option("enableLanguageForGlossary");
    if (empty($choseLanguageForGlossary))
        $choseLanguageForGlossary = 'en';
    $hidezeronumberitem = get_option('hidezeronumberitem');
    if (empty($hidezeronumberitem))
        $hidezeronumberitem = 'no';
    ?>
<script type="text/javascript">
var inboxs = new Array();
inboxs['language'] = "<?php echo $choseLanguageForGlossary; ?>";
inboxs['hidezeronumberitem'] = "<?php echo $hidezeronumberitem; ?>";
inboxs['selectors'] = '.tooltips_list > span';
<?php
    $glossaryNavItemFontSize = get_option("glossaryNavItemFontSize");
    $glossarySelectedNavItemFontSize = get_option("glossarySelectedNavItemFontSize");
    if (empty($glossaryNavItemFontSize)) {
        $glossaryNavItemFontSize = '12px';
    } else {
        $glossaryNavItemFontSize = $glossaryNavItemFontSize . 'px';
    }
    if (empty($glossarySelectedNavItemFontSize)) {
        $glossarySelectedNavItemFontSize = '14px';
    } else {
        $glossarySelectedNavItemFontSize = $glossarySelectedNavItemFontSize . 'px';
    }
    ?>
inboxs['navitemdefaultsize'] = '<?php echo $glossaryNavItemFontSize; ?>'; 
inboxs['navitemselectedsize'] = '<?php echo $glossarySelectedNavItemFontSize; ?>';
<?php
    $selectedGlossaryStyle = get_option("selectedGlossaryStyle");
    if (empty($selectedGlossaryStyle)) {
        $selectedGlossaryStyle = 'glossary-blue';
    }

    if ($selectedGlossaryStyle == 'glossary-blue') {
        echo "inboxs['navitembackground'] = '#007DBD';";
    }

    if ($selectedGlossaryStyle == 'glossary-green') {
        echo "inboxs['navitembackground'] = '#0fa930';";
    }

    if ($selectedGlossaryStyle == 'glossary-blonde') {
        echo "inboxs['navitembackground'] = '#dbc7a7';";
    }

    if ($selectedGlossaryStyle == 'glossary-dark') {
        echo "inboxs['navitembackground'] = '#999999';";
    }

    if ($selectedGlossaryStyle == 'glossary-red') {
        echo "inboxs['navitembackground'] = '#f99d9d';";
    }

    $glossaryNumbersOrNot = get_option("glossaryNumbersOrNot");
    if (empty($glossaryNumbersOrNot)) {
        $glossaryNumbersOrNot = 'yes';
    }
    $glossaryNumbersOrNot = strtolower($glossaryNumbersOrNot);
    if ($choseLanguageForGlossary == 'custom') {
        $glossaryLanguageCustomNavNumbers = get_option('glossaryLanguageCustomNavNumbers');
        if (empty($glossaryLanguageCustomNavNumbers)) {
            $glossaryLanguageCustomNavNumbers = '0,1,2,3,4,5,6,7,8,9';
        }
        ?>
	inboxs['numberletters'] = "<?php echo $glossaryLanguageCustomNavNumbers; ?>";
	<?php
        $glossaryLanguageCustomNavALL = get_option('glossaryLanguageCustomNavALL');
        if (empty($glossaryLanguageCustomNavALL)) {
            $glossaryLanguageCustomNavALL = 'ALL';
        }
        ?>
	inboxs['wordofselectall'] = "<?php echo $glossaryLanguageCustomNavALL; ?>";
	<?php
        $glossaryLanguageCustomNavLetters = get_option('glossaryLanguageCustomNavLetters');
        if (empty($glossaryLanguageCustomNavLetters)) {
            $glossaryLanguageCustomNavLetters = 'a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z';
        }
        ?>
	inboxs['alphabetletters'] = "<?php echo $glossaryLanguageCustomNavLetters; ?>";
	<?php
    }
    ?>
inboxs['number'] = "<?php echo $glossaryNumbersOrNot; ?>";

jQuery(document).ready(function () {
	jQuery('.tooltips_directory').directory(inboxs); 
	jQuery('.navitem').css('font-size','<?php echo $glossaryNavItemFontSize; ?>');	
})
</script>
<?php
}
add_action('wp_footer', 'footernavpro');

function removenavigationbarpro()
{
    $selectremovenavbaringlossarypage = get_option('selectremovenavbaringlossarypage');
    if ('yes' == strtolower($selectremovenavbaringlossarypage)) {
        ?>
<script type="text/javascript">
jQuery("document").ready(function()
		{
			jQuery(".navitems").hide();
		});
</script>
<?php
    }
}
add_action('wp_footer', 'removenavigationbarpro');

function footerdisabletooltipinhtmltagpro()
{
    $disabletooltipinhtmltag = get_option("disabletooltipinhtmltag");
    if (! (empty($disabletooltipinhtmltag))) {
        $patterns = '';
        $replacements = '';
        $disabletooltipinhtmltag = trim($disabletooltipinhtmltag);
        $disabletooltipinhtmltagarray = explode(',', $disabletooltipinhtmltag);

        // 16.0.2
        if ((! (empty($disabletooltipinhtmltagarray))) && (is_array($disabletooltipinhtmltagarray)) && (count($disabletooltipinhtmltagarray) > 0)) {
            $disabletooltipinhtmltagarray = array_filter($disabletooltipinhtmltagarray);
        }
        // end 16.0.2

        if ((! (empty($disabletooltipinhtmltagarray))) && (is_array($disabletooltipinhtmltagarray)) && (count($disabletooltipinhtmltagarray) > 0)) {
            echo '<script type="text/javascript">';
            foreach ($disabletooltipinhtmltagarray as $disabletooltipinhtmltagSingle) {
                $disabletooltipinhtmltagSingle = trim($disabletooltipinhtmltagSingle);
                ?>
				jQuery(document).ready(function () {
					jQuery('<?php echo $disabletooltipinhtmltagSingle;?> .tooltipsall').each
					(function()
					{
					disabletooltipinhtmltagSinglei = jQuery(this).html();
					jQuery(this).replaceWith(disabletooltipinhtmltagSinglei);
					})
				})
				<?php
            }
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerdisabletooltipinhtmltagpro');

function disabletooltipforclassandidspro()
{
    $disabletooltipforclassandids = get_option("disabletooltipforclassandids");
    if (! (empty($disabletooltipforclassandids))) {
        $patterns = '';
        $replacements = '';
        $disabletooltipforclassandids = trim($disabletooltipforclassandids);
        $disabletooltipforclassandidsarray = explode(',', $disabletooltipforclassandids);

        // 16.0.2
        if ((! (empty($disabletooltipforclassandidsarray))) && (is_array($disabletooltipforclassandidsarray)) && (count($disabletooltipforclassandidsarray) > 0)) {
            $disabletooltipforclassandidsarray = array_filter($disabletooltipforclassandidsarray);
        }
        // end 16.0.2

        if ((! (empty($disabletooltipforclassandidsarray))) && (is_array($disabletooltipforclassandidsarray)) && (count($disabletooltipforclassandidsarray) > 0)) {
            echo '<script type="text/javascript">';
            foreach ($disabletooltipforclassandidsarray as $disabletooltipforclassandidsSingle) {
                $disabletooltipforclassandidsSingle = trim($disabletooltipforclassandidsSingle);
                ?>
				jQuery(document).ready(function () {
					jQuery('<?php echo $disabletooltipforclassandidsSingle;?> .tooltipsall').each
					(function()
					{
					$disabletooltipforclassandidSinglei = jQuery(this).html();
					jQuery(this).replaceWith($disabletooltipforclassandidSinglei);
					})
				})
				<?php
            }
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'disabletooltipforclassandidspro');

function footerdisabletooltipinshortcodepro()
{
    ?>
<script type="text/javascript">
jQuery(document).ready(function () {
	jQuery('.classtoolTipsCustomShortCode').each(function()
	{
		   jQuery(this).html(jQuery(this).text());
	});
})
</script>
<?php
}
add_action('wp_footer', 'footerdisabletooltipinshortcodepro');

function removemessedimagetooltipbottom()
{
    global $post;

    if ((isset($post->ID)) && (! (empty($post->ID)))) {
        $return_content_remove_css_js = remove_tooltips_css_js_code_in_page($post->ID);
        if (true == $return_content_remove_css_js) {
            return '';
        }
    }

    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    $tooltipBorderBottomSelect = get_option("tooltipBorderBottomSelect");
    $toolstipsUnderLineColor = get_option("toolstipsUnderLineColor");
    if (empty($toolstipsUnderLineColor)) {
        $toolstipsUnderLineColor = '#888888';
    }

    if ($tooltipBorderBottomSelect == 'hidden') {
        $hiddeimageunderline = "1px hidden $toolstipsUnderLineColor";
    } else {
        $hiddeimageunderline = "2px dotted $toolstipsUnderLineColor";
    }
    ?>
<script type="text/javascript">
	
	jQuery(document).ready(function () {
		jQuery('.tooltipsall:has(img)').css('border-bottom','0px');
		jQuery('.tooltipsall > img').css('border-bottom','<?php echo $hiddeimageunderline; ?>');
		jQuery('.tooltipsall > img').css('padding','0px 0px 6px 0px');
	})
	</script>
<?php
}
add_action('wp_footer', 'removemessedimagetooltipbottom');

function tooltipsautocomplete()
{
    ?>
<script type="text/javascript">
	var tooltipsallterms = new Array();
<?php
    $get_all_tooltips_full_array = '';
    $get_all_tooltips_title_array = '';
    $get_all_tooltips_full_array = tooltips_get_option_pro('tooltipsarray');
    if ((! (empty($get_all_tooltips_full_array))) && (is_array($get_all_tooltips_full_array)) && (count($get_all_tooltips_full_array) > 0)) {
        foreach ($get_all_tooltips_full_array as $get_all_tooltips_full_single) {
            $push_to_tooltipsallterms = $get_all_tooltips_full_single['keyword'];
            $push_to_tooltipsallterms = str_ireplace("'", "\'", $push_to_tooltipsallterms);
            echo "tooltipsallterms.push('" . $push_to_tooltipsallterms . "');";
        }
    }
    ?>
	</script>
<?php
}
add_action('admin_footer', 'tooltipsautocomplete');

add_action('admin_enqueue_scripts', 'tomas_add_color_picker');

function tomas_add_color_picker($hook)
{
    if (is_admin()) {
        wp_enqueue_style('wp-color-picker');
        wp_enqueue_script('wordpress-tooltips-color-picker', plugins_url('js/wordpress-tooltips-color.js', __FILE__), array(
            'wp-color-picker'
        ), false, true);
    }
}

function tomas_one_tooltip_shortcode_pro($atts, $inputcontent = null)
{
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    // 11.2.8
    extract(shortcode_atts(array(
        'keyword' => "Proper Shortcode Usage is: <div>[tooltips keyword='wordpress' content = 'hello, wp']</div> or <div>[tooltips content = 'hello, wp']wordpress[/tooltips]</div>",
        'content' => "Proper Shortcode Usage is: <div>[tooltips keyword='wordpress' content = 'hello, wp']</div> or <div>[tooltips content = 'hello, wp']wordpress[/tooltips]</div></div>"
    ), $atts));

    if (! empty(trim($inputcontent))) {
        $keyword = $inputcontent;
    }

    $m_keyword_result = '';
    $keywordmd = md5(uniqid('', TRUE));

    $m_replace = "<span class='tooltipsall tooltip_post_id_custom_$keywordmd classtoolTipsCustomShortCodeOnlyForMultiTooltips'>$keyword</span>";
    $m_keyword_result .= $m_replace;

    $m_keyword_result .= '<script type="text/javascript">';
    $m_keyword_result .= 'jQuery("document").ready(function(){'; // !!!

    $m_content = $content;

    $m_content = str_ireplace('\\', '', $m_content);
    $m_content = str_ireplace("'", "\'", $m_content);
    $m_content = str_ireplace('"', '\"', $m_content);
    /*
     * $m_content = preg_replace('/([^>])(\r\n)/is', "\\1".'<br/>', $m_content);
     * $m_content = preg_replace('/([>])(\r\n)/is', "\\1".'', $m_content);
     */

    /*
     * works well before 16.4.4
     * $m_content = preg_replace('|\r\n|', '<br/>', $m_content);
     * $m_content = preg_replace('|\r|', '', $m_content);
     * $m_content = preg_replace('|\n|', '<br/>', $m_content);
     */

    // added in 16.4.4
    $enableRemoveWPautop = get_option("enableRemoveWPautop");
    if ($enableRemoveWPautop == 'NO') {} else {
        $m_content = preg_replace('|\r\n|', '<br/>', $m_content);
        $m_content = preg_replace('|\r|', '', $m_content);
        $m_content = preg_replace('|\n|', '<br/>', $m_content);
    }
    // end in 16.4.4

    if (! (empty($m_content))) {
        $m_keyword_result .= " toolTips('.tooltip_post_id_custom_$keywordmd',\"$m_content\",'0'); ";
    }

    $m_keyword_result .= '});'; // !!!
    $m_keyword_result .= '</script>';

    return $m_keyword_result;
}

// !!! works well before 16.7.4 add_shortcode('tooltips', 'tomas_one_tooltip_shortcode_pro');
$disableTooltipandEnableGlossary = get_option('disableTooltipandEnableGlossary');

if ($disableTooltipandEnableGlossary == 'YES') {} else {
    add_shortcode('tooltips', 'tomas_one_tooltip_shortcode_pro');
}

function tomas_tooltip_by_id_shortcode_pro($atts, $content = null)
{
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6

    $keyword = '';
    extract(shortcode_atts(array(
        'tooltip_id' => __("Proper Shortcode Usage is: <div>[tooltip_by_id tooltip_id='1']</div>", 'wordpress-tooltips')
    ), $atts));

    $tooltip_id = (int) $tooltip_id;

    if (! (is_int($tooltip_id))) {
        return false;
    }

    $tooltip_id_post = tooltips_get_by_id_pro($tooltip_id);

    if ($tooltip_id_post == false) {
        return false;
    }

    if ((! (empty($tooltip_id_post))) && (is_array($tooltip_id_post)) && (count($tooltip_id_post) > 0)) {
        $keyword = $tooltip_id_post['keyword'];
        $content = $tooltip_id_post['content'];
        // !!!15.6.0
        $title = $tooltip_id_post['post_title'];
        // !!!end 15.6.0
    }

    $m_keyword_result = '';
    $keywordmd = md5(uniqid('', TRUE));

    $m_replace = "<span class='tooltipsall tooltip_post_id_custom_$keywordmd classtoolTipsCustomShortCode'>$keyword</span>";
    $m_keyword_result .= $m_replace;

    $m_keyword_result .= '<script type="text/javascript">';
    $m_keyword_result .= 'jQuery("document").ready(function(){';

    $m_content = $content;

    $m_content = str_ireplace('\\', '', $m_content);
    $m_content = str_ireplace("'", "\'", $m_content);
    $m_content = str_ireplace('"', '\"', $m_content);

    /*
     * good before 16.4.4
     * $m_content = preg_replace('/([^>])(\r\n)/is', "\\1".'<br/>', $m_content);
     * $m_content = preg_replace('/([>])(\r\n)/is', "\\1".'', $m_content);
     */

    // added in 16.4.4
    $enableRemoveWPautop = get_option("enableRemoveWPautop");
    if ($enableRemoveWPautop == 'NO') {} else {
        $m_content = preg_replace('/([^>])(\r\n)/is', "\\1" . '<br/>', $m_content);
        $m_content = preg_replace('/([>])(\r\n)/is', "\\1" . '', $m_content);
    }
    // end in 16.4.4

    if (! (empty($m_content))) {
        // !!! before 15.6.0 $m_keyword_result .= " toolTips('.tooltip_post_id_custom_$keywordmd','[[[[[$m_content]]]]]','0'); "; // 14.2.6
        $m_keyword_result .= " toolTips('.tooltip_post_id_custom_$keywordmd','[[[[[$m_content]]]]]','0','[[[[[$title]]]]]'); "; // !!!15.6.0

    }

    $m_keyword_result .= '});'; // !!!
    $m_keyword_result .= '</script>';

    return $m_keyword_result;
}

add_shortcode('tooltip_by_id', 'tomas_tooltip_by_id_shortcode_pro');

function old_tomas_icon_tooltip_by_id_shortcode_pro($atts, $iconcontent = null)
{
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6
    $keyword = '';
    extract(shortcode_atts(array(
        'tooltip_id' => __("Proper Shortcode Usage is: <div>[icon_tooltip_by_id tooltip_id='1']your icon here[/icon_tooltip_by_id]</div>", 'wordpress-tooltips')
    ), $atts));

    $tooltip_id = (int) $tooltip_id;

    if (! (is_int($tooltip_id))) {
        return false;
    }

    $tooltip_id_post = tooltips_get_by_id_pro($tooltip_id);

    if ($tooltip_id_post == false) {
        return false;
    }

    if ((! (empty($tooltip_id_post))) && (is_array($tooltip_id_post)) && (count($tooltip_id_post) > 0)) {
        $keyword = $tooltip_id_post['keyword'];
        $content = $tooltip_id_post['content'];
    }

    if (! empty(trim($iconcontent))) {
        $keyword = $iconcontent;
    }

    $m_keyword_result = '';
    $keywordmd = md5(uniqid('', TRUE));

    $m_replace = "<span class='tooltipsall tooltip_post_id_custom_icon_$keywordmd classtoolTipsCustomShortCodeOnlyForMultiTooltips'>$iconcontent</span>";
    $m_keyword_result .= $m_replace;

    $m_keyword_result .= '<script type="text/javascript">';
    $m_keyword_result .= 'jQuery("document").ready(function(){'; // !!!

    $m_content = $content;

    $m_content = str_ireplace('\\', '', $m_content);
    $m_content = str_ireplace("'", "\'", $m_content);
    $m_content = str_ireplace('"', '\"', $m_content);

    /*
     * good before 16.4.4
     * $m_content = preg_replace('/([^>])(\r\n)/is', "\\1".'<br/>', $m_content);
     * $m_content = preg_replace('/([>])(\r\n)/is', "\\1".'', $m_content);
     */

    // added in 16.4.4
    $enableRemoveWPautop = get_option("enableRemoveWPautop");
    if ($enableRemoveWPautop == 'NO') {} else {
        $m_content = preg_replace('/([^>])(\r\n)/is', "\\1" . '<br/>', $m_content);
        $m_content = preg_replace('/([>])(\r\n)/is', "\\1" . '', $m_content);
    }
    // end in 16.4.4

    if (! (empty($m_content))) {
        $m_keyword_result .= " toolTips('.tooltip_post_id_custom_icon_$keywordmd','$m_content','0'); ";
    }

    $m_keyword_result .= '});';
    $m_keyword_result .= '</script>';

    return $m_keyword_result;
}

// !!!15.4.4
function tomas_icon_tooltip_by_id_shortcode_pro($atts, $iconcontent = null)
{
    // 11.4.6
    if (tooltips_pro_disable_tooltip_in_mobile()) {
        return '';
    }
    // 11.4.6
    $keyword = '';
    extract(shortcode_atts(array(
        'tooltip_id' => __("Proper Shortcode Usage is: <div>[icon_tooltip_by_id tooltip_id='1']your icon here[/icon_tooltip_by_id]</div>", 'wordpress-tooltips')
    ), $atts));

    $tooltip_id = (int) $tooltip_id;

    if (! (is_int($tooltip_id))) {
        return false;
    }

    $tooltip_id_post = tooltips_get_by_id_pro($tooltip_id);

    if ($tooltip_id_post == false) {
        return false;
    }

    if ((! (empty($tooltip_id_post))) && (is_array($tooltip_id_post)) && (count($tooltip_id_post) > 0)) {
        $keyword = $tooltip_id_post['keyword'];
        $content = $tooltip_id_post['content'];
    }

    if (! empty(trim($iconcontent))) {
        $keyword = $iconcontent;
    }

    $m_keyword_result = '';
    // $keywordmd = md5(uniqid('',TRUE));
    $keywordmd = $tooltip_id; // !!! 15.4.4

    $m_replace = "<span class='tooltipsall tooltip_post_id_custom_icon_$keywordmd classtoolTipsCustomShortCodeOnlyForMultiTooltips'>$iconcontent</span>";
    $m_keyword_result .= $m_replace;
    /*
     * $m_keyword_result .= '<script type="text/javascript">';
     * $m_keyword_result .= 'jQuery("document").ready(function(){'; //!!!
     *
     * $m_content = $content;
     *
     * $m_content = str_ireplace('\\','',$m_content);
     * $m_content = str_ireplace("'","\'",$m_content);
     *
     * $m_content = preg_replace('/([^>])(\r\n)/is', "\\1".'<br/>', $m_content);
     * $m_content = preg_replace('/([>])(\r\n)/is', "\\1".'', $m_content);
     *
     * if (!(empty($m_content)))
     * {
     * $m_keyword_result .= " toolTips('.tooltip_post_id_custom_icon_$keywordmd','$m_content','0'); ";
     * }
     *
     * $m_keyword_result .= '});';
     * $m_keyword_result .= '</script>';
     */
    return $m_keyword_result;
}
// !!! end 15.4.4
add_shortcode('icon_tooltip_by_id', 'tomas_icon_tooltip_by_id_shortcode_pro');

function disable_to_this_page_control_meta_box()
{
    $current_page_id = get_the_ID();
    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'disable_to_this_page', true);
    $remove_tooltips_style_js_from_this_page = get_post_meta($current_page_id, 'remove_tooltips_style_js_from_this_page', true);

    $get_post_meta_value_for_disable_specific_tooltips = get_post_meta($current_page_id, 'disable_specific_tooltips_to_this_page', true);

    $get_post_meta_value_for_only_allow_specific_category_tooltips = get_post_meta($current_page_id, 'only_allow_specific_category_to_this_page', true); // !!! 14.9.6

    $get_post_meta_value_for_enable_advance_tooltip_shortcode = get_post_meta($current_page_id, 'enable_advance_tooltip_shortcode', true);

    if (empty($get_post_meta_value_for_enable_advance_tooltip_shortcode)) {

        $get_post_meta_value_for_enable_advance_tooltip_shortcode = get_option("enableadvancetooltipsshortcodeglobally");
        $get_post_meta_value_for_enable_advance_tooltip_shortcode = strtolower($get_post_meta_value_for_enable_advance_tooltip_shortcode);
    }

    $delay_execution_of_tooltip_in_page = get_post_meta($current_page_id, 'delay_execution_of_tooltip_in_page', true);
    global $wpdb;

    ?>
<table cellspacing="2" cellpadding="5" style="width: 100%;"
	class="form-table">
	<tbody>
		<tr class="form-field">
			<td><input name="disable_to_this_page" type="checkbox" value="yes"
				<?php  if(esc_attr( $get_post_meta_value_for_this_page ) == 'yes' ) {echo 'checked="checked"';} ?>><label><?php echo __('Disable all tooltips in this post?','wordpress-tooltips') ?></label>
				<p style="color: gray; font-size: 12px;">
					<i><?php echo __("( Still can use shortcode '[tooltips]' to add tooltips manually )",'wordpress-tooltips') ?></i>
				</p>
				<hr style="margin: 5px 0px 0px 0px; padding: 0px 0px;" /></td>
		</tr>
		<tr class="form-field">
			<td><input name="remove_tooltips_style_js_from_this_page"
				type="checkbox" value="yes"
				<?php  if(esc_attr( $remove_tooltips_style_js_from_this_page ) == 'yes' ) {echo 'checked="checked"';} ?>><label><?php echo __("Don't load tooltip style and script for this page too?",'wordpress-tooltips') ?></label>
				<p style="color: gray; font-size: 12px;">
					<i><?php echo __("( Speed up your site by remove tooltip javascript & css codes in this page )",'wordpress-tooltips') ?></i>
				</p>
				<hr style="margin: 5px 0px 0px 0px; padding: 0px 0px;" /></td>
		</tr>
		<tr class="form-field">
			<td><label><?php echo __('Disable specific tooltips?','wordpress-tooltips') ?></label>
				<input id="disable_specific_to_this_page"
				name="disable_specific_to_this_page" type="text"
				value="<?php echo $get_post_meta_value_for_disable_specific_tooltips; ?>">
				<p style="color: gray; font-size: 12px;">
					<i><?php echo __("( Just exclude a few specific tooltips in this page, please enter tooltips title split by comma ',' )",'wordpress-tooltips') ?></i>
				</p></td>
		</tr>
<?php //!!! 14.9.8 start ?>
	    <tr class="form-field">
			<td><label><?php echo __('Disable specific tooltip categories?','wordpress-tooltips') ?></label>
				<input id="only_allow_specific_category_to_this_page"
				name="only_allow_specific_category_to_this_page" type="text"
				value="<?php echo $get_post_meta_value_for_only_allow_specific_category_tooltips; ?>">
				<p style="color: gray; font-size: 12px;">
					<i><?php echo __("( Just exclude a few specific tooltips categories in this page, please enter tooltips categories ids, split by comma ',' )",'wordpress-tooltips') ?></i>
				</p></td>
		</tr>
<?php //!!! end 14.9.8  ?>
	    <tr class="form-field">
			<td><label><?php echo __('Delay the execution of tooltip function?','wordpress-tooltips') ?></label>
				<input id="delay_execution_of_tooltip_in_page"
				name="delay_execution_of_tooltip_in_page" type="text"
				value="<?php echo $delay_execution_of_tooltip_in_page; ?>"
				placeholder="<?php echo __('for example: 3000', "wordpress-tooltips");; ?>">
				<p style="color: gray; font-size: 12px;">
					<i><?php echo __("( support tooltip effects in dynamiclly generated content, for example AJAX, Vue..., just enter the number of millisecond to delay in here )",'wordpress-tooltips') ?></i>
				</p></td>
		</tr>

		<tr class="form-field">
			<td><label><?php echo __('Enable advance tooltips shortcode?','wordpress-tooltips') ?></label>
				<select id="enable_advance_tooltip_shortcode"
				name="enable_advance_tooltip_shortcode" style="width: 200px;">
					<option id="enable_advance_tooltip_shortcodeOption" value="no"
						<?php if ($get_post_meta_value_for_enable_advance_tooltip_shortcode == 'no') echo "selected";   ?>> <?php echo __( 'Disable Advance Tooltips Shortcode', 'wordpress-tooltips' ); ?> </option>
					<option id="enable_advance_tooltip_shortcodeOption" value="yes"
						<?php if ($get_post_meta_value_for_enable_advance_tooltip_shortcode == 'yes') echo "selected";   ?>> <?php echo __( 'Enable Advance Tooltips Shortcode', 'wordpress-tooltips' ); ?> </option>
			</select>
					<?php $tooltipfaqshortcodeurl =  get_option('siteurl') . '/wp-admin/edit.php?post_type=tooltips&page=tooltipsfaq#tooltips-pro-how-to-each-bar-id'; ?>
					<p style="color: gray; font-size: 12px;">
					<i><?php echo __("Please make sure you read <a href='$tooltipfaqshortcodeurl' target='_blank'>'F.A.Q: How to Use Tooltips Pro Shortcode [tooltips]'</a> before enable this option",'wordpress-tooltips') ?></i>
				</p></td>
		</tr>
	</tbody>
</table>
<?php
}

function disable_tooltips_control_meta_box()
{
    global $post;
    if ($post->post_type == 'tooltips') {} else {
        add_meta_box("disable_tooltips_control_meta_box_id", __('Tooltip settings for this page', 'wordpress-tooltips'), 'disable_to_this_page_control_meta_box', null, "side", "high", null);
    }
}

function show_tooltips_excerpt_meta_box()
{
    $current_page_id = get_the_ID();
    $tooltipExcerptOrContentSelect = get_post_meta($current_page_id, 'tooltipExcerptOrContentSelect', true);

    global $wpdb;

    ?>
<table cellspacing="2" cellpadding="5" style="width: 100%;"
	class="form-table">
	<tbody>
		<tr class="form-field">
			<td><label><?php echo __('Excerpt or Full Content?','wordpress-tooltips') ?></label>
				<select id="tooltipExcerptOrContentSelect"
				name="tooltipExcerptOrContentSelect">
						<?php
    /*
     * <option id="tooltipExcerptOrContentOption" value="useoptinalsettingsdefaultvalue" <?php if ($tooltipExcerptOrContentSelect == 'useoptinalsettingsdefaultvalue') echo "selected"; ?>> Follow the Settings of the Optional Settings Panel</option>
     */
    // !!!15.6.6
    ?>
						<option id="tooltipExcerptOrContentOption"
						value="useoptinalsettingsdefaultvalue"
						<?php if ($tooltipExcerptOrContentSelect == 'useoptinalsettingsdefaultvalue') echo "selected";   ?>>
						Follow Optional Settings</option>
					<option id="tooltipExcerptOrContentOption" value="tooltipcontent"
						<?php if ($tooltipExcerptOrContentSelect == 'tooltipcontent') echo "selected";   ?>>
						Use Full Tooltip Content In Pop-Up</option>
					<option id="tooltipExcerptOrContentOption" value="tooltipexcerpt"
						<?php if ($tooltipExcerptOrContentSelect == 'tooltipexcerpt') echo "selected";   ?>>
						Use Tooltip Excerpt In Pop Up Box</option>
			</select></td>
		</tr>
	</tbody>
</table>
<?php
}

function show_tooltips_excerpt_control_meta_box()
{
    global $post;
    if ($post->post_type == 'tooltips') {
        add_meta_box("show_tooltips_excerpt_control_meta_box_id", __('Show excerpt in tooltip pop up?', 'wordpress-tooltips'), 'show_tooltips_excerpt_meta_box', null, "side", "high", null);
    }
}

function save_show_tooltips_excerpt_tooltip_control_meta_box($post_id, $post, $update)
{
    global $post;

    $current_page_id = get_the_ID();

    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'disable_to_this_page', true);

    if (isset($_POST['tooltipExcerptOrContentSelect'])) {
        $meta_box_checkbox_value = $_POST['tooltipExcerptOrContentSelect'];
        update_post_meta($current_page_id, 'tooltipExcerptOrContentSelect', $meta_box_checkbox_value);
    }
    tooltipsgeneratejs(true); //20.5.8 to generate js file when change tooltip
}

add_action('add_meta_boxes', 'show_tooltips_excerpt_control_meta_box');
add_action('save_post', 'save_show_tooltips_excerpt_tooltip_control_meta_box', 10, 3);

//!!!26.1.8


function create_tooltips_by_existed_post_id_control_meta_box()
{
    global $post;
    if ($post->post_type == 'tooltips')
    {
        add_meta_box("create_tooltips_by_existed_post_id_control_meta_box_id", __( 'tooltips settings for this page', 'wordpress-tooltips' ), 'tooltips_via_existed_post_id', null, "side", "high", null);
    }
    else
    {
        
    }
}

function tooltips_via_existed_post_id()
{
    global $wpdb;
    $current_page_id = get_the_ID();
    
    $get_post_meta_value_for_tt_use_post_title_and_content_as_tooltips_via_id = get_post_meta($current_page_id, 'tt_use_post_title_and_content_as_tooltips_via_id', true);
    $no_index_to_this_tooltips_page = get_post_meta($current_page_id, 'no_index_to_this_tooltips_page', true);
    
    ?>
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
	    <tbody>
	    <tr class="form-field">
	        <td>
	        	<label><?php echo __('Use existed post as tooltips post?','wordpress-tooltips') ?></label>
				<input id="tt_use_post_title_and_content_as_tooltips_via_id" name="tt_use_post_title_and_content_as_tooltips_via_id"  type="text" value="<?php echo $get_post_meta_value_for_tt_use_post_title_and_content_as_tooltips_via_id; ?>" >
				<p style="color:gray;font-size:12px;"><i><?php echo __("( Input ID of your existed post, tooltips use title and post content of that post as tooltips title and content )",'wordpress-tooltips') ?></i></p>
	        </td>
	    </tr>
	    </tbody>
	</table>
	<?php
	// 3.7.1
	?>
	<table cellspacing="2" cellpadding="5" style="width: 100%;" class="form-table">
	    <tbody>
	    <tr class="form-field">
	        <td>
				<input name="no_index_to_this_tooltips_page"  type="checkbox" value="yes" <?php  if(esc_attr( $no_index_to_this_tooltips_page ) == 'yes' ) {echo 'checked="checked"';} ?> ><label><?php echo __('No-Index for this tooltips post?','wordpress-tooltips') ?></label>
				<p style="color:gray;font-size:12px;"><i><?php echo __("( Add no-index meta to tell google not index this tooltips post)",'wordpress-tooltips') ?></i></p>
	        </td>
	    </tr>
	    </tbody>
	</table>	
	<?php
}



function save_tooltips_by_existed_post_id_control_meta_box($post_id, $post, $update)
{
	global $post;

	$current_page_id = get_the_ID();

	if(isset($_POST['tt_use_post_title_and_content_as_tooltips_via_id']) != "") {
		//$meta_box_checkbox_value = $_POST['tt_use_post_title_and_content_as_tooltips_via_id'];
	    $meta_box_checkbox_value = sanitize_text_field($_POST['tt_use_post_title_and_content_as_tooltips_via_id']); //3.7.5
		update_post_meta( $current_page_id, 'tt_use_post_title_and_content_as_tooltips_via_id', $meta_box_checkbox_value );
	} else {
		update_post_meta( $current_page_id, 'tt_use_post_title_and_content_as_tooltips_via_id', '' );
	}

	$get_post_meta_value_for_tt_use_post_title_and_content_as_tooltips_via_id = get_post_meta($current_page_id, 'tt_use_post_title_and_content_as_tooltips_via_id', true);

	
	if(isset($_POST['no_index_to_this_tooltips_page']) && ($_POST['no_index_to_this_tooltips_page'] == 'yes')) 
	{
		//$meta_box_checkbox_value = $_POST['no_index_to_this_tooltips_page'];
	    $meta_box_checkbox_value = sanitize_text_field($_POST['no_index_to_this_tooltips_page']);
		update_post_meta( $current_page_id, 'no_index_to_this_tooltips_page', $meta_box_checkbox_value );
	} 
	else 
	{
		delete_post_meta( $current_page_id, 'no_index_to_this_tooltips_page');
	}
	
	$no_index_to_this_tooltips_page = get_post_meta($current_page_id, 'no_index_to_this_tooltips_page', true);
	
}


add_action( 'add_meta_boxes',  'create_tooltips_by_existed_post_id_control_meta_box' );
add_action( 'save_post', 'save_tooltips_by_existed_post_id_control_meta_box' , 10, 3);
//end 26.1.8

function content_tooltips_keyword_synonyms_control_meta_box_pro()
{
    global $post;
    $current_page_id = get_the_ID();
    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'toolstipssynonyms', true);
    global $wpdb;

    ?>
<table cellspacing="2" cellpadding="5" style="width: 100%;"
	class="form-table">
	<tbody>
		<tr class="form-field">
			<td>
				<p>
	<?php
    echo __("Synonyms of the keyword", "wordpress-tooltips");
    ?>
	        	</p> <input type="text" id="toolstipssynonyms"
				name="toolstipssynonyms"
				value="<?php echo $get_post_meta_value_for_this_page;  ?>">
				<p style="color: gray; font-size: 12px;">
					<i>
				<?php
    echo __("( separated by ", "wordpress-tooltips");
    ?>
				</i>
				<?php
    echo __(" '|'", "wordpress-tooltips");
    ?>
				<i>
				<?php
    echo __(" ) ", "wordpress-tooltips");
    ?>
				</i>
				</p>
			</td>
		</tr>
	</tbody>
</table>
<?php
}

function tooltips_keyword_synonyms_control_meta_box_pro()
{
    global $post;

    if ($post->post_type == 'tooltips') {
        add_meta_box("tooltips_keyword_synonyms_control_meta_box_id", __('Synonyms of this tooltip', 'wordpress-tooltips'), 'content_tooltips_keyword_synonyms_control_meta_box_pro', null, "side", "high", null);
    }
}

function save_disable_tooltip_control_meta_box($post_id, $post, $update)
{
    global $post;

    $current_page_id = get_the_ID();

    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'disable_to_this_page', true);

    // !!! 14.6.6
    $tt_in_elementor_editor = false;
    $tt_in_elementor_editor = tt_in_elementor_editor();
    if ($tt_in_elementor_editor == true) {
        return '';
    }
    // !!! end 14.6.6

    if (isset($_POST['disable_to_this_page']) != "") {
        $meta_box_checkbox_value = $_POST['disable_to_this_page'];
        update_post_meta($current_page_id, 'disable_to_this_page', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'disable_to_this_page', '');
    }

    if (isset($_POST['remove_tooltips_style_js_from_this_page']) != "") {
        $meta_box_checkbox_value = $_POST['remove_tooltips_style_js_from_this_page'];
        update_post_meta($current_page_id, 'remove_tooltips_style_js_from_this_page', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'remove_tooltips_style_js_from_this_page', '');
    }

    if (isset($_POST['disable_specific_to_this_page']) != "") {
        $meta_box_checkbox_value = $_POST['disable_specific_to_this_page'];
        update_post_meta($current_page_id, 'disable_specific_tooltips_to_this_page', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'disable_specific_tooltips_to_this_page', '');
    }

    if (isset($_POST['delay_execution_of_tooltip_in_page']) != "") {
        $meta_box_checkbox_value = $_POST['delay_execution_of_tooltip_in_page'];
        update_post_meta($current_page_id, 'delay_execution_of_tooltip_in_page', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'delay_execution_of_tooltip_in_page', '');
    }

    if (isset($_POST['enable_advance_tooltip_shortcode']) != "") {
        $meta_box_checkbox_value = $_POST['enable_advance_tooltip_shortcode'];
        update_post_meta($current_page_id, 'enable_advance_tooltip_shortcode', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'enable_advance_tooltip_shortcode', '');
    }

    // !!! 14.9.6

    if (isset($_POST['only_allow_specific_category_to_this_page']) != "") {
        $meta_box_checkbox_value = $_POST['only_allow_specific_category_to_this_page'];
        update_post_meta($current_page_id, 'only_allow_specific_category_to_this_page', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'only_allow_specific_category_to_this_page', '');
    }
}

function save_content_tooltips_keyword_synonyms_control_meta_box_pro($post_id, $post, $update)
{
    global $post;

    $current_page_id = get_the_ID();

    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'toolstipssynonyms', true);

    if (isset($_POST['toolstipssynonyms']) != "") {
        $meta_box_checkbox_value = $_POST['toolstipssynonyms'];
        update_post_meta($current_page_id, 'toolstipssynonyms', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'toolstipssynonyms', '');
    }
}

function content_form_tooltips_control_meta_box_pro()
{
    global $post;
    $current_page_id = get_the_ID();
    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'tooltipsforforms', true);
    global $wpdb;

    ?>
<table cellspacing="2" cellpadding="5" style="width: 100%;"
	class="form-table">
	<tbody>
		<tr class="form-field">
			<td>
				<p>
	<?php
    echo __("Tooltip For Forms", "wordpress-tooltips");
    ?>
	        	</p> <input type="text" id="tooltipsforforms"
				name="tooltipsforforms"
				value="<?php echo $get_post_meta_value_for_this_page;  ?>">
				<p style="color: gray; font-size: 12px;">
					<i>
				<?php
    echo __("please enter class or id of form element", "wordpress-tooltips");
    ?>
				</i>
				</p>
				<p style="color: gray; font-size: 12px;">
					<i>
				<?php
    echo __("for example:", "wordpress-tooltips");
    ?>
				</i>
				</p>
				<p style="color: gray; font-size: 12px;">
					<i>
				<?php
    echo __(".input_box_1", "wordpress-tooltips");
    ?>
				</i>
				</p>
				<p style="color: gray; font-size: 12px;">
					<i>
				<?php
    echo __("#text_box_2", "wordpress-tooltips");
    ?>
				</i>
				</p>
			</td>
		</tr>
	</tbody>
</table>
<?php
}

function form_tooltips_control_meta_box_pro()
{
    global $post;

    if ($post->post_type == 'tooltips') {
        add_meta_box("tooltips_for_forms_control_meta_box_id", __('Tooltip For Forms', 'wordpress-tooltips'), 'content_form_tooltips_control_meta_box_pro', null, "side", "high", null);
    }
}

function save_form_tooltips_control_meta_box_pro($post_id, $post, $update)
{
    global $post;

    $current_page_id = get_the_ID();

    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'tooltipsforforms', true);

    if (isset($_POST['tooltipsforforms']) != "") {
        $meta_box_checkbox_value = $_POST['tooltipsforforms'];
        update_post_meta($current_page_id, 'tooltipsforforms', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'tooltipsforforms', '');
    }
}

add_action('add_meta_boxes', 'form_tooltips_control_meta_box_pro');
add_action('save_post', 'save_form_tooltips_control_meta_box_pro', 10, 3);

function tooltips_video_control_meta_box()
{
    global $post;

    if ($post->post_type == 'tooltips') {
        add_meta_box("tooltips_video_control_meta_box_id", __('Insert video into tooltips', 'wordpress-tooltips'), 'content_tooltips_video_control_meta_box', null, "side", "high", null);
    }
}

function content_tooltips_video_control_meta_box()
{
    global $wpdb, $post;
    $current_page_id = get_the_ID();

    $get_post_meta_value_full_video_url = get_post_meta($current_page_id, 'toolstipsfullvideourl', true);
    $get_post_meta_value_full_video_url = trim($get_post_meta_value_full_video_url);

    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'toolstipsyoutubevideo', true);
    $get_post_meta_value_for_this_page = trim($get_post_meta_value_for_this_page);

    $get_post_meta_value_youtube_height = get_post_meta($current_page_id, 'toolstipsyoutubeheight', true);
    $get_post_meta_value_youtube_height = trim($get_post_meta_value_youtube_height);

    if (empty($get_post_meta_value_youtube_height)) {
        $get_post_meta_value_youtube_height = '400px';
    }

    $get_post_meta_value_youtube_width = get_post_meta($current_page_id, 'toolstipsyoutubewidth', true);
    $get_post_meta_value_youtube_width = trim($get_post_meta_value_youtube_width);
    if (empty($get_post_meta_value_youtube_width)) {
        $get_post_meta_value_youtube_width = '315px';
    }

    ?>
<table cellspacing="2" cellpadding="5" style="width: 100%;"
	class="form-table">
	<tbody>
		<tr class="form-field">
			<td>
				<p>
				<?php
    echo __("Video URL", "wordpress-tooltips");
    ?>	        	
	        	</p> <input type="text" id="toolstipsfullvideourl"
				name="toolstipsfullvideourl"
				value="<?php echo $get_post_meta_value_full_video_url;  ?>">
				<p style="color: gray; font-size: 12px;">
					<i>https://www.yourdoain.com/wp-content/uploads/video.mp4</i>
				</p>

				<p style="margin-top: 10px;">
				<?php
    echo __("Or Youtube Video ID", "wordpress-tooltips");
    ?>	        	
	        	</p> <input type="text" id="toolstipsyoutubevideo"
				name="toolstipsyoutubevideo"
				value="<?php echo $get_post_meta_value_for_this_page;  ?>">
				<p style="color: gray; font-size: 12px;">
					<i>https://www.youtube.com/watch?v=</i><b>3PFnHXl1h34</b>
				</p>

				<p style="margin-top: 10px;">
					Video Height<font color='gray'><i>(px)</i></font>
				</p>
				<p>
					<input type="text" id="toolstipsyoutubeheight"
						name="toolstipsyoutubeheight"
						value="<?php echo $get_post_meta_value_youtube_height;  ?>">
				</p>

				<p style="margin-top: 10px;">
					Video Width<font color='gray'><i>(px)</i></font>
				</p>
				<p>
					<input type="text" id="toolstipsyoutubewidth"
						name="toolstipsyoutubewidth"
						value="<?php echo $get_post_meta_value_youtube_width;  ?>">
				</p>
				<p style="margin-top: 10px;">
					<font color='gray'> <i> If you entered "Video URL", "Youtube Video
							ID" will be ignored. </i></font>
				</p>
			</td>
		</tr>
	</tbody>
</table>
<?php
}

function save_content_tooltips_video_control_meta_box($post_id, $post, $update)
{
    global $post;

    $current_page_id = get_the_ID();

    $get_post_meta_value_full_video_url = get_post_meta($current_page_id, 'toolstipsfullvideourl', true);
    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'toolstipsyoutubevideo', true);
    $get_post_meta_value_youtube_height = get_post_meta($current_page_id, 'toolstipsyoutubeheight', true);
    $get_post_meta_value_youtube_height = trim($get_post_meta_value_youtube_height);
    $get_post_meta_value_youtube_width = get_post_meta($current_page_id, 'toolstipsyoutubewidth', true);
    $get_post_meta_value_youtube_width = trim($get_post_meta_value_youtube_width);

    if (isset($_POST['toolstipsfullvideourl']) != "") {
        $meta_box_checkbox_value = $_POST['toolstipsfullvideourl'];
        update_post_meta($current_page_id, 'toolstipsfullvideourl', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'toolstipsfullvideourl', '');
    }

    if (isset($_POST['toolstipsyoutubevideo']) != "") {
        $meta_box_checkbox_value = $_POST['toolstipsyoutubevideo'];
        update_post_meta($current_page_id, 'toolstipsyoutubevideo', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'toolstipsyoutubevideo', '');
    }

    if (isset($_POST['toolstipsyoutubeheight']) != "") {
        $meta_box_checkbox_value = $_POST['toolstipsyoutubeheight'];
        update_post_meta($current_page_id, 'toolstipsyoutubeheight', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'toolstipsyoutubeheight', '');
    }

    if (isset($_POST['toolstipsyoutubewidth']) != "") {
        $meta_box_checkbox_value = $_POST['toolstipsyoutubewidth'];
        update_post_meta($current_page_id, 'toolstipsyoutubewidth', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'toolstipsyoutubewidth', '');
    }
}

function tooltips_bullet_screen_control_meta_box()
{
    global $post;

    if ($post->post_type == 'tooltips') {
        add_meta_box("tooltips_bullet_screen_control_meta_box_id", __('Bullet Screen of this tooltip', 'wordpress-tooltips'), 'content_tooltips_bullet_screen_control_meta_box', null, "side", "high", null);
    }
}

function content_tooltips_bullet_screen_control_meta_box()
{
    global $post;
    $current_page_id = get_the_ID();
    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'toolstipbulletscreentag', true);
    global $wpdb;

    ?>
<table cellspacing="2" cellpadding="5" style="width: 100%;"
	class="form-table">
	<tbody>
		<tr class="form-field">
			<td>
				<p>
				<?php
    echo __("Bullet Screen Words", "wordpress-tooltips");
    ?>	        	
	        	</p> <input type="text" id="toolstipbulletscreentag"
				name="toolstipbulletscreentag"
				value="<?php echo $get_post_meta_value_for_this_page;  ?>">
				<p style="color: gray; font-size: 12px;">
					<i># separated by comma </i>
				</p>

				<p style="color: gray; font-size: 12px;">
					<i># what is <a href='https://tooltips.org/bullet-screen'>Bullet
							Screen</a> ?
					</i>
				</p>
			</td>
		</tr>
	</tbody>
</table>
<?php
}

function save_content_tooltips_bullet_screen_control_meta_box($post_id, $post, $update)
{
    global $post;

    $current_page_id = get_the_ID();

    $get_post_meta_value_for_this_page = get_post_meta($current_page_id, 'toolstipbulletscreentag', true);

    if (isset($_POST['toolstipbulletscreentag']) != "") {
        $meta_box_checkbox_value = $_POST['toolstipbulletscreentag'];
        update_post_meta($current_page_id, 'toolstipbulletscreentag', $meta_box_checkbox_value);
    } else {
        update_post_meta($current_page_id, 'toolstipbulletscreentag', '');
    }
}


// start 26.7.8
// old before 26.7.8 add_action('add_meta_boxes', 'disable_tooltips_control_meta_box');
// old before 26.7.8  add_action('save_post', 'save_disable_tooltip_control_meta_box', 10, 3);

$tooltipformaxbutton = get_option('enabletooltipmetaboxineditor');
if ($tooltipformaxbutton == 'NO')
{

}
else
{
    add_action('add_meta_boxes', 'disable_tooltips_control_meta_box');
    add_action('save_post', 'save_disable_tooltip_control_meta_box', 10, 3);
}
// end 26.7.8

add_action('add_meta_boxes', 'tooltips_keyword_synonyms_control_meta_box_pro');
add_action('save_post', 'save_content_tooltips_keyword_synonyms_control_meta_box_pro', 10, 3);
add_action('add_meta_boxes', 'tooltips_video_control_meta_box');
add_action('save_post', 'save_content_tooltips_video_control_meta_box', 10, 3);
add_action('add_meta_boxes', 'tooltips_bullet_screen_control_meta_box');
add_action('save_post', 'save_content_tooltips_bullet_screen_control_meta_box', 10, 3);

// 14.6.0
$selectdisableStatistics = get_option('selectdisableStatistics');
if ('YES' == $selectdisableStatistics) {
    add_action('wp_ajax_tooltips_open_content_stat', 'tooltips_open_content_stat');
    add_action('wp_ajax_nopriv_tooltips_open_content_stat', 'tooltips_open_content_stat');
}
// 14.6.0 add_action( 'wp_ajax_tooltips_open_content_stat', 'tooltips_open_content_stat');
// 14.6.0 add_action( 'wp_ajax_nopriv_tooltips_open_content_stat', 'tooltips_open_content_stat');

add_filter('manage_tooltips_posts_columns', 'tooltips_own_add_stats_columns');
add_action('manage_tooltips_posts_custom_column', 'tooltips_own_stats_columns', 10, 3);

function tooltips_pro_admin_css()
{
    wp_enqueue_style('tooltips_pro_admin_css', plugin_dir_url(__FILE__) . 'asset/css/admin/admin.css');

    $current_edit_page = strtolower($_SERVER['REQUEST_URI']);
    if (! (empty($current_edit_page))) {
        if ((strpos($current_edit_page, 'edit.php') === false) && (strpos($current_edit_page, 'gf_edit') === false)) {
            // wp_enqueue_style('tooltips_autocomplete_css', plugin_dir_url( __FILE__ ) .'js/autocomplete/jquery.autocomplete.css');
            // wp_register_script( 'tooltips_autocomplete_js', plugin_dir_url( __FILE__ ).'js/autocomplete/jquery.autocomplete.js', array('jquery'));
            // wp_enqueue_script( 'tooltips_autocomplete_js' );
            wp_register_script('tooltips_disable_autocomplete_js', plugin_dir_url(__FILE__) . 'js/autocomplete-disable-tooltips-admin.js', array(
                'jquery'
            ));
            wp_enqueue_script('tooltips_disable_autocomplete_js');
        }

        if (strpos($current_edit_page, 'tooltipsfaq') === false) {} else {
            wp_register_script('tooltips_admin_js', plugin_dir_url(__FILE__) . 'js/admin.js', array(
                'jquery'
            ));
            wp_enqueue_script('tooltips_admin_js');
        }

        // 14.6.8
        if (strpos($current_edit_page, 'tooltipglobalsettings') === false) {} else {
            wp_register_script('tooltips_admin_js', plugin_dir_url(__FILE__) . 'js/globalsettings.js', array(
                'jquery'
            ));
            wp_enqueue_script('tooltips_admin_js');
        }
    }
}
add_action('admin_head', 'tooltips_pro_admin_css');

function create_glossary_index_page_pro()
{
    global $table_prefix, $wpdb, $post, $wp_rewrite;

    $enabGlossaryIndexPage = get_option("enabGlossaryIndexPage");

    if ($enabGlossaryIndexPage != 'NO') {
        $tooltipsGlossaryIndexPage = get_option("tooltipsGlossaryIndexPage");

        if (empty($tooltipsGlossaryIndexPage)) {
            $glossary_index_page = $wpdb->get_var($wpdb->prepare("select id from $wpdb->posts where post_title=%s and post_status='publish' ", 'glossary'));
            if (empty($glossary_index_page)) {
                $insert_glossary_index_page = array();
                $insert_glossary_index_page['post_title'] = 'glossary';
                $insert_glossary_index_page['post_content'] = '';
                $insert_glossary_index_page['post_status'] = 'publish';
                $insert_glossary_index_page['post_author'] = 1;
                $insert_glossary_index_page['post_type'] = 'page';
                $inserted_glossary_index_page = wp_insert_post($insert_glossary_index_page);
                $wp_rewrite->flush_rules();
            } else {}
        }
    }
}
add_action('wp_head', 'create_glossary_index_page_pro');

function tooltips_pro_remote_request($url)
{
    if (empty($url)) {
        return false;
    }
    $request = wp_safe_remote_request($url);

    if (is_wp_error($request)) {
        return false;
    } else {
        $notifyresult = $request['body'];
        if ($request['response']['code'] == 200) {
            return $notifyresult;
        } else {
            return false;
        }
    }
    return false;
}

function tooltips_pro_check_notify()
{
    $tooltipspro_last_check_notify_time = get_option('tooltipspro_last_check_notify_time');
    if (empty($tooltipspro_last_check_notify_time)) {
        $tooltipspro_last_check_notify_time = 0;
    }
    $tooltipspro_current_time = time();
    if (($tooltipspro_last_check_notify_time > 0) && (($tooltipspro_current_time - $tooltipspro_last_check_notify_time) < 1800)) {
        return;
    } else {
        update_option('tooltipspro_last_check_notify_time', $tooltipspro_current_time);
    }

    // before 28.5.8 $update_version_json = tooltips_pro_remote_request('https://notify.tooltips.org/tooltipsproupdate.json');
    $update_version_json = tooltips_pro_remote_request('https://notify.tooltips.org/tooltipsplusupdate.json');
    $update_version_json = sanitize_text_field($update_version_json);

    $tooltips_pro_have_new_version = get_option('tooltips_pro_have_new_version_' . $update_version_json);
    if ($tooltips_pro_have_new_version == 'dismiss') {
        return;
    }

    if (! (empty($update_version_json))) {
        $update_version = str_replace('.', '', $update_version_json);
        $tooltipsprocurrentversion = get_option('tooltipsprocurrentversion');
        $tooltipsprocurrentversion = str_replace('.', '', $tooltipsprocurrentversion);
        if ((empty($tooltipsprocurrentversion)) || ($tooltipsprocurrentversion < $update_version)) {
            $tooltipsProMessageString = __("Tooltip Pro new version $update_version_json has been released, please <a href='https://tooltips.org'>login</a> to download new version, change log can be found at <a href='https://tooltips.org/wordpress-tooltip-plugin/wordpress-tooltip-plugin-document/'>document</a>", 'wordpress-tooltips');
            update_option('tooltips_pro_have_new_version_' . $update_version_json, $tooltipsProMessageString);
        }
    }

    $tooltips_pro_have_new_version = get_option('tooltips_pro_have_new_version_' . $update_version_json);
    if ((! (empty($tooltips_pro_have_new_version))) && ($tooltips_pro_have_new_version != 'dismiss') && (! (empty($tooltipsProMessageString)))) {

        tooltips_pro_only_update_notify($tooltipsProMessageString, $update_version_json);
    }
}

function tooltips_pro_hide_notices()
{
    if (isset($_GET['tooltips-pro-hide-notice']) && isset($_GET['tooltips_pro_notice_nonce'])) {
        if (! wp_verify_nonce($_GET['tooltips_pro_notice_nonce'], 'tooltips_pro_hide_notices_nonce')) {
            wp_die(__('Action failed. Please refresh the page and retry.', 'wordpress-tooltips'));
        }

        if (! current_user_can('manage_options')) {
            wp_die(__('Cheatin&#8217; huh?', 'wordpress-tooltips'));
        }

        $hide_notice = sanitize_text_field($_GET['tooltips-pro-hide-notice']);
        update_option('tooltips_pro_have_new_version_' . $_GET['tooltips-pro-hide-notice'], 'dismiss');
    }
}

function tooltips_pro_only_update_notify($p_message, $version)
{
    echo "<div id='message' class='updated fade' style='position: relative; line-height: 60px;margin-left: 0px;margin-top:10px; margin-bottom:10px;'>";
    ?>
<a class="notice-dismiss tooltips-pro-update-dismiss"
	href="<?php echo esc_url( wp_nonce_url( add_query_arg( 'tooltips-pro-hide-notice', $version ), 'tooltips_pro_hide_notices_nonce', 'tooltips_pro_notice_nonce' ) ); ?>"><?php echo __( 'Dismiss', 'wordpress-tooltips' ); ?></a>
<?php
    echo '<p>';
    echo $p_message;
    echo '</p>';
    echo "</div>";
}

add_action('admin_head', 'tooltips_pro_check_notify', 10);
add_action('init', 'tooltips_pro_hide_notices');

function showTooltipsEffectInShortcode($content)
{
    global $table_prefix, $wpdb, $post;

    $current_post = get_post();

    // 13.2.0
    $post_id = 0;
    if (is_object($post)) {
        $post_id = $post->ID;
    }

    if (! (empty($post_id))) {
        $get_post_meta_value_for_enable_advance_tooltip_shortcode = get_post_meta($post_id, 'enable_advance_tooltip_shortcode', true);
        if ($get_post_meta_value_for_enable_advance_tooltip_shortcode == 'yes') {
            remove_filter('the_content', 'wpautop');
        } else {
            // 16.5.4 we do not need to do this because it is wordpess default functon, if user use other plugin to remove wpautop, it will conflicts with this code
            // 16.5.4 add_filter( 'the_content', 'wpautop' );
            // added in 16.5.8
            $enableRemoveWPautop = get_option("enableRemoveWPautop");
            if ($enableRemoveWPautop == 'YES') {
                remove_filter('the_content', 'wpautop');
            }
            // end in 16.5.8
			//20.0.4 and 30.2.8
			$enableTooltipsForBrizyAddon = get_option('enableTooltipsForBrizyAddon');
			if (empty($enableTooltipsForBrizyAddon)) $enableTooltipsForBrizyAddon = 'NO';
			if ($enableTooltipsForBrizyAddon == 'YES')
			{
				remove_filter( 'the_content', 'wpautop' );
			} 			            
        }
    }

    return $content;
}
// !!! old works well before 16.7.4 add_filter( 'the_content', 'showTooltipsEffectInShortcode', 0 );

$disableTooltipandEnableGlossary = get_option('disableTooltipandEnableGlossary');
if ($disableTooltipandEnableGlossary == 'YES') {} else {
    add_filter('the_content', 'showTooltipsEffectInShortcode', 0);
}

add_action('admin_head', 'tooltips_admin_rangeslider_css_js');

function tooltips_admin_rangeslider_css_js()
{
    wp_enqueue_style('ionrangeslidercss', plugin_dir_url(__FILE__) . 'asset/css/ionrangeslider/ion.rangeSlider.css');

    wp_register_script('ionrangesliderjs', plugin_dir_url(__FILE__) . 'js/ionrangeslider/ion.rangeSlider.min.js', array(
        'jquery'
    ));
    wp_enqueue_script('ionrangesliderjs');
}

function rangesliderinitpro()
{
    $tooltipZindexValue = get_option("tooltipZindexValue");
    if (empty($tooltipZindexValue)) {
        $tooltipZindexValue = 15001;
    }
    $tooltipHookPriorityValue = get_option("tooltipHookPriorityValue");
    if (empty($tooltipHookPriorityValue)) {
        $tooltipHookPriorityValue = '20';
    }
    ?>
<script type="text/javascript">
	var tooltip_zindex_custom_values = [-1, 10, 100, 1000, 10000, 100000, 1000000];
	jQuery(document).ready(function($) 
	{
		$('#tooltipZindexValue').ionRangeSlider({min: -1,max: 1000000,from: <?php echo $tooltipZindexValue; ?>,step:1000,grid: true,skin: "modern"});
	});

	jQuery(document).ready(function($) 
	{
		$('#tooltipHookPriorityValue').ionRangeSlider({min: 7,max: 100000,from: <?php echo $tooltipHookPriorityValue; ?>,step:1,grid: true,skin: "flat"});
	});	
	</script>
<?php
}

add_action('admin_footer', 'rangesliderinitpro');

//add_action('wp_footer', 'tooltipsgeneratejs', 50000000000);

//20.4.8
$savettjsinstaticfileandloadit = get_option("savettjsinstaticfileandloadit");

if (strtolower($savettjsinstaticfileandloadit) == 'yes')
{
    
}
else
{
    add_action('wp_footer', 'tooltipsgeneratejs', 50000000000);
}

// end 20.4.8
register_activation_hook(__FILE__, 'regeneratetooltipeffect');

$selectsignificantdigitalsuperscripts = get_option('selectsignificantdigitalsuperscripts');
// if ('no' == strtolower($selectsignificantdigitalsuperscripts))
// 14.4.6
$hidecountnumberitem = get_option("hidecountnumberitem");
if (('yes' == strtolower($hidecountnumberitem)) || ('no' == strtolower($selectsignificantdigitalsuperscripts))) {
    require_once ('rules/glossarysuperscripts.php');
}

// !!! 13.9.8
function user_first_run_guide_bar()
{
    $is_user_first_run_guide_bar = get_option('user_first_run_guide_bar');
    if (empty($is_user_first_run_guide_bar)) {
        echo "<div class='notice tooltips-notice notice-info'><p>Thanks for installing <strong>Tooltips</strong>! Please check <a href='" . admin_url() . "edit.php?post_type=tooltips&page=tooltipsfaq' target='_blank'>Tooltip Knowledge Base</a> and <a href='" . admin_url() . "post-new.php?post_type=tooltips' target='_blank'>Create First Tooltip</a>, it will starting work automatically. Here is <a href='" . admin_url() . "edit.php?post_type=tooltips&page=tooltipglobalsettings' target='_blank'>Setting Panel</a>, Any question or feature request please contact <a href='https://tooltips.org/support-ticket/'  target='_blank'>Support</a> :)</p></div>";
        update_option('user_first_run_guide_bar', 'yes');
    }
}

add_action('admin_notices', 'user_first_run_guide_bar');

// !!! 15.4.0
function tooltips_js_defer_async($tag, $handle, $src)
{
    $return_content = $tag;

    $enableDeferTooltip = get_option("enableDeferTooltip");
    if ($enableDeferTooltip != 'yes') {
        return $return_content;
    }

    if (('directoryjs' != $handle) && ('qtip2js' != $handle) && ('imagesloadedjs' != $handle)) {
        return $return_content;
    }

    // $return_content = str_replace('<script', '<script async', $tag);
    $return_content = str_replace('<script', '<script defer', $tag);
    return $return_content;
}

add_filter('script_loader_tag', 'tooltips_js_defer_async', 10, 3);

// !!! 15.4.4
function tooltips_js_async_defer($tag, $handle, $src)
{
    $return_content = $tag;

    $enableAsyncTooltip = get_option("enableAsyncTooltip");
    if ($enableAsyncTooltip != 'yes') {
        return $return_content;
    }

    if (('directoryjs' != $handle) && ('qtip2js' != $handle) && ('imagesloadedjs' != $handle)) {
        return $return_content;
    }

    $return_content = str_replace('<script', '<script async', $tag);
    return $return_content;
}

add_filter('script_loader_tag', 'tooltips_js_async_defer', 10, 3);

// 15.5.0
function footerdisabletooltipmatchingorderpro()
{
    $onlyFirstKeyword = get_option("onlyFirstKeyword");

    if (($onlyFirstKeyword == false) || ($onlyFirstKeyword == 'all')) {
        return true;
    }

    $inputFirstNKeywordSetting = 0;
    if ($onlyFirstKeyword == 'first') {
        $inputFirstNKeywordSetting = 1;
    }

    // 14.6.8
    if ($onlyFirstKeyword == 'firstn') {
        $inputFirstNKeywordSetting = get_option('inputFirstNKeywordSetting');
        if (empty($inputFirstNKeywordSetting)) {
            $inputFirstNKeywordSetting = 1;
        }
    }

    $m_result = tooltips_get_option_pro('tooltipsarray', 'post_title', 'DESC', 'LENGTH');

    if (! (empty($m_result))) {
        $tooltips_post_id_array = array();

        $m_keyword_id = 0;
        foreach ($m_result as $m_single) {

            $m_keyword = $m_single['keyword'];
            $m_content = $m_single['content'];
            $tooltip_post_id = $m_single['post_id'];
            $tooltip_unique_id = $m_single['unique_id'];
            $tooltips_post_id_array[] = 'tooltip_post_id_' . $tooltip_post_id;
        }

        $tooltips_post_id_string = implode("','", $tooltips_post_id_array);

        if (! (empty($tooltips_post_id_string))) {
            echo '<script type="text/javascript">';
            ?>
				jQuery(document).ready(function () {
				var removetooltipsmatchingarray = new Array() ;
				var matchingpostnumber = <?php echo $inputFirstNKeywordSetting; ?> - 1;
				<?php
            foreach ($tooltips_post_id_array as $tooltips_post_id_single) {
                $tooltips_post_id_single = trim($tooltips_post_id_single);
                ?>								
					removetooltipsmatchingarray.push('<?php echo $tooltips_post_id_single; ?>');
					<?php
            }
            ?> 
					for(var matchingpostid = 0; matchingpostid < removetooltipsmatchingarray.length; matchingpostid++ )
					{
						matchingpostidi = 0;
						jQuery('.'+removetooltipsmatchingarray[matchingpostid]).each
						(function()
						{
							if (matchingpostidi <= matchingpostnumber)
							{
	
							}
							else
							{
								disabletooltipinhtmltagSinglei = jQuery(this).html();
								jQuery(this).replaceWith(disabletooltipinhtmltagSinglei);
							}
							matchingpostidi = matchingpostidi + 1;
						})
					}
				})
				<?php
            echo '</script>';
        }
    }
}
//before 27.1.8 add_action('wp_footer', 'footerdisabletooltipmatchingorderpro'); 
//moved to static  js generatetooltipjs.php

// start 15.8.8
function footerdisabletooltipinblockquotepro()
{
    $enableTooltipsForBlockquote = get_option('enableTooltipsForBlockquote');

    if (! (empty($enableTooltipsForBlockquote))) {
        if ($enableTooltipsForBlockquote == 'NO') {
            echo '<script type="text/javascript">';
            ?>
				jQuery(document).ready(function () {
					jQuery('blockquote .tooltipsall').each
					(function()
					{
					disabletooltipinhtmltagSinglei = jQuery(this).html();
					jQuery(this).replaceWith(disabletooltipinhtmltagSinglei);
					})
				})
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerdisabletooltipinblockquotepro');

// end 15.8.8

// 19.6.8
function footerClickOutTooltipBox()
{
    $tooltipHiddenSelect = get_option("tooltipHiddenSelect");

    if (! (empty($tooltipHiddenSelect))) {
        if ($tooltipHiddenSelect == 'outoftooltip') {
            echo '<script type="text/javascript">';
            ?>
            	
				jQuery(document).ready(function () {
                    jQuery(document).on('mousedown', function(event) {
                      if (!jQuery(event.target).parents('.qtip').length) {
                        jQuery('.tooltipsall').qtip('hide');
                      }
                    });
				})
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerClickOutTooltipBox');

//end 19.6.8

//start 23.1.8
function footerFocusTooltipBox()
{
    $accesstooltipwithtabkey = get_option("accesstooltipwithtabkey");
    
    if (! (empty($accesstooltipwithtabkey))) {
        if ($accesstooltipwithtabkey == 'YES') {
            echo '<script type="text/javascript">';
            ?>
				jQuery(document).ready(function () {
                    jQuery('.tooltipsall a').on('focus', function(event)
                    {
                    	jQuery(this).parent().qtip('show');
                    });
				})
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerFocusTooltipBox');


function footerBlurTooltipBox()
{
    $accesstooltipwithtabkey = get_option("accesstooltipwithtabkey");
    
    
    if (! (empty($accesstooltipwithtabkey))) {
        if ($accesstooltipwithtabkey == 'YES') {
            echo '<script type="text/javascript">';
            ?>
				jQuery(document).ready(function () {
                    jQuery('.tooltipsall a').on('blur', function(event) 
                    {
                        jQuery('.tooltipsall').qtip('hide');
                    });
				})
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerBlurTooltipBox',20);
//end 23.1.8


//20.0.8
function footerClickLinksTooltipBox()
{
    $openlinkwithtooltipautomatically = get_option("openlinkwithtooltipautomatically");

    if (! (empty($openlinkwithtooltipautomatically))) {
        if ($openlinkwithtooltipautomatically == 'YES') 
        {
            echo '<script type="text/javascript">';
            ?>
                jQuery(document).ready(function($) {
                    $('body').on('mouseover', '.tooltipsall > a', function() {
                        var href = $(this).attr('href');
                        //if (href && href.indexOf('<?php echo home_url(); ?>') === -1) 
                        if (href)
                        {
                            $(this).attr('target', '_blank');
                            $(this).get(0).click(); 
                        }
                    });
                });
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerClickLinksTooltipBox');


// start 22.2.8
function footerdisabletooltipinsmartcontentlinkpro()
{
    $enableTooltipsSCL = get_option('enableTooltipsSCL');
    if (! (empty($enableTooltipsSCL))) {
        $enableTooltipsSCL = strtolower($enableTooltipsSCL);
        if ($enableTooltipsSCL <> 'yes') {
            echo '<script type="text/javascript">';
            ?>
				jQuery(document).ready(function () {
					jQuery('.scl_wraper .tooltipsall').each
					(function()
					{
					disabletooltipinhtmltagSinglei = jQuery(this).html();
					jQuery(this).replaceWith(disabletooltipinhtmltagSinglei);
					})
				})
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerdisabletooltipinsmartcontentlinkpro');

// start 22.3.8
function footerdisabletooltipmaxbutonpro()
{
    $tooltipformaxbutton = get_option("tooltipformaxbutton");
    if (! (empty($tooltipformaxbutton))) {
        $tooltipformaxbutton = strtolower($tooltipformaxbutton);
        if ($tooltipformaxbutton <> 'yes') {
            echo '<script type="text/javascript">';
            ?>
				jQuery(document).ready(function () {
					jQuery('.maxbutton .tooltipsall').each
					(function()
					{
					disabletooltipinhtmltagSinglei = jQuery(this).html();
					jQuery(this).replaceWith(disabletooltipinhtmltagSinglei);
					})
				})
				<?php
            echo '</script>';
        }
    }
}
add_action('wp_footer', 'footerdisabletooltipmaxbutonpro');

//22.4.8
function remove_glossary_term_some_theme_nva($items)
{
    
    if (is_post_type_archive('tooltips') && isset($_GET['tooltipscat']))
    {
        
        foreach ($items as $key => $item)
        {
            

            $classes = implode('', $item->classes);
            if (strpos($classes,'tooltips' ))
            {
                unset($items[$key]);
            }
        }
    }
    return $items;
}
add_filter('wp_nav_menu_objects','remove_glossary_term_some_theme_nva',2);

//24.3.8
function tooltips_plugin_action_links_pro( $links, $file )
{
    if ( $file == plugin_basename( __FILE__ ))
    {
        $settings_link = '<i><a href="https://tooltips.org/wordpress-tooltip-plugin/wordpress-tooltip-plugin-document/" target="_blank">'.esc_html__( 'Document' , 'wordpress-tooltips').'</a></i>';
        array_unshift($links, $settings_link);

        $settings_link = '<a href="' . admin_url( 'edit.php?post_type=tooltips&page=tooltipglobalsettings' ) . '">'.esc_html__( 'Settings' , 'wordpress-tooltips').'</a>';
        array_unshift($links, $settings_link);

        $settings_link = '<a href="' . admin_url( 'edit.php?post_type=tooltips&page=tooltipssettings' ) . '">'.esc_html__( 'Style' , 'wordpress-tooltips').'</a>';
        array_unshift($links, $settings_link);
        
        $settings_link = '<a href="' . admin_url( 'post-new.php?post_type=tooltips' ) . '">'.esc_html__( 'New Tooltip' , 'wordpress-tooltips').'</a>';
        array_unshift($links, $settings_link);
        
    }
    
    return $links;
}

add_filter( 'plugin_action_links', 'tooltips_plugin_action_links_pro', 10, 2 );
//end 24.3.8

